/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiCode128BarCodeType;
import com.stimulsoft.report.barCodes.StiGS1ApplicationIdentifiers;
import com.stimulsoft.report.enums.StiComponentId;

public class StiGS1_128BarCodeType
extends StiCode128BarCodeType {
    StiComponentId componentId() {
        return StiComponentId.StiGS1_128BarCodeType;
    }

    String serviceName() {
        return "GS1-128";
    }

    @Override
    protected boolean isTextSpacing() {
        return false;
    }

    String defaultCodeValue() {
        return "(21)012345(3103)000123";
    }

    protected boolean textSpacing() {
        return false;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        StringBuilder sbText;
        StringBuilder sbCode;
        String errorMessage;
        String code = this.GetCode(barCode);
        if ((code = code.replace(StiBarCodeTypeService.BarcodeCommandCode.Fnc1, (char)StiCode128BarCodeType.ControlCodes.FNC1.getValue())).trim().startsWith("(")) {
            code = code.replace("(", "[").replace(")", "]");
        }
        if ((errorMessage = StiGS1ApplicationIdentifiers.ParseCode(code, sbCode = new StringBuilder(), sbText = new StringBuilder(), (char)StiCode128BarCodeType.ControlCodes.FNC1.getValue(), false)) != null && barCode.getCodeValue() == null && barCode.getCode().getValue().contains("{")) {
            errorMessage = null;
            sbCode = new StringBuilder(barCode.getCode().getValue());
            sbText = new StringBuilder(barCode.getCode().getValue());
        }
        if (errorMessage == null) {
            String encodedText = StiGS1_128BarCodeType.EncodeAuto(sbCode.toString(), true);
            int[] fullCode = new int[encodedText.length()];
            for (int index = 0; index < encodedText.length(); ++index) {
                fullCode[index] = encodedText.charAt(index);
            }
            int checkSum = fullCode[0] + fullCode[1];
            for (int index = 0; index < encodedText.length() - 4; ++index) {
                checkSum += fullCode[index + 2] * (index + 2);
            }
            fullCode[fullCode.length - 2] = checkSum % 103;
            StringBuilder barsArray = new StringBuilder();
            for (int index = 0; index < fullCode.length; ++index) {
                barsArray.append(this.CodeToBar(this.Code128Table[fullCode[index]]));
            }
            StringBuilder sbb2 = new StringBuilder();
            for (int i = 0; i < sbText.length(); ++i) {
                char ch = sbText.charAt(i);
                if (ch < ' ' || ch > '\u00ff') {
                    sbb2.append('\u2219');
                    continue;
                }
                sbb2.append(ch);
            }
            sbText = sbb2;
            this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, 2.0, zoom, sbCode.toString(), sbText.toString(), barsArray.toString(), rect, barCode);
            this.drawBarCode(context, rect, barCode);
        } else {
            this.drawBarCodeError(context, rect, barCode, errorMessage);
        }
    }

    public StiBarCodeTypeService createNew() {
        return new StiGS1_128BarCodeType();
    }

    public StiGS1_128BarCodeType() {
        this(13, 1);
    }

    public StiGS1_128BarCodeType(int module, int height) {
        super(module, height);
    }

    @Override
    public String getDefaultCodeValue() {
        return "[21]012345[3103]000123";
    }
}

