/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiDataMatrixEncodingType;
import com.stimulsoft.report.barCodes.enums.StiDataMatrixSize;
import java.util.HashMap;

public class StiDataMatrixBarCodeType
extends StiBarCodeTypeService {
    private double module = 40.0;
    private double height = 1.0;
    private StiDataMatrixEncodingType encodingType = StiDataMatrixEncodingType.Ascii;
    private StiDataMatrixSize matrixSize = StiDataMatrixSize.Automatic;
    private boolean useRectangularSymbols = false;
    public boolean processTilde;

    public StiDataMatrixBarCodeType() {
        this(40.0, StiDataMatrixEncodingType.Ascii, false, StiDataMatrixSize.Automatic);
    }

    public StiDataMatrixBarCodeType(double module, StiDataMatrixEncodingType encodingType, boolean useRectangularSymbols, StiDataMatrixSize matrixSize) {
        this.module = module;
        this.encodingType = encodingType;
        this.useRectangularSymbols = useRectangularSymbols;
        this.matrixSize = matrixSize;
    }

    public String getServiceName() {
        return "DataMatrix";
    }

    @Override
    @StiDefaulValue(value="40.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 2.0) {
            this.module = 2.0;
        }
        if (value > 400.0) {
            this.module = 400.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
    }

    @StiSerializable
    public boolean isProcessTilde() {
        return this.processTilde;
    }

    public void setProcessTilde(boolean processTilde) {
        this.processTilde = processTilde;
    }

    @StiDefaulValue(value="Ascii")
    @StiSerializable
    public final StiDataMatrixEncodingType getEncodingType() {
        return this.encodingType;
    }

    public final void setEncodingType(StiDataMatrixEncodingType value) {
        this.encodingType = value;
    }

    @StiDefaulValue(value="Automatic")
    @StiSerializable
    public final StiDataMatrixSize getMatrixSize() {
        return this.matrixSize;
    }

    public final void setMatrixSize(StiDataMatrixSize value) {
        this.matrixSize = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getUseRectangularSymbols() {
        return this.useRectangularSymbols;
    }

    public final void setUseRectangularSymbols(boolean value) {
        this.useRectangularSymbols = value;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.0;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code;
        this.getBarCodeData().Code = code = this.GetCode(barCode);
        StiDataMatrix dm = new StiDataMatrix(StiDataMatrixBarCodeType.toInts(code.getBytes()), this.getEncodingType(), this.getUseRectangularSymbols(), this.getMatrixSize(), this.processTilde);
        this.getBarCodeData().MatrixGrid = dm.getMatrix();
        this.getBarCodeData().MatrixWidth = dm.getWidth();
        this.getBarCodeData().MatrixHeight = dm.getHeight();
        this.getBarCodeData().MatrixRatioY = 1;
        if (dm.getErrorMessage() == null) {
            this.draw2DBarCode(context, rect, barCode, zoom);
        } else {
            this.drawBarCodeError(context, rect, barCode);
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Module", this.getModule(), 40.0);
        jObject.AddPropertyEnum("EncodingType", (Enum)this.getEncodingType(), (Enum)StiDataMatrixEncodingType.Ascii);
        jObject.AddPropertyEnum("MatrixSize", (Enum)this.getMatrixSize(), (Enum)StiDataMatrixSize.Automatic);
        jObject.AddPropertyBool("UseRectangularSymbols", this.getUseRectangularSymbols());
        jObject.AddPropertyBool("ProcessTilde", this.isProcessTilde());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("EncodingType")) {
                this.encodingType = StiDataMatrixEncodingType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("MatrixSize")) {
                this.matrixSize = StiDataMatrixSize.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("UseRectangularSymbols")) {
                this.useRectangularSymbols = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("ProcessTilde")) continue;
            this.processTilde = (Boolean)property.Value;
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "12345678901";
    }

    protected static class StiDataMatrix {
        private int gridWidth = 0;
        private int gridHeight = 0;
        private int[] grid = null;
        private String errorMessage = null;
        private ecc200ListItem[] ecc200List = null;
        private boolean processTilde = false;

        public final int[] getMatrix() {
            return this.grid;
        }

        public final int getWidth() {
            return this.gridWidth;
        }

        public final int getHeight() {
            return this.gridHeight;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        private void DataMatrixPlacementbit(int[] array, int numRows, int numColumns, int row, int column, int pos, int b) {
            if (row < 0) {
                row += numRows;
                column += 4 - (numRows + 4) % 8;
            }
            if (column < 0) {
                column += numColumns;
                row += 4 - (numColumns + 4) % 8;
            }
            array[row * numColumns + column] = (pos << 3) + b;
        }

        private void DataMatrixPlacementBlock(int[] array, int numRows, int numColumns, int row, int column, int pos) {
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 2, column - 2, pos, 7);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 2, column - 1, pos, 6);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 1, column - 2, pos, 5);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 1, column - 1, pos, 4);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 1, column - 0, pos, 3);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 0, column - 2, pos, 2);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 0, column - 1, pos, 1);
            this.DataMatrixPlacementbit(array, numRows, numColumns, row - 0, column - 0, pos, 0);
        }

        private void DataMatrixPlacementCornerA(int[] array, int numRows, int numColumns, int pos) {
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, 0, pos, 7);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, 1, pos, 6);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, 2, pos, 5);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 2, pos, 4);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 1, pos, 3);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 1, numColumns - 1, pos, 2);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 2, numColumns - 1, pos, 1);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 3, numColumns - 1, pos, 0);
        }

        private void DataMatrixPlacementCornerB(int[] array, int numRows, int numColumns, int pos) {
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 3, 0, pos, 7);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 2, 0, pos, 6);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, 0, pos, 5);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 4, pos, 4);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 3, pos, 3);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 2, pos, 2);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 1, pos, 1);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 1, numColumns - 1, pos, 0);
        }

        private void DataMatrixPlacementCornerC(int[] array, int numRows, int numColumns, int pos) {
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 3, 0, pos, 7);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 2, 0, pos, 6);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, 0, pos, 5);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 2, pos, 4);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 1, pos, 3);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 1, numColumns - 1, pos, 2);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 2, numColumns - 1, pos, 1);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 3, numColumns - 1, pos, 0);
        }

        private void DataMatrixPlacementCornerD(int[] array, int numRows, int numColumns, int pos) {
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, 0, pos, 7);
            this.DataMatrixPlacementbit(array, numRows, numColumns, numRows - 1, numColumns - 1, pos, 6);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 3, pos, 5);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 2, pos, 4);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 0, numColumns - 1, pos, 3);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 1, numColumns - 3, pos, 2);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 1, numColumns - 2, pos, 1);
            this.DataMatrixPlacementbit(array, numRows, numColumns, 1, numColumns - 1, pos, 0);
        }

        private int[] DataMatrixPlacement(int numRows, int numColumns) {
            int[] array = new int[numColumns * numRows];
            int row = 4;
            int column = 0;
            int pos = 1;
            do {
                if (row == numRows && column == 0) {
                    this.DataMatrixPlacementCornerA(array, numRows, numColumns, pos++);
                }
                if (row == numRows - 2 && column == 0 && numColumns % 4 != 0) {
                    this.DataMatrixPlacementCornerB(array, numRows, numColumns, pos++);
                }
                if (row == numRows - 2 && column == 0 && numColumns % 8 == 4) {
                    this.DataMatrixPlacementCornerC(array, numRows, numColumns, pos++);
                }
                if (row == numRows + 4 && column == 2 && numColumns % 8 == 0) {
                    this.DataMatrixPlacementCornerD(array, numRows, numColumns, pos++);
                }
                do {
                    if (row >= numRows || column < 0 || array[row * numColumns + column] != 0) continue;
                    this.DataMatrixPlacementBlock(array, numRows, numColumns, row, column, pos++);
                } while ((row -= 2) >= 0 && (column += 2) < numColumns);
                ++row;
                column += 3;
                do {
                    if (row < 0 || column >= numColumns || array[row * numColumns + column] != 0) continue;
                    this.DataMatrixPlacementBlock(array, numRows, numColumns, row, column, pos++);
                } while ((row += 2) < numRows && (column -= 2) >= 0);
            } while ((row += 3) < numRows || ++column < numColumns);
            if (array[numRows * numColumns - 1] == 0) {
                array[numRows * numColumns - numColumns - 2] = 1;
                array[numRows * numColumns - 1] = 1;
            }
            return array;
        }

        private int[] makeEcc200Blocks(int[] binary, int bytes, int datablock, int rsblock) {
            ReedSolomon reedSolomon = new ReedSolomon(rsblock);
            int blocks = (bytes + 2) / datablock;
            for (int b = 0; b < blocks; ++b) {
                int[] buf = new int[256];
                int p = 0;
                for (int n = b; n < bytes; n += blocks) {
                    buf[p++] = binary[n];
                }
                int[] ecc = reedSolomon.Encode(p, buf);
                p = rsblock - 1;
                for (int n = b; n < rsblock * blocks; n += blocks) {
                    binary[bytes + n] = ecc[p--];
                }
            }
            return binary;
        }

        private StiBarCodeTypeService.ValueObject dataMatrixEncode(int[] output, int matrixLength, int[] barcode, StiDataMatrixEncodingType encoding) {
            Integer n;
            Integer n2;
            Integer n3;
            StiRefObject outPos = new StiRefObject((Object)0);
            StiRefObject barPos = new StiRefObject((Object)0);
            Integer[] input = StiBarCodeTypeService.unpackTilde(barcode, this.processTilde);
            if ((Integer)barPos.argvalue < input.length && input[(Integer)barPos.argvalue] == StiBarCodeTypeService.BarcodeCommandCode.Fnc1) {
                StiRefObject stiRefObject = outPos;
                n3 = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
                output[n3.intValue()] = CommandCode.FNC1.intValue;
                stiRefObject = barPos;
                n3 = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
            }
            if (barcode.length > 0) {
                switch (encoding) {
                    case C40: 
                    case Text: 
                    case X12: {
                        this.encodeCTX(output, matrixLength, barcode, encoding, (StiRefObject<Integer>)barPos, (StiRefObject<Integer>)outPos);
                        break;
                    }
                    case Edifact: {
                        this.encodeE(output, matrixLength, barcode, (StiRefObject<Integer>)barPos, (StiRefObject<Integer>)outPos);
                        break;
                    }
                    case Ascii: {
                        this.encodeA(output, matrixLength, barcode, (StiRefObject<Integer>)barPos, (StiRefObject<Integer>)outPos);
                        break;
                    }
                    case Binary: {
                        this.encodeB(output, matrixLength, barcode, (StiRefObject<Integer>)barPos, (StiRefObject<Integer>)outPos);
                    }
                }
            }
            int codeLength = (Integer)outPos.argvalue;
            if ((Integer)outPos.argvalue < matrixLength && encoding != StiDataMatrixEncodingType.Ascii) {
                n3 = outPos;
                n2 = (Integer)((StiRefObject)n3).argvalue;
                ((StiRefObject)n3).argvalue = (Integer)((StiRefObject)n3).argvalue + 1;
                n = ((StiRefObject)n3).argvalue;
                output[n2.intValue()] = CommandCode.EscapeToAscii.intValue;
            }
            if ((Integer)outPos.argvalue < matrixLength) {
                n3 = outPos;
                n2 = (Integer)((StiRefObject)n3).argvalue;
                ((StiRefObject)n3).argvalue = (Integer)((StiRefObject)n3).argvalue + 1;
                n = ((StiRefObject)n3).argvalue;
                output[n2.intValue()] = CommandCode.Padding.intValue;
            }
            while ((Integer)outPos.argvalue < matrixLength) {
                int v = 129 + ((Integer)outPos.argvalue + 1) * 149 % 253 + 1;
                if (v > 254) {
                    v -= 254;
                }
                n2 = outPos;
                n = (Integer)((StiRefObject)n2).argvalue;
                ((StiRefObject)n2).argvalue = (Integer)((StiRefObject)n2).argvalue + 1;
                Integer n4 = ((StiRefObject)n2).argvalue;
                output[n.intValue()] = v;
            }
            if ((Integer)outPos.argvalue > matrixLength || (Integer)barPos.argvalue < barcode.length) {
                return new StiBarCodeTypeService.ValueObject(0);
            }
            return new StiBarCodeTypeService.ValueObject(codeLength, output);
        }

        private void encodeB(int[] output, int matrixLength, int[] barcode, StiRefObject<Integer> outPos, StiRefObject<Integer> barPos) {
            StiRefObject<Integer> stiRefObject = outPos;
            Integer n = (Integer)stiRefObject.argvalue;
            stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
            Integer n2 = stiRefObject.argvalue;
            output[n.intValue()] = CommandCode.ModeBinary.intValue;
            if (barcode.length < 250) {
                stiRefObject = outPos;
                n = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
                output[n.intValue()] = barcode.length;
            } else {
                stiRefObject = outPos;
                n = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
                output[n.intValue()] = 249 + barcode.length / 250;
                stiRefObject = outPos;
                n = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
                output[n.intValue()] = barcode.length % 250;
            }
            do {
                stiRefObject = barPos;
                n = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
                output[((Integer)outPos.argvalue).intValue()] = barcode[n] + ((Integer)outPos.argvalue + 1) * 149 % 255 + 1;
                stiRefObject = outPos;
                n = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n2 = stiRefObject.argvalue;
            } while ((Integer)barPos.argvalue < barcode.length && (Integer)outPos.argvalue < matrixLength);
        }

        private void encodeA(int[] output, int matrixLength, int[] barcode, StiRefObject<Integer> barPos, StiRefObject<Integer> outPos) {
            while ((Integer)barPos.argvalue < barcode.length && (Integer)outPos.argvalue < matrixLength) {
                Integer n;
                Integer n2;
                StiRefObject<Integer> stiRefObject;
                if (barcode[(Integer)barPos.argvalue] > 255) {
                    if (barcode[(Integer)barPos.argvalue] == StiBarCodeTypeService.BarcodeCommandCode.Fnc1) {
                        stiRefObject = outPos;
                        n2 = (Integer)stiRefObject.argvalue;
                        stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                        n = stiRefObject.argvalue;
                        output[n2.intValue()] = CommandCode.FNC1.intValue;
                    }
                    stiRefObject = barPos;
                    n2 = (Integer)stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    n = stiRefObject.argvalue;
                    continue;
                }
                if (barcode.length - (Integer)barPos.argvalue >= 2 && this.IsDigit(barcode[(Integer)barPos.argvalue]) && this.IsDigit(barcode[(Integer)barPos.argvalue + 1])) {
                    stiRefObject = outPos;
                    n2 = (Integer)stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    n = stiRefObject.argvalue;
                    output[n2.intValue()] = (barcode[(Integer)barPos.argvalue] - 48) * 10 + barcode[(Integer)barPos.argvalue + 1] - 48 + 130;
                    stiRefObject = barPos;
                    Integer.valueOf((Integer)stiRefObject.argvalue + 2);
                    stiRefObject.argvalue = stiRefObject.argvalue;
                    continue;
                }
                if (barcode[(Integer)barPos.argvalue] > 127) {
                    stiRefObject = outPos;
                    n2 = (Integer)stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    n = stiRefObject.argvalue;
                    output[n2.intValue()] = 235;
                    stiRefObject = outPos;
                    n2 = (Integer)stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    n = stiRefObject.argvalue;
                    int n3 = n2;
                    stiRefObject = barPos;
                    n2 = (Integer)stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    n = stiRefObject.argvalue;
                    output[n3] = barcode[n2] - 127;
                    continue;
                }
                stiRefObject = outPos;
                n2 = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n = stiRefObject.argvalue;
                int n4 = n2;
                stiRefObject = barPos;
                n2 = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n = stiRefObject.argvalue;
                output[n4] = barcode[n2] + 1;
            }
        }

        private void encodeE(int[] output, int matrixLength, int[] barcode, StiRefObject<Integer> outPos, StiRefObject<Integer> barPos) {
            int[] outBuf = new int[4];
            StiRefObject<Integer> stiRefObject = outPos;
            StiRefObject<Integer> stiRefObject2 = (StiRefObject<Integer>)stiRefObject.argvalue;
            stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
            Integer n = stiRefObject.argvalue;
            output[stiRefObject2.intValue()] = CommandCode.ModeEdifact.intValue;
            do {
                Integer n2;
                outBuf[0] = 0;
                outBuf[1] = 0;
                outBuf[2] = 0;
                outBuf[3] = 0;
                int bufPos = 0;
                while ((Integer)barPos.argvalue < barcode.length && bufPos < 4) {
                    int n3 = bufPos++;
                    stiRefObject2 = barPos;
                    n = (Integer)stiRefObject2.argvalue;
                    stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                    n2 = stiRefObject2.argvalue;
                    outBuf[n3] = barcode[n];
                }
                if (bufPos < 4) {
                    outBuf[bufPos++] = 31;
                }
                output[((Integer)outPos.argvalue).intValue()] = (outBuf[0] & 0x3F) << 2;
                stiRefObject2 = outPos;
                n = (Integer)stiRefObject2.argvalue;
                stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                n2 = stiRefObject2.argvalue;
                int n4 = n;
                output[n4] = output[n4] | (outBuf[1] & 0x30) >> 4;
                output[((Integer)outPos.argvalue).intValue()] = (outBuf[1] & 0xF) << 4;
                if (bufPos == 2) {
                    stiRefObject2 = outPos;
                    n = (Integer)stiRefObject2.argvalue;
                    stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                    n2 = stiRefObject2.argvalue;
                    continue;
                }
                stiRefObject2 = outPos;
                n = (Integer)stiRefObject2.argvalue;
                stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                n2 = stiRefObject2.argvalue;
                int n5 = n;
                output[n5] = output[n5] | (outBuf[2] & 0x3C) >> 2;
                output[((Integer)outPos.argvalue).intValue()] = (outBuf[2] & 3) << 6;
                stiRefObject2 = outPos;
                n = (Integer)stiRefObject2.argvalue;
                stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                n2 = stiRefObject2.argvalue;
                int n6 = n;
                output[n6] = output[n6] | outBuf[3] & 0x3F;
            } while ((Integer)barPos.argvalue < barcode.length && (Integer)outPos.argvalue < matrixLength);
        }

        private void encodeCTX(int[] output, int matrixLength, int[] barcode, StiDataMatrixEncodingType encoding, StiRefObject<Integer> outPos, StiRefObject<Integer> barPos) {
            Integer n;
            Object object;
            StiRefObject<Integer> stiRefObject;
            int[] outBuf = new int[6];
            int bufPos = 0;
            String s2 = "!\"#$%&'()*+,-./:;<=>?@[\\]_";
            String s3 = "";
            String e = "";
            if (encoding == StiDataMatrixEncodingType.C40) {
                stiRefObject = outPos;
                object = (StiRefObject<Integer>)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n = stiRefObject.argvalue;
                output[((Integer)object).intValue()] = CommandCode.ModeC40.intValue;
                e = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                s3 = "`abcdefghijklmnopqrstuvwxyz{|}~\u000f7";
            }
            if (encoding == StiDataMatrixEncodingType.Text) {
                stiRefObject = outPos;
                object = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n = stiRefObject.argvalue;
                output[((Integer)object).intValue()] = CommandCode.ModeText.intValue;
                e = " 0123456789abcdefghijklmnopqrstuvwxyz";
                s3 = "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~\u000f7";
            }
            if (encoding == StiDataMatrixEncodingType.X12) {
                stiRefObject = outPos;
                object = (Integer)stiRefObject.argvalue;
                stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                n = stiRefObject.argvalue;
                output[((Integer)object).intValue()] = CommandCode.ModeX12.intValue;
                e = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ\r*>";
            }
            do {
                int w_idx;
                if ((Integer)barPos.argvalue + 1 == barcode.length && bufPos == 0) {
                    stiRefObject = outPos;
                    object = (Integer)stiRefObject.argvalue;
                    stiRefObject.argvalue = (Integer)stiRefObject.argvalue + 1;
                    n = stiRefObject.argvalue;
                    output[((Integer)object).intValue()] = CommandCode.EscapeToAscii.intValue;
                    this.encodeA(output, matrixLength, barcode, barPos, outPos);
                    encoding = StiDataMatrixEncodingType.Ascii;
                    return;
                }
                object = barPos;
                n = (Integer)((StiRefObject)object).argvalue;
                ((StiRefObject)object).argvalue = Integer.valueOf((Integer)((StiRefObject)object).argvalue + 1);
                StiRefObject<Integer> stiRefObject2 = ((StiRefObject)object).argvalue;
                int c = barcode[n];
                if ((c & 0x80) != 0) {
                    if (encoding == StiDataMatrixEncodingType.X12) {
                        throw new StiDataMatrixException(String.format("Cannot encode char 0x{%s} in X12", c));
                    }
                    c &= 0x7F;
                    outBuf[bufPos++] = 1;
                    outBuf[bufPos++] = 30;
                }
                if ((w_idx = e.indexOf((char)c)) >= 0) {
                    outBuf[bufPos++] = (w_idx + 3) % 40;
                } else {
                    if (encoding == StiDataMatrixEncodingType.X12) {
                        throw new StiDataMatrixException(String.format("Cannot encode char 0x%s in X12", c));
                    }
                    if (c < 32) {
                        outBuf[bufPos++] = 0;
                        outBuf[bufPos++] = c;
                    } else {
                        w_idx = s2.indexOf((char)c);
                        if (w_idx >= 0) {
                            outBuf[bufPos++] = 1;
                            outBuf[bufPos++] = w_idx;
                        } else {
                            w_idx = s3.indexOf((char)c);
                            if (w_idx >= 0) {
                                outBuf[bufPos++] = 2;
                                outBuf[bufPos++] = w_idx;
                            } else {
                                throw new StiDataMatrixException(String.format("Cannot encode char 0x%s", c));
                            }
                        }
                    }
                }
                if ((Integer)barPos.argvalue == barcode.length && bufPos % 3 == 2) {
                    outBuf[bufPos++] = 0;
                }
                while (bufPos >= 3) {
                    int v = outBuf[0] * 1600 + outBuf[1] * 40 + outBuf[2] + 1;
                    stiRefObject2 = outPos;
                    Integer n2 = (Integer)stiRefObject2.argvalue;
                    stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                    Integer n3 = stiRefObject2.argvalue;
                    output[n2.intValue()] = v >> 8;
                    stiRefObject2 = outPos;
                    n2 = (Integer)stiRefObject2.argvalue;
                    stiRefObject2.argvalue = (Integer)stiRefObject2.argvalue + 1;
                    n3 = stiRefObject2.argvalue;
                    output[n2.intValue()] = v & 0xFF;
                    bufPos -= 3;
                    outBuf[0] = outBuf[3];
                    outBuf[1] = outBuf[4];
                    outBuf[2] = outBuf[5];
                    outBuf[3] = 0;
                    outBuf[4] = 0;
                    outBuf[5] = 0;
                }
            } while ((Integer)barPos.argvalue < barcode.length && (Integer)outPos.argvalue < matrixLength);
        }

        private boolean IsDigit(int b) {
            return b >= 48 && b <= 57;
        }

        private StiBarCodeTypeService.ValueObject makeGrid(int[] barcode, Integer widthOriginal, Integer heightOriginal, StiDataMatrixEncodingType globalEncoding) {
            int mWidth = widthOriginal;
            int mHeight = heightOriginal;
            int[] binary = new int[3200];
            int[] grid = null;
            int indexMatrix = 0;
            if (mWidth != 0) {
                for (indexMatrix = 0; indexMatrix < this.ecc200List.length && (this.ecc200List[indexMatrix].Width != mWidth || this.ecc200List[indexMatrix].Height != mHeight); ++indexMatrix) {
                }
                if (indexMatrix == this.ecc200List.length) {
                    throw new StiDataMatrixException(String.format("Invalid size %1$sx%2$s", mWidth, mHeight));
                }
            } else {
                StiBarCodeTypeService.ValueObject result = this.dataMatrixEncode(binary, 1558, barcode, globalEncoding);
                binary = result.getOutput();
                for (indexMatrix = 0; indexMatrix < this.ecc200List.length && result.getCodeLength() > this.ecc200List[indexMatrix].Bytes; ++indexMatrix) {
                }
                if (indexMatrix == this.ecc200List.length) {
                    throw new StiDataMatrixException("Cannot find suitable size, barcode too long");
                }
                mWidth = this.ecc200List[indexMatrix].Width;
                mHeight = this.ecc200List[indexMatrix].Height;
            }
            StiBarCodeTypeService.ValueObject dataMatrixEncodeResult = this.dataMatrixEncode(binary, this.ecc200List[indexMatrix].Bytes, barcode, globalEncoding);
            binary = dataMatrixEncodeResult.getOutput();
            if (dataMatrixEncodeResult.getCodeLength() == 0) {
                throw new StiDataMatrixException(String.format("Barcode too long for %1$sx%2$s", mWidth, mHeight));
            }
            binary = this.makeEcc200Blocks(binary, this.ecc200List[indexMatrix].Bytes, this.ecc200List[indexMatrix].Datablock, this.ecc200List[indexMatrix].RSblock);
            int numColumns = mWidth - 2 * (mWidth / this.ecc200List[indexMatrix].FW);
            int numRows = mHeight - 2 * (mHeight / this.ecc200List[indexMatrix].FH);
            int[] places = this.DataMatrixPlacement(numRows, numColumns);
            grid = new int[mWidth * mHeight];
            int x = 0;
            int y = 0;
            for (y = 0; y < mHeight; y += this.ecc200List[indexMatrix].FH) {
                for (x = 0; x < mWidth; ++x) {
                    grid[y * mWidth + x] = 1;
                }
                for (x = 0; x < mWidth; x += 2) {
                    grid[(y + this.ecc200List[indexMatrix].FH - 1) * mWidth + x] = 1;
                }
            }
            for (x = 0; x < mWidth; x += this.ecc200List[indexMatrix].FW) {
                for (y = 0; y < mHeight; ++y) {
                    grid[y * mWidth + x] = 1;
                }
                for (y = 0; y < mHeight; y += 2) {
                    grid[y * mWidth + x + this.ecc200List[indexMatrix].FW - 1] = 1;
                }
            }
            for (y = 0; y < numRows; ++y) {
                for (x = 0; x < numColumns; ++x) {
                    int v = places[(numRows - y - 1) * numColumns + x];
                    if (v != 1 && (v <= 7 || (binary[(v >> 3) - 1] & 1 << (v & 7)) == 0)) continue;
                    grid[(1 + y + 2 * (y / (this.ecc200List[indexMatrix].FH - 2))) * mWidth + 1 + x + 2 * (x / (this.ecc200List[indexMatrix].FW - 2))] = 1;
                }
            }
            StiBarCodeTypeService.ValueObject result = new StiBarCodeTypeService.ValueObject();
            result.setWidthOriginal(mWidth);
            result.setHeightOriginal(mHeight);
            result.setOutput(grid);
            return result;
        }

        private static int[] convertStringToBytes(String st) {
            char[] chars = st.toCharArray();
            int[] buf = new int[chars.length];
            for (int index = 0; index < chars.length; ++index) {
                int ch = chars[index];
                buf[index] = ch < 256 ? ch : (ch == StiBarCodeTypeService.BarcodeCommandCode.Fnc1 || ch == StiBarCodeTypeService.BarcodeCommandCode.Fnc2 || ch == StiBarCodeTypeService.BarcodeCommandCode.Fnc3 || ch == StiBarCodeTypeService.BarcodeCommandCode.Fnc4 ? ch : 63);
            }
            return buf;
        }

        public StiDataMatrix(String message, StiDataMatrixEncodingType globalEncoding, boolean useRectangularSymbols, StiDataMatrixSize matrixSize, boolean processTilde) {
            this(StiDataMatrix.convertStringToBytes(message), globalEncoding, useRectangularSymbols, matrixSize, processTilde);
        }

        public StiDataMatrix(int[] data, StiDataMatrixEncodingType globalEncoding, boolean useRectangularSymbols, StiDataMatrixSize matrixSize, boolean processTilde) {
            this.processTilde = processTilde;
            this.gridWidth = 0;
            this.gridHeight = 0;
            int[] array = null;
            if (matrixSize != StiDataMatrixSize.Automatic) {
                useRectangularSymbols = true;
            }
            this.ecc200List = useRectangularSymbols ? new ecc200ListItem[]{new ecc200ListItem(10, 10, 10, 10, 3, 3, 5), new ecc200ListItem(12, 12, 12, 12, 5, 5, 7), new ecc200ListItem(8, 18, 8, 18, 5, 5, 7), new ecc200ListItem(14, 14, 14, 14, 8, 8, 10), new ecc200ListItem(8, 32, 8, 16, 10, 10, 11), new ecc200ListItem(16, 16, 16, 16, 12, 12, 12), new ecc200ListItem(12, 26, 12, 26, 16, 16, 14), new ecc200ListItem(18, 18, 18, 18, 18, 18, 14), new ecc200ListItem(20, 20, 20, 20, 22, 22, 18), new ecc200ListItem(12, 36, 12, 18, 22, 22, 18), new ecc200ListItem(22, 22, 22, 22, 30, 30, 20), new ecc200ListItem(16, 36, 16, 18, 32, 32, 24), new ecc200ListItem(24, 24, 24, 24, 36, 36, 24), new ecc200ListItem(26, 26, 26, 26, 44, 44, 28), new ecc200ListItem(16, 48, 16, 24, 49, 49, 28), new ecc200ListItem(32, 32, 16, 16, 62, 62, 36), new ecc200ListItem(36, 36, 18, 18, 86, 86, 42), new ecc200ListItem(40, 40, 20, 20, 114, 114, 48), new ecc200ListItem(44, 44, 22, 22, 144, 144, 56), new ecc200ListItem(48, 48, 24, 24, 174, 174, 68), new ecc200ListItem(52, 52, 26, 26, 204, 102, 42), new ecc200ListItem(64, 64, 16, 16, 280, 140, 56), new ecc200ListItem(72, 72, 18, 18, 368, 92, 36), new ecc200ListItem(80, 80, 20, 20, 456, 114, 48), new ecc200ListItem(88, 88, 22, 22, 576, 144, 56), new ecc200ListItem(96, 96, 24, 24, 696, 174, 68), new ecc200ListItem(104, 104, 26, 26, 816, 136, 56), new ecc200ListItem(120, 120, 20, 20, 1050, 175, 68), new ecc200ListItem(132, 132, 22, 22, 1304, 163, 62), new ecc200ListItem(144, 144, 24, 24, 1558, 156, 62)} : new ecc200ListItem[]{new ecc200ListItem(10, 10, 10, 10, 3, 3, 5), new ecc200ListItem(12, 12, 12, 12, 5, 5, 7), new ecc200ListItem(14, 14, 14, 14, 8, 8, 10), new ecc200ListItem(16, 16, 16, 16, 12, 12, 12), new ecc200ListItem(18, 18, 18, 18, 18, 18, 14), new ecc200ListItem(20, 20, 20, 20, 22, 22, 18), new ecc200ListItem(22, 22, 22, 22, 30, 30, 20), new ecc200ListItem(24, 24, 24, 24, 36, 36, 24), new ecc200ListItem(26, 26, 26, 26, 44, 44, 28), new ecc200ListItem(32, 32, 16, 16, 62, 62, 36), new ecc200ListItem(36, 36, 18, 18, 86, 86, 42), new ecc200ListItem(40, 40, 20, 20, 114, 114, 48), new ecc200ListItem(44, 44, 22, 22, 144, 144, 56), new ecc200ListItem(48, 48, 24, 24, 174, 174, 68), new ecc200ListItem(52, 52, 26, 26, 204, 102, 42), new ecc200ListItem(64, 64, 16, 16, 280, 140, 56), new ecc200ListItem(72, 72, 18, 18, 368, 92, 36), new ecc200ListItem(80, 80, 20, 20, 456, 114, 48), new ecc200ListItem(88, 88, 22, 22, 576, 144, 56), new ecc200ListItem(96, 96, 24, 24, 696, 174, 68), new ecc200ListItem(104, 104, 26, 26, 816, 136, 56), new ecc200ListItem(120, 120, 20, 20, 1050, 175, 68), new ecc200ListItem(132, 132, 22, 22, 1304, 163, 62), new ecc200ListItem(144, 144, 24, 24, 1558, 156, 62)};
            if (matrixSize != StiDataMatrixSize.Automatic) {
                ecc200ListItem item = this.ecc200List[matrixSize.getValue()].clone();
                this.gridWidth = item.Width;
                this.gridHeight = item.Height;
            }
            try {
                StiBarCodeTypeService.ValueObject result = this.makeGrid(data, new Integer(this.gridWidth), new Integer(this.gridHeight), globalEncoding);
                array = result.getOutput();
                this.gridWidth = result.getWidthOriginal();
                this.gridHeight = result.getHeightOriginal();
            }
            catch (StiDataMatrixException dme) {
                this.errorMessage = dme.getMessage();
                dme.printStackTrace();
            }
            if (array != null) {
                this.grid = new int[this.gridWidth * this.gridHeight];
                for (int y = 0; y < this.gridHeight; ++y) {
                    int posArray = y * this.gridWidth;
                    int posGrid = (this.gridHeight - y - 1) * this.gridWidth;
                    for (int x = 0; x < this.gridWidth; ++x) {
                        this.grid[posGrid + x] = array[posArray + x];
                    }
                }
            }
        }

        private static final class ecc200ListItem
        implements Cloneable {
            public int Height;
            public int Width;
            public int FH;
            public int FW;
            public int Bytes;
            public int Datablock;
            public int RSblock;

            public ecc200ListItem(int h, int w, int fh, int fw, int bytes, int datablock, int rsblock) {
                this.Height = h;
                this.Width = w;
                this.FH = fh;
                this.FW = fw;
                this.Bytes = bytes;
                this.Datablock = datablock;
                this.RSblock = rsblock;
            }

            private ecc200ListItem() {
            }

            public ecc200ListItem clone() {
                ecc200ListItem varCopy = new ecc200ListItem();
                varCopy.Height = this.Height;
                varCopy.Width = this.Width;
                varCopy.FH = this.FH;
                varCopy.FW = this.FW;
                varCopy.Bytes = this.Bytes;
                varCopy.Datablock = this.Datablock;
                varCopy.RSblock = this.RSblock;
                return varCopy;
            }
        }

        public static class ReedSolomon {
            private final int logmod;
            private final int rlen;
            private int[] log = new int[this.logmod + 1];
            private int[] alog = new int[this.logmod];
            private int[] rspoly = null;

            public ReedSolomon(int nsym) {
                this.logmod = 255;
                int p = 1;
                for (int v = 0; v < this.logmod; ++v) {
                    this.alog[v] = p;
                    this.log[p] = v;
                    if ((p <<= 1) <= 255) continue;
                    p ^= 0x12D;
                }
                this.rlen = nsym;
                this.rspoly = new int[nsym + 1];
                int index = 1;
                this.rspoly[0] = 1;
                for (int i = 1; i <= nsym; ++i) {
                    this.rspoly[i] = 1;
                    for (int k = i - 1; k > 0; --k) {
                        if (this.rspoly[k] != 0) {
                            this.rspoly[k] = this.alog[(this.log[this.rspoly[k]] + index) % this.logmod];
                        }
                        int n = k;
                        this.rspoly[n] = this.rspoly[n] ^ this.rspoly[k - 1];
                    }
                    this.rspoly[0] = this.alog[(this.log[this.rspoly[0]] + index) % this.logmod];
                    ++index;
                }
            }

            public final int[] Encode(int len, int[] data) {
                int[] res = new int[this.rlen];
                for (int i = 0; i < len; ++i) {
                    int m = res[this.rlen - 1] ^ data[i];
                    for (int k = this.rlen - 1; k > 0; --k) {
                        res[k] = m != 0 && this.rspoly[k] != 0 ? res[k - 1] ^ this.alog[(this.log[m] + this.log[this.rspoly[k]]) % this.logmod] : res[k - 1];
                    }
                    res[0] = m != 0 && this.rspoly[0] != 0 ? this.alog[(this.log[m] + this.log[this.rspoly[0]]) % this.logmod] : 0;
                }
                return res;
            }
        }

        public static enum CommandCode {
            Padding(129),
            ModeC40(230),
            FNC1(232),
            ModeBinary(231),
            ModeX12(238),
            ModeText(239),
            ModeEdifact(240),
            EscapeToAscii(254);

            private int intValue;
            private static HashMap<Integer, CommandCode> mappings;

            private static synchronized HashMap<Integer, CommandCode> getMappings() {
                if (mappings == null) {
                    mappings = new HashMap();
                }
                return mappings;
            }

            private CommandCode(int value) {
                this.intValue = value;
                CommandCode.getMappings().put(value, this);
            }

            public int getValue() {
                return this.intValue;
            }

            public static CommandCode forValue(int value) {
                return CommandCode.getMappings().get(value);
            }
        }
    }

    protected static class StiDataMatrixException
    extends RuntimeException {
        private static final long serialVersionUID = -2025675374153866698L;

        public StiDataMatrixException() {
        }

        public StiDataMatrixException(String message) {
            super(message);
        }

        public StiDataMatrixException(String message, RuntimeException inner) {
            super(message, inner);
        }
    }
}

