/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiCode93BarCodeType;

public class StiCode93ExtBarCodeType
extends StiCode93BarCodeType {
    private final String Code93ExtSymbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%<]>[";
    private final String[] Code93ExtTable = new String[]{"]U", "<A", "<B", "<C", "<D", "<E", "<F", "<G", "<H", "<I", "<J", "<K", "<L", "<M", "<N", "<O", "<P", "<Q", "<R", "<S", "<T", "<U", "<V", "<W", "<X", "<Y", "<Z", "]A", "]B", "]C", "]D", "]E", " ", ">A", ">B", ">C", ">D", ">E", ">F", ">G", ">H", ">I", ">J", ">K", ">L", "-", ".", ">O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ">Z", "]F", "]G", "]H", "]I", "]J", "]V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "]K", "]L", "]M", "]N", "]O", "]W", "[A", "[B", "[C", "[D", "[E", "[F", "[G", "[H", "[I", "[J", "[K", "[L", "[M", "[N", "[O", "[P", "[Q", "[R", "[S", "[T", "[U", "[V", "[W", "[X", "[Y", "[Z", "]P", "]Q", "]R", "]S", "]T"};

    public StiCode93ExtBarCodeType() {
        this(13.0, 1.0, 2.2);
    }

    public StiCode93ExtBarCodeType(double module, double height, double ratio) {
        super(module, height, ratio);
    }

    @Override
    public String getServiceName() {
        return "Code93 Extended";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        if (code == null) {
            code = "";
        }
        StringBuilder checkedCode = new StringBuilder();
        StringBuilder checkedString = new StringBuilder();
        for (int index = 0; index < code.length(); ++index) {
            char sym = code.charAt(index);
            if (sym >= '\u0080') continue;
            checkedCode.append(this.Code93ExtTable[sym]);
            checkedString.append(sym);
        }
        code = checkedCode.toString();
        int[] fullCode = new int[code.length() + 4];
        for (int index = 0; index < code.length(); ++index) {
            fullCode[index + 1] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%<]>[".indexOf(code.charAt(index));
        }
        int sum1 = 0;
        int multiplier = 1;
        for (int index = code.length() - 1; index >= 0; --index) {
            sum1 += fullCode[index + 1] * multiplier;
            if (++multiplier <= 20) continue;
            multiplier = 1;
        }
        fullCode[fullCode.length - 3] = sum1 % 47;
        int sum2 = 0;
        multiplier = 1;
        for (int index = code.length(); index >= 0; --index) {
            sum2 += fullCode[index + 1] * multiplier;
            if (++multiplier <= 15) continue;
            multiplier = 1;
        }
        fullCode[fullCode.length - 2] = sum2 % 47;
        fullCode[0] = this.Code93Table.length - 2;
        fullCode[fullCode.length - 1] = this.Code93Table.length - 1;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code93Table[fullCode[index]]));
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, this.getRatio(), zoom, code, checkedString.toString(), barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "Abc123";
    }
}

