/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiCode128BarCodeType;

public class StiCode128bBarCodeType
extends StiCode128BarCodeType {
    public StiCode128bBarCodeType() {
        this(13.0, 1.0);
    }

    public StiCode128bBarCodeType(double module, double height) {
        super(module, height);
    }

    public String getServiceName() {
        return "Code128b";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f\u0081");
        StringBuilder sbTemp = new StringBuilder();
        int[] fullCode = new int[code.length() + 3];
        fullCode[0] = 104;
        int checkSum = fullCode[0];
        for (int index = 0; index < code.length(); ++index) {
            char ch = code.charAt(index);
            fullCode[index + 1] = ch - 32;
            if (ch == '\u0081') {
                fullCode[index + 1] = 102;
            }
            checkSum += fullCode[index + 1] * (index + 1);
            sbTemp.append((char)(ch != '\u0081' ? (int)ch : 8729));
        }
        fullCode[fullCode.length - 2] = checkSum % 103;
        fullCode[fullCode.length - 1] = 106;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code128Table[fullCode[index]]));
        }
        String text = sbTemp.toString();
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, 2.0, zoom, code, text, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "ABCabc123";
    }
}

