/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.enums.StiCode11CheckSum;

public class StiCode11BarCodeType
extends StiBarCodeTypeService {
    protected String Code11Symbols = "0123456789-";
    protected int Code11StartStopSymbolIndex = 11;
    protected String[] Code11Table = new String[]{"40405", "50405", "41405", "51404", "40505", "50504", "41504", "40415", "50414", "50404", "40504", "40514"};
    private double module = 8.0;
    private double height = 1.0;
    private StiCode11CheckSum checksum = StiCode11CheckSum.Auto;
    protected static final double Code11SpaceLeft = 5.0;
    protected static final double Code11SpaceRight = 5.0;
    protected static final double Code11SpaceTop = 0.0;
    protected static final double Code11SpaceBottom = 1.0;
    protected static final double Code11LineHeightShort = 40.0;
    protected static final double Code11LineHeightLong = 40.0;
    protected static final double Code11TextPosition = 41.0;
    protected static final double Code11TextHeight = 8.0;
    protected static final double Code11MainHeight = 50.0;
    protected static final double Code11LineHeightForCut = 40.0;
    protected static final double defaultCode11Module = 8.0;

    public StiCode11BarCodeType() {
        this(8.0, 1.0, StiCode11CheckSum.Auto);
    }

    public StiCode11BarCodeType(double module, double height, StiCode11CheckSum checksum) {
        this.module = module;
        this.height = height;
        this.checksum = checksum;
    }

    public String getServiceName() {
        return "Code11";
    }

    @Override
    @StiDefaulValue(value="8.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 4.0) {
            this.module = 4.0;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < (double)0.2f) {
            this.height = 0.2f;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="Auto")
    public final StiCode11CheckSum getChecksum() {
        return this.checksum;
    }

    public final void setChecksum(StiCode11CheckSum value) {
        this.checksum = value;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.0;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        int index;
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, this.Code11Symbols);
        int checksumLength = 0;
        if (this.checksum == StiCode11CheckSum.Auto) {
            int n = checksumLength = code.length() >= 10 ? 2 : 1;
        }
        if (this.checksum == StiCode11CheckSum.OneDigit) {
            checksumLength = 1;
        }
        if (this.checksum == StiCode11CheckSum.TwoDigits) {
            checksumLength = 2;
        }
        int[] fullCode = new int[code.length() + 2 + checksumLength];
        fullCode[0] = this.Code11StartStopSymbolIndex;
        for (int index2 = 0; index2 < code.length(); ++index2) {
            fullCode[index2 + 1] = this.Code11Symbols.indexOf(code.charAt(index2));
        }
        int checkSum = 0;
        int weight = 1;
        for (index = code.length(); index > 0; --index) {
            checkSum += fullCode[index] * weight;
            if (++weight <= 10) continue;
            weight = 1;
        }
        fullCode[code.length() + 1] = checkSum % 11;
        if (checksumLength == 2) {
            checkSum = 0;
            weight = 1;
            for (index = code.length() + 1; index > 0; --index) {
                checkSum += fullCode[index] * weight;
                if (++weight <= 9) continue;
                weight = 1;
            }
            fullCode[code.length() + 2] = checkSum % 9;
        }
        fullCode[fullCode.length - 1] = fullCode[0];
        StringBuilder barsArray = new StringBuilder();
        for (int index3 = 0; index3 < fullCode.length; ++index3) {
            barsArray.append(this.Code11Table[fullCode[index3]]);
            if (index3 == fullCode.length - 1) continue;
            barsArray.append("0");
        }
        this.CalculateSizeFull(5.0, 5.0, 0.0, 1.0, 40.0, 40.0, 41.0, 8.0, 50.0, 40.0, 2.0, zoom, code, code, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 8.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Height")) continue;
            this.height = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "A12345678B";
    }
}

