/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiAustraliaPost4StateBarCodeType
extends StiBarCodeTypeService {
    protected String AustraliaPost4StateSymbolsC = "ABC DEF#GHIabcdeJKLfMNOgPQRhijklSTUmVWXnYZ0opqrs123t456u789vwxyz";
    protected String AustraliaPost4StateSymbolsN = "012_345_678_9";
    private final String AustraliaPost4StateStartCode = "13";
    private final String AustraliaPost4StateStopCode = "13";
    private double module = 20.0;
    private double height = 1.0;
    protected static final double AustraliaPost4StateSpaceLeft = (double)11.8f;
    protected static final double AustraliaPost4StateSpaceRight = (double)11.8f;
    protected static final double AustraliaPost4StateSpaceTop = (double)10.9f;
    protected static final double AustraliaPost4StateSpaceBottom = (double)3.9f;
    protected static final double AustraliaPost4StateLineHeightLong = 10.0;
    protected static final double AustraliaPost4StateLineHeightShort = 6.200000047683716;
    protected static final double AustraliaPost4StateTextPosition = 1.0;
    protected static final double AustraliaPost4StateTextHeight = 5.0;
    protected static final double AustraliaPost4StateMainHeight = 24.799999713897705;
    protected static final double AustraliaPost4StateLineHeightForCut = 10.0;
    private static int[][] mult = new int[64][64];
    private static int[] gen = new int[]{0, 0, 0, 0, 0};

    public StiAustraliaPost4StateBarCodeType() {
        this(20.0, 1.0);
    }

    public StiAustraliaPost4StateBarCodeType(double module, double height) {
        this.module = module;
        this.height = height;
    }

    public String getServiceName() {
        return "Australia Post 4-state";
    }

    @Override
    @StiDefaulValue(value="20.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 20.0) {
            this.module = 20.0;
        }
        if (value > 20.0) {
            this.module = 20.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 1.0) {
            this.height = 1.0;
        }
        if (value > 1.0) {
            this.height = 1.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 5.0;
    }

    @Override
    protected StiTextHorAlignment getTextAlignment() {
        return StiTextHorAlignment.Left;
    }

    private static void RSInitialise() {
        int primpoly = 67;
        int test = 64;
        for (int i = 0; i < 64; ++i) {
            StiAustraliaPost4StateBarCodeType.mult[0][i] = 0;
            StiAustraliaPost4StateBarCodeType.mult[1][i] = i;
        }
        int prev = 1;
        for (int i = 1; i < 64; ++i) {
            int next = prev << 1;
            if ((next & test) != 0) {
                next ^= primpoly;
            }
            for (int j = 0; j < 64; ++j) {
                StiAustraliaPost4StateBarCodeType.mult[next][j] = mult[prev][j] << 1;
                if ((mult[next][j] & test) == 0) continue;
                int[] nArray = mult[next];
                int n = j;
                nArray[n] = nArray[n] ^ primpoly;
            }
            prev = next;
        }
        StiAustraliaPost4StateBarCodeType.gen[0] = 48;
        StiAustraliaPost4StateBarCodeType.gen[1] = 17;
        StiAustraliaPost4StateBarCodeType.gen[2] = 29;
        StiAustraliaPost4StateBarCodeType.gen[3] = 30;
        StiAustraliaPost4StateBarCodeType.gen[4] = 1;
    }

    private static int[] RSEncode(int[] infosymbols) {
        int i;
        if (gen[0] == 0) {
            StiAustraliaPost4StateBarCodeType.RSInitialise();
        }
        int[] temp = new int[31];
        int len = infosymbols.length;
        for (i = 0; i < 4; ++i) {
            temp[i] = 0;
        }
        for (i = 0; i < len; ++i) {
            temp[i + 4] = infosymbols[len - 1 - i];
        }
        for (i = len - 1; i >= 0; --i) {
            for (int j = 0; j <= 4; ++j) {
                temp[i + j] = temp[i + j] ^ mult[gen[j]][temp[4 + i]];
            }
        }
        int[] parity4 = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            parity4[i2] = temp[3 - i2];
        }
        return parity4;
    }

    private String CharTo4State(char inputChar, boolean useTableC) {
        StringBuilder outputString = new StringBuilder();
        if (useTableC) {
            int inputNumber = this.AustraliaPost4StateSymbolsC.indexOf(inputChar);
            outputString.append((char)((inputNumber >> 4 & 3) + 48));
            outputString.append((char)((inputNumber >> 2 & 3) + 48));
            outputString.append((char)((inputNumber & 3) + 48));
        } else {
            int inputNumber = this.AustraliaPost4StateSymbolsN.indexOf(inputChar);
            outputString.append((char)((inputNumber >> 2 & 3) + 48));
            outputString.append((char)((inputNumber & 3) + 48));
        }
        return outputString.toString();
    }

    private String StateToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        for (int index = 0; index < inputCode.length(); ++index) {
            if (inputCode.charAt(index) == '0') {
                outputBar.append("c");
            } else if (inputCode.charAt(index) == '1') {
                outputBar.append("d");
            } else if (inputCode.charAt(index) == '2') {
                outputBar.append("e");
            } else if (inputCode.charAt(index) == '3') {
                outputBar.append("f");
            }
            outputBar.append("0");
        }
        return outputBar.toString();
    }

    private StiBarCodeTypeService.ValueObject MakeBarsArray(String code) {
        StiBarCodeTypeService.ValueObject valueObject = new StiBarCodeTypeService.ValueObject();
        if (code.length() < 10) {
            valueObject.setErrorString("Data too short");
            return valueObject;
        }
        String FCC = code.substring(0, 2);
        String DPID = code.substring(2, 10);
        String CustInfo = code.substring(10);
        int custInfoLength = -1;
        if (FCC.equals("11") || FCC.equals("87") || FCC.equals("45") || FCC.equals("92")) {
            custInfoLength = 0;
        } else if (FCC.equals("59")) {
            custInfoLength = 16;
        } else if (FCC.equals("62") || FCC.equals("44")) {
            custInfoLength = 31;
        }
        if (custInfoLength < 0) {
            valueObject.setErrorString("Unknown FCC");
            return valueObject;
        }
        int custInfoSymbols = custInfoLength / 3;
        if (CustInfo.length() > custInfoSymbols) {
            valueObject.setErrorString("CustomerInfo too long");
            return valueObject;
        }
        if (custInfoSymbols > CustInfo.length()) {
            custInfoSymbols = CustInfo.length();
        }
        StringBuilder tempBarsArray = new StringBuilder();
        tempBarsArray.append(this.CharTo4State(FCC.charAt(0), false));
        tempBarsArray.append(this.CharTo4State(FCC.charAt(1), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(0), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(1), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(2), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(3), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(4), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(5), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(6), false));
        tempBarsArray.append(this.CharTo4State(DPID.charAt(7), false));
        for (int index = 0; index < custInfoSymbols; ++index) {
            tempBarsArray.append(this.CharTo4State(CustInfo.charAt(index), true));
        }
        if (tempBarsArray.length() < 21 + custInfoLength) {
            tempBarsArray.append(StiStringUtil.createCopies((char)'3', (int)(21 + custInfoLength - tempBarsArray.length())));
        }
        int triplesCount = tempBarsArray.length() / 3;
        int[] triples = new int[triplesCount];
        for (int index = 0; index < triplesCount; ++index) {
            triples[index] = (tempBarsArray.charAt(index * 3 + 0) - 48 << 4) + (tempBarsArray.charAt(index * 3 + 1) - 48 << 2) + (tempBarsArray.charAt(index * 3 + 2) - 48);
        }
        int[] rs = StiAustraliaPost4StateBarCodeType.RSEncode(triples);
        for (int index = 0; index < 4; ++index) {
            tempBarsArray.append((char)((rs[index] >> 4 & 3) + 48));
            tempBarsArray.append((char)((rs[index] >> 2 & 3) + 48));
            tempBarsArray.append((char)((rs[index] & 3) + 48));
        }
        valueObject.setBarsArray(this.StateToBar("13" + tempBarsArray.toString() + "13"));
        valueObject.setCode(String.format("%1$s %2$s %3$s %4$s %5$s %6$s %7$s", FCC, DPID, CustInfo.substring(0, custInfoSymbols), rs[0], rs[1], rs[2], rs[3]));
        return valueObject;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, this.AustraliaPost4StateSymbolsC);
        String barsArray = "";
        String errorString = "";
        StiBarCodeTypeService.ValueObject barsArrayResult = this.MakeBarsArray(new String(code));
        boolean tempVar = barsArrayResult.getResult();
        code = barsArrayResult.getCode();
        barsArray = barsArrayResult.getBarsArray();
        errorString = barsArrayResult.getErrorString();
        if (tempVar) {
            this.CalculateSizeFull(11.8f, 11.8f, 10.9f, 3.9f, 6.200000047683716, 10.0, 1.0, 5.0, 24.799999713897705, 10.0, 1.0, zoom, code, code, barsArray, rect, barCode);
            this.drawBarCode(context, rect, barCode);
        } else if (errorString.length() > 0) {
            this.drawBarCodeError(context, rect, barCode, errorString);
        } else {
            this.drawBarCodeError(context, rect, barCode);
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 20.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Height")) continue;
            this.height = property.floatValue().floatValue();
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "1139987520";
    }
}

