/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.report.barCodes.GaloisField;
import com.stimulsoft.report.barCodes.GaloisFieldPolynomial;
import java.util.ArrayList;

public class ReedSolomonEncoder {
    private final GaloisField field;
    private final ArrayList<GaloisFieldPolynomial> cachedGenerators;

    public ReedSolomonEncoder(GaloisField field) {
        this.field = field;
        this.cachedGenerators = new ArrayList();
        this.cachedGenerators.add(new GaloisFieldPolynomial(field, new int[]{1}));
    }

    private GaloisFieldPolynomial BuildGenerator(int degree) {
        if (degree >= this.cachedGenerators.size()) {
            GaloisFieldPolynomial lastGenerator = this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            for (int d = this.cachedGenerators.size(); d <= degree; ++d) {
                GaloisFieldPolynomial nextGenerator = lastGenerator.Multiply(new GaloisFieldPolynomial(this.field, new int[]{1, this.field.Exp(d - 1 + this.field.GetGeneratorBase())}));
                this.cachedGenerators.add(nextGenerator);
                lastGenerator = nextGenerator;
            }
        }
        return this.cachedGenerators.get(degree);
    }

    public void Encode(int[] toEncode, int ecBytes) {
        if (ecBytes == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int dataBytes = toEncode.length - ecBytes;
        if (dataBytes <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GaloisFieldPolynomial generator = this.BuildGenerator(ecBytes);
        int[] infoCoefficients = new int[dataBytes];
        System.arraycopy(toEncode, 0, infoCoefficients, 0, dataBytes);
        GaloisFieldPolynomial info = new GaloisFieldPolynomial(this.field, infoCoefficients);
        info = info.MultiplyByMonomial(ecBytes, 1);
        GaloisFieldPolynomial remainder = info.Divide(generator)[1];
        int[] coefficients = remainder.GetCoefficients();
        int numZeroCoefficients = ecBytes - coefficients.length;
        for (int i = 0; i < numZeroCoefficients; ++i) {
            toEncode[dataBytes + i] = 0;
        }
        System.arraycopy(coefficients, 0, toEncode, dataBytes + numZeroCoefficients, coefficients.length);
    }
}

