/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.io.StiFileUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.options.EngineOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StiReportCache {
    public static List<String> cachedDirectories;

    public static String createNewCache() {
        String temp = StiValidationUtil.isNullOrEmpty((String)EngineOptions.ReportCache.getCachePath()) ? System.getProperty("java.io.tmpdir") : EngineOptions.ReportCache.getCachePath();
        if (!new File(temp = temp + File.separator + "Stimulsoft" + File.separator + "ReportsCache").exists()) {
            new File(temp).mkdirs();
        }
        StiGuid cache = StiGuid.newGuid();
        if (!new File(temp = temp + File.separator + cache).exists()) {
            new File(temp).mkdirs();
        }
        if (cachedDirectories == null) {
            cachedDirectories = new ArrayList<String>();
        }
        cachedDirectories.add(temp);
        return temp;
    }

    public static void deleteCache(String path) {
        StiFileUtil.deleteFolder((File)new File(path));
    }

    public static void clearCache() {
        if (cachedDirectories == null) {
            return;
        }
        for (String path : cachedDirectories) {
            StiReportCache.deleteCache(path);
        }
    }

    public static String getPageCacheName(String cache, String cachePageGuid) {
        return cache + File.separator + cachePageGuid + ".mch";
    }

    private StiReportCache() {
    }
}

