/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.system.StiDateOnly;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.data.functons.StiDayOfWeekToStrHelper;
import com.stimulsoft.data.functons.StiMonthToStrHelper;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.RV;
import com.stimulsoft.report.resource.StiResourceManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class Func {

    public static class Zh {
        private static String[] NumChineseCharacter = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};

        public static String toWordsZh(BigDecimal num) {
            if (num.signum() <= 0) {
                return "\u4f60\u8f93\u5165\u7684\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u662f\u6570\u5b57!";
            }
            String str = num.toBigInteger().toString();
            String rs = Zh.numberString(str);
            rs = rs.replace("\u96f6\u96f6", "\u96f6");
            return rs;
        }

        public static String toCurrencyWordsZh(BigDecimal num) {
            String rs;
            if (num.signum() <= 0) {
                return "\u4f60\u8f93\u5165\u7684\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u662f\u6570\u5b57!";
            }
            String str = (num = num.setScale(2, RoundingMode.DOWN)).toPlainString();
            String[] nums = str.split("\\.");
            if (nums.length == 1) {
                rs = Zh.numberString(nums[0]) + "\u5143\u6574";
                rs = rs.replace("\u96f6\u96f6", "\u96f6");
            } else {
                rs = Zh.numberString(nums[0]) + "\u5143";
                rs = rs + Zh.floatString(nums[1]);
                rs = rs.replace("\u96f6\u96f6", "\u96f6");
            }
            return rs;
        }

        private static String floatString(String num) {
            String cc;
            String bb;
            int len;
            if (num.length() > 2) {
                num = num.substring(0, 2);
            }
            if ((len = (bb = Zh.convertString(num)).indexOf("\u96f6")) != 0) {
                if ((bb = bb.replace("\u96f6", "")).length() == 1) {
                    cc = bb.substring(0, 1) + "\u89d2\u6574";
                } else {
                    cc = bb.substring(0, 1) + "\u89d2";
                    cc = cc + bb.substring(1, 2) + "\u5206";
                }
            } else {
                cc = bb + "\u5206";
            }
            return cc;
        }

        private static String numberString(String num) {
            String bb = "";
            if (num.length() <= 4) {
                bb = Zh.convert4(num);
            } else if (num.length() > 4 && num.length() <= 8) {
                bb = Zh.convert4(num.substring(0, num.length() - 4)) + "\u4e07";
                bb = bb + Zh.convert4(num.substring(num.length() - 4, num.length()));
            } else if (num.length() > 8 && num.length() <= 12) {
                bb = Zh.convert4(num.substring(0, num.length() - 8)) + "\u4ebf";
                bb = Zh.convert4(num.substring(num.length() - 8, num.length() - 4)) == "" ? (Zh.convert4(num.substring(num.length() - 4, num.length())) != "" ? bb + "\u96f6" : bb + "") : bb + Zh.convert4(num.substring(num.length() - 8, num.length() - 4)) + "\u4e07";
                bb = bb + Zh.convert4(num.substring(num.length() - 4, num.length()));
            }
            return bb;
        }

        private static String convert4(String num) {
            String bb;
            if (num.length() == 1) {
                bb = Zh.convertString(num);
            } else if (num.length() == 2) {
                bb = Zh.convertString(num);
                bb = Zh.convert2(bb);
            } else if (num.length() == 3) {
                bb = Zh.convertString(num);
                bb = Zh.convert3(bb);
            } else {
                bb = Zh.convertString(num);
                String len = bb.substring(0, 4);
                if (len != "\u96f6\u96f6\u96f6\u96f6") {
                    len = bb.substring(0, 3);
                    if (len != "\u96f6\u96f6\u96f6") {
                        if ((bb = bb.replace("\u96f6\u96f6\u96f6", "")).length() == 1) {
                            bb = bb.substring(0, 1) + "\u4edf";
                        } else {
                            String cc = bb.substring(0, 1) != "\u96f6" && bb.substring(0, 2) != "\u96f6" ? bb.substring(0, 1) + "\u4edf" : bb.substring(0, 1);
                            bb = cc + Zh.convert3(bb.substring(1, 4));
                        }
                    } else {
                        bb = bb.replace("\u96f6\u96f6\u96f6", "\u96f6");
                    }
                } else {
                    bb = bb.replace("\u96f6\u96f6\u96f6\u96f6", "");
                }
            }
            return bb;
        }

        private static String convertString(String num) {
            String bb = "";
            for (int i = 0; i < num.length(); ++i) {
                bb = bb + NumChineseCharacter[Integer.parseInt(num.substring(i, i + 1))];
            }
            return bb;
        }

        private static String convert2(String num) {
            String cc;
            String len = num.substring(0, 1);
            if (len != "\u96f6") {
                String bb = num.replace("\u96f6", "");
                if (bb.length() == 1) {
                    cc = bb.substring(0, 1) + "\u62fe";
                } else {
                    cc = bb.substring(0, 1) + "\u62fe";
                    cc = cc + bb.substring(1, 2);
                }
            } else {
                cc = num;
            }
            return cc;
        }

        private static String convert3(String num) {
            String bb;
            String len = num.substring(0, 2);
            if (len != "\u96f6\u96f6") {
                bb = num.replace("\u96f6\u96f6", "");
                if (bb.length() == 1) {
                    bb = bb.substring(0, 1) + "\u4f70";
                } else {
                    String cc = bb.substring(0, 1) != "\u96f6" ? bb.substring(0, 1) + "\u4f70" : bb.substring(0, 1);
                    bb = cc + Zh.convert2(bb.substring(1, 3));
                }
            } else {
                bb = num.replace("\u96f6\u96f6", "\u96f6");
            }
            return bb;
        }
    }

    public static class MonthToStr {
        public static String monthName(StiDateTime dateTime, Locale locale) {
            return StiMonthToStrHelper.monthName(dateTime, locale);
        }

        public static String monthName(StiDateTime dateTime, Boolean localized) {
            return StiMonthToStrHelper.monthName(dateTime, localized);
        }

        public static String monthName(StiDateTime dateTime, String culture) {
            return StiMonthToStrHelper.monthName(dateTime, culture);
        }

        public static String monthName(StiDateTime dateTime, String culture, Boolean upperCase) {
            return StiMonthToStrHelper.monthName(dateTime, culture, upperCase);
        }

        public static void addCulture(String[] monthNames, String[] cultureNames, Boolean defaultUpperCase) {
            StiMonthToStrHelper.addCulture(monthNames, cultureNames, defaultUpperCase);
        }
    }

    public static class EngineHelper {
        public static int getRealPageNumber(Object sender) {
            StiComponent comp;
            int pageNumber = 0;
            StiComponent stiComponent = comp = sender instanceof StiComponent ? (StiComponent)sender : null;
            if (comp != null) {
                int pageIndex;
                pageNumber = comp.getReport().getPageNumber();
                StiPage page = comp.getPage();
                if (page != null && (pageIndex = comp.getReport().getRenderedPages().indexOf(page)) != -1 && comp.getReport().getEngine() != null && comp.getReport().getEngine().getPageNumbers() != null) {
                    pageNumber = comp.getReport().getEngine().getPageNumbers().GetPageNumber(pageIndex);
                }
                double pageWidth = page.getPageWidth() - page.getMargins().getLeft() - page.getMargins().getRight();
                for (double compLeft = comp.getLeft(); compLeft > pageWidth; compLeft -= pageWidth) {
                    ++pageNumber;
                }
                double pageHeight = page.getPageHeight() - page.getMargins().getTop() - page.getMargins().getBottom();
                for (double compTop = comp.getTop(); compTop > pageHeight; compTop -= pageHeight) {
                    pageNumber += page.getSegmentPerWidth();
                }
            }
            return pageNumber;
        }

        public static String joinColumnContent(StiDataSource dataSource, String columnName, String delimiter) {
            return EngineHelper.joinColumnContent(dataSource, columnName, delimiter, false);
        }

        public static String joinColumnContent(StiDataSource dataSource, String columnName, String delimiter, boolean distinct) {
            ArrayList<String> list = new ArrayList<String>();
            HashMap hash = new HashMap();
            if (!dataSource.isEmpty()) {
                StiCalcDataColumn cdc = dataSource.getColumns().get(columnName) instanceof StiCalcDataColumn ? (StiCalcDataColumn)dataSource.getColumns().get(columnName) : null;
                StiPage page = dataSource.getDictionary() == null && dataSource.getDictionary().getReport() == null ? dataSource.getDictionary().getReport().getPages().get(0) : null;
                boolean needCalc = cdc != null && page != null;
                dataSource.saveState("JoinColumnContent");
                dataSource.First();
                while (!dataSource.getIsEof()) {
                    String st = null;
                    st = needCalc ? StiParser.ParseTextValue("{" + cdc.getValue() + "}", page).toString() : dataSource.get(columnName).toString();
                    boolean needAdd = true;
                    if (distinct) {
                        if (hash.containsKey(st)) {
                            needAdd = false;
                        } else {
                            hash.put(st, null);
                        }
                    }
                    if (needAdd) {
                        list.add(st);
                    }
                    dataSource.Next();
                }
                dataSource.RestoreState("JoinColumnContent");
            }
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < list.size(); ++index) {
                sb.append((String)list.get(index));
                if (index >= list.size() - 1) continue;
                sb.append(delimiter);
            }
            return sb.toString();
        }

        public static String toQueryString(List<?> list, String quotationMark, String dateTimeFormat) {
            return EngineHelper.toQueryString(list, quotationMark, dateTimeFormat, true);
        }

        public static String toQueryString(List<?> list, String quotationMark, String dateTimeFormat, boolean needEscape) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (Object obj : list) {
                String st;
                if (index > 0) {
                    sb.append(", ");
                }
                if (StiValidationUtil.isNullOrEmpty((String)dateTimeFormat)) {
                    st = obj.toString();
                } else {
                    String string = st = obj instanceof StiDateTime ? ((StiDateTime)obj).format(dateTimeFormat) : ((StiDateOnly)obj).format(dateTimeFormat, Locale.getDefault());
                }
                if (needEscape) {
                    st = st.replace("\\", "\\\\").replace("'", "\\'");
                    if (!StiValidationUtil.isNullOrEmpty((String)quotationMark) && quotationMark != "'") {
                        st = st.replace(quotationMark, quotationMark + quotationMark);
                    }
                } else if (!StiValidationUtil.isNullOrEmpty((String)quotationMark)) {
                    st = st.replace(quotationMark, quotationMark + quotationMark);
                }
                sb.append(quotationMark + st + quotationMark);
                ++index;
            }
            return sb.toString();
        }
    }

    public static class Convert {
        private static int[] Arabics = new int[]{1, 5, 10, 50, 100, 1000};
        private static char[] Romans = new char[]{'I', 'V', 'X', 'L', 'C', 'M'};
        private static int[] Subs = new int[]{0, 0, 0, 2, 2, 4};
        private static char[] ABC = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        private static char[] ABCRu = new char[]{'\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042d', '\u042e', '\u042f'};

        public static byte[] fromBase64String(String base64) {
            return StiBase64DecoderUtil.decode((String)base64);
        }

        public static String toRoman(int value) {
            Object report = null;
            StringBuilder str = new StringBuilder();
            block0: while (value > 0) {
                for (int i = 5; i >= 0; --i) {
                    if (value >= Arabics[i]) {
                        str.append(Romans[i]);
                        value -= Arabics[i];
                        continue block0;
                    }
                    boolean flag = false;
                    for (int j = Subs[i]; j < i; ++j) {
                        if (Arabics[j] == Arabics[i] - Arabics[j] || value < Arabics[i] - Arabics[j]) continue;
                        str.append(Romans[j]);
                        str.append(Romans[i]);
                        value -= Arabics[i] - Arabics[j];
                        flag = true;
                        break;
                    }
                    if (flag) continue block0;
                }
            }
            return str.toString();
        }

        public static String toArabic(int value, Boolean useEasternDigits) {
            return Convert.toArabic(String.valueOf(value), useEasternDigits);
        }

        public static String toArabic(String value, Boolean useEasternDigits) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < value.length(); ++index) {
                int num = value.charAt(index);
                if (num >= 48 && num <= 57) {
                    num += 1584;
                    if (useEasternDigits.booleanValue()) {
                        num += 144;
                    }
                }
                sb.append((char)num);
            }
            return sb.toString();
        }

        public static double toSingle(Object value) {
            try {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return Double.valueOf(value.toString());
            }
            catch (Exception exception) {
                return 0.0;
            }
        }

        public static double toDouble(Object value) {
            return Convert.toSingle(value);
        }

        public static double toDecimal(Object value) {
            return Convert.toSingle(value);
        }

        public static BigDecimal toBigDecimal(Object value) {
            try {
                if (value instanceof BigDecimal) {
                    return (BigDecimal)value;
                }
                return new BigDecimal(value.toString());
            }
            catch (Exception e) {
                return new BigDecimal(0);
            }
        }

        public static long toInt32(Object value) {
            try {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                return Long.valueOf(value.toString());
            }
            catch (Exception exception) {
                return 0L;
            }
        }

        public static int toInt(Object value) {
            try {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return Integer.valueOf(value.toString());
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public static boolean toBoolean(Object value) {
            try {
                return Boolean.valueOf(String.valueOf(value));
            }
            catch (Exception exception) {
                return false;
            }
        }

        public static char toChar(Object value) {
            try {
                return value.toString().charAt(0);
            }
            catch (Exception exception) {
                return '\uffff';
            }
        }

        public static String toString(Object value, int radix) {
            if (value.getClass() == Long.class) {
                return Long.toString((Long)value, radix);
            }
            if (value.getClass() == Integer.class) {
                return Integer.toString((Integer)value, radix);
            }
            if (value.getClass() == Byte.class) {
                return Long.toString(((Byte)value).byteValue(), radix);
            }
            if (value.getClass() == Short.class) {
                return Long.toString(((Short)value).shortValue(), radix);
            }
            return value.toString();
        }

        public static String toString(Object value) {
            try {
                String result = String.valueOf(value);
                if (value instanceof Number && (result.endsWith(".0") || result.endsWith(",0"))) {
                    return result.substring(0, result.length() - 2);
                }
                return result;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static StiDateTime toDateTime(Object value) {
            try {
                if (value instanceof StiDateTime) {
                    return (StiDateTime)value;
                }
                if (value instanceof Calendar) {
                    return new StiDateTime((Calendar)value);
                }
                if (value instanceof ZonedDateTime) {
                    return new StiDateTime((ZonedDateTime)value);
                }
                if (value instanceof Date) {
                    return new StiDateTime((Date)value);
                }
                return StiDateTime.fromString((String)value.toString());
            }
            catch (Exception e) {
                if (StiLoggingUtil.getLogLevel() >= 10) {
                    e.printStackTrace();
                }
                return new StiDateTime();
            }
        }
    }

    public static class En {
        private static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        private static String[] units = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        private static String[] tens = new String[]{"ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};

        private static void addUnits(StringBuilder sb, long value) {
            if (value != 0L) {
                sb.append(units[(int)value - 1]);
            }
        }

        private static void addTens(StringBuilder sb, long value) {
            if (value != 0L) {
                sb.append(tens[(int)value - 1]);
            }
        }

        private static RV addRank(StringBuilder sb, RV rv, String unit) {
            BigDecimal rankValue = rv.value.divideToIntegralValue(rv.rank);
            if (rankValue.signum() > 0) {
                BigDecimal hundreds = rankValue.divideToIntegralValue(new BigDecimal("100"));
                BigDecimal tens = rankValue.divideToIntegralValue(new BigDecimal("10")).remainder(new BigDecimal("10"));
                BigDecimal units = rankValue.remainder(new BigDecimal("10")).setScale(2, RoundingMode.DOWN);
                if (tens.compareTo(new BigDecimal("1")) == 0) {
                    tens = new BigDecimal("0");
                    units = rankValue.remainder(new BigDecimal("100"));
                }
                if (sb.length() > 0) {
                    if (hundreds.compareTo(new BigDecimal("0")) > 0) {
                        sb.append(" ");
                    } else if (tens.add(units).signum() > 0) {
                        sb.append(" and ");
                    }
                }
                if (hundreds.signum() > 0) {
                    En.addUnits(sb, hundreds.intValue());
                    sb.append(" hundred");
                    if (tens.add(units).signum() > 0) {
                        sb.append(" and ");
                    }
                }
                if (tens.signum() > 0) {
                    En.addTens(sb, tens.longValue());
                    if (units.signum() > 0) {
                        sb.append("-");
                    }
                }
                if (units.signum() > 0) {
                    En.addUnits(sb, units.longValue());
                }
                sb.append(" ");
                sb.append(unit);
                rv.value = rv.value.remainder(rv.rank);
            }
            rv.rank = rv.rank.divide(new BigDecimal(1000));
            return rv;
        }

        public static String decline(BigDecimal value, String one, String two) {
            BigDecimal units = value.remainder(new BigDecimal("100"));
            if (units.compareTo(new BigDecimal("1")) == 0) {
                return one;
            }
            return two;
        }

        public static String decline(BigDecimal value, boolean showCents, String dollars, String cents) {
            if (showCents) {
                String[] strCents = cents.split("/");
                return En.decline(value, strCents[0], strCents[1]);
            }
            String[] strDollars = dollars.split("/");
            return En.decline(value, strDollars[0], strDollars[1]);
        }

        public static String numToStr(BigDecimal value) {
            return En.numToStr(value, true);
        }

        public static String numToStr(BigDecimal value, boolean uppercase) {
            StringBuilder sb = new StringBuilder();
            if (value.signum() == 0) {
                sb.append("zero");
            } else {
                boolean isNegative = false;
                if (value.signum() < 0) {
                    isNegative = true;
                    value = value.abs();
                }
                BigDecimal rank = new BigDecimal("1000000000000000000");
                RV rv = new RV(rank, value);
                rv = En.addRank(sb, rv, "quintillion");
                rv = En.addRank(sb, rv, "quadrillion");
                rv = En.addRank(sb, rv, "trillion");
                rv = En.addRank(sb, rv, "billion");
                rv = En.addRank(sb, rv, "million");
                rv = En.addRank(sb, rv, "thousand");
                rv = En.addRank(sb, rv, "");
                if (isNegative) {
                    sb.insert(0, "minus ");
                }
            }
            if (uppercase) {
                sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
            }
            return sb.toString();
        }

        public static String numToStr(double value, boolean uppercase) {
            return En.numToStr((long)value, uppercase);
        }

        public static String numToStr(double value) {
            return En.numToStr((long)value);
        }

        public static String currToStr(long value) {
            return En.currToStr(new BigDecimal(value));
        }

        public static String currToStr(long value, boolean showCents) {
            return En.currToStr(new BigDecimal(value), showCents);
        }

        public static String currToStr(long value, boolean uppercase, boolean cents) {
            return En.currToStr(new BigDecimal(value), uppercase, cents);
        }

        public static String currToStr(double value) {
            return En.currToStr(new BigDecimal(value));
        }

        public static String currToStr(double value, boolean showCents) {
            return En.currToStr(new BigDecimal(value), showCents);
        }

        public static String currToStr(double value, boolean uppercase, boolean cents) {
            return En.currToStr(new BigDecimal(value), uppercase, cents);
        }

        public static String currToStr(BigDecimal value) {
            return En.currToStr(value, true, true);
        }

        public static String currToStr(BigDecimal value, boolean showCents) {
            return En.currToStr(value, true, showCents);
        }

        public static String currToStr(BigDecimal value, boolean uppercase, boolean showCents) {
            return En.currToStr(value, uppercase, showCents, "dollar/dollars", "cent/cents");
        }

        public static String currToStr(long value, boolean uppercase, boolean showCents, String dollars, String cents) {
            return En.currToStr(new BigDecimal(value), uppercase, showCents, dollars, cents);
        }

        public static String currToStr(double value, boolean uppercase, boolean showCents, String dollars, String cents) {
            return En.currToStr(new BigDecimal(value), uppercase, showCents, dollars, cents);
        }

        public static String currToStr(BigDecimal value, boolean uppercase, boolean showCents, String dollars, String cents) {
            BigDecimal integral = value.setScale(2, RoundingMode.DOWN);
            BigDecimal dec = new BigDecimal("0");
            if (StiOptions.Engine.getUseRoundForToCurrencyWordsFunctions()) {
                dec = value.subtract(integral).multiply(new BigDecimal("100")).setScale(0, RoundingMode.HALF_UP);
                if (dec.compareTo(new BigDecimal("99")) > 0) {
                    dec = new BigDecimal("0");
                    integral = integral.subtract(new BigDecimal("1"));
                }
            } else {
                dec = value.subtract(integral).multiply(new BigDecimal("100"));
            }
            String str = En.numToStr(integral, uppercase);
            if (value.signum() == 0) {
                str = str + " ";
            }
            if (!str.endsWith(" ")) {
                str = str + " ";
            }
            str = String.format("%s%s", str, En.decline(integral, false, dollars, cents));
            if (showCents) {
                str = str + " and ";
                str = str + String.format("%s", En.numToStr(dec, false));
                if (dec.signum() == 0) {
                    str = str + " ";
                }
                str = str + String.format("%s", En.decline(dec, true, dollars, cents));
            }
            return str;
        }

        public static String DateToStr(StiDateTime date) {
            return En.DateToStr(date, false);
        }

        public static String DateToStr(StiDateTime date, boolean uppercase) {
            StringBuilder sb = new StringBuilder(String.format("%s %s %s", date.day(), months[date.month() - 1], date.year()));
            if (uppercase) {
                String ch = sb.delete(0, 1).toString();
                sb.insert(0, ch.toUpperCase());
            }
            return sb.toString();
        }
    }

    public static class Es {
        private static String[][] currencies = new String[][]{{"d\u00f3lar", "d\u00f3lares", "centavo", "centavos"}, {"euro", "euros", "c\u00e9ntimo", "c\u00e9ntimos"}};
        private static String ZeroWord = "cero";
        private static String LessWord = "menos";
        private static String[][] triplets = new String[7][2];
        private static String[] lessTwenty = new String[20];
        private static String[] tens = new String[10];

        public static String convertToWord(BigDecimal number, String currencyISO, long decimals, boolean female) throws StiException {
            int centGender;
            int gender;
            String culture = "es-ES";
            if (number.compareTo(NumToWordHelper.MaxValue) > 0) {
                throw new StiException("Value too long: " + number);
            }
            BigDecimal integerPart = new BigDecimal(number.toBigInteger());
            BigDecimal decimalPart = number.subtract(integerPart).multiply(new BigDecimal(Math.pow(10.0, decimals)));
            if (decimalPart.compareTo(NumToWordHelper.MaxValue) > 0) {
                throw new StiException("Value too long: " + decimalPart);
            }
            int n = gender = female ? 2 : Integer.parseInt(Resource.resourceManager.getString(currencyISO + "Gender", culture));
            if (gender == 0) {
                gender = 1;
            }
            String integerString = Es.convertToWord(integerPart.longValue(), gender, 0, false);
            int n2 = centGender = female ? 2 : Integer.parseInt(Resource.resourceManager.getString(currencyISO + "CentGender", culture));
            if (centGender == 0) {
                centGender = 1;
            }
            String decimalString = Es.convertToWord(decimalPart.longValue(), centGender, 0, false);
            String postCurrency = "y";
            StiRefObject mainCurrency = new StiRefObject((Object)"");
            StiRefObject centCurrency = new StiRefObject((Object)"");
            NumToWordHelper.determinateCurrencies(culture, currencyISO, integerPart.longValue(), decimalPart.longValue(), (StiRefObject<String>)mainCurrency, (StiRefObject<String>)centCurrency);
            Es.determinateCurrenciesEurUsd(culture, currencyISO, integerPart.longValue(), decimalPart.longValue(), (StiRefObject<String>)mainCurrency, (StiRefObject<String>)centCurrency);
            String stringValue = NumToWordHelper.addWords(integerString, decimalString, (String)mainCurrency.argvalue, (String)centCurrency.argvalue, postCurrency);
            return stringValue.trim();
        }

        private static void determinateCurrenciesEurUsd(String culture, String currencyISO, long integerPart, long decimalPart, StiRefObject<String> mainCurrency, StiRefObject<String> centCurrency) {
            int currencyIndex = -1;
            if ("USD".equals(currencyISO)) {
                currencyIndex = 0;
            }
            if ("EUR".equals(currencyISO)) {
                currencyIndex = 1;
            }
            if (currencyIndex != -1) {
                mainCurrency.argvalue = integerPart / 1000000L > 0L && integerPart % 1000000L == 0L ? currencies[currencyIndex][1] : (integerPart != 1L ? currencies[currencyIndex][1] : currencies[currencyIndex][0]);
                centCurrency.argvalue = decimalPart != 1L ? currencies[currencyIndex][3] : currencies[currencyIndex][2];
            }
        }

        private static String convertToWord(long number, int Gender2, int tranche, boolean alone) {
            boolean lessThanZero;
            String result = "";
            boolean bl = lessThanZero = number < 0L;
            if (lessThanZero) {
                number = Math.abs(number);
            }
            if (number == 0L) {
                result = ZeroWord;
            } else if (number < 20L) {
                result = number == 1L && Gender2 == 2 ? "una" : (number == 1L && Gender2 == 1 && !alone ? "un" : lessTwenty[(int)number]);
            } else if (number < 100L) {
                result = number % 10L == 0L ? tens[(int)number / 10] : (number / 10L == 2L ? "veinti" + Es.convertToWord(number % 10L, Gender2, 0, alone) : tens[(int)number / 10] + " y " + Es.convertToWord(number % 10L, Gender2, 0, alone));
            } else if (number < 1000L) {
                switch ((int)number / 100) {
                    case 1: {
                        result = number == 100L ? "cien" : "ciento";
                        break;
                    }
                    case 5: {
                        result = Gender2 == 1 ? "quinientos" : "quinientas";
                        break;
                    }
                    case 7: {
                        result = Gender2 == 1 ? "setecientos" : "setecientas";
                        break;
                    }
                    case 9: {
                        result = Gender2 == 1 ? "novecientos" : "novecientas";
                        break;
                    }
                    default: {
                        result = Es.convertToWord(number / 100L, Gender2, 0, false) + (Gender2 == 1 ? "cientos" : "cientas");
                    }
                }
                if (number % 100L > 0L) {
                    result = result + " " + Es.convertToWord(number % 100L, Gender2, 0, alone);
                }
            } else {
                result = number < 1000000L ? (number / 1000L == 1L ? triplets[1][0] + (number % 1000L == 0L ? "" : " " + Es.convertToWord(number % 1000L, Gender2, 0, alone)) : Es.convertToWord(number / 1000L, Gender2, 1, false) + triplets[1][1] + (number % 1000L == 0L ? "" : " " + Es.convertToWord(number % 1000L, Gender2, 0, alone))) : (number < 1000000000000L ? (number / 1000000L == 1L ? Es.convertToWord(number / 1000000L, Gender2, 2, false) + triplets[2][0] + (number % 1000000L == 0L ? "" : " " + Es.convertToWord(number % 1000000L, Gender2, 0, alone)) : Es.convertToWord(number / 1000000L, Gender2, 2, false) + triplets[2][1] + (number % 1000000L == 0L ? "" : " " + Es.convertToWord(number % 1000000L, Gender2, 0, alone))) : (number < 1000000000000000000L ? (number / 1000000000000L == 1L ? Es.convertToWord(number / 1000000000000L, Gender2, 2, false) + triplets[4][0] + (number % 1000000000000L == 0L ? "" : " " + Es.convertToWord(number % 1000000000000L, Gender2, 0, alone)) : Es.convertToWord(number / 1000000000000L, Gender2, 2, false) + triplets[4][1] + (number % 1000000000000L == 0L ? "" : " " + Es.convertToWord(number % 1000000000000L, Gender2, 0, alone))) : (number / 1000000000000000000L == 1L ? Es.convertToWord(number / 1000000000000000000L, Gender2, 2, false) + triplets[6][0] + (number % 1000000000000000000L == 0L ? "" : " " + Es.convertToWord(number % 1000000000000000000L, Gender2, 0, alone)) : Es.convertToWord(number / 1000000000000000000L, Gender2, 2, false) + triplets[6][1] + (number % 1000000000000000000L == 0L ? "" : " " + Es.convertToWord(number % 1000000000000000000L, Gender2, 0, alone)))));
            }
            if (lessThanZero) {
                result = LessWord + " " + result;
            }
            return result.trim();
        }

        static {
            Es.triplets[0][0] = "";
            Es.triplets[1][0] = " mil";
            Es.triplets[2][0] = " mill\u00f3n";
            Es.triplets[3][0] = " mil milliones";
            Es.triplets[4][0] = " bill\u00f3n";
            Es.triplets[5][0] = " mil bill\u00f3n";
            Es.triplets[6][0] = " trill\u00f3n";
            Es.triplets[0][1] = "";
            Es.triplets[1][1] = " mil";
            Es.triplets[2][1] = " millones";
            Es.triplets[3][1] = " mil milliones";
            Es.triplets[4][1] = " bill\u00f3nes";
            Es.triplets[5][1] = " mil bill\u00f3nes";
            Es.triplets[6][1] = " trill\u00f3nes";
            Es.lessTwenty[0] = "";
            Es.lessTwenty[1] = "uno";
            Es.lessTwenty[2] = "dos";
            Es.lessTwenty[3] = "tres";
            Es.lessTwenty[4] = "cuatro";
            Es.lessTwenty[5] = "cinco";
            Es.lessTwenty[6] = "seis";
            Es.lessTwenty[7] = "siete";
            Es.lessTwenty[8] = "ocho";
            Es.lessTwenty[9] = "nueve";
            Es.lessTwenty[10] = "diez";
            Es.lessTwenty[11] = "once";
            Es.lessTwenty[12] = "doce";
            Es.lessTwenty[13] = "trece";
            Es.lessTwenty[14] = "catorce";
            Es.lessTwenty[15] = "quince";
            Es.lessTwenty[16] = "diecis\u00e9is";
            Es.lessTwenty[17] = "diecisiete";
            Es.lessTwenty[18] = "dieciocho";
            Es.lessTwenty[19] = "diecinueve";
            Es.tens[2] = "veinte";
            Es.tens[3] = "treinta";
            Es.tens[4] = "cuarenta";
            Es.tens[5] = "cincuenta";
            Es.tens[6] = "sesenta";
            Es.tens[7] = "setenta";
            Es.tens[8] = "ochenta";
            Es.tens[9] = "noventa";
        }
    }

    public static class NumToWordHelper {
        public static final BigDecimal MaxValue = new BigDecimal("1000000000000000");

        public static void determinateCurrencies(String culture, String currencyISO, long integerPart, long decimalPart, StiRefObject<String> mainCurrency, StiRefObject<String> centCurrency) {
            mainCurrency.argvalue = integerPart / 1000000L > 0L && integerPart % 1000000L == 0L ? Resource.resourceManager.getString(currencyISO + "BigSeparator", culture) : (integerPart != 1L ? Resource.resourceManager.getString(currencyISO + "Plural", culture) : Resource.resourceManager.getString(currencyISO + "Single", culture));
            centCurrency.argvalue = decimalPart != 1L ? Resource.resourceManager.getString(currencyISO + "CentPlural", culture) : Resource.resourceManager.getString(currencyISO + "CentSingle", culture);
        }

        public static String addWords(String integerString, String decimalString, String mainCurrency, String centCurrency, String postCurrency) {
            StiRefObject stringValue = new StiRefObject((Object)"");
            NumToWordHelper.addWord((StiRefObject<String>)stringValue, integerString, " ");
            NumToWordHelper.addWord((StiRefObject<String>)stringValue, mainCurrency, " ");
            NumToWordHelper.addWord((StiRefObject<String>)stringValue, postCurrency, " ");
            NumToWordHelper.addWord((StiRefObject<String>)stringValue, decimalString, " ");
            NumToWordHelper.addWord((StiRefObject<String>)stringValue, centCurrency, " ");
            return (String)stringValue.argvalue;
        }

        private static void addWord(StiRefObject<String> value, String word, String separator) {
            if (!StiValidationUtil.isNullOrEmpty((String)word)) {
                value.argvalue = (String)value.argvalue + separator + word;
            }
        }
    }

    public static class PtBr {
        private static String[] unid = new String[]{"ZERO ", "UM ", "DOIS ", "TR\u00caS ", "QUATRO ", "CINCO ", "SEIS ", "SETE ", "OITO ", "NOVE ", "DEZ ", "ONZE ", "DOZE ", "TREZE ", "CATORZE ", "QUINZE ", "DEZESSEIS ", "DEZESSETE ", "DEZOITO ", "DEZENOVE "};
        private static String[] dezena = new String[]{"ZERO ", "DEZ ", "VINTE ", "TRINTA ", "QUARENTA ", "CINQ\u00dcENTA ", "SESSENTA ", "SETENTA ", "OITENTA ", "NOVENTA "};
        private static String[] centena = new String[]{"ZERO ", "CENTO ", "DUZENTOS ", "TREZENTOS ", "QUATROCENTOS ", "QUINHENTOS ", "SEISCENTOS ", "SETECENTOS ", "OITOCENTOS ", "NOVECENTOS "};

        public static String numToStr(BigDecimal value) {
            return PtBr.numToStr(value, false, "REAL/REAIS", "CENTAVO/CENTAVOS");
        }

        public static String numToStr(BigDecimal value, boolean uppercase, String dollars, String cents) {
            if (StiValidationUtil.isNullOrEmpty((String)dollars) || !dollars.contains("/")) {
                dollars = dollars + "/" + dollars;
            }
            if (StiValidationUtil.isNullOrEmpty((String)cents) || !cents.contains("/")) {
                cents = cents + "/" + cents;
            }
            String[] stDollars = dollars.split("/");
            String[] stCents = cents.split("/");
            String[] grupo = new String[5];
            String[] texto = new String[]{"", "", "", "", ""};
            DecimalFormat df = new DecimalFormat("0000000000.00");
            String valor = df.format(value.doubleValue());
            grupo[1] = valor.substring(1, 4);
            grupo[2] = valor.substring(4, 7);
            grupo[3] = valor.substring(7, 10);
            grupo[4] = "0" + valor.substring(11, 13);
            for (int contador = 1; contador <= 4; ++contador) {
                int tamanho;
                String parte = grupo[contador];
                int tempInt = Integer.parseInt(parte);
                int n = tempInt < 10 ? 1 : (tempInt < 100 ? 2 : (tamanho = tempInt < 1000 ? 3 : 0));
                if (tamanho == 3) {
                    if (!parte.endsWith("00")) {
                        int n2 = contador;
                        texto[n2] = texto[n2] + centena[Integer.parseInt(parte.substring(0, 1))] + "E ";
                        tamanho = 2;
                    } else {
                        int n3 = contador;
                        texto[n3] = texto[n3] + (parte.startsWith("1") ? "CEM " : centena[Integer.parseInt(parte.substring(0, 1))]);
                    }
                }
                if (tamanho == 2) {
                    if (Integer.parseInt(parte.substring(1, 3)) < 20) {
                        int n4 = contador;
                        texto[n4] = texto[n4] + unid[Integer.parseInt(parte.substring(1, 3))];
                    } else {
                        int n5 = contador;
                        texto[n5] = texto[n5] + dezena[Integer.parseInt(parte.substring(1, 2))];
                        if (!parte.endsWith("0")) {
                            int n6 = contador;
                            texto[n6] = texto[n6] + "E ";
                            tamanho = 1;
                        }
                    }
                }
                if (tamanho != 1) continue;
                int n7 = contador;
                texto[n7] = texto[n7] + unid[Integer.parseInt(parte.substring(2, 3))];
            }
            String final_ = "";
            if (Integer.parseInt(grupo[1] + grupo[2] + grupo[3]) == 0 && Integer.parseInt(grupo[4]) != 0) {
                final_ = texto[4] + (Integer.parseInt(grupo[4]) == 1 ? stCents[0] : stCents[1]);
            } else {
                String string = Integer.parseInt(grupo[1]) != 0 ? texto[1] + (Integer.parseInt(grupo[1]) > 1 ? "MILH\u00d5ES " : "MILH\u00c3O ") : (final_ = "");
                final_ = Integer.parseInt(grupo[2] + grupo[3]) == 0 ? final_ + "DE " : final_ + (Integer.parseInt(grupo[2]) != 0 ? texto[2] + "MIL " : "");
                final_ = final_ + (Integer.parseInt(grupo[3]) != 0 ? texto[3] : "");
                final_ = final_ + (Integer.parseInt(grupo[1] + grupo[2] + grupo[3]) == 1 ? stDollars[0] : stDollars[1]) + " ";
                final_ = final_ + (Integer.parseInt(grupo[4]) != 0 ? "E " + texto[4] + (Integer.parseInt(grupo[4]) == 1 ? stCents[0] : stCents[1]) : "");
            }
            String output = "";
            output = value.doubleValue() == 0.0 ? unid[0] : final_.trim();
            return uppercase ? Character.toUpperCase(output.charAt(0)) + output.substring(1).toLowerCase() : output.toLowerCase();
        }
    }

    public static class Ua {
        private static String[] months = new String[]{"\u0441\u0456\u0447\u043d\u044f", "\u043b\u044e\u0442\u043e\u0433\u043e", "\u0431\u0435\u0440\u0435\u0437\u043d\u044f", "\u043a\u0432\u0456\u0442\u043d\u044f", "\u0442\u0440\u0430\u0432\u043d\u044f", "\u0447\u0435\u0440\u0432\u043d\u044f", "\u043b\u0438\u043f\u043d\u044f", "\u0441\u0435\u0440\u043f\u043d\u044f", "\u0432\u0435\u0440\u0435\u0441\u043d\u044f", "\u0436\u043e\u0432\u0442\u043d\u044f", "\u043b\u0438\u0441\u0442\u043e\u043f\u0430\u0434\u0430", "\u0433\u0440\u0443\u0434\u043d\u044f"};
        private static String[] units = new String[]{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438", "\u043f'\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u044c", "\u0441\u0456\u043c", "\u0432\u0456\u0441\u0456\u043c", "\u0434\u0435\u0432'\u044f\u0442\u044c", "\u0434\u0435\u0441\u044f\u0442\u044c", "\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u043f'\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0434\u0435\u0432'\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c"};
        private static String[] tens = new String[]{"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u044f\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u044f\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f'\u044f\u0442\u0434\u0435\u0441\u044f\u0442", "\u0448\u0456\u0441\u0442\u0434\u0435\u0441\u044f\u0442", "\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442", "\u0432\u0456\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432'\u044f\u043d\u043e\u0441\u0442\u043e"};
        private static String[] hundreds = new String[]{"\u0441\u0442\u043e", "\u0434\u0432\u0456\u0441\u0442\u0456", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u043e\u0442\u0438\u0440\u0438\u0441\u0442\u0430", "\u043f'\u044f\u0442\u0441\u043e\u0442", "\u0448\u0456\u0441\u0442\u0441\u043e\u0442", "\u0441\u0456\u043c\u0441\u043e\u0442", "\u0432\u0456\u0441\u0456\u043c\u0441\u043e\u0442", "\u0434\u0435\u0432'\u044f\u0442\u0441\u043e\u0442"};
        private static String[][] gendered = new String[][]{{"\u043e\u0434\u0438\u043d", "\u043e\u0434\u043d\u0430", "\u043e\u0434\u043d\u0435"}, {"\u0434\u0432\u0430", "\u0434\u0432\u0456", "\u0434\u0432\u0430"}};

        private static void addUnits(StringBuilder sb, BigDecimal value, int gender) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (value.compareTo(new BigDecimal("3")) < 0) {
                    sb.append(gendered[value.intValue() - 1][gender]);
                } else {
                    sb.append(units[value.intValue() - 1]);
                }
            }
        }

        private static void addTens(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(tens[value.intValue() - 1]);
            }
        }

        private static void addHundreds(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(hundreds[value.intValue() - 1]);
            }
        }

        private static void addThousand(StringBuilder sb, BigDecimal value, int gender) {
            Ua.addHundreds(sb, value.divideToIntegralValue(new BigDecimal("100")));
            value = value.remainder(new BigDecimal(100));
            if (value.compareTo(new BigDecimal("20")) < 0) {
                Ua.addUnits(sb, value, gender);
            } else {
                Ua.addTens(sb, value.divideToIntegralValue(new BigDecimal("10")));
                Ua.addUnits(sb, value.remainder(new BigDecimal("10")), gender);
            }
        }

        private static RV addRank(StringBuilder sb, RV rv, String one, String two, String five, int gender) {
            BigDecimal rankValue = rv.value.divideToIntegralValue(rv.rank);
            if (rankValue.signum() > 0) {
                Ua.addThousand(sb, rankValue, gender);
                BigDecimal units = rankValue.remainder(new BigDecimal("10"));
                BigDecimal units2 = rankValue.remainder(new BigDecimal("100"));
                String unit = "";
                unit = units2.compareTo(new BigDecimal("11")) >= 0 && units2.compareTo(new BigDecimal("20")) < 0 ? five : (units.compareTo(new BigDecimal("1")) == 0 ? one : (units.compareTo(new BigDecimal("1")) > 0 && units.compareTo(new BigDecimal("5")) < 0 ? two : five));
                if (rankValue.compareTo(new BigDecimal("10")) > 0 && rankValue.compareTo(new BigDecimal("20")) < 0) {
                    unit = five;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(unit);
                rv.value = rv.value.remainder(rv.rank);
            }
            rv.rank = rv.rank.divide(new BigDecimal(1000));
            return rv;
        }

        public static String numToStr(BigDecimal value, int gender) {
            return Ua.numToStr(value, false, gender);
        }

        public static String numToStr(BigDecimal value, Boolean uppercase, int gender) {
            StringBuilder sb = new StringBuilder();
            if (value.signum() == 0) {
                sb.append("\u043d\u043e\u043b\u044c");
            } else {
                if (value.signum() < 0) {
                    sb.append("\u043c\u0438\u043d\u0443\u0441");
                    value = value.abs();
                }
                BigDecimal rank = new BigDecimal("1000000000000000000");
                RV rv = new RV(rank, value);
                rv = Ua.addRank(sb, rv, "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d", "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d\u0430", "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0430", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d", "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0430", "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u043c\u0456\u043b\u044c\u044f\u0440\u0434", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0430", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u043c\u0456\u043b\u044c\u0439\u043e\u043d", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0430", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u0456\u0432", 0);
                rv = Ua.addRank(sb, rv, "\u0442\u0438\u0441\u044f\u0447\u0430", "\u0442\u0438\u0441\u044f\u0447\u0456", "\u0442\u0438\u0441\u044f\u0447", 1);
                Ua.addThousand(sb, rv.value, gender);
            }
            if (uppercase.booleanValue()) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            return sb.toString();
        }

        public static String dateToStr(StiDateTime date) {
            return Ua.dateToStr(date, false);
        }

        public static String dateToStr(StiDateTime date, Boolean uppercase) {
            StringBuilder sb = new StringBuilder(String.format("%s %s %s", date.day(), months[date.month()], date.year()));
            if (uppercase.booleanValue()) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            return sb.toString();
        }
    }

    public static class Ru {
        private static String[] months = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044f", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f", "\u043c\u0430\u0440\u0442\u0430", "\u0430\u043f\u0440\u0435\u043b\u044f", "\u043c\u0430\u044f", "\u0438\u044e\u043d\u044f", "\u0438\u044e\u043b\u044f", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f", "\u043d\u043e\u044f\u0431\u0440\u044f", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f"};
        private static String[] units = new String[]{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u0435\u0442\u044b\u0440\u0435", "\u043f\u044f\u0442\u044c", "\u0448\u0435\u0441\u0442\u044c", "\u0441\u0435\u043c\u044c", "\u0432\u043e\u0441\u0435\u043c\u044c", "\u0434\u0435\u0432\u044f\u0442\u044c", "\u0434\u0435\u0441\u044f\u0442\u044c", "\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c", "\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c"};
        private static String[] tens = new String[]{"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442", "\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e"};
        private static String[] hundreds = new String[]{"\u0441\u0442\u043e", "\u0434\u0432\u0435\u0441\u0442\u0438", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430", "\u043f\u044f\u0442\u044c\u0441\u043e\u0442", "\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442", "\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442"};
        private static String[][] gendered = new String[][]{{"\u043e\u0434\u0438\u043d", "\u043e\u0434\u043d\u0430", "\u043e\u0434\u043d\u043e"}, {"\u0434\u0432\u0430", "\u0434\u0432\u0435", "\u0434\u0432\u0430"}};
        private static HashMap<String, Currency> currencies = new HashMap();

        public static void registerCurrency(Currency currency, String currencyName) {
            currencies.put(currencyName.toUpperCase(), currency);
        }

        private static Currency getCurrency(String currencyName) {
            return currencies.get(currencyName.toUpperCase());
        }

        public static String numToStr(BigDecimal value, int gender) {
            return Ru.numToStr(value, false, gender);
        }

        public static String numToStr(BigDecimal value, Boolean uppercase, int gender) {
            StringBuilder sb = new StringBuilder();
            if (value.signum() == 0) {
                sb.append("\u043d\u043e\u043b\u044c");
            } else {
                if (value.signum() < 0) {
                    sb.append("\u043c\u0438\u043d\u0443\u0441");
                    value = value.abs();
                }
                BigDecimal rank = new BigDecimal("1000000000000000000");
                RV rv = new RV(rank, value);
                rv = Ru.addRank(sb, rv, "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u044c\u043e\u043d", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u044c\u043e\u043d\u0430", "\u043a\u0432\u0438\u043d\u0442\u0438\u043b\u044c\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u043e\u043d\u0430", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u043c\u0438\u043b\u043b\u0438\u043e\u043d", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432", 0);
                rv = Ru.addRank(sb, rv, "\u0442\u044b\u0441\u044f\u0447\u0430", "\u0442\u044b\u0441\u044f\u0447\u0438", "\u0442\u044b\u0441\u044f\u0447", 1);
                Ru.addThousand(sb, rv.value, gender);
            }
            if (uppercase.booleanValue()) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            return sb.toString();
        }

        private static void addUnits(StringBuilder sb, BigDecimal value, int gender) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (value.compareTo(new BigDecimal("3")) < 0) {
                    sb.append(gendered[value.intValue() - 1][gender]);
                } else {
                    sb.append(units[value.intValue() - 1]);
                }
            }
        }

        private static void addTens(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(tens[value.intValue() - 1]);
            }
        }

        private static void addHundreds(StringBuilder sb, BigDecimal value) {
            if (value.signum() != 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(hundreds[value.intValue() - 1]);
            }
        }

        private static void addThousand(StringBuilder sb, BigDecimal value, int gender) {
            Ru.addHundreds(sb, value.divideToIntegralValue(new BigDecimal("100")));
            value = value.remainder(new BigDecimal(100));
            if (value.compareTo(new BigDecimal("20")) < 0) {
                Ru.addUnits(sb, value, gender);
            } else {
                Ru.addTens(sb, value.divideToIntegralValue(new BigDecimal("10")));
                Ru.addUnits(sb, value.remainder(new BigDecimal("10")), gender);
            }
        }

        private static RV addRank(StringBuilder sb, RV rv, String one, String two, String five, int gender) {
            BigDecimal rankValue = rv.value.divideToIntegralValue(rv.rank);
            if (rankValue.signum() > 0) {
                Ru.addThousand(sb, rankValue, gender);
                BigDecimal units = rankValue.remainder(new BigDecimal("10"));
                BigDecimal units2 = rankValue.remainder(new BigDecimal("100"));
                String unit = "";
                unit = units2.compareTo(new BigDecimal("11")) >= 0 && units2.compareTo(new BigDecimal("20")) < 0 ? five : (units.compareTo(new BigDecimal("1")) == 0 ? one : (units.compareTo(new BigDecimal("1")) > 0 && units.compareTo(new BigDecimal("5")) < 0 ? two : five));
                if (rankValue.compareTo(new BigDecimal("10")) > 0 && rankValue.compareTo(new BigDecimal("20")) < 0) {
                    unit = five;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(unit);
                rv.value = rv.value.remainder(rv.rank);
            }
            rv.rank = rv.rank.divide(new BigDecimal(1000));
            return rv;
        }

        public static String currToStr(BigDecimal value, boolean cents) {
            return Ru.currToStr(value, "RUR", cents);
        }

        public static String currToStr(BigDecimal value, String currency, boolean cents) {
            return Ru.currToStr(value, true, currency, cents);
        }

        public static String currToStr(BigDecimal value, boolean uppercase, String currency, boolean cents) {
            BigDecimal integral = value.setScale(0, 1);
            long dec = 0L;
            if (StiOptions.Engine.getUseRoundForToCurrencyWordsFunctions()) {
                dec = Math.abs(value.add(integral.multiply(new BigDecimal("-1"))).multiply(new BigDecimal("100")).longValue());
                if (dec > 99L) {
                    dec = 0L;
                    integral = integral.add(new BigDecimal("1"));
                }
            } else {
                dec = (long)Math.abs((value.doubleValue() - (double)value.longValue()) * 100.0);
            }
            String str = String.format("%s %s", Ru.numToStr(integral, uppercase, Ru.getCurrency(currency).gender().ordinal()), Ru.decline(integral, currency));
            if (cents) {
                str = str + String.format(" %s", dec);
                str = str + String.format(" %s", Ru.decline(dec, currency, true));
            }
            return str;
        }

        public static String currToStr(BigDecimal value) {
            return Ru.currToStr(value, "RUR");
        }

        public static String currToStr(BigDecimal value, String currency) {
            return Ru.currToStr(value, true, currency, true);
        }

        public static String decline(BigDecimal value, String one, String two, String five) {
            return Ru.decline(value.longValue(), one, two, five);
        }

        public static String decline(double value, String one, String two, String five) {
            return Ru.decline((long)value, one, two, five);
        }

        public static String decline(long value, String one, String two, String five) {
            long units = value % 100L;
            if (units >= 10L && units < 20L) {
                return five;
            }
            if ((units %= 10L) == 1L) {
                return one;
            }
            if (units > 1L && units < 5L) {
                return two;
            }
            return five;
        }

        public static String decline(BigDecimal value, String currency) {
            return Ru.decline(value, currency, false);
        }

        public static String decline(long value, String currency) {
            return Ru.decline(value, currency, false);
        }

        public static String decline(BigDecimal value, String currency, boolean cents) {
            return Ru.decline(value.longValue(), currency, cents);
        }

        public static String decline(long value, String currency, boolean cents) {
            Currency curr = Ru.getCurrency(currency);
            if (cents) {
                return Ru.decline(value, curr.centOne(), curr.centTwo(), curr.centFive());
            }
            return Ru.decline(value, curr.dollarOne(), curr.dollarTwo(), curr.dollarFive());
        }

        static {
            Ru.registerCurrency(new EURCurrency(), "EUR");
            Ru.registerCurrency(new USDCurrency(), "USD");
            Ru.registerCurrency(new RURCurrency(), "RUR");
            Ru.registerCurrency(new UAHCurrency(), "UAH");
            Ru.registerCurrency(new KZTCurrency(), "KZT");
        }
    }

    public static class DayOfWeekToStr {
        public static String dayOfWeek(StiDateTime date) {
            return StiDayOfWeekToStrHelper.dayOfWeek(date);
        }

        public static String dayOfWeek(StiDateTime date, boolean localized) {
            return StiDayOfWeekToStrHelper.dayOfWeek(date, localized);
        }

        public static String dayOfWeek(StiDateTime dateTime, String culture) {
            return StiDayOfWeekToStrHelper.dayOfWeek(dateTime, culture);
        }

        public static String dayOfWeek(StiDateTime dateTime, String culture, boolean upperCase) {
            return StiDayOfWeekToStrHelper.dayOfWeek(dateTime, culture, upperCase);
        }

        public static void addCulture(String[] monthNames, String[] cultureNames, boolean defaultUpperCase) {
            StiDayOfWeekToStrHelper.addCulture(monthNames, cultureNames, defaultUpperCase);
        }
    }

    static class KZTCurrency
    extends Currency {
        private String[] _dollars = new String[]{"\u0442\u0435\u043d\u0433\u0435", "\u0442\u0435\u043d\u0433\u0435", "\u0442\u0435\u043d\u0433\u0435"};
        private String[] _cents = new String[]{"\u0442\u0438\u044b\u043d", "\u0442\u0438\u044b\u043d\u0430", "\u0442\u0438\u044b\u043d\u043e\u0432"};

        KZTCurrency() {
        }

        @Override
        Gender gender() {
            return Gender.Masculine;
        }

        @Override
        Gender centsGender() {
            return Gender.Feminine;
        }

        @Override
        String[] dollars() {
            return this._dollars;
        }

        @Override
        String[] cents() {
            return this._cents;
        }
    }

    static class UAHCurrency
    extends Currency {
        private String[] _dollars = new String[]{"\u0433\u0440\u0438\u0432\u043d\u0430", "\u0433\u0440\u0438\u0432\u043d\u044b", "\u0433\u0440\u0438\u0432\u0435\u043d"};
        private String[] _cents = new String[]{"\u043a\u043e\u043f\u0435\u0439\u043a\u0430", "\u043a\u043e\u043f\u0435\u0439\u043a\u0438", "\u043a\u043e\u043f\u0435\u0435\u043a"};

        UAHCurrency() {
        }

        @Override
        Gender gender() {
            return Gender.Feminine;
        }

        @Override
        Gender centsGender() {
            return Gender.Feminine;
        }

        @Override
        String[] dollars() {
            return this._dollars;
        }

        @Override
        String[] cents() {
            return this._cents;
        }
    }

    static class EURCurrency
    extends Currency {
        private String[] _dollars = new String[]{"\u0435\u0432\u0440\u043e", "\u0435\u0432\u0440\u043e", "\u0435\u0432\u0440\u043e"};
        private String[] _cents = new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"};

        EURCurrency() {
        }

        @Override
        Gender gender() {
            return Gender.Neutral;
        }

        @Override
        Gender centsGender() {
            return Gender.Masculine;
        }

        @Override
        String[] dollars() {
            return this._dollars;
        }

        @Override
        String[] cents() {
            return this._cents;
        }
    }

    static class USDCurrency
    extends Currency {
        private String[] _dollars = new String[]{"\u0434\u043e\u043b\u043b\u0430\u0440", "\u0434\u043e\u043b\u043b\u0430\u0440\u0430", "\u0434\u043e\u043b\u043b\u0430\u0440\u043e\u0432"};
        private String[] _cents = new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"};

        USDCurrency() {
        }

        @Override
        Gender gender() {
            return Gender.Masculine;
        }

        @Override
        Gender centsGender() {
            return Gender.Masculine;
        }

        @Override
        String[] dollars() {
            return this._dollars;
        }

        @Override
        String[] cents() {
            return this._cents;
        }
    }

    static class RURCurrency
    extends Currency {
        private String[] _dollars = new String[]{"\u0440\u0443\u0431\u043b\u044c", "\u0440\u0443\u0431\u043b\u044f", "\u0440\u0443\u0431\u043b\u0435\u0439"};
        private String[] _cents = new String[]{"\u043a\u043e\u043f\u0435\u0439\u043a\u0430", "\u043a\u043e\u043f\u0435\u0439\u043a\u0438", "\u043a\u043e\u043f\u0435\u0435\u043a"};

        RURCurrency() {
        }

        @Override
        Gender gender() {
            return Gender.Masculine;
        }

        @Override
        Gender centsGender() {
            return Gender.Feminine;
        }

        @Override
        String[] dollars() {
            return this._dollars;
        }

        @Override
        String[] cents() {
            return this._cents;
        }
    }

    static class Currency
    extends BaseCurrency {
        Currency() {
        }

        String[] dollars() {
            return null;
        }

        String[] cents() {
            return null;
        }

        String dollarOne() {
            return this.dollars()[0];
        }

        String dollarTwo() {
            return this.dollars()[1];
        }

        String dollarFive() {
            return this.dollars()[2];
        }

        String centOne() {
            return this.cents()[0];
        }

        String centTwo() {
            return this.cents()[1];
        }

        String centFive() {
            return this.cents()[2];
        }
    }

    static class BaseCurrency {
        BaseCurrency() {
        }

        Gender gender() {
            return null;
        }

        Gender centsGender() {
            return null;
        }
    }

    static enum Gender {
        Masculine,
        Feminine,
        Neutral;

    }

    public static class Resource {
        public static StiResourceManager resourceManager = new StiResourceManager();
    }
}

