/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.value;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.report.dictionary.enums.StiDateTimeType;
import com.stimulsoft.viewer.requestfromuser.StiDialogInfoValue;
import com.stimulsoft.viewer.requestfromuser.components.StiDateTimePicker;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.controls.StiRequestFromUserDropDownButton;
import com.stimulsoft.viewer.requestfromuser.value.IStiValueItemControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;

public class StiValueDateTimeItemControl
extends StiRequestPanel
implements IStiValueItemControl {
    private static final long serialVersionUID = -3245853900353155288L;
    private StiDateTimePicker dateTimeInput;
    private StiRequestFromUserDropDownButton dropDownButton;
    private boolean isDateTime;
    private StiDateTimeType dateTimeType;
    private StiReport report;

    public StiValueDateTimeItemControl(StiVariable variable, StiReport report) {
        super(null);
        this.initializeComponent();
        this.report = report;
        this.isDateTime = variable.getType() == StiSystemTypeEnum.SystemDateTime;
        this.dateTimeType = variable.getDialogInfo().getDateTimeType();
        boolean allowUserValues = variable.getDialogInfo().getAllowUserValues();
        List list = null;
        ArrayList<StiDialogInfoValue> listValues = new ArrayList<StiDialogInfoValue>();
        list = variable.getDialogInfoItems();
        for (StiVariableItem item : list) {
            listValues.add(new StiDialogInfoValue(item));
        }
        this.dropDownButton.setListValues(listValues);
        this.dropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = ((JComboBox)e.getSource()).getSelectedItem();
                StiValueDateTimeItemControl.this.dropDownButtonItemChanged((StiDialogInfoValue)object);
            }
        });
        if (this.isDateTime) {
            switch (variable.getDialogInfo().getDateTimeType()) {
                case DateAndTime: {
                    this.dateTimeInput.setCustomFormat(StiDateUtil.DEFAULT_DATE_TIME_PATTERN);
                    break;
                }
                case Date: {
                    this.dateTimeInput.setCustomFormat(StiDateUtil.DEFAULT_DATE_PATTERN);
                    break;
                }
                case Time: {
                    this.dateTimeInput.setCustomFormat("HH:mm:ss");
                }
            }
        } else {
            this.dateTimeInput.setDateTime(false);
            this.dateTimeInput.setCustomFormat("HH:mm:ss");
        }
        if (listValues.size() == 0) {
            this.dropDownButton.setVisible(false);
        }
        if (allowUserValues) {
            this.dateTimeInput.setShowCheckBox(true);
        } else {
            this.dateTimeInput.setEnabled(false);
        }
        if (this.dropDownButton.isVisible()) {
            this.dropDownButton.setLeft(this.dropDownButton.getX() + this.dateTimeInput.getRight() + 2);
        }
        this.setWidth(this.dropDownButton.isVisible() ? this.dropDownButton.getRight() + 2 : this.dateTimeInput.getRight() + 2);
        try {
            if (this.isDateTime) {
                if (variable.getValueObject() != null && !StiDateTime.ZERO.equals(variable.getValueObject())) {
                    this.dateTimeInput.setValue(report.getVariables().containsKey((Object)variable.getName()) ? (StiDateTime)report.getVariables().get((Object)variable.getName()) : (StiDateTime)variable.getValueObject());
                } else {
                    this.dateTimeInput.setChecked(false);
                }
            } else if (variable.getValueObject() != null && !StiTimeSpan.ZERO.equals(variable.getValueObject())) {
                this.dateTimeInput.setValue(report.getVariables().containsKey((Object)variable.getName()) ? (StiTimeSpan)report.getVariables().get((Object)variable.getName()) : (StiTimeSpan)variable.getValueObject());
            } else {
                this.dateTimeInput.setChecked(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getValue() {
        if (this.dateTimeInput.getShowCheckBox().booleanValue() && !this.dateTimeInput.isChecked()) {
            if (this.isDateTime) {
                return StiDateTime.ZERO;
            }
            return StiTimeSpan.ZERO;
        }
        return this.dateTimeInput.getValue();
    }

    private void dropDownButtonItemChanged(StiDialogInfoValue value) {
        if (value == null || value.getKey() == null) {
            if (this.dateTimeInput.getShowCheckBox().booleanValue()) {
                this.dateTimeInput.setChecked(false);
            }
        } else {
            if (value.getKey() instanceof StiDateTime) {
                this.dateTimeInput.setValue((StiDateTime)value.getKey());
            } else if (value.getKey() instanceof StiTimeSpan) {
                this.dateTimeInput.setValue((StiTimeSpan)value.getKey());
            } else if (value.getKey() instanceof Date) {
                this.dateTimeInput.setValue((Date)value.getKey());
            }
            this.dateTimeInput.setChecked(true);
        }
    }

    private void initializeComponent() {
        this.dateTimeInput = new StiDateTimePicker();
        this.dropDownButton = new StiRequestFromUserDropDownButton();
        this.dateTimeInput.setLocation(0, 0);
        this.dateTimeInput.setName("dateTimeInput1");
        this.dateTimeInput.setSize(180, 20);
        this.dropDownButton.setHorizontalOffset(-230);
        this.dropDownButton.setLocation(162, 0);
        this.dropDownButton.setName("dropDownButton");
        this.dropDownButton.setPopupHeight(200);
        this.dropDownButton.setPopupWidth(250);
        this.dropDownButton.setSize(20, 20);
        this.add(this.dateTimeInput);
        this.add((Component)((Object)this.dropDownButton));
        this.setName("StiValueDateTimeItemControl");
        this.setSize(180, 21);
    }
}

