/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.list;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.viewer.requestfromuser.ButtonListInfo;
import com.stimulsoft.viewer.requestfromuser.StiNewRequestFromUserDialogCreatingEventArgs;
import com.stimulsoft.viewer.requestfromuser.components.StiDateTimePicker;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestButton;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.list.IStiListItemControl;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class StiListDateTimeItemControl
extends StiRequestPanel
implements IStiListItemControl {
    private static final long serialVersionUID = -32827602773665316L;
    private ButtonListInfo btInfo;
    private StiRequestButton btRemove;
    private StiDateTimePicker dateTimePicker;

    public StiListDateTimeItemControl(ButtonListInfo btInfo, StiVariableItem infoItem) {
        super(null);
        this.btInfo = btInfo;
        this.initializeComponent();
        this.btInfo = btInfo;
        if (infoItem != null) {
            if (btInfo.getType() == StiSystemTypeEnum.SystemDateTime) {
                this.dateTimePicker.setValue(infoItem.getDateTime());
            } else {
                this.dateTimePicker.setValue(infoItem.getTimeSpan());
            }
        } else {
            this.dateTimePicker.setValue(StiDateTime.currentDate());
        }
        this.dateTimePicker.setCustomFormat(this.getDateFormat());
        StiNewRequestFromUserDialogCreatingEventArgs arg = new StiNewRequestFromUserDialogCreatingEventArgs(btInfo.getVariable(), this.dateTimePicker.getWidth());
        this.dateTimePicker.setWidth(arg.getWidth());
        this.btRemove.setLeft(this.dateTimePicker.getRight() + 3);
        Dimension size = new Dimension((this.btRemove.getRight() + 3) * 2, 25);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    private String getDateFormat() {
        if (this.btInfo.getType() == StiSystemTypeEnum.SystemTimeSpan) {
            return "HH:mm:ss";
        }
        switch (this.btInfo.getVariable().getDialogInfo().getDateTimeType()) {
            case DateAndTime: {
                return StiDateUtil.DEFAULT_DATE_TIME_PATTERN;
            }
            case Date: {
                return StiDateUtil.DEFAULT_DATE_PATTERN;
            }
        }
        return "HH:mm:ss";
    }

    @Override
    public Object getValue() {
        return this.dateTimePicker.getValue();
    }

    @Override
    public String getDisplayValue() {
        return this.dateTimePicker.getValue().format(this.getDateFormat());
    }

    @Override
    public void setFocus() {
        this.dateTimePicker.focus();
    }

    private void initializeComponent() {
        this.btRemove = new StiRequestButton();
        this.dateTimePicker = new StiDateTimePicker();
        this.btRemove.setLocation(204, 1);
        this.btRemove.setName("btRemove");
        this.btRemove.setSize(23, 23);
        this.btRemove.setIcon(StiResourceUtil.loadIcon((String)"/icons/Delete.png"));
        final StiListDateTimeItemControl this_ = this;
        this.btRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiListDateTimeItemControl.this.btInfo.getButtonXControl().removeItem(this_);
            }
        });
        this.dateTimePicker.setLocation(2, 2);
        this.dateTimePicker.setName("dateTimePicker");
        this.dateTimePicker.setSize(200, 20);
        this.add(this.dateTimePicker);
        this.add(this.btRemove);
        this.setName("StiListDateTimeItemControl");
        this.setSize(228, 25);
    }
}

