/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.list;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.report.components.ButtonX;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.viewer.requestfromuser.ButtonListInfo;
import com.stimulsoft.viewer.requestfromuser.IStiItemControl;
import com.stimulsoft.viewer.requestfromuser.components.StiCheckButton;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.list.IStiListItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListBoolItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListCharItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListDateTimeItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListDoubleItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListGuidItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListLongItemControl;
import com.stimulsoft.viewer.requestfromuser.list.StiListStringItemControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class StiListButtonXControl
extends StiRequestPanel
implements ButtonX.ClosePopupEventable,
IStiItemControl {
    private static final long serialVersionUID = -4488221147609771403L;
    private static final int CONTROL_WIDTH = 235;
    private static final int BUTTON_WIDTH = 231;
    private JButton buttonAdd;
    private JButton buttonRemoveAll;
    private JButton buttonClose;
    private JScrollPane controlContainerItem;
    private JPanel listValues;
    private JPanel uPanel;
    private JPanel dPanel;
    private StiSystemTypeEnum listType;
    private ButtonListInfo btInfo;
    private ButtonX mainButton;

    public StiListButtonXControl(StiSystemTypeEnum type, StiVariable variable) {
        super(null);
        this.initializeComponent();
        this.listType = type;
        this.btInfo = new ButtonListInfo();
        this.btInfo.setVariable(variable);
        this.btInfo.setButtonXControl(this);
        this.btInfo.setType(this.listType);
        List list = variable.getDialogInfoItems();
        if (variable.getDialogInfo().getAllowUserValues()) {
            this.init();
            if (list != null && list.size() != 0) {
                for (int index = 0; index < list.size(); ++index) {
                    this.addNewItem((StiVariableItem)list.get(index), false);
                }
                this.mainButtonPopupClose();
            }
            this.updateFlowLayoutPanelSize();
        } else if (list != null && list.size() != 0) {
            for (int index = 0; index < list.size(); ++index) {
                this.addNewItem((StiVariableItem)list.get(index), false);
            }
            this.mainButtonPopupClose();
        }
    }

    private void buttonAddClick() {
        this.addNewItem(null, true);
    }

    private void buttonRemoveAllClick() {
        this.listValues.removeAll();
        this.updateFlowLayoutPanelSize();
    }

    private void mainButtonPopupClose() {
        StringBuilder str = new StringBuilder();
        if (this.btInfo.getVariable().getDialogInfo().getAllowUserValues()) {
            for (int index = 0; index < this.listValues.getComponentCount(); ++index) {
                IStiListItemControl item = (IStiListItemControl)((Object)this.listValues.getComponent(index));
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(item.getDisplayValue());
            }
        } else {
            for (JComponent item : this.mainButton.getSubItems()) {
                StiCheckButton checkButton = (StiCheckButton)item;
                if (!checkButton.isSelected()) continue;
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(checkButton.getValueString());
            }
        }
        this.mainButton.setText(str.length() >= 23 ? str.toString().substring(0, 23) + "..." : str.toString());
        str = null;
    }

    void updateFlowLayoutPanelSize() {
        if (this.listValues.getComponentCount() == 0) {
            Dimension dSize = new Dimension(1, 1);
            this.controlContainerItem.setMaximumSize(dSize);
            this.controlContainerItem.setSize(dSize);
            this.listValues.setSize(dSize);
            this.controlContainerItem.setVisible(false);
            this.buttonRemoveAll.setEnabled(false);
            this.setButtonsSize(231);
        } else {
            this.buttonRemoveAll.setEnabled(this.btInfo.getVariable().getDialogInfo().getAllowUserValues());
            this.controlContainerItem.setVisible(true);
            int height = this.listValues.getComponentCount() * 25 + 3;
            int listWidth = 235;
            this.listValues.setSize(listWidth, height - 3);
            this.listValues.setMaximumSize(new Dimension(listWidth, height - 3));
            Dimension dSize = new Dimension(height > 320 ? 253 : 235, height > 300 ? 300 : height);
            this.controlContainerItem.setMaximumSize(dSize);
            this.controlContainerItem.setSize(dSize);
            this.controlContainerItem.setPreferredSize(dSize);
            this.setButtonsSize(231 + (height > 320 ? 18 : 0));
        }
    }

    private void addNewItem(StiVariableItem infoItem, boolean checkSize) {
        if (this.btInfo.getVariable().getDialogInfo().getAllowUserValues()) {
            StiRequestPanel newListItem = null;
            switch (this.listType) {
                case SystemDateTime: 
                case SystemTimeSpan: {
                    newListItem = new StiListDateTimeItemControl(this.btInfo, infoItem);
                    break;
                }
                case SystemChar: {
                    newListItem = new StiListCharItemControl(this.btInfo, infoItem);
                    break;
                }
                case SystemFloat: 
                case SystemDouble: 
                case SystemDecimal: {
                    newListItem = new StiListDoubleItemControl(this.btInfo, infoItem);
                    break;
                }
                case SystemGuid: {
                    newListItem = new StiListGuidItemControl(this.btInfo, infoItem);
                    break;
                }
                case SystemString: {
                    newListItem = new StiListStringItemControl(this.btInfo, infoItem);
                    break;
                }
                case SystemByte: 
                case SystemInt16: 
                case SystemInt32: 
                case SystemInt64: {
                    newListItem = new StiListLongItemControl(this.btInfo, infoItem);
                    break;
                }
                case SystemBoolean: {
                    newListItem = new StiListBoolItemControl(this.btInfo, infoItem);
                }
            }
            if (newListItem != null) {
                StiRequestPanel listItem = newListItem;
                listItem.setBackground(this.listValues.getBackground());
                if (checkSize) {
                    this.listValues.add(listItem);
                    this.updateFlowLayoutPanelSize();
                    newListItem.setFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StiListButtonXControl.this.controlContainerItem.getVerticalScrollBar().setValue(StiListButtonXControl.this.controlContainerItem.getVerticalScrollBar().getMaximum());
                        }
                    });
                } else {
                    this.listValues.add(listItem);
                }
            }
        } else {
            StiCheckButton checkButton = new StiCheckButton(this.btInfo, infoItem);
            checkButton.setSelected(true);
            checkButton.setAutoCheckOnClick(true);
            checkButton.setTag(infoItem);
            checkButton.setPreferredSize(new Dimension(231, 20));
            checkButton.setMaximumSize(new Dimension(231, 20));
            this.mainButton.addSubItem((JComponent)checkButton);
        }
    }

    public void removeItem(JComponent control) {
        this.listValues.remove(control);
        this.updateFlowLayoutPanelSize();
    }

    private void localize() {
        this.buttonClose.setText(StiLocalization.getValue((String)"Buttons", (String)"Close"));
        this.buttonAdd.setText(StiLocalization.getValue((String)"FormDictionaryDesigner", (String)"NewItem"));
        this.buttonRemoveAll.setText(StiLocalization.getValue((String)"Buttons", (String)"RemoveAll"));
    }

    private void init() {
        this.buttonAdd = StiListButtonXControl.createFlatButton();
        this.listValues = new JPanel();
        this.controlContainerItem = new JScrollPane(this.listValues, 20, 31);
        this.listValues.setLayout(new BoxLayout(this.listValues, 1));
        this.buttonRemoveAll = StiListButtonXControl.createFlatButton();
        this.buttonClose = StiListButtonXControl.createFlatButton();
        this.uPanel = new JPanel();
        this.dPanel = new JPanel();
        this.uPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.uPanel.add(this.buttonAdd);
        this.dPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.dPanel.add(this.buttonRemoveAll);
        this.dPanel.add(this.buttonClose);
        this.mainButton.addSubItems(Arrays.asList(this.uPanel, this.controlContainerItem, this.dPanel));
        this.buttonAdd.setName("buttonAdd");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiListButtonXControl.this.buttonAddClick();
            }
        });
        this.controlContainerItem.setName("controlContainerItem");
        this.controlContainerItem.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.listValues.setAutoscrolls(true);
        this.listValues.setLocation(0, 0);
        this.listValues.setMaximumSize(new Dimension(275, 300));
        this.listValues.setName("listValues");
        this.listValues.setSize(275, 300);
        this.buttonRemoveAll.setEnabled(false);
        this.buttonRemoveAll.setName("buttonRemoveAll");
        this.buttonRemoveAll.setText("Remove All");
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiListButtonXControl.this.buttonRemoveAllClick();
            }
        });
        this.buttonClose.setName("buttonClose");
        this.setButtonsSize(231);
        this.localize();
    }

    private void setButtonsSize(int width) {
        Dimension buttonSize = new Dimension(width, 20);
        this.uPanel.setMaximumSize(new Dimension(width, 27));
        this.dPanel.setMaximumSize(new Dimension(width, 50));
        this.buttonAdd.setPreferredSize(buttonSize);
        this.buttonRemoveAll.setPreferredSize(buttonSize);
        this.buttonClose.setPreferredSize(buttonSize);
    }

    private static JButton createFlatButton() {
        JButton button = new JButton();
        button.setForeground(Color.BLACK);
        button.setBackground(Color.WHITE);
        return button;
    }

    public ArrayList<String> getResult() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.btInfo.getVariable().getDialogInfo().getAllowUserValues()) {
            for (Component component : this.listValues.getComponents()) {
                IStiListItemControl item = (IStiListItemControl)((Object)component);
                list.add(String.valueOf(item.getValue()));
            }
        } else {
            for (JComponent component : this.mainButton.getSubItems()) {
                StiCheckButton item = (StiCheckButton)component;
                if (!item.isSelected()) continue;
                list.add(String.valueOf(((StiVariableItem)item.getTag()).getKeyObject()));
            }
        }
        return list;
    }

    private void initializeComponent() {
        this.mainButton = new ButtonX((ButtonX.ClosePopupEventable)this);
        this.mainButton.setAutoExpandOnClick(Boolean.valueOf(true));
        this.mainButton.setLocation(0, 0);
        this.mainButton.setName("mainButton");
        this.mainButton.setSize(200, 21);
        this.add((Component)this.mainButton);
        this.setName("StiListButtonXControl");
        this.setSize(200, 21);
    }

    public void poupClosed() {
        this.mainButtonPopupClose();
    }
}

