/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.panels;

import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.units.StiToolTipHelper;
import com.stimulsoft.report.viewer.StiPageViewMode;
import com.stimulsoft.report.viewer.visual.StiVisual;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.mouse.StiCursorManager;
import com.stimulsoft.viewer.controls.visual.StiPageVisual;
import com.stimulsoft.viewer.controls.visual.StiViewPopupMenu;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.events.StiViewerEventDispatcher;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.utils.StiNavigateButtonsProcessor;
import com.stimulsoft.viewer.utils.StiURLHelper;
import com.stimulsoft.viewer.valueobjects.PageDrawing;
import com.stimulsoft.viewer.valueobjects.StiEmptyGraphics;
import com.stimulsoft.viewer.valueobjects.WidthHeight;
import com.stimulsoft.viewer.view.StiView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class StiViewPannel
extends JScrollPane
implements StiViewEventable,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 199296845244255281L;
    private static final int DISTANCE_BETWEEN_PAGES_HORIZONTAL = 10;
    private static final int DISTANCE_BETWEEN_PAGES_VERTICAL = 10;
    private static final int DISTANCE_FROM_LEFT = 10;
    private static final int DISTANCE_FROM_RIGHT = 10;
    private static final int DISTANCE_FROM_TOP = 10;
    private static final int DISTANCE_FROM_BOTTOM = 10;
    private static final String[] REPAINT_TRACE_METHOD_NAMES = new String[]{"scrollToCurrentPage", "validateTree"};
    private static final int[] INPUT_DISABLES = new int[]{38, 40, 34, 33, 39, 37, 35, 36};
    private StiView view;
    private StiViewPopupMenu popupMenu;
    private Boolean isHandModeActivated = false;
    private Boolean isLeftMouseButtonPressed = false;
    private StiPoint lastMousePosition = new StiPoint();
    private Boolean canRepaint = true;
    private Boolean canScrollRepaint = true;
    private StiEmptyGraphics stiEmptyGraphics = new StiEmptyGraphics();
    private StiViewModel stiViewModel;
    private StiViewerEventDispatcher eventDispatcher = new StiViewerEventDispatcher();
    private Dimension oldSize = new Dimension(0, 0);

    public StiViewPannel(StiViewModel model) {
        super(new StiView(), 22, 30);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.stiViewModel = model;
        this.view = (StiView)this.getViewport().getView();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.popupMenu = new StiViewPopupMenu(this, model);
        this.setFocusable(true);
        this.view.setBackground(StiViewerFx.BACKGROUND_COLOR);
        this.setBackground(StiViewerFx.BACKGROUND_COLOR);
        this.getVerticalScrollBar().setUnitIncrement(0);
        this.getViewport().setScrollMode(0);
        InputMap inputMap = this.getInputMap(0);
        for (final int keyCode : INPUT_DISABLES) {
            String actionName = "Navigate" + keyCode;
            inputMap.put(KeyStroke.getKeyStroke(keyCode, 0), actionName);
            this.getActionMap().put(actionName, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StiNavigateButtonsProcessor.actionPerformed(keyCode);
                }
            });
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StiViewPannel.this.onScrollViewerResize();
            }
        });
    }

    public void updatePagesPlacement() {
        StiPageVisual pageVisual;
        WidthHeight widthHeight = new WidthHeight();
        List<PageDrawing> pageDrawingArray = this.placePages(widthHeight);
        HashMap<Integer, StiPageVisual> pages = new HashMap<Integer, StiPageVisual>();
        for (StiVisual visual : this.view.getVisuals()) {
            pageVisual = (StiPageVisual)visual;
            if (pageVisual == null) continue;
            pages.put(pageVisual.getPageIndex(), pageVisual);
        }
        int pageIndex = 0;
        for (PageDrawing pageDrawing : pageDrawingArray) {
            pageVisual = (StiPageVisual)((Object)pages.get(pageIndex));
            if (pageVisual == null) {
                pageVisual = new StiPageVisual(this, this.stiViewModel);
                pageVisual.setBounds(pageDrawing.getLeft().intValue(), pageDrawing.getTop().intValue(), pageDrawing.getWidth().intValue(), pageDrawing.getHeight().intValue());
                this.view.addVisual(pageVisual);
            } else {
                pages.remove(pageIndex);
            }
            pageVisual.setSelected(this.getCurrentPage() == pageIndex);
            pageVisual.setBounds(pageDrawing.getLeft().intValue(), pageDrawing.getTop().intValue(), pageDrawing.getWidth().intValue(), pageDrawing.getHeight().intValue());
            pageVisual.setPageIndex(pageIndex);
            pageVisual.setLine(pageDrawing.getLine());
            pageVisual.setDestLeft(pageDrawing.getLeft().intValue());
            pageVisual.setDestTop(pageDrawing.getTop().intValue());
            pageVisual.setDestWidth(pageDrawing.getWidth().intValue());
            pageVisual.setDestHeight(pageDrawing.getHeight().intValue());
            pageVisual.setPage(this.getReport().getRenderedPages().get(pageIndex));
            ++pageIndex;
        }
        this.view.updateSize(Math.max(widthHeight.getWidth(), this.getViewWidth()), Math.max(widthHeight.getHeight(), this.getViewHeight()));
    }

    private List<PageDrawing> placePages(WidthHeight widthHeight) {
        Integer totalWidth = widthHeight.getWidth();
        Integer totalHeight = widthHeight.getHeight();
        ArrayList<PageDrawing> pageDrawingArray = new ArrayList<PageDrawing>();
        if (this.getReport() != null) {
            int pageIndex = 0;
            Integer dist = 0;
            if (this.getPageViewMode() == StiPageViewMode.SinglePage) {
                for (StiPage page : this.getReport().getRenderedPages()) {
                    PageDrawing pageDrawing = new PageDrawing();
                    pageDrawing.setUnzoomWidth(page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getWidth()));
                    pageDrawing.setUnzoomHeight(page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getHeight()));
                    if (pageIndex == this.getCurrentPage()) {
                        pageDrawing.setWidth(pageDrawing.getUnzoomWidth() * this.getZoom());
                        pageDrawing.setHeight(pageDrawing.getUnzoomHeight() * this.getZoom());
                        dist = new Long(Math.round(((double)this.getViewWidth().intValue() - pageDrawing.getWidth()) / 2.0)).intValue();
                        if (dist < 10) {
                            dist = 10;
                        }
                        pageDrawing.setLeft(dist.doubleValue());
                        if ((double)this.getViewHeight().intValue() > pageDrawing.getHeight()) {
                            pageDrawing.setTop(((double)this.getViewHeight().intValue() - pageDrawing.getHeight()) / 2.0);
                        } else {
                            pageDrawing.setTop(new Integer(10).doubleValue());
                        }
                        totalWidth = pageDrawing.getWidth().intValue() + 10 + 10;
                        totalHeight = Math.max(totalHeight, pageDrawing.getHeight().intValue() + 10 + 10);
                    } else {
                        pageDrawing.setWidth(pageDrawing.getUnzoomWidth() * 0.1);
                        pageDrawing.setHeight(pageDrawing.getUnzoomHeight() * 0.1);
                        if (pageIndex < this.getCurrentPage()) {
                            pageDrawing.setLeft(-(pageDrawing.getWidth() + 10.0) * (double)(this.getCurrentPage() - pageIndex) - 10.0);
                            pageDrawing.setTop(((double)this.getViewHeight().intValue() - pageDrawing.getHeight()) / 2.0);
                        } else {
                            pageDrawing.setLeft((double)(Math.max(this.getViewWidth(), totalWidth) + 10) + (pageDrawing.getWidth() + 10.0) * (double)(pageIndex - this.getCurrentPage()));
                            pageDrawing.setTop(((double)Math.max(this.getViewHeight(), totalHeight) - pageDrawing.getHeight()) / 2.0);
                        }
                    }
                    pageDrawingArray.add(pageDrawing);
                    ++pageIndex;
                }
            } else {
                PageDrawing pageDrawing;
                pageIndex = 0;
                for (StiPage page : this.getReport().getRenderedPages()) {
                    pageDrawing = new PageDrawing();
                    pageDrawing.setUnzoomWidth(page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getWidth()));
                    pageDrawing.setUnzoomHeight(page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getHeight()));
                    pageDrawing.setLeft(0.0);
                    pageDrawing.setTop(0.0);
                    pageDrawing.setWidth(pageDrawing.getUnzoomWidth() * this.getZoom());
                    pageDrawing.setHeight(pageDrawing.getUnzoomHeight() * this.getZoom());
                    pageDrawingArray.add(pageDrawing);
                    ++pageIndex;
                }
                int index = 0;
                int line = 0;
                while (index < pageDrawingArray.size()) {
                    int viewWidth = 20;
                    int pageQnt = 0;
                    while (index < pageDrawingArray.size()) {
                        pageDrawing = (PageDrawing)pageDrawingArray.get(index);
                        viewWidth = (int)((double)viewWidth + pageDrawing.getWidth());
                        viewWidth += 10;
                        if (this.getPageViewMode() == StiPageViewMode.SinglePage) {
                            pageDrawing.setLine(0);
                            ++index;
                            ++pageQnt;
                            break;
                        }
                        if (this.getPageViewMode() == StiPageViewMode.Continuous) {
                            pageDrawing.setLine(line);
                            ++index;
                            ++pageQnt;
                            break;
                        }
                        if (this.getPageViewMode() != StiPageViewMode.MultiplePages) continue;
                        if (viewWidth >= this.getViewWidth()) {
                            if (pageQnt != 0) break;
                            pageDrawing.setLine(line);
                            ++index;
                            break;
                        }
                        ++pageQnt;
                        pageDrawing.setLine(line);
                        ++index;
                    }
                    ++line;
                }
                totalHeight = 20;
                totalWidth = 0;
                int posY = 10;
                index = 0;
                while (index < pageDrawingArray.size()) {
                    pageDrawing = (PageDrawing)pageDrawingArray.get(index);
                    line = pageDrawing.getLine();
                    int lineWidth = 0;
                    int lineHeight = 0;
                    for (int posIndex = index; posIndex < pageDrawingArray.size() && line == ((PageDrawing)pageDrawingArray.get(posIndex)).getLine(); ++posIndex) {
                        pageDrawing = (PageDrawing)pageDrawingArray.get(posIndex);
                        lineWidth = (int)((double)lineWidth + pageDrawing.getWidth());
                        lineWidth += 10;
                        lineHeight = Math.max(pageDrawing.getHeight().intValue(), lineHeight);
                    }
                    totalHeight = totalHeight + lineHeight;
                    if (index != 0) {
                        totalHeight = totalHeight + 10;
                    }
                    totalWidth = Math.max(lineWidth, totalWidth);
                    dist = (this.getViewWidth() - lineWidth + 10) / 2;
                    if (dist < 10) {
                        dist = 10;
                    }
                    Integer posX = dist;
                    while (index < pageDrawingArray.size() && line == ((PageDrawing)pageDrawingArray.get(index)).getLine()) {
                        pageDrawing = (PageDrawing)pageDrawingArray.get(index);
                        pageDrawing.setLeft(posX.doubleValue());
                        pageDrawing.setTop((double)posY + ((double)lineHeight - pageDrawing.getHeight()) / 2.0);
                        posX = posX + (pageDrawing.getWidth().intValue() + 10);
                        ++index;
                    }
                    posY += lineHeight + 10;
                }
                totalWidth = totalWidth + 20;
            }
        }
        widthHeight.setWidth(totalWidth);
        widthHeight.setHeight(totalHeight);
        return pageDrawingArray;
    }

    public void setZoomPageWidth() {
        Double zoom = ((double)this.getViewWidth().intValue() - 10.0 - 10.0) / (double)this.getMaxPageWidth().intValue();
        zoom = Math.max(20.0, Math.min(StiMath.round((Double)(zoom * 100.0), (Double)2.0), 400.0));
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", zoom.intValue()));
        this.scrollToCurrentPageLater();
    }

    public void setZoomOnePage() {
        Integer maxWidth = this.getMaxPageWidth();
        Integer maxHeight = this.getMaxPageHeight();
        Double zoomWidth = (double)(this.getViewWidth() - 10 - 10) / maxWidth.doubleValue();
        Double zoomHeight = (double)(this.getViewHeight() - 10 - 10) / maxHeight.doubleValue();
        Double zoom = Math.min(Math.max(0.2, Math.min(zoomWidth, zoomHeight)), 2.0) * 100.0;
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", zoom.intValue()));
        this.scrollToCurrentPageLater();
    }

    public void setZoomTwoPages() {
        if (this.getPageViewMode() != StiPageViewMode.MultiplePages) {
            this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("PageViewModeChanged", StiPageViewMode.MultiplePages));
        }
        Double maxWidth = (double)this.getMaxPageWidth().intValue() * 2.0;
        Double zoomX = (double)(this.getViewWidth() - 10 - 10 - 10) / maxWidth;
        Double maxHeight = this.getMaxPageHeight().doubleValue();
        Double zoomY = (double)(this.getViewHeight() - 10 - 10) / maxHeight;
        Double zoom = Math.min(Math.max(0.2, Math.min(zoomX, zoomY)), 2.0);
        zoom = StiMath.round((Double)(zoom * 100.0), (Double)2.0);
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", zoom.intValue()));
        this.scrollToCurrentPageLater();
    }

    public void setZoomMultiplePages() {
        if (this.getPageViewMode() != StiPageViewMode.MultiplePages) {
            this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("PageViewModeChanged", StiPageViewMode.MultiplePages));
        }
        Integer pagesByWidth = Math.max(this.stiViewModel.getViewMultipleDimension().width, 1);
        Integer pagesByHeight = Math.max(this.stiViewModel.getViewMultipleDimension().height, 1);
        Integer maxWidth = this.getMaxPageWidth() * pagesByWidth;
        Double zoomX = (double)(this.getViewWidth() - 10 - 10 - (pagesByWidth - 1) * 10) / maxWidth.doubleValue();
        Integer maxHeight = this.getMaxPageHeight() * pagesByHeight;
        Double zoomY = (double)(this.getViewHeight() - 10 - 10 - (pagesByHeight - 1) * 10) / maxHeight.doubleValue();
        Double zoom = StiMath.round((Double)(Math.max(0.2, Math.min(zoomX, zoomY)) * 100.0), (Double)2.0);
        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", zoom.intValue()));
        this.scrollToCurrentPageLater();
    }

    public Integer getMaxPageWidth() {
        if (this.getReport() == null) {
            return 0;
        }
        Double width = 0.0;
        Integer pageIndex = 0;
        for (StiPage page : this.getReport().getRenderedPages()) {
            Double pageWidth = page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getWidth());
            pageWidth = pageWidth + 16.0;
            width = Math.max(width, pageWidth);
            Integer n = pageIndex;
            Integer n2 = pageIndex = Integer.valueOf(pageIndex + 1);
        }
        return width.intValue();
    }

    public Integer getMaxPageHeight() {
        if (this.getReport() == null) {
            return 0;
        }
        Double height = 0.0;
        Integer pageIndex = 0;
        for (StiPage page : this.getReport().getRenderedPages()) {
            Double pageHeight = page.ConvertToHInches(page.getUnit(), page.getDisplayRectangle().getHeight());
            pageHeight = pageHeight + 6.0;
            height = Math.max(height, pageHeight);
            Integer n = pageIndex;
            Integer n2 = pageIndex = Integer.valueOf(pageIndex + 1);
        }
        return height.intValue();
    }

    public void scrollToCurrentPageLater() {
        this.canRepaint = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StiViewPannel.this.scrollToCurrentPage();
            }
        });
    }

    public void scrollToCurrentPageRepaint() {
        this.canRepaint = false;
        this.scrollToCurrentPage();
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = this.canRepaint();
        if (graphics != null) {
            return graphics;
        }
        return super.getGraphics();
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (this.canRepaint.booleanValue() && this.canScrollRepaint.booleanValue()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    public void scrollToCurrentPage() {
        this.scrollToCurrentPage(true);
    }

    public void scrollToCurrentPage(Boolean canScrollRepaint) {
        this.canScrollRepaint = canScrollRepaint;
        StiPageVisual pageVisual = (StiPageVisual)this.view.getPageVisualFromIndex(this.getCurrentPage());
        if (pageVisual == null) {
            return;
        }
        this.scrollToRect(new StiRectangle((long)pageVisual.getDestLeft().intValue(), (long)pageVisual.getDestTop().intValue(), (long)pageVisual.getDestWidth().intValue(), (long)pageVisual.getDestHeight().intValue()));
        this.canScrollRepaint = true;
        if (!canScrollRepaint.booleanValue()) {
            this.paintImmediately(this.getBounds());
        }
    }

    public void scrollToComponent(StiComponent component) {
        StiRectangle rect = this.getComponentRect(component, null);
        this.scrollToRect(rect);
    }

    private void scrollToRect(StiRectangle rect) {
        StiToolTipHelper.hideToolTip();
        Double toX = 0.0;
        Double toY = 0.0;
        toX = (double)this.getViewWidth().intValue() < rect.getWidth() ? Double.valueOf(rect.getX() - 10.0) : Double.valueOf(rect.getX() - ((double)this.getViewWidth().intValue() - rect.getWidth()) / 2.0);
        toY = (double)this.getViewHeight().intValue() < rect.getHeight() ? Double.valueOf(rect.getY() - 10.0) : Double.valueOf(rect.getY() - ((double)this.getViewHeight().intValue() - rect.getHeight()) / 2.0);
        this.getVerticalScrollBar().setValue(toY.intValue());
        this.getHorizontalScrollBar().setValue(toX.intValue());
        this.canRepaint = true;
        this.paintImmediately(this.getBounds());
    }

    public Graphics canRepaint() {
        if (!this.canRepaint.booleanValue()) {
            for (StackTraceElement stackTraceElement : new Throwable().fillInStackTrace().getStackTrace()) {
                if (!stackTraceElement.getClassName().equals(this.getClass().getName())) continue;
                for (String methodName : REPAINT_TRACE_METHOD_NAMES) {
                    if (!stackTraceElement.getMethodName().equals(methodName)) continue;
                    return this.stiEmptyGraphics;
                }
            }
        }
        return null;
    }

    public StiPageVisual getPageVisualFromIndex(int index) {
        int pageIndex = 0;
        for (StiVisual visual : this.view.getVisuals()) {
            if (!(visual instanceof StiPageVisual)) continue;
            if (pageIndex == index) {
                return (StiPageVisual)visual;
            }
            ++pageIndex;
        }
        return null;
    }

    private StiPageVisual getPageVisualFromMouse() {
        for (StiVisual visual : this.view.getVisuals()) {
            if (!(visual instanceof StiPageVisual)) continue;
            StiPageVisual pageVisual = (StiPageVisual)visual;
            StiRectangle rect = new StiRectangle((long)pageVisual.getX(), (long)pageVisual.getY(), (long)pageVisual.getWidth(), (long)pageVisual.getHeight());
            Point mousePosition = this.view.getMousePosition();
            if (mousePosition == null || !rect.contains(mousePosition.getX(), mousePosition.getY())) continue;
            return pageVisual;
        }
        return null;
    }

    public StiRectangle getComponentRect(StiComponent comp, StiPageVisual pageVisual) {
        if (pageVisual == null) {
            pageVisual = this.getPageVisualFromIndex(this.getReport().getRenderedPages().indexOf((Object)(comp instanceof StiPage ? (StiPage)comp : comp.getPage())));
            if (pageVisual == null) {
                return new StiRectangle(0L, 0L, 0L, 0L);
            }
            if (comp instanceof StiPage) {
                return new StiRectangle((long)pageVisual.getDestLeft().intValue(), (long)pageVisual.getDestTop().intValue(), (long)pageVisual.getDestWidth().intValue(), (long)pageVisual.getDestHeight().intValue());
            }
        }
        StiRectangle rect = comp.getPaintRectangle(true, false);
        Double mgLeft = comp.getPage().ConvertToHInches(comp.getPage().getUnit(), comp.getPage().getMargins().getLeft());
        Double mgTop = comp.getPage().ConvertToHInches(comp.getPage().getUnit(), comp.getPage().getMargins().getTop());
        Double pgWidth = comp.getPage().ConvertToHInches(comp.getPage().getUnit(), comp.getPage().getDisplayRectangle().getWidth());
        Double pgHeight = comp.getPage().ConvertToHInches(comp.getPage().getUnit(), comp.getPage().getDisplayRectangle().getHeight());
        Double zoomX = (double)pageVisual.getDestWidth().intValue() / pgWidth;
        Double zoomY = (double)pageVisual.getDestHeight().intValue() / pgHeight;
        Double left = (double)pageVisual.getDestLeft().intValue() + (mgLeft + rect.getX()) * zoomX;
        Double top = (double)pageVisual.getDestTop().intValue() + (mgTop + rect.getY()) * zoomY;
        return new StiRectangle(left.doubleValue(), top.doubleValue(), rect.getWidth() * zoomX, rect.getHeight() * zoomY);
    }

    private List<StiComponent> getAllComponents() {
        ArrayList<StiComponent> comps = new ArrayList<StiComponent>();
        for (StiPage page : this.getReport().getRenderedPages()) {
            comps.add((StiComponent)page);
            StiComponentsCollection pageComponents = page.getComponents();
            for (StiComponent pageComp : pageComponents) {
                comps.add(pageComp);
            }
        }
        return comps;
    }

    private StiComponent findComponentByTag(String value) {
        for (StiComponent comp : this.getAllComponents()) {
            if (!value.equals(comp.getTagValue())) continue;
            return comp;
        }
        return null;
    }

    private StiComponent findComponentByGuid(String value) {
        for (StiComponent comp : this.getAllComponents()) {
            if (!value.equals(comp.getGuid())) continue;
            return comp;
        }
        return null;
    }

    private StiComponent findComponentByBookmark(String value) {
        for (StiComponent comp : this.getAllComponents()) {
            if (!value.equals(comp.getBookmarkValue())) continue;
            return comp;
        }
        return null;
    }

    public void clearAll() {
        this.view.clearVisuals();
    }

    private void onViewMouseDown(MouseEvent event) {
        if (event.getButton() == 1) {
            this.lastMousePosition = new StiPoint(MouseInfo.getPointerInfo().getLocation().getX(), MouseInfo.getPointerInfo().getLocation().getY());
            this.isLeftMouseButtonPressed = true;
        }
    }

    @Override
    public Point getMousePosition() {
        Point point = super.getMousePosition();
        if (point == null && this.stiViewModel.getParentFrame() != null && this.stiViewModel.getParentFrame().getGlassPane() != null && this.stiViewModel.getParentFrame().getGlassPane().isVisible()) {
            point = this.stiViewModel.getParentFrame().getGlassPane().getMousePosition();
        }
        return point;
    }

    private void onViewMouseMove(MouseEvent event) {
        Point point = this.getMousePosition();
        if (point == null) {
            return;
        }
        StiPoint cursorPosition = new StiPoint(MouseInfo.getPointerInfo().getLocation().getX(), MouseInfo.getPointerInfo().getLocation().getY());
        Cursor cursor = Cursor.getDefaultCursor();
        Boolean isShowToolTip = false;
        if (this.isLeftMouseButtonPressed.booleanValue() && !this.isHandModeActivated.booleanValue()) {
            Double dx = Math.abs(this.lastMousePosition.x - cursorPosition.x);
            Double dy = Math.abs(this.lastMousePosition.y - cursorPosition.y);
            Double length = Math.sqrt(dx * dx + dy * dy);
            if (length > 10.0) {
                this.isHandModeActivated = true;
            }
        }
        if (this.getReport() != null && !this.lastMousePosition.equals((Object)cursorPosition)) {
            if (this.isHandModeActivated.booleanValue()) {
                cursor = StiCursorManager.DRAGGING_HAND_CURSOR;
                Integer moveX = new Double(this.lastMousePosition.x - cursorPosition.x).intValue();
                Integer moveY = new Double(this.lastMousePosition.y - cursorPosition.y).intValue();
                this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getValue() + moveX);
                this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getValue() + moveY);
                this.lastMousePosition = cursorPosition;
            } else {
                Point mousePosition;
                StiPageVisual pageVisual = this.getPageVisualFromMouse();
                Point point2 = mousePosition = pageVisual != null ? pageVisual.getMousePosition() : null;
                if (mousePosition != null) {
                    List toolTips = StiToolTipHelper.getToolTips((StiPage)pageVisual.getPage());
                    for (int index = toolTips.size() - 1; index >= 0; --index) {
                        StiToolTipHelper toolTip = (StiToolTipHelper)toolTips.get(index);
                        if (!this.getComponentRect(toolTip.getComponent(), pageVisual).contains(mousePosition.getX() + (double)pageVisual.getX(), mousePosition.getY() + (double)pageVisual.getY())) continue;
                        isShowToolTip = true;
                        if (toolTip.getHyperlink().booleanValue()) {
                            cursor = Cursor.getPredefinedCursor(12);
                        }
                        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
                        StiToolTipHelper.showToolTip((StiVisual)pageVisual, (String)toolTip.getText(), (Double)mouseLocation.getX(), (Double)mouseLocation.getY());
                        break;
                    }
                }
            }
        }
        if (!isShowToolTip.booleanValue()) {
            StiToolTipHelper.hideToolTip();
        }
        this.setGuiCursor(cursor);
    }

    private void setGuiCursor(Cursor cursor) {
        if (this.stiViewModel.getParentFrame() != null && this.stiViewModel.getParentFrame().getGlassPane() != null && this.stiViewModel.getParentFrame().getGlassPane().isVisible()) {
            this.stiViewModel.getParentFrame().getGlassPane().setCursor(cursor);
        } else {
            this.setCursor(cursor);
        }
    }

    private void onViewMouseUp(MouseEvent event) {
        if (this.isHandModeActivated.booleanValue()) {
            this.onViewMouseMove(event);
            this.isHandModeActivated = false;
            StiCursorManager.setDefaultCursor(this);
        } else if (this.isLeftMouseButtonPressed.booleanValue()) {
            Point mousePosition;
            Boolean isGotoHyperLink = false;
            StiPageVisual pageVisual = this.getPageVisualFromMouse();
            Point point = mousePosition = pageVisual != null ? pageVisual.getMousePosition() : null;
            if (mousePosition != null) {
                ArrayList components = new ArrayList(pageVisual.getPage().getComponents());
                Collections.reverse(components);
                for (StiComponent comp : components) {
                    StiComponent findedComp;
                    String hyperlink;
                    StiRectangle rectComp;
                    if (comp.getHyperlinkValue() == null || !(rectComp = this.getComponentRect(comp, pageVisual)).contains(mousePosition.getX() + (double)pageVisual.getX(), mousePosition.getY() + (double)pageVisual.getY()) || (hyperlink = comp.getHyperlinkValue()).length() < 2) continue;
                    if (hyperlink.length() > 2 && hyperlink.substring(0, 2).equals("##")) {
                        findedComp = this.findComponentByTag(hyperlink.substring(2, hyperlink.length() - 1));
                        if (findedComp == null && hyperlink.indexOf("GUID#") > 0) {
                            findedComp = this.findComponentByGuid(hyperlink.substring(hyperlink.indexOf("GUID#") + 5));
                        }
                        if (findedComp == null) continue;
                        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowBookmark", findedComp, true));
                        isGotoHyperLink = true;
                        continue;
                    }
                    if (hyperlink.length() > 1 && hyperlink.substring(0, 1).equals("#")) {
                        findedComp = this.findComponentByBookmark(hyperlink.substring(1));
                        if (findedComp == null) continue;
                        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ShowBookmark", findedComp, true));
                        isGotoHyperLink = true;
                        continue;
                    }
                    if (hyperlink.length() <= 0) continue;
                    StiURLHelper.openURL(hyperlink);
                }
            }
            if (!isGotoHyperLink.booleanValue() && this.getPageViewMode() != StiPageViewMode.SinglePage && mousePosition != null) {
                int pageIndex = 0;
                for (StiVisual visual : this.view.getVisuals()) {
                    if (!(visual instanceof StiPageVisual)) continue;
                    pageVisual = (StiPageVisual)visual;
                    StiRectangle rect = new StiRectangle((long)pageVisual.getX(), (long)pageVisual.getY(), (long)pageVisual.getWidth(), (long)pageVisual.getHeight());
                    if (rect.contains(mousePosition.getX(), mousePosition.getY()) && pageIndex != this.getCurrentPage()) {
                        this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("CurrentPageChanged", pageIndex));
                        break;
                    }
                    ++pageIndex;
                }
            }
            if (isGotoHyperLink.booleanValue()) {
                StiCursorManager.setDefaultCursor(this);
            }
        }
        this.isLeftMouseButtonPressed = false;
    }

    public List<StiVisual> getVisuals() {
        return this.view.getVisuals();
    }

    public void onScrollViewerResize() {
        if (Math.abs(this.getSize().width - this.oldSize.width) > 2 || Math.abs(this.getSize().height - this.oldSize.height) > 2) {
            if (this.stiViewModel != null && this.stiViewModel.getDocument() != null) {
                this.updatePagesPlacement();
                this.scrollToCurrentPageLater();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StiViewPannel.this.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ChangeViewState", (Object)StiViewPannel.this.stiViewModel.getViewState()));
                }
            });
        }
        this.oldSize = this.getSize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.onViewMouseDown(e);
        this.showPopupMenu(e);
    }

    public void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.getReport() != null) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        StiNavigateButtonsProcessor.changeFocus(0);
        this.onViewMouseUp(e);
        this.showPopupMenu(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.onViewMouseMove(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.onViewMouseMove(e);
    }

    @Override
    public StiViewerEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public StiReport getReport() {
        return this.stiViewModel.getDocument() != null ? this.stiViewModel.getDocument().getReport() : null;
    }

    public int getCurrentPage() {
        return this.stiViewModel.getCurrentPage();
    }

    public Double getZoom() {
        return this.stiViewModel.getZoom();
    }

    public StiPageViewMode getPageViewMode() {
        return this.stiViewModel.getPageViewMode();
    }

    public Integer getViewHeight() {
        return this.getParent().getBounds().height - (this.getHorizontalScrollBar().isVisible() ? this.getHorizontalScrollBar().getHeight() : 0) - 4;
    }

    public Integer getViewWidth() {
        return this.getBounds().width - this.getVerticalScrollBar().getWidth() - 4;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.stiViewModel.getReport() != null) {
            if (e.isControlDown()) {
                this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ChangeViewState", (Object)StiViewState.Own));
                this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", new Double(this.stiViewModel.getZoom() * 100.0 + (double)(-2 * e.getScrollAmount() * e.getWheelRotation())).intValue()));
            } else if (this.stiViewModel.getPageViewMode() == StiPageViewMode.SinglePage) {
                if (e.getWheelRotation() > 0) {
                    if (this.stiViewModel.getCurrentDisplayPage() < this.stiViewModel.getDisplayPagesCount()) {
                        this.changePage(this.stiViewModel.getCurrentDisplayPage() + 1);
                    }
                } else if (this.stiViewModel.getCurrentDisplayPage() != 1) {
                    this.changePage(this.stiViewModel.getCurrentDisplayPage() - 1);
                }
            } else {
                this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getValue() + e.getWheelRotation() * 100);
            }
        }
    }

    private void changePage(Integer pageIndex) {
        this.eventDispatcher.dispatchStiEvent(new StiViewCommonEvent("CurrentDisplayPageChanged", pageIndex));
    }

    public StiViewModel getStiViewModel() {
        return this.stiViewModel;
    }
}

