/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.logic;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.exception.StiExceptionProvider;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.system.StiFileExecuter;
import com.stimulsoft.base.worker.StiSimpleWorker;
import com.stimulsoft.report.IStiProgressInformation;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dialogs.StiProgressInformationDialog;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiDocumentExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.print.StiPrintHelper;
import com.stimulsoft.report.saveLoad.StiDocument;
import com.stimulsoft.report.units.StiToolTipHelper;
import com.stimulsoft.report.viewer.StiPageViewMode;
import com.stimulsoft.report.viewer.visual.StiVisual;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.dialogs.StiFileSaveDialog;
import com.stimulsoft.viewer.controls.dialogs.StiSaveDialog;
import com.stimulsoft.viewer.controls.visual.StiPageVisual;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventListener;
import com.stimulsoft.viewer.form.StiInfoDialog;
import com.stimulsoft.viewer.form.StiMailSenderDialog;
import com.stimulsoft.viewer.form.export.StiDataExportDialog;
import com.stimulsoft.viewer.form.export.StiExcelExportDialog;
import com.stimulsoft.viewer.form.export.StiHtmlExportDialog;
import com.stimulsoft.viewer.form.export.StiImageExportDialog;
import com.stimulsoft.viewer.form.export.StiPdfExportDialog;
import com.stimulsoft.viewer.form.export.StiPpt2007ExportDialog;
import com.stimulsoft.viewer.form.export.StiRtfExportDialog;
import com.stimulsoft.viewer.form.export.StiTxtExportDialog;
import com.stimulsoft.viewer.form.export.StiWordExportDialog;
import com.stimulsoft.viewer.form.export.StiXpsExportDialog;
import com.stimulsoft.viewer.logic.StiViewModel;
import com.stimulsoft.viewer.requestfromuser.StiViewerControlsDialog;
import com.stimulsoft.viewer.utils.StiViewSettings;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.print.PrinterJob;
import java.io.File;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class StiViewController
implements StiViewEventListener,
StiViewSettings {
    private StiViewerFx viewerPanel;
    private StiViewModel stiViewModel;
    private StiViewerControlsDialog viewerControlsDialog;

    public StiViewController(StiViewerFx viewerPanel, StiViewModel stiViewModel) {
        this.viewerPanel = viewerPanel;
        this.stiViewModel = stiViewModel;
        this.viewerControlsDialog = new StiViewerControlsDialog(stiViewModel, viewerPanel);
        this.bindEvents();
        this.setupSettings();
    }

    private void bindEvents() {
        this.viewerPanel.getStiMainToolBar().getEventDispatcher().addStiEventListener(this);
        this.viewerPanel.getStiFindToolBar().getEventDispatcher().addStiEventListener(this);
        this.viewerPanel.getStiViewModeToolBar().getEventDispatcher().addStiEventListener(this);
        this.viewerPanel.getStiViewPannel().getEventDispatcher().addStiEventListener(this);
        this.viewerPanel.getStiBookmarkPannel().getEventDispatcher().addStiEventListener(this);
        this.viewerPanel.getStiThumbnailsPannel().getEventDispatcher().addStiEventListener(this);
        this.viewerPanel.getStiNavigateToolBar().getEventDispatcher().addStiEventListener(this);
        this.stiViewModel.getEventDispatcher().addStiEventListener(this);
    }

    @Override
    public void stiCommonEventPerformed(StiViewCommonEvent stiCommonEvent) {
        try {
            String eventType = stiCommonEvent.getEventType();
            if ("LoadDocumentFile".equals(eventType)) {
                File documentFile = (File)stiCommonEvent.getSource();
                this.stiViewModel.loadDocumentFile(documentFile, true);
            } else if ("ShowFindPannel".equals(eventType)) {
                this.showFindPannel((Boolean)stiCommonEvent.getSource());
            } else if ("ShowBookmarkPannel".equals(eventType)) {
                this.showBookmarksPannel((Boolean)stiCommonEvent.getSource());
            } else if ("ShowFullScreen".equals(eventType)) {
                this.viewerPanel.showFullScreen((Boolean)stiCommonEvent.getSource());
            } else if ("Print".equals(eventType)) {
                this.print();
            } else if ("ShowThumbnailPannel".equals(eventType)) {
                Boolean show = (Boolean)stiCommonEvent.getSource();
                this.showThumbPanel(show, false);
            } else if ("ChangeViewState".equals(eventType)) {
                StiViewState state = (StiViewState)((Object)stiCommonEvent.getSource());
                this.changeViewState(state, stiCommonEvent.getParam0() != null ? (Dimension)stiCommonEvent.getParam0() : null);
            } else if ("ScrollToComponent".equals(eventType)) {
                StiComponent component = (StiComponent)stiCommonEvent.getSource();
                this.currentPageChanged(this.stiViewModel.getDocument().getReport().getRenderedPages().indexOf((Object)component.getPage()), false, false);
                this.viewerPanel.getStiViewPannel().scrollToComponent(component);
            } else if ("ChangeBitmapVisual".equals(eventType)) {
                for (StiComponent component : (Set)stiCommonEvent.getSource()) {
                    this.changeBitmapVisual(component);
                }
            } else if ("ZoomChanged".equals(eventType)) {
                this.updateZoom((Integer)stiCommonEvent.getSource());
            } else if ("PageViewModeChanged".equals(eventType)) {
                this.updatePageViewMode((StiPageViewMode)stiCommonEvent.getSource());
            } else if ("CurrentPageChanged".equals(eventType)) {
                this.currentPageChanged((Integer)stiCommonEvent.getSource(), false, stiCommonEvent.getParam0() != null ? (Boolean)stiCommonEvent.getParam0() : true);
            } else if ("CurrentDisplayPageChanged".equals(eventType)) {
                this.currentDisplayPageChanged((Integer)stiCommonEvent.getSource());
            } else if ("ShowBookmark".equals(eventType)) {
                this.showBookmark(stiCommonEvent.getSource() instanceof StiComponent ? (StiComponent)stiCommonEvent.getSource() : null, (Boolean)stiCommonEvent.getParam0());
            } else if ("DocumentFileLoaded".equals(eventType)) {
                File reportFile = stiCommonEvent.getParam0() instanceof File ? (File)stiCommonEvent.getParam0() : null;
                Boolean resetVariables = stiCommonEvent.getParam0() instanceof Boolean ? (Boolean)stiCommonEvent.getParam0() : true;
                this.documentFileLoaded((StiDocument)stiCommonEvent.getSource(), reportFile, resetVariables);
            } else if ("ShowExportDialog".equals(eventType)) {
                this.showExportDialog((StiExportFormat)stiCommonEvent.getSource(), (Boolean)stiCommonEvent.getParam0());
            } else if ("ExportReport".equals(eventType)) {
                this.exportReport((StiExportSettings)stiCommonEvent.getSource());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void exportReport(final StiExportSettings settings) {
        if (settings.getExportFormat() == StiExportFormat.Document) {
            StiSaveDialog saveDialog = new StiSaveDialog(this.stiViewModel, settings, this);
            saveDialog.save();
            return;
        }
        final StiFileSaveDialog stiFileChooser = new StiFileSaveDialog(settings.getExportFormat(), this.stiViewModel.getReport(), this.stiViewModel.getReport().getReportAlias());
        int chooserResult = stiFileChooser.showSaveDialog(this.viewerPanel);
        if (chooserResult == 0) {
            final StiProgressInformationDialog progress = new StiProgressInformationDialog(this.stiViewModel.getParentFrame());
            progress.setAllowClose(false);
            progress.start(StiLocalization.getValue((String)"Export", (String)"ExportingReport"));
            StiSimpleWorker exportWorker = new StiSimpleWorker(){

                protected void finished() {
                    progress.close();
                }

                protected void doInBackground() throws Throwable {
                    StiExportService exportService = settings.getExportFormat().getExportService();
                    exportService.setProgress((IStiProgressInformation)progress);
                    StiViewController.this.stiViewModel.getReport().exportDocument(settings.getExportFormat(), exportService, stiFileChooser.getFile(), settings, StiViewController.this.viewerPanel.getParentFrame());
                    if (!progress.getIsBreaked()) {
                        StiViewController.this.exportFinished(exportService.getExportSettings(), exportService.getExFile(), exportService.getExportedFiles());
                    }
                }
            };
            exportWorker.execute();
        }
    }

    public void exportFinished(StiExportSettings settings, File file, List<File> exportedFiles) {
        if (settings.isSendEmail()) {
            StiMailProperties mailProperties = new StiMailProperties();
            StiReport report = this.stiViewModel.getReport();
            mailProperties.setSubject(report.getReportAlias() != null && report.getReportAlias().trim().length() > 0 ? report.getReportAlias() : report.getReportName());
            mailProperties.setBody(report.getReportDescription());
            mailProperties.getAttachments().add(file);
            mailProperties.getAttachments().addAll(exportedFiles);
            StiMailSenderDialog senderDialog = new StiMailSenderDialog(mailProperties, this.stiViewModel.getParentFrame());
            senderDialog.setVisible(true);
        } else if (settings.isOpenAfterExport()) {
            StiFileExecuter.openByExtension((String)file.getAbsolutePath());
        }
    }

    private void showExportDialog(StiExportFormat format, Boolean sendEmail) {
        if (format == StiExportFormat.Document) {
            StiDocumentExportSettings documentExportSetting = new StiDocumentExportSettings(sendEmail.booleanValue());
            this.exportReport((StiExportSettings)documentExportSetting);
            return;
        }
        StiExportSettings settings = null;
        switch (format) {
            case Html: {
                settings = StiHtmlExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case ImageBmp: 
            case ImageJpeg: 
            case ImagePng: 
            case ImageSvg: 
            case ImageSvgz: 
            case ImagePcx: {
                settings = StiImageExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Text: {
                settings = StiTxtExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Rtf: {
                settings = StiRtfExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Xps: {
                settings = StiXpsExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case PowerPoint: {
                settings = StiPpt2007ExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Csv: {
                settings = StiDataExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Word: {
                settings = StiWordExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Pdf: {
                settings = StiPdfExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
                break;
            }
            case Excel: {
                settings = StiExcelExportDialog.showDialog(this.viewerPanel.getParentFrame(), sendEmail, this.stiViewModel.getCurrentPage());
            }
        }
        if (settings != null) {
            this.exportReport(settings);
        }
    }

    private void setupSettings() {
        this.showThumbPanel(StiSettings.getBoolValue((String)"viewer", (String)"ShowThumbnails", (Boolean)true), true);
        String viewModeSt = StiSettings.getStringValue((String)"viewer", (String)"ViewMode", (String)StiPageViewMode.SinglePage.toString());
        this.updatePageViewMode(StiPageViewMode.valueOf((String)viewModeSt));
        String viewStateSt = StiSettings.getStringValue((String)"viewer", (String)"ViewState", (String)StiViewState.ZoomOnePage.toString());
        StiViewState viewState = StiViewState.valueOf(viewStateSt);
        Double zoom = (double)StiSettings.getIntValue((String)"viewer", (String)"Zoom", (Integer)100).intValue() / 100.0;
        this.changeViewState(viewState != StiViewState.ZoomMultiplePages ? viewState : StiViewState.Own, null);
        this.stiViewModel.setZoom(zoom);
    }

    private void showThumbPanel(Boolean show, Boolean updateButton) {
        this.viewerPanel.showThumbsPannel(show);
        this.stiViewModel.setThumbnailPannelVisible(show);
        if (updateButton.booleanValue()) {
            this.viewerPanel.getStiMainToolBar().getButtonThumbs().setSelected(show);
        }
        StiSettings.setBoolValue((String)"viewer", (String)"ShowThumbnails", (Boolean)show);
    }

    private void changeViewState(StiViewState state, Dimension multipleDimension) {
        if (multipleDimension != null) {
            this.stiViewModel.setViewMultipleDimension(multipleDimension);
        }
        this.stiViewModel.setViewState(state);
        this.viewerPanel.getStiMainToolBar().getButtonZoomPageWidth().setSelected(false);
        this.viewerPanel.getStiMainToolBar().getButtonZoomMultiplePages().setSelected(false);
        this.viewerPanel.getStiMainToolBar().getButtonZoomTwoPages().setSelected(false);
        this.viewerPanel.getStiMainToolBar().getButtonZoomOnePage().setSelected(false);
        switch (state) {
            case ZoomOnePage: {
                this.viewerPanel.getStiViewPannel().setZoomOnePage();
                this.viewerPanel.getStiMainToolBar().getButtonZoomOnePage().setSelected(true);
                break;
            }
            case ZoomTwoPages: {
                this.viewerPanel.getStiViewPannel().setZoomTwoPages();
                this.viewerPanel.getStiMainToolBar().getButtonZoomTwoPages().setSelected(true);
                break;
            }
            case ZoomMultiplePages: {
                this.viewerPanel.getStiMainToolBar().getButtonZoomMultiplePages().setSelected(true);
                this.viewerPanel.getStiViewPannel().setZoomMultiplePages();
                break;
            }
            case ZoomPageWidth: {
                this.viewerPanel.getStiViewPannel().setZoomPageWidth();
                this.viewerPanel.getStiMainToolBar().getButtonZoomPageWidth().setSelected(true);
            }
        }
        StiSettings.setStringValue((String)"viewer", (String)"ViewState", (String)state.name());
    }

    private void showBookmarksPannel(Boolean show) {
        this.viewerPanel.showBookmarksPannel(show);
        this.stiViewModel.setBookmarksPannelVisible(show);
        this.viewerPanel.getStiMainToolBar().getButtonBookmarks().setSelected(show);
    }

    private void print() {
        ArrayList<StiPage> pages = new ArrayList<StiPage>();
        for (StiVisual visual : this.viewerPanel.getStiViewPannel().getVisuals()) {
            pages.add(visual.getPage());
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setJobName(this.stiViewModel.getReport().getReportName());
        try {
            StiPrintHelper.printJob((PrinterJob)printJob, (StiReport)this.stiViewModel.getReport(), (Boolean)true);
        }
        catch (Exception PrintException) {
            StiExceptionProvider.show((Throwable)PrintException, (Frame)this.viewerPanel.getParentFrame());
        }
    }

    private void showFindPannel(Boolean show) {
        this.viewerPanel.getStiFindToolBar().showToolbar(show);
        this.viewerPanel.getStiMainToolBar().getButtonFind().setSelected(show);
    }

    private Integer changeBitmapVisual(StiComponent comp) {
        Integer pageIndex = this.stiViewModel.getDocument().getReport().getRenderedPages().indexOf((Object)(comp instanceof StiPage ? (StiPage)comp : comp.getPage()));
        StiPageVisual pageVisual = this.viewerPanel.getStiViewPannel().getPageVisualFromIndex(pageIndex);
        if (pageVisual != null) {
            pageVisual.changeBitmap();
        }
        return pageIndex;
    }

    private void showBookmark(StiComponent component, Boolean changeCurrentPage) {
        if (this.stiViewModel.getDocument() != null) {
            Boolean needToRepaint = false;
            StiComponent lastBookmarkedComponent = this.stiViewModel.getDocument().getReport().getInfo().getBookmarkComponent();
            if (lastBookmarkedComponent != null) {
                this.changeBitmapVisual(lastBookmarkedComponent);
                lastBookmarkedComponent.setHighlightState(StiHighlightState.Hide);
                needToRepaint = true;
            }
            this.stiViewModel.getDocument().getReport().getInfo().setBookmarkComponent(null);
            if (component != null) {
                component.setHighlightState(StiHighlightState.Active);
                this.stiViewModel.getDocument().getReport().getInfo().setBookmarkComponent(component);
                Integer pageIndex = this.changeBitmapVisual(component);
                if (changeCurrentPage == null || changeCurrentPage.booleanValue()) {
                    this.currentPageChanged(pageIndex, false, false);
                }
                this.viewerPanel.getStiViewPannel().scrollToComponent(component);
                needToRepaint = false;
            }
            if (needToRepaint.booleanValue()) {
                this.viewerPanel.getStiViewPannel().paintImmediately(this.viewerPanel.getStiViewPannel().getBounds());
            }
        }
    }

    public void documentFileLoaded(StiDocument document, File reportFile, Boolean resetVariables) {
        long interval;
        if (StiLicenseKeyValidator.getLicenseKey() == null && (interval = (ZonedDateTime.now().toInstant().toEpochMilli() - StiAttribute.CREATED.getTicks()) / 86400000L) > 30L) {
            new StiInfoDialog(this.viewerPanel, interval > 120L).setVisible(true);
        }
        this.stiViewModel.getPaintQueue().clearVisuals();
        this.stiViewModel.setDocument(document);
        this.stiViewModel.setLoadedReportFile(reportFile);
        StiToolTipHelper.clearAll();
        this.viewerPanel.getStiBookmarkPannel().removeBookmark();
        this.viewerPanel.getStiViewPannel().clearAll();
        this.viewerPanel.getStiThumbnailsPannel().clearAll();
        this.stiViewModel.setCurrentPage(0, true);
        this.viewerPanel.getStiThumbnailsPannel().createThumbnails();
        this.viewerPanel.getStiViewPannel().updatePagesPlacement();
        this.viewerPanel.getStiBookmarkPannel().buildBookmarksTree();
        this.updatePageViewMode(this.stiViewModel.getPageViewMode());
        this.viewerPanel.getStiViewPannel().onScrollViewerResize();
        if (resetVariables.booleanValue()) {
            this.viewerControlsDialog.refreshDialogs(true);
        }
        System.gc();
        System.runFinalization();
    }

    private void updatePageViewMode(StiPageViewMode mode) {
        this.stiViewModel.setPageViewMode(mode);
        this.viewerPanel.getStiViewPannel().updatePagesPlacement();
        if (StiPageViewMode.Continuous.equals((Object)mode) || StiPageViewMode.SinglePage.equals((Object)mode)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StiViewController.this.viewerPanel.getStiViewPannel().setZoomOnePage();
                }
            });
        } else {
            this.viewerPanel.getStiViewPannel().scrollToCurrentPageLater();
        }
        StiSettings.setStringValue((String)"viewer", (String)"ViewMode", (String)mode.name());
    }

    private void currentDisplayPageChanged(Integer pageIndex) {
        this.currentPageChanged(pageIndex, true, true);
    }

    private void currentPageChanged(Integer pageIndex, Boolean changeDisplayPage, Boolean scroll) {
        this.currentPageChanged(pageIndex, true, changeDisplayPage, scroll);
    }

    private void currentPageChanged(Integer pageIndex, Boolean later, Boolean changeDisplayPage, Boolean scroll) {
        if (changeDisplayPage.booleanValue()) {
            this.stiViewModel.setCurrentDisplayPage(pageIndex, true);
        } else {
            this.stiViewModel.setCurrentPage(pageIndex, true);
        }
        this.viewerPanel.getStiViewPannel().updatePagesPlacement();
        if (scroll.booleanValue()) {
            if (later.booleanValue()) {
                this.viewerPanel.getStiViewPannel().scrollToCurrentPageLater();
            } else {
                this.viewerPanel.getStiViewPannel().scrollToCurrentPage(false);
            }
        }
        this.viewerPanel.getStiThumbnailsPannel().updateThumbnails();
        this.viewerPanel.getStiThumbnailsPannel().scrollToCurrentPage();
    }

    private void updateZoom(Integer newZoomValue) {
        newZoomValue = Math.min(400, Math.max(newZoomValue, 10));
        if (this.stiViewModel.getDocument() != null && (double)newZoomValue.intValue() / 100.0 != this.stiViewModel.getZoom()) {
            this.stiViewModel.setZoom((double)newZoomValue.intValue() / 100.0);
            this.viewerPanel.getStiViewPannel().updatePagesPlacement();
            this.viewerPanel.getStiViewPannel().scrollToCurrentPageRepaint();
        }
        StiSettings.setIntValue((String)"viewer", (String)"Zoom", (Integer)newZoomValue);
    }
}

