/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form.export;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.report.export.settings.StiExcel2007ExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExcelXmlExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.viewer.controls.visual.StiLabel;
import com.stimulsoft.viewer.form.export.StiBaseExportDialog;
import java.awt.HeadlessException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StiExcelExportDialog
extends StiBaseExportDialog {
    private static final long serialVersionUID = 7303098990096277761L;
    protected JComboBox imageResolutionComboBox;
    protected JComboBox typeComboBox;
    protected JComboBox imageQualityComboBox;
    protected JCheckBox exportDataOnlyCheckBox;
    protected JCheckBox exportObjectFormattingCheckBox;
    protected JCheckBox useOnePageCheckBox;
    protected JCheckBox exportEachPageCheckBox;
    protected JCheckBox exportPageBreaksCheckBox;

    private StiExcelExportDialog(JFrame parent, Boolean sendEmail, int curretPage) throws HeadlessException {
        super(parent, sendEmail, curretPage);
    }

    public static StiExportSettings showDialog(JFrame parent, Boolean sendEmail, int curretPage) {
        StiExcelExportDialog dialog = new StiExcelExportDialog(parent, sendEmail, curretPage);
        dialog.setVisible(true);
        return dialog.okResult ? dialog.getExportSettings() : null;
    }

    @Override
    protected void buildComponent() {
        super.buildComponent();
        this.mainBuild();
    }

    private void mainBuild() {
        this.addC(this.addInfo(new StiLabel("Type:"), "TypeExport"), 0, 0, 1);
        this.typeComboBox = new JComboBox<String>(new String[]{"Excel", "Excel 97-2003", "Excel Xml 2003"});
        this.addC(this.typeComboBox, 1, 0, 2, 0.0);
        if (StiSettings.getStringValue((String)"Export", (String)"Excel2007Type", (String)"Excel 97-2003").equals("Excel Xml 2003")) {
            this.typeComboBox.setSelectedIndex(2);
            this.expandPanel.setExpandedHeight(65);
        } else {
            this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageResolution")), "ImageResolution"), 0, 1, 1);
            this.imageResolutionComboBox = new JComboBox<String>(RTF_IMAGE_RESOLUTIONS);
            this.addC(this.imageResolutionComboBox, 1, 1, 1, 0.5);
            this.addC(new JLabel("dpi"), 2, 1, 1, 0.0);
            this.addC(this.addInfo(new StiLabel(StiLocalization.getValue((String)"Export", (String)"ImageQuality")), "ImageQuality"), 0, 2, 1);
            this.imageQualityComboBox = new JComboBox<String>(IMAGE_QUALITY);
            this.addC(this.imageQualityComboBox, 1, 2, 1, 0.5);
            this.addC(new JLabel("%"), 2, 2, 1, 0.0);
            this.exportDataOnlyCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"ExportDataOnly"));
            this.addC(this.addInfo(this.exportDataOnlyCheckBox, "ExportDataOnly"), 0, 3, 1, 0.5, -1);
            this.exportObjectFormattingCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"ExportObjectFormatting"));
            this.addC(this.addInfo(this.exportObjectFormattingCheckBox, "ExportObjectFormatting"), 0, 4, 1, 0.5, -1);
            this.useOnePageCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"UseOnePageHeaderAndFooter"));
            this.addC(this.addInfo(this.useOnePageCheckBox, "UseOnePageHeaderAndFooter"), 0, 5, 1, 0.5, -1);
            this.exportEachPageCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"ExportEachPageToSheet"));
            this.addC(this.addInfo(this.exportEachPageCheckBox, "ExportEachPageToSheet"), 0, 6, 1, 0.5, -1);
            this.exportPageBreaksCheckBox = new JCheckBox(StiLocalization.getValue((String)"Export", (String)"ExportPageBreaks"));
            this.addC(this.addInfo(this.exportPageBreaksCheckBox, "ExportPageBreaks"), 0, 7, 1, 0.5, -1);
            this.expandPanel.setExpandedHeight(275);
        }
        this.loadSettings();
        this.expandPanel.setWidth(360);
        this.bindEvents();
    }

    protected void bindEvents() {
        if (this.exportDataOnlyCheckBox != null) {
            this.exportDataOnlyCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enabled = ((JCheckBox)e.getSource()).isSelected();
                    StiExcelExportDialog.this.exportObjectFormattingCheckBox.setEnabled(enabled);
                    StiExcelExportDialog.this.useOnePageCheckBox.setEnabled(!enabled);
                }
            });
        }
        if (this.typeComboBox.getItemListeners().length > 0) {
            this.typeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StiExcelExportDialog.this.saveSettings();
                    StiExcelExportDialog.this.expandPanel.removeAll();
                    StiExcelExportDialog.this.mainBuild();
                    StiExcelExportDialog.this.expandPanel.revalidate();
                    StiExcelExportDialog.this.expandPanel.setExpanded(true);
                }
            });
        }
    }

    @Override
    protected StiExportSettings getExportSettings() {
        if (this.typeComboBox.getSelectedIndex() == 1) {
            StiExcelExportSettings settings = new StiExcelExportSettings(super.getExportSettings());
            settings.setImageQuality((float)(Integer.parseInt((String)this.imageQualityComboBox.getSelectedItem()) / 100));
            int imageResolution = 75;
            try {
                imageResolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
            }
            catch (Exception e) {
                System.out.println("Unable to parse Image Resulution value: " + this.imageResolutionComboBox.getSelectedItem());
                e.printStackTrace();
            }
            settings.setImageResolution((float)imageResolution);
            settings.setExportDataOnly(this.exportDataOnlyCheckBox.isSelected());
            settings.setExportEachPageToSheet(this.exportEachPageCheckBox.isSelected());
            settings.setExportObjectFormatting(this.exportObjectFormattingCheckBox.isSelected());
            settings.setExportPageBreaks(this.exportPageBreaksCheckBox.isSelected());
            settings.setUseOnePageHeaderAndFooter(this.useOnePageCheckBox.isSelected());
            return settings;
        }
        if (this.typeComboBox.getSelectedIndex() == 0) {
            StiExcel2007ExportSettings settings = new StiExcel2007ExportSettings(super.getExportSettings());
            settings.setImageQuality((float)(Integer.parseInt((String)this.imageQualityComboBox.getSelectedItem()) / 100));
            int imageResolution = 75;
            try {
                imageResolution = Integer.parseInt(((String)this.imageResolutionComboBox.getSelectedItem()).replaceAll("[^\\d]", ""));
            }
            catch (Exception e) {
                System.out.println("Unable to parse Image Resulution value: " + this.imageResolutionComboBox.getSelectedItem());
                e.printStackTrace();
            }
            settings.setImageResolution((float)imageResolution);
            settings.setExportDataOnly(this.exportDataOnlyCheckBox.isSelected());
            settings.setExportEachPageToSheet(this.exportEachPageCheckBox.isSelected());
            settings.setExportObjectFormatting(this.exportObjectFormattingCheckBox.isSelected());
            settings.setExportPageBreaks(this.exportPageBreaksCheckBox.isSelected());
            settings.setUseOnePageHeaderAndFooter(this.useOnePageCheckBox.isSelected());
            return settings;
        }
        StiExcelXmlExportSettings settings = new StiExcelXmlExportSettings(super.getExportSettings());
        return settings;
    }

    private void loadSettings() {
        this.selectStringCombo(this.typeComboBox, StiSettings.getStringValue((String)"Export", (String)"Excel2007Type", (String)"Excel 97-2003"));
        this.expandPanel.setExpanded(StiSettings.getBoolValue((String)"Export", (String)"Excel2007SettingsPanelExpanded", (Boolean)false));
        this.openAfterExport.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Excel2007OpenAfterExport", (Boolean)true));
        if (this.imageResolutionComboBox != null) {
            this.selectStringCombo(this.imageResolutionComboBox, StiSettings.getStringValue((String)"Export", (String)"Excel2007ImageResolution", (String)"100"));
            this.selectStringCombo(this.imageQualityComboBox, StiSettings.getStringValue((String)"Export", (String)"Excel2007ImageQuality", (String)"75"));
            this.exportDataOnlyCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Excel2007ExportDataOnly", (Boolean)false));
            this.exportObjectFormattingCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Excel2007ExportObjectFormatting", (Boolean)false));
            this.useOnePageCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Excel2007UseOnePageHEader", (Boolean)false));
            this.exportEachPageCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Excel2007ExportEachPageToSheet", (Boolean)false));
            this.exportPageBreaksCheckBox.setSelected(StiSettings.getBoolValue((String)"Export", (String)"Excel2007ExportPageBreaks", (Boolean)false));
        }
    }

    @Override
    protected void saveSettings() {
        StiSettings.setStringValue((String)"Export", (String)"Excel2007Type", (String)((String)this.typeComboBox.getSelectedItem()));
        StiSettings.setBoolValue((String)"Export", (String)"Excel2007SettingsPanelExpanded", (Boolean)this.expandPanel.getExpanded());
        StiSettings.setBoolValue((String)"Export", (String)"Excel2007OpenAfterExport", (Boolean)this.openAfterExport.isSelected());
        if (this.imageResolutionComboBox != null) {
            StiSettings.setStringValue((String)"Export", (String)"Excel2007ImageResolution", (String)((String)this.imageResolutionComboBox.getSelectedItem()));
            StiSettings.setStringValue((String)"Export", (String)"Excel2007ImageQuality", (String)((String)this.imageQualityComboBox.getSelectedItem()));
            StiSettings.setBoolValue((String)"Export", (String)"Excel2007ExportDataOnly", (Boolean)this.exportDataOnlyCheckBox.isSelected());
            StiSettings.setBoolValue((String)"Export", (String)"Excel2007ExportObjectFormatting", (Boolean)this.exportObjectFormattingCheckBox.isSelected());
            StiSettings.setBoolValue((String)"Export", (String)"Excel2007UseOnePageHEader", (Boolean)this.useOnePageCheckBox.isSelected());
            StiSettings.setBoolValue((String)"Export", (String)"Excel2007ExportEachPageToSheet", (Boolean)this.exportEachPageCheckBox.isSelected());
            StiSettings.setBoolValue((String)"Export", (String)"Excel2007ExportPageBreaks", (Boolean)this.exportPageBreaksCheckBox.isSelected());
        }
    }
}

