/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.form;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.viewer.StiViewerFx;
import com.stimulsoft.viewer.controls.visual.StiFlatButton;
import com.stimulsoft.viewer.utils.StiURLHelper;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class StiInfoDialog
extends JDialog {
    private static final long serialVersionUID = -744024289885320828L;
    private JLabel label;
    private StiFlatButton okButton;
    private boolean expired;
    private StiViewerFx viewerPanel;

    public StiInfoDialog(StiViewerFx viewerPanel, boolean expired) throws HeadlessException {
        super(viewerPanel.getParentFrame(), "Viewer", true);
        this.expired = expired;
        this.buildComponent();
        this.bindEvents();
        this.setDefaultCloseOperation(2);
        this.setSize(280, 220);
        this.setResizable(false);
        this.viewerPanel = viewerPanel;
        this.setLocationRelativeTo(viewerPanel);
    }

    private void buildComponent() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.label = new JLabel();
        this.label.setText(this.expired ? StiLocalization.Get((String)"Notices", (String)"YourTrialHasExpired") : StiLocalization.Get((String)"Notices", (String)"YouUsingTrialVersion"));
        this.label.setLocation(0, 0);
        this.label.setAlignmentX(0.5f);
        this.label.setPreferredSize(new Dimension(280, 122));
        this.add(this.label);
        this.add(new JSeparator());
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        this.okButton = new StiFlatButton(StiLocalization.getHingValue((String)"Buttons", (String)"Ok"));
        bottomPanel.add(this.okButton);
        this.add(bottomPanel);
    }

    private void bindEvents() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StiInfoDialog.this.expired) {
                    StiURLHelper.openURL("https://www.stimulsoft.com/en/online-store");
                    StiInfoDialog.this.viewerPanel.getParentFrame().dispose();
                }
                StiInfoDialog.this.changeText();
            }
        });
    }

    private void changeText() {
        this.dispose();
    }
}

