/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.controls.visual;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.viewer.enums.StiViewState;
import com.stimulsoft.viewer.events.StiViewCommonEvent;
import com.stimulsoft.viewer.events.StiViewEventable;
import com.stimulsoft.viewer.logic.StiViewModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class StiViewPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -7679996142700861014L;
    private static final ImageIcon ICON_ZOOM_CHECKED = StiResourceUtil.loadIcon((String)"/icons/ZoomChecked.png");
    private static final ImageIcon EMPTY_ICON = StiResourceUtil.loadIcon((String)"/icons/Empty.png");
    private static final ImageIcon ZOOM_ONE_PAGE_ICON = StiResourceUtil.loadIcon((String)"/icons/ZoomOnePageMenu.png");
    private static final ImageIcon ZOOM_ONE_PAGE_CHECKED_ICON = StiResourceUtil.loadIcon((String)"/icons/ZoomOnePageMenuChecked.png");
    private static final ImageIcon ZOOM_TWO_PAGES_ICON = StiResourceUtil.loadIcon((String)"/icons/ZoomTwoPagesMenu.png");
    private static final ImageIcon ZOOM_TWO_PAGES_CHECKED_ICON = StiResourceUtil.loadIcon((String)"/icons/ZoomTwoPagesMenuChecked.png");
    private static final ImageIcon ZOOM_PAGE_WIDTH_ICON = StiResourceUtil.loadIcon((String)"/icons/ZoomPageWidthMenu.png");
    private static final ImageIcon ZOOM_PAGE_WIDTH_CHECKED_ICON = StiResourceUtil.loadIcon((String)"/icons/ZoomPageWidthMenuChecked.png");
    private StiViewEventable eventDispatcher;
    private JMenuItem item200;
    private JMenuItem item150;
    private JMenuItem item100;
    private JMenuItem item75;
    private JMenuItem item50;
    private JMenuItem item25;
    private JMenuItem item10;
    private JMenuItem itemOnePage;
    private JMenuItem itemTwoPages;
    private JMenuItem itemPageWidth;

    public StiViewPopupMenu(StiViewEventable eventDispatcher, StiViewModel model) {
        this.eventDispatcher = eventDispatcher;
        this.item200 = new JMenuItem("200%", EMPTY_ICON);
        this.item200.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(200, e);
            }
        });
        this.add(this.item200);
        this.item150 = new JMenuItem("150%", EMPTY_ICON);
        this.item150.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(150, e);
            }
        });
        this.add(this.item150);
        this.item100 = new JMenuItem("100%", EMPTY_ICON);
        this.item100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(100, e);
            }
        });
        this.add(this.item100);
        this.item75 = new JMenuItem("75%", EMPTY_ICON);
        this.item75.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(75, e);
            }
        });
        this.add(this.item75);
        this.item50 = new JMenuItem("50%", EMPTY_ICON);
        this.item50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(50, e);
            }
        });
        this.add(this.item50);
        this.item25 = new JMenuItem("25%", EMPTY_ICON);
        this.item25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(25, e);
            }
        });
        this.add(this.item25);
        this.item10 = new JMenuItem("10%", EMPTY_ICON);
        this.item10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomTo(10, e);
            }
        });
        this.add(this.item10);
        this.addSeparator();
        this.itemOnePage = new JMenuItem(StiLocalization.getValue((String)"FormViewer", (String)"ZoomOnePage"), ZOOM_ONE_PAGE_ICON);
        this.itemOnePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomPages(StiViewState.ZoomOnePage, e);
            }
        });
        this.add(this.itemOnePage);
        this.itemTwoPages = new JMenuItem(StiLocalization.getValue((String)"FormViewer", (String)"ZoomTwoPages"), ZOOM_TWO_PAGES_ICON);
        this.itemTwoPages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomPages(StiViewState.ZoomTwoPages, e);
            }
        });
        this.add(this.itemTwoPages);
        this.itemPageWidth = new JMenuItem(StiLocalization.getValue((String)"FormViewer", (String)"ZoomPageWidth"), ZOOM_PAGE_WIDTH_ICON);
        this.itemPageWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StiViewPopupMenu.this.zoomPages(StiViewState.ZoomPageWidth, e);
            }
        });
        this.add(this.itemPageWidth);
        this.bindEvents(model);
        this.updateViewStateIcon(model.getViewState());
        this.updateZoomIcon((int)(model.getZoom() * 100.0));
    }

    private void bindEvents(StiViewModel model) {
        model.addPropertyChangeListener("viewState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StiViewState state = (StiViewState)((Object)evt.getNewValue());
                StiViewPopupMenu.this.updateViewStateIcon(state);
            }
        });
        model.addPropertyChangeListener("zoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int zoom = (int)((Double)evt.getNewValue() * 100.0);
                StiViewPopupMenu.this.updateZoomIcon(zoom);
            }
        });
    }

    private void updateViewStateIcon(StiViewState state) {
        this.itemOnePage.setIcon(ZOOM_ONE_PAGE_ICON);
        this.itemTwoPages.setIcon(ZOOM_TWO_PAGES_ICON);
        this.itemPageWidth.setIcon(ZOOM_PAGE_WIDTH_ICON);
        if (state == StiViewState.ZoomOnePage) {
            this.itemOnePage.setIcon(ZOOM_ONE_PAGE_CHECKED_ICON);
            this.itemOnePage.setSelected(true);
        } else if (state == StiViewState.ZoomTwoPages) {
            this.itemTwoPages.setIcon(ZOOM_TWO_PAGES_CHECKED_ICON);
        } else if (state == StiViewState.ZoomPageWidth) {
            this.itemPageWidth.setIcon(ZOOM_PAGE_WIDTH_CHECKED_ICON);
        }
    }

    private void updateZoomIcon(int zoom) {
        this.item200.setIcon(EMPTY_ICON);
        this.item150.setIcon(EMPTY_ICON);
        this.item100.setIcon(EMPTY_ICON);
        this.item75.setIcon(EMPTY_ICON);
        this.item50.setIcon(EMPTY_ICON);
        this.item25.setIcon(EMPTY_ICON);
        this.item10.setIcon(EMPTY_ICON);
        if (zoom == 200) {
            this.item200.setIcon(ICON_ZOOM_CHECKED);
        } else if (zoom == 150) {
            this.item150.setIcon(ICON_ZOOM_CHECKED);
        } else if (zoom == 100) {
            this.item100.setIcon(ICON_ZOOM_CHECKED);
        } else if (zoom == 75) {
            this.item75.setIcon(ICON_ZOOM_CHECKED);
        } else if (zoom == 50) {
            this.item50.setIcon(ICON_ZOOM_CHECKED);
        } else if (zoom == 25) {
            this.item25.setIcon(ICON_ZOOM_CHECKED);
        } else if (zoom == 10) {
            this.item10.setIcon(ICON_ZOOM_CHECKED);
        }
    }

    private void zoomPages(StiViewState state, ActionEvent actionEvent) {
        this.eventDispatcher.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ChangeViewState", (Object)state));
    }

    private void zoomTo(Integer value, ActionEvent actionEvent) {
        this.zoomPages(StiViewState.Own, null);
        this.eventDispatcher.getEventDispatcher().dispatchStiEvent(new StiViewCommonEvent("ZoomChanged", value));
    }
}

