/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webviewer.helper;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.mail.StiMailSender;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.StiPdfComplianceMode;
import com.stimulsoft.report.export.service.StiBmpExportService;
import com.stimulsoft.report.export.service.StiCsvExportService;
import com.stimulsoft.report.export.service.StiExcel2007ExportService;
import com.stimulsoft.report.export.service.StiExcelExportService;
import com.stimulsoft.report.export.service.StiExcelXmlExportService;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.service.StiJpegExportService;
import com.stimulsoft.report.export.service.StiOdsExportService;
import com.stimulsoft.report.export.service.StiOdtExportService;
import com.stimulsoft.report.export.service.StiPcxExportService;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.service.StiPngExportService;
import com.stimulsoft.report.export.service.StiPpt2007ExportService;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.StiSvgzExportService;
import com.stimulsoft.report.export.service.StiSylkExportService;
import com.stimulsoft.report.export.service.StiTxtExportService;
import com.stimulsoft.report.export.service.StiWord2007ExportService;
import com.stimulsoft.report.export.service.StiXmlExportService;
import com.stimulsoft.report.export.service.StiXpsExportService;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiImageExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.settings.StiWordExportSettings;
import com.stimulsoft.report.export.settings.StiXmlExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.report.export.tools.StiDataType;
import com.stimulsoft.report.export.tools.StiExcelType;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiImageType;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiPdfAllowEditable;
import com.stimulsoft.report.export.tools.StiPdfAutoPrintMode;
import com.stimulsoft.report.export.tools.StiRtfExportMode;
import com.stimulsoft.report.export.tools.StiTxtBorderType;
import com.stimulsoft.report.export.tools.StiUserAccessPrivileges;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.pdf.StiPdfEncryptionKeyLength;
import com.stimulsoft.report.export.tools.pdf.StiPdfImageCompressionMethod;
import com.stimulsoft.report.saveLoad.StiEncryptedDocumentSLService;
import com.stimulsoft.report.saveLoad.StiSLActions;
import com.stimulsoft.report.saveLoad.StiSLService;
import com.stimulsoft.web.helper.StiEditableFieldsHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.webviewer.StiRequiredOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiExportsClass {
    public static String getReportFileName(StiReport report) {
        return report.getReportAlias() == null || report.getReportAlias().trim().length() == 0 ? report.getReportName() : report.getReportAlias();
    }

    private static String getReportFileExtension(StiExportFormat exportFormat) {
        switch (exportFormat) {
            case Document: {
                return "mdc";
            }
            case Excel: {
                return "xls";
            }
            case Excel2007: {
                return "xlsx";
            }
            case PowerPoint: {
                return "ppt";
            }
            case Text: {
                return "txt";
            }
            case Word: {
                return "docx";
            }
        }
        return exportFormat.toString().toLowerCase().replaceAll("image", "");
    }

    public static void exportReport(StiReport report, StiExportFormat exportFormat, Element jsonObject, OutputStream stream) throws NoSuchAlgorithmException, IOException, JSONException, StiException {
        StiExportsClass.exportReport(report, exportFormat, jsonObject, stream, false);
    }

    public static Object exportReport(StiReport report, StiExportFormat exportFormat, Element settingsObject, boolean saveFileDialog) throws NoSuchAlgorithmException, IOException, JSONException, StiException {
        return StiExportsClass.exportReport(report, exportFormat, settingsObject, null, saveFileDialog);
    }

    public static Object emailReport(StiReport report, StiExportFormat exportFormat, Element settingsNode, StiMailProperties mail, boolean compressMessage) {
        String attachmentName = StiExportsClass.getReportFileName(report);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (StiValidationUtil.isNullOrEmpty((String)mail.getBody())) {
            mail.setBody(String.format("This Email contains the '$s' report file.", attachmentName));
        }
        try {
            StiExportsClass.exportReport(report, exportFormat, settingsNode, stream, false);
            ByteArrayInputStream bis = new ByteArrayInputStream(stream.toByteArray());
            StiMailProperties stiMailProperties = mail;
            stiMailProperties.getClass();
            StiMailProperties.StiStreamAttachment sa = new StiMailProperties.StiStreamAttachment(stiMailProperties, (InputStream)bis, attachmentName);
            mail.getStreamAttachments().add(sa);
            StiMailSender.sendMail((StiMailProperties)mail);
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SendEmail><ErrorCode>An error occurred while sending Email.</ErrorCode><ErrorDescription>%s</ErrorDescription></SendEmail>", e.getMessage());
        }
        return "0";
    }

    public static Object exportReport(StiReport report, StiRequiredOptions requestOptions, StiMailProperties emailOptions) throws NoSuchAlgorithmException, IOException, JSONException, StiException, ParserConfigurationException {
        boolean saveFileDialog = true;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element xmlExport = doc.createElement("Export");
        doc.appendChild(xmlExport);
        Element element = doc.createElement("Format");
        element.setTextContent(requestOptions.getExportFormat().toString());
        xmlExport.appendChild(element);
        Element xmlSettings = doc.createElement("Settings");
        xmlExport.appendChild(xmlSettings);
        if (requestOptions.getExportSettings() != null) {
            for (String key : requestOptions.getExportSettings().keySet()) {
                element = doc.createElement(key);
                element.setTextContent(requestOptions.getExportSettings().get(key) != null ? requestOptions.getExportSettings().get(key).toString() : "");
                if ("OpenAfterExport".equals(key)) {
                    xmlExport.appendChild(element);
                    saveFileDialog = !Boolean.parseBoolean(element.getTextContent());
                    continue;
                }
                xmlSettings.appendChild(element);
            }
        }
        StiEditableFieldsHelper.applyEditableFieldsToReport((StiReport)report, requestOptions.getEditableParameters());
        if (emailOptions == null) {
            return StiExportsClass.exportReport(report, requestOptions.getExportFormat(), xmlSettings, null, saveFileDialog);
        }
        return StiExportsClass.emailReport(report, requestOptions.getExportFormat(), xmlSettings, emailOptions, false);
    }

    public static StiWebActionResult exportReport(StiReport report, StiExportFormat exportFormat, Element jsonObject, OutputStream stream, boolean saveFileDialog) throws NoSuchAlgorithmException, IOException, JSONException, StiException {
        StiExportSettings settings = StiExportsClass.getExportSettings(exportFormat, jsonObject);
        switch (exportFormat) {
            case Document: {
                return StiExportsClass.saveDocumentFile(report, jsonObject, stream);
            }
            case Pdf: {
                return StiExportsClass.exportAsPdf(report, (StiPdfExportSettings)settings, stream, saveFileDialog);
            }
            case Xps: {
                return StiExportsClass.exportAsXps(report, (StiXpsExportSettings)settings, stream, saveFileDialog);
            }
            case PowerPoint: {
                return StiExportsClass.exportAsPpt2007(report, (StiPowerPointExportSettings)settings, stream, saveFileDialog);
            }
            case Html: {
                return StiExportsClass.exportAsHtml(report, (StiHtmlExportSettings)settings, stream, saveFileDialog);
            }
            case Text: {
                return StiExportsClass.exportAsText(report, (StiTxtExportSettings)settings, stream);
            }
            case Rtf: {
                return StiExportsClass.exportAsRtf(report, (StiRtfExportSettings)settings, stream);
            }
            case Word: {
                return StiExportsClass.exportAsWord2007(report, (StiWordExportSettings)settings, stream);
            }
            case Odt: {
                return StiExportsClass.exportAsOdt(report, (StiOdtExportSettings)settings, stream);
            }
            case Excel: {
                return StiExportsClass.exportAsExcel(report, (StiExcelExportSettings)settings, stream);
            }
            case ExcelXml: {
                return StiExportsClass.exportAsExcelXml(report, (StiExcelExportSettings)settings, stream);
            }
            case Excel2007: {
                return StiExportsClass.exportAsExcel2007(report, (StiExcelExportSettings)settings, stream);
            }
            case Ods: {
                return StiExportsClass.exportAsOds(report, (StiOdsExportSettings)settings, stream);
            }
            case Csv: {
                return StiExportsClass.exportAsCsv(report, (StiDataExportSettings)settings, stream);
            }
            case Xml: {
                return StiExportsClass.exportAsXml(report, stream);
            }
            case Sylk: {
                return StiExportsClass.exportAsSylk(report, (StiDataExportSettings)settings, stream);
            }
            case ImageBmp: {
                return StiExportsClass.exportAsBmp(report, (StiImageExportSettings)settings, stream);
            }
            case ImageJpeg: {
                return StiExportsClass.exportAsJpeg(report, (StiImageExportSettings)settings, stream);
            }
            case ImagePcx: {
                return StiExportsClass.exportAsPcx(report, (StiImageExportSettings)settings, stream);
            }
            case ImagePng: {
                return StiExportsClass.exportAsPng(report, (StiImageExportSettings)settings, stream);
            }
            case ImageSvg: {
                return StiExportsClass.exportAsSvg(report, (StiImageExportSettings)settings, stream);
            }
            case ImageSvgz: {
                return StiExportsClass.exportAsSvgz(report, (StiImageExportSettings)settings, stream);
            }
        }
        return new StiWebActionResult();
    }

    public static StiWebActionResult saveDocumentFile(StiReport report, Element settingsNode, OutputStream stream) throws IOException, NoSuchAlgorithmException, JSONException {
        String format = "mdc";
        String password = "";
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equals("SaveReportFormat")) {
                    format = node.getTextContent().toLowerCase();
                    continue;
                }
                if (!node.getNodeName().equals("SaveReportPassword")) continue;
                password = node.getTextContent();
            }
        }
        boolean isStreamNull = false;
        if (stream == null) {
            isStreamNull = true;
            stream = new ByteArrayOutputStream();
        }
        StiSLService service = null;
        if ("mdc".equals(format)) {
            service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(0);
        } else if ("mdz".equals(format)) {
            service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(1);
        } else if ("mdx".equals(format)) {
            service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(2);
        }
        if (service instanceof StiEncryptedDocumentSLService) {
            ((StiEncryptedDocumentSLService)service).setKey(password);
        }
        service.save(report, stream);
        if (isStreamNull) {
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + "." + format, "application/xml");
        }
        return null;
    }

    private static StiWebActionResult exportAsPdf(StiReport report, StiPdfExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, JSONException, IOException {
        StiPdfExportService service = new StiPdfExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportPdf(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".pdf", "application/pdf", saveFileDialog);
        }
        service.exportPdf(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsXps(StiReport report, StiXpsExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, IOException {
        StiXpsExportService service = new StiXpsExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportXps(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".xps", "application/vnd.ms-xpsdocument", saveFileDialog);
        }
        service.exportXps(report, stream, (StiExportSettings)settings);
        return null;
    }

    private static StiWebActionResult exportAsPpt2007(StiReport report, StiPowerPointExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, IOException {
        StiPpt2007ExportService service = new StiPpt2007ExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportPowerPoint(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".pptx", "application/vnd.ms-powerpoint", saveFileDialog);
        }
        service.exportPowerPoint(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsHtml(StiReport report, StiHtmlExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, IOException {
        StiHtmlExportService service = new StiHtmlExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportHtml(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".html", "text/html", saveFileDialog);
        }
        service.exportHtml(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsText(StiReport report, StiTxtExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiTxtExportService service = new StiTxtExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportTxt(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".txt", "application/text");
        }
        service.exportTxt(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsRtf(StiReport report, StiRtfExportSettings settings, OutputStream stream) throws StiException, IOException, JSONException {
        StiRtfExportService service = new StiRtfExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportRtf(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".rtf", "application/msword");
        }
        service.exportRtf(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsWord2007(StiReport report, StiWordExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiWord2007ExportService service = new StiWord2007ExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportWord(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".docx", "application/msword");
        }
        service.exportWord(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsOdt(StiReport report, StiOdtExportSettings settings, OutputStream stream) throws StiException, IOException {
        StiOdtExportService service = new StiOdtExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportOdt(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".odt", "application/vnd.oasis.opendocument.text");
        }
        service.exportOdt(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsExcel(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiExcelExportService service = new StiExcelExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportExcel(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".xls", "application/excel");
        }
        service.exportExcel(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsExcelXml(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiExcelXmlExportService service = new StiExcelXmlExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportExcel(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".xls", "application/excel");
        }
        service.exportExcel(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsExcel2007(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiExcel2007ExportService service = new StiExcel2007ExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportExcel(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".xlsx", "application/excel");
        }
        service.exportExcel(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsOds(StiReport report, StiOdsExportSettings settings, OutputStream stream) throws StiException, IOException {
        StiOdsExportService service = new StiOdsExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportOds(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".ods", "application/excel");
        }
        service.exportOds(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsCsv(StiReport report, StiDataExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiCsvExportService service = new StiCsvExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportCsv(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".csv", "application/excel");
        }
        service.exportCsv(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsXml(StiReport report, OutputStream stream) throws StiException, IOException {
        StiXmlExportService service = new StiXmlExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportXml(report, stream, (StiExportSettings)new StiXmlExportSettings());
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".xml", "application/xml");
        }
        service.exportXml(report, stream, (StiExportSettings)new StiXmlExportSettings());
        return null;
    }

    public static StiWebActionResult exportAsSylk(StiReport report, StiDataExportSettings settings, OutputStream stream) throws JSONException, IOException, StiException {
        StiSylkExportService service = new StiSylkExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportSylk(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".sylk", "application/mixed");
        }
        service.exportSylk(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsBmp(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiBmpExportService service = new StiBmpExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".bmp", "application/bmp");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsJpeg(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiJpegExportService service = new StiJpegExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".jpg", "application/jpeg");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsPcx(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiPcxExportService service = new StiPcxExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".pcx", "application/pcx");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsPng(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiPngExportService service = new StiPngExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".png", "application/png");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsSvg(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiSvgExportService service = new StiSvgExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".svg", "application/mixed");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsSvgz(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiSvgzExportService service = new StiSvgzExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiExportsClass.getReportFileName(report) + ".svgz", "application/mixed");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiExportSettings getExportSettings(StiExportFormat exportFormat, Element settingsNode) throws JSONException {
        switch (exportFormat) {
            case Pdf: {
                return StiExportsClass.getPdfExportSettings(settingsNode);
            }
            case Xps: {
                return StiExportsClass.getXpsExportSettings(settingsNode);
            }
            case PowerPoint: {
                return StiExportsClass.getPpt2007ExportSettings(settingsNode);
            }
            case Text: {
                return StiExportsClass.getTextExportSettings(settingsNode);
            }
            case Rtf: {
                return StiExportsClass.getRtfExportSettings(settingsNode);
            }
            case Word: {
                return StiExportsClass.getWord2007ExportSettings(settingsNode);
            }
            case Odt: {
                return StiExportsClass.getOdtExportSettings(settingsNode);
            }
            case Ods: {
                return StiExportsClass.getOdsExportSettings(settingsNode);
            }
            case Html: 
            case Html5: 
            case Mht: {
                return StiExportsClass.getHtmlExportSettings(settingsNode);
            }
            case Excel: 
            case Excel2007: 
            case ExcelXml: {
                return StiExportsClass.getExcelExportSettings(settingsNode, exportFormat);
            }
            case Csv: 
            case Xml: 
            case Sylk: 
            case Dbf: 
            case Dif: {
                return StiExportsClass.getDataExportSettings(settingsNode);
            }
            case ImageBmp: 
            case ImageJpeg: 
            case ImagePcx: 
            case ImagePng: 
            case ImageSvg: 
            case ImageSvgz: 
            case ImageGif: 
            case ImageTiff: 
            case ImageEmf: {
                return StiExportsClass.getImageExportSettings(settingsNode);
            }
        }
        return null;
    }

    private static StiPdfExportSettings getPdfExportSettings(Element settingsNode) throws JSONException {
        StiPdfExportSettings settings = new StiPdfExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("EmbeddedFonts")) {
                    settings.setEmbeddedFonts(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("StandardPdfFonts")) {
                    settings.setStandardPdfFonts(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("Compressed")) continue;
                if (node.equals("ExportRtfTextAsImage")) {
                    settings.setExportRtfTextAsImage(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("PasswordInputUser")) {
                    settings.setPasswordInputUser(value);
                    continue;
                }
                if (node.equals("PasswordInputOwner")) {
                    settings.setPasswordInputOwner(value);
                    continue;
                }
                if (node.equals("UserAccessPrivileges")) {
                    settings.setUserAccessPrivileges(StiUserAccessPrivileges.parse((String)value));
                    continue;
                }
                if (node.equals("KeyLength")) {
                    settings.setKeyLength(StiPdfEncryptionKeyLength.valueOf((String)value));
                    continue;
                }
                if (node.equals("UseUnicode")) {
                    settings.setUseUnicode(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("UseDigitalSignature") || node.equals("GetCertificateFromCryptoUI") || node.equals("SubjectNameString") || node.equals("UseLocalMachineCertificates") || node.equals("CreatorString") || node.equals("KeywordsString")) continue;
                if (node.equals("ImageCompressionMethod")) {
                    settings.setImageCompressionMethod(StiPdfImageCompressionMethod.valueOf((String)value));
                    continue;
                }
                if (node.equals("ImageFormat")) {
                    settings.setImageFormat(StiColorImageFormat.valueOf((String)value));
                    continue;
                }
                if (node.equals("DitheringType")) {
                    settings.setDitheringType(StiMonochromeDitheringType.valueOf((String)value));
                    continue;
                }
                if (node.equals("PdfComplianceMode")) {
                    settings.setPdfComplianceMode(StiPdfComplianceMode.valueOf((String)value));
                    continue;
                }
                if (node.equals("AutoPrintMode")) {
                    settings.setAutoPrintMode(StiPdfAutoPrintMode.valueOf((String)value));
                    continue;
                }
                if (!node.equals("AllowEditable")) continue;
                settings.setAllowEditable(StiPdfAllowEditable.valueOf((String)value));
            }
        }
        return settings;
    }

    private static StiXpsExportSettings getXpsExportSettings(Element settingsNode) throws JSONException {
        StiXpsExportSettings settings = new StiXpsExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (!node.equals("ExportRtfTextAsImage")) continue;
                settings.setExportRtfTextAsImage(Boolean.valueOf(value).booleanValue());
            }
        }
        return settings;
    }

    private static StiPowerPointExportSettings getPpt2007ExportSettings(Element settingsNode) throws JSONException {
        StiPowerPointExportSettings settings = new StiPowerPointExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (!node.equals("ImageQuality")) continue;
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
            }
        }
        return settings;
    }

    private static StiHtmlExportSettings getHtmlExportSettings(Element settingsNode) throws JSONException {
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("Encoding")) {
                    settings.setEncoding(Charset.forName(value));
                    continue;
                }
                if (node.equals("Zoom")) {
                    settings.setZoom(StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ExportMode")) {
                    settings.setExportMode(StiHtmlExportMode.valueOf((String)value));
                    continue;
                }
                if (node.equals("ExportQuality")) {
                    settings.setExportQuality(StiHtmlExportQuality.valueOf((String)value));
                    continue;
                }
                if (node.equals("AddPageBreaks")) {
                    settings.setAddPageBreaks(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("BookmarksTreeWidth")) {
                    settings.setBookmarksTreeWidth(Integer.valueOf(value).intValue());
                    continue;
                }
                if (node.equals("ExportBookmarksMode")) {
                    settings.setExportBookmarksMode(StiHtmlExportBookmarksMode.valueOf((String)value));
                    continue;
                }
                if (node.equals("UseStylesTable")) {
                    settings.setUseStylesTable(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("RemoveEmptySpaceAtBottom")) {
                    settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("PageHorAlignment")) {
                    settings.setPageHorAlignment(StiHorAlignment.valueOf((String)value));
                    continue;
                }
                if (!node.equals("ImageFormat")) continue;
                if (value.equals("Bmp")) {
                    settings.setImageFormat(StiImageFormat.Bmp);
                    continue;
                }
                if (value.equals("Emf")) {
                    settings.setImageFormat(StiImageFormat.Emf);
                    continue;
                }
                if (value.equals("Gif")) {
                    settings.setImageFormat(StiImageFormat.Gif);
                    continue;
                }
                if (value.equals("Jpeg")) {
                    settings.setImageFormat(StiImageFormat.Jpeg);
                    continue;
                }
                if (value.equals("Png")) {
                    settings.setImageFormat(StiImageFormat.Png);
                    continue;
                }
                if (!value.equals("Tiff")) continue;
                settings.setImageFormat(StiImageFormat.Tiff);
            }
        }
        return settings;
    }

    private static StiTxtExportSettings getTextExportSettings(Element settingsNode) throws JSONException {
        StiTxtExportSettings settings = new StiTxtExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("Encoding")) {
                    settings.setEncoding(Charset.forName(value));
                    continue;
                }
                if (node.equals("DrawBorder")) {
                    settings.setDrawBorder(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("BorderType")) {
                    settings.setBorderType(StiTxtBorderType.valueOf((String)value));
                    continue;
                }
                if (node.equals("KillSpaceLines")) {
                    settings.setKillSpaceLines(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("KillSpaceGraphLines")) {
                    settings.setKillSpaceGraphLines(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("PutFeedPageCode")) {
                    settings.setPutFeedPageCode(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("CutLongLines")) {
                    settings.setCutLongLines(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ZoomX")) {
                    settings.setZoomX((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ZoomY")) {
                    settings.setZoomY((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("UseEscapeCodes")) {
                    settings.setUseEscapeCodes(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (!node.equals("EscapeCodesCollectionName")) continue;
                settings.setEscapeCodesCollectionName(value);
            }
        }
        return settings;
    }

    private static StiRtfExportSettings getRtfExportSettings(Element settingsNode) throws JSONException {
        StiRtfExportSettings settings = new StiRtfExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("CodePage")) {
                    settings.setCodePage(Integer.valueOf(value).intValue());
                    continue;
                }
                if (node.equals("ExportMode")) {
                    settings.setExportMode(StiRtfExportMode.valueOf((String)value));
                    continue;
                }
                if (node.equals("UsePageHeadersAndFooters")) {
                    settings.setUsePageHeadersAndFooters(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("RemoveEmptySpaceAtBottom")) {
                    settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (!node.equals("StoreImagesAsPng")) continue;
                settings.setStoreImagesAsPng(Boolean.valueOf(value).booleanValue());
            }
        }
        return settings;
    }

    private static StiWordExportSettings getWord2007ExportSettings(Element settingsNode) throws JSONException {
        StiWordExportSettings settings = new StiWordExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("UsePageHeadersAndFooters")) {
                    settings.setUsePageHeadersAndFooters(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("RemoveEmptySpaceAtBottom")) {
                    settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("CompanyString")) {
                    settings.setCompanyString(value);
                    continue;
                }
                if (!node.equals("LastModifiedString")) continue;
                settings.setLastModifiedString(value);
            }
        }
        return settings;
    }

    private static StiOdtExportSettings getOdtExportSettings(Element settingsNode) {
        StiOdtExportSettings settings = new StiOdtExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("UsePageHeadersAndFooters")) {
                    settings.setUsePageHeadersAndFooters(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (!node.equals("RemoveEmptySpaceAtBottom")) continue;
                settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
            }
        }
        return settings;
    }

    private static StiExcelExportSettings getExcelExportSettings(Element settingsNode, StiExportFormat exportFormat) throws JSONException {
        StiExcelExportSettings settings = new StiExcelExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ExcelType")) {
                    settings.setExcelType(StiExcelType.valueOf((String)value));
                    continue;
                }
                if (node.equals("UseOnePageHeaderAndFooter")) {
                    settings.setUseOnePageHeaderAndFooter(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ExportDataOnly")) {
                    settings.setExportDataOnly(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ExportPageBreaks")) {
                    settings.setExportPageBreaks(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ExportObjectFormatting")) {
                    settings.setExportObjectFormatting(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ExportEachPageToSheet")) {
                    settings.setExportEachPageToSheet(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("CompanyString")) {
                    settings.setCompanyString(value);
                    continue;
                }
                if (!node.equals("LastModifiedString")) continue;
                settings.setLastModifiedString(value);
            }
        }
        return settings;
    }

    private static StiOdsExportSettings getOdsExportSettings(Element settingsNode) throws JSONException {
        StiOdsExportSettings settings = new StiOdsExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (!node.equals("ImageResolution")) continue;
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
            }
        }
        return settings;
    }

    private static StiDataExportSettings getDataExportSettings(Element settingsNode) throws JSONException {
        StiDataExportSettings settings = new StiDataExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("DataType")) {
                    settings.setDataType(StiDataType.valueOf((String)value));
                    continue;
                }
                if (node.equals("DataExportMode")) {
                    settings.setDataExportMode(StiDataExportMode.valueOf((String)value));
                    continue;
                }
                if (node.equals("Encoding")) {
                    settings.setEncoding(Charset.forName(value));
                    continue;
                }
                if (node.equals("ExportDataOnly")) {
                    settings.setExportDataOnly(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("Separator")) {
                    settings.setSeparator(value);
                    continue;
                }
                if (node.equals("SkipColumnHeaders")) {
                    settings.setSkipColumnHeaders(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (!node.equals("UseDefaultSystemEncoding")) continue;
                settings.setUseDefaultSystemEncoding(Boolean.valueOf(value).booleanValue());
            }
        }
        return settings;
    }

    private static StiImageExportSettings getImageExportSettings(Element settingsNode) throws JSONException {
        StiImageExportSettings settings = new StiImageExportSettings();
        if (settingsNode != null) {
            NodeList nodeList = settingsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String node = nodeList.item(i).getNodeName();
                String value = nodeList.item(i).getTextContent();
                if (node.equals("PageRange")) {
                    settings.setPageRange(new StiPagesRange(value));
                    continue;
                }
                if (node.equals("ImageType")) {
                    settings.setImageType(StiImageType.valueOf((String)value));
                    continue;
                }
                if (node.equals("ImageZoom")) {
                    settings.setImageZoom(StiObjectConverter.ConvertToDouble((Object)value));
                    continue;
                }
                if (node.equals("ImageResolution")) {
                    settings.setImageResolution(Integer.valueOf(value).intValue());
                    continue;
                }
                if (node.equals("CutEdges")) {
                    settings.setCutEdges(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("ImageFormat")) {
                    settings.setImageFormat(StiColorImageFormat.valueOf((String)value));
                    continue;
                }
                if (node.equals("MultipleFiles")) {
                    settings.setMultipleFiles(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (node.equals("DitheringType")) {
                    settings.setDitheringType(StiMonochromeDitheringType.valueOf((String)value));
                    continue;
                }
                if (!node.equals("TiffCompressionScheme")) continue;
            }
        }
        return settings;
    }
}

