/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.html;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.lib.utils.StiValidationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiHtmlElement {
    public static final String STYLE_ATTRIBUTE = "style";
    public static final String WIDTH_ATTRIBUTE = "width";
    public static final String HEIGHT_ATTRIBUTE = "height";
    public static final String BACKGROUND_COLOR_ATTRIBUTE = "background-color";
    public static final String CSS_CLASS_ATTRIBUTE = "class";
    public static final String ID_ATTRIBUTE = "id";

    public static Element createJavascriptHtmlElement(Document ownerDoc) {
        Element element = ownerDoc.createElement("script");
        element.setAttribute("language", "javascript");
        element.setAttribute("type", "text/javascript");
        return element;
    }

    public static Element createPanelHtmlElement(Document ownerDoc) {
        Element element = ownerDoc.createElement("div");
        return element;
    }

    public static void addStyle(Element elemnt, String styleAttribute, String styleValue) {
        String style = styleAttribute + ":" + styleValue;
        if (StiValidationUtil.isNullOrEmpty((String)elemnt.getAttribute(STYLE_ATTRIBUTE))) {
            elemnt.setAttribute(STYLE_ATTRIBUTE, style);
        } else {
            elemnt.setAttribute(STYLE_ATTRIBUTE, elemnt.getAttribute(STYLE_ATTRIBUTE) + ";" + style);
        }
    }

    public static void setCssClass(Element element, String cssClass) {
        element.setAttribute(CSS_CLASS_ATTRIBUTE, cssClass);
    }

    public static void setID(Element element, String id) {
        element.setAttribute(ID_ATTRIBUTE, id);
    }

    public static void setBackColor(Element element, StiColor color) {
        StiHtmlElement.addStyle(element, BACKGROUND_COLOR_ATTRIBUTE, color.toHTML());
    }
}

