/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.StiFontCollection;
import com.stimulsoft.base.helper.StiSvgHelper;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

public class StiReportResourceHelper {
    public static ArrayList<HashMap<String, Object>> getResourcesItems(StiReport report) {
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        for (StiResource resource : report.getDictionary().getResources()) {
            if (!resource.isAvailableInTheViewer()) continue;
            HashMap<String, Object> resourceItem = new HashMap<String, Object>();
            resourceItem.put("name", resource.getName());
            resourceItem.put("alias", resource.getAlias());
            resourceItem.put("type", resource.getType());
            resourceItem.put("size", resource.getContent() != null ? resource.getContent().length : 0);
            items.add(resourceItem);
        }
        return items.size() > 0 ? items : null;
    }

    public static String getResourceContentType(StiResource resource) {
        switch (resource.type) {
            case ReportSnapshot: 
            case Report: {
                return "application/octet-stream";
            }
            case Pdf: {
                return "application/pdf";
            }
            case Txt: {
                return "text/plain";
            }
            case Json: {
                return "text/plain";
            }
            case Rtf: {
                return "application/rtf";
            }
            case Word: {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case Excel: {
                return "application/vnd.ms-excel";
            }
            case Csv: {
                return "text/csv";
            }
            case Dbf: {
                return "application/dbf";
            }
            case Image: {
                if (StiImageHelper.isPng((byte[])resource.getContent())) {
                    return "image/png";
                }
                if (StiImageHelper.isMetafile((byte[])resource.content)) {
                    return "image/x-wmf";
                }
                if (StiImageHelper.isBmp((byte[])resource.content)) {
                    return "image/bmp";
                }
                if (StiImageHelper.isJpeg((byte[])resource.content)) {
                    return "image/jpeg";
                }
                if (StiImageHelper.isGif((byte[])resource.content)) {
                    return "image/gif";
                }
                if (StiSvgHelper.isSvg((byte[])resource.content)) {
                    return "image/svg+xml";
                }
                if (StiImageHelper.isTiff((byte[])resource.content)) {
                    return "image/tiff";
                }
                if (StiImageHelper.isEmf((byte[])resource.content)) {
                    return "image/x-emf";
                }
                return "image/png";
            }
        }
        return "text/plain";
    }

    public static String getResourceFileExt(StiResource resource) {
        switch (resource.type) {
            case ReportSnapshot: {
                return ".mdc";
            }
            case Report: {
                return ".mrt";
            }
            case Pdf: {
                return ".pdf";
            }
            case Txt: {
                return ".txt";
            }
            case Rtf: {
                return ".rtf";
            }
            case Word: {
                return ".docx";
            }
            case Excel: {
                return ".xlsx";
            }
            case Csv: {
                return ".csv";
            }
            case Dbf: {
                return ".dbf";
            }
            case Json: {
                return ".json";
            }
            case Image: {
                if (StiImageHelper.isPng((byte[])resource.content)) {
                    return ".png";
                }
                if (StiImageHelper.isMetafile((byte[])resource.content)) {
                    return ".wmf";
                }
                if (StiImageHelper.isBmp((byte[])resource.content)) {
                    return ".bmp";
                }
                if (StiImageHelper.isJpeg((byte[])resource.content)) {
                    return ".jpg";
                }
                if (StiImageHelper.isGif((byte[])resource.content)) {
                    return ".gif";
                }
                if (StiSvgHelper.isSvg((byte[])resource.content)) {
                    return ".svg";
                }
                if (StiImageHelper.isTiff((byte[])resource.content)) {
                    return ".tiff";
                }
                if (StiImageHelper.isEmf((byte[])resource.content)) {
                    return ".emf";
                }
                return ".png";
            }
        }
        return "";
    }

    public static String getStimulsoftFontBase64Data() {
        return "data:application/x-font-ttf;base64,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";
    }

    public static String getBase64DataFromFontResourceContent(StiResourceType resourceType, byte[] content) {
        if (content != null) {
            String mimeType = "application/octet-stream";
            switch (resourceType) {
                case FontEot: {
                    mimeType = "application/vnd.ms-fontobject";
                    break;
                }
                case FontTtf: {
                    mimeType = "application/x-font-ttf";
                    break;
                }
                case FontWoff: {
                    mimeType = "application/font-woff";
                    break;
                }
                case FontOtf: {
                    mimeType = "application/x-font-opentype";
                }
            }
            try {
                return String.format("data:%s;base64,%s", mimeType, new String(StiBase64EncoderUtil.encode((byte[])content), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        return "";
    }

    public static boolean isFontResourceType(StiResourceType resourceType) {
        return resourceType == StiResourceType.FontOtf || resourceType == StiResourceType.FontTtc || resourceType == StiResourceType.FontTtf;
    }

    public static ArrayList<HashMap<String, Object>> getFontResourcesArray(StiReport report) {
        ArrayList<HashMap<String, Object>> fontResources = new ArrayList<HashMap<String, Object>>();
        if (report != null) {
            for (StiResource resource : report.getDictionary().getResources()) {
                if (!StiReportResourceHelper.isFontResourceType(resource.getType())) continue;
                HashMap<String, String> fontResourceItem = new HashMap<String, String>();
                fontResourceItem.put("contentForCss", StiReportResourceHelper.getBase64DataFromFontResourceContent(resource.type, resource.content));
                fontResourceItem.put("originalFontFamily", StiFontCollection.getFontFamily((String)report.getResourceFontName(resource.getName()), (boolean)false));
                fontResources.add(fontResourceItem);
            }
        }
        return fontResources;
    }
}

