/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.StiConvert;
import com.stimulsoft.base.StiEncryption;
import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiReportParser;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteraction;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiCrossHeaderInteraction;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiSortHelper;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiTableOfContents;
import com.stimulsoft.report.components.enums.StiInteractionSortDirection;
import com.stimulsoft.report.components.interfaces.IStiInteraction;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.engine.engineV2.builders.StiCrossTabV2Builder;
import com.stimulsoft.report.enums.StiHtmlPreviewMode;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.html.StiHtmlTextWriter;
import com.stimulsoft.report.painters.StiContextPainter;
import com.stimulsoft.report.viewer.StiPreviewSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiReportDisplayMode;
import com.stimulsoft.web.enums.StiReportType;
import com.stimulsoft.web.enums.StiWebViewMode;
import com.stimulsoft.web.helper.StiBookmarkTreeNode;
import com.stimulsoft.web.helper.StiEditableFieldsHelper;
import com.stimulsoft.web.helper.StiExportsHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.web.helper.StiVariablesHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.xml.sax.SAXException;

public class StiReportHelper {
    public static String getHtmlColor(StiColor color) {
        return color.toHTML();
    }

    public static StiReport getCompiledReport(StiReport report) {
        return report;
    }

    public static StiReport createReportCopy(StiReport report) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Hashtable memoryStore = StiSerializeManager.serializeReport2((StiReport)report, (OutputStream)stream, (boolean)false, (boolean)false);
            ByteArrayInputStream bis = new ByteArrayInputStream(stream.toByteArray());
            StiReport cloneReport = StiSerializeManager.deserializeReport((InputStream)bis, (Hashtable)memoryStore, (boolean)true);
            cloneReport.getCustomFunctions().addAll(report.getCustomFunctions());
            stream.close();
            bis.close();
            cloneReport.getInfo().setForceDesigningMode(false);
            if (report.getVariables() != null) {
                for (String key : report.getVariables().keySet()) {
                    cloneReport.getVariables().put(key, report.getVariables().get((Object)key));
                }
            }
            return cloneReport;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void applyQueryParameters(StiRequestParams requestParams, StiReport report) {
        if (requestParams.server.passQueryParametersToReport && report != null && report.dictionary.variables.size() > 0) {
            for (String key : requestParams.all.keySet()) {
                if (key == null || key.startsWith("stiweb_") || !report.getDictionary().variables.contains(key)) continue;
                report.getDictionary().getVariables().get(key).setValue(requestParams.all.get(key));
                report.getVariables().put(key, requestParams.all.get(key));
            }
        }
    }

    private static ArrayList getDashboards(StiReport report) {
        boolean isReportExist = false;
        String reportName = report.getReportAlias() == null || report.getReportAlias().trim().length() == 0 ? report.getReportName() : report.getReportAlias();
        ArrayList dashboards = new ArrayList();
        return dashboards;
    }

    public static boolean isReportHasDashboards(StiReport report) {
        return false;
    }

    public static boolean isReportHasInteractions(StiReport report) {
        for (StiPage page : report.getPages()) {
            for (StiComponent comp : page.GetComponents()) {
                if (!StiReportHelper.isComponentHasInteraction(comp)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isComponentHasInteraction(StiComponent component) {
        if (component.getInteraction() != null) {
            if (component.getInteraction().getSortingEnabled() && !StiValidationUtil.isNullOrWhiteSpace((String)component.getInteraction().getSortingColumn())) {
                return true;
            }
            if (!(!component.getInteraction().getDrillDownEnabled() || StiValidationUtil.isNullOrEmpty((String)component.getInteraction().getDrillDownPageGuid()) && StiValidationUtil.isNullOrEmpty((String)component.getInteraction().getDrillDownReport()))) {
                return true;
            }
            if (component.getInteraction() instanceof StiBandInteraction && ((StiBandInteraction)component.getInteraction()).getCollapsingEnabled()) {
                return true;
            }
            if (component instanceof StiChart && StiOptions.Engine.getAllowInteractionInChartWithComponents()) {
                return true;
            }
        }
        if (component instanceof StiChart) {
            for (IStiSeries series : ((StiChart)component).getSeries()) {
                if (series.getInteraction() == null || !series.getInteraction().getDrillDownEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public static String getReportFileName(StiReport report) {
        String fileName;
        String string = fileName = report.getReportAlias() == null || report.getReportAlias().trim().length() == 0 ? report.getReportName() : report.getReportAlias();
        if (fileName == null || fileName.trim().length() == 0) {
            if (report.getReportFile() != null && report.getReportFile().trim().length() > 0) {
                fileName = report.getReportFile().replace(".mrt", "").replace(".mrz", "").replace(".mrx", "").replace(".mdc", "").replace(".mdz", "").replace(".mdx", "");
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            } else {
                fileName = "Report";
            }
        }
        return fileName.replace('<', '_').replace('>', '_').replace(':', '_').replace(';', '_').replace('\"', '_').replace('/', '_').replace('\\', '_').replace('|', '_').replace('?', '_').replace('*', '_').replace('%', '_');
    }

    public static void applySorting(StiReport report, HashMap<String, Object> parameters) {
        String[] values = parameters.get("ComponentName").toString().split(";");
        StiComponent comp = report.GetComponentByName(values[0]);
        Boolean isCtrl = Boolean.parseBoolean(values[1].toLowerCase());
        values = parameters.get("DataBand").toString().split(";");
        StiDataBand dataBand = (StiDataBand)report.GetComponentByName(values[0]);
        if (dataBand != null) {
            ArrayList<String> vals = new ArrayList<String>(Arrays.asList(values));
            vals.remove(0);
            dataBand.setSort(vals);
        }
        if (comp != null && dataBand != null) {
            String dataBandColumnString = comp.getInteraction().GetSortColumnsString();
            if (dataBand.getSort() == null || dataBand.getSort().size() == 0) {
                dataBand.setSort(StiSortHelper.addColumnToSorting((List)dataBand.getSort(), (String)dataBandColumnString, (boolean)true));
            } else {
                int sortIndex = StiSortHelper.getColumnIndexInSorting((List)dataBand.getSort(), (String)dataBandColumnString);
                if (isCtrl.booleanValue()) {
                    if (sortIndex == -1) {
                        dataBand.setSort(StiSortHelper.addColumnToSorting((List)dataBand.getSort(), (String)dataBandColumnString, (boolean)true));
                    } else {
                        dataBand.setSort(StiSortHelper.changeColumnSortDirection((List)dataBand.getSort(), (String)dataBandColumnString));
                    }
                } else if (sortIndex != -1) {
                    StiInteractionSortDirection direction = StiSortHelper.getColumnSortDirection((List)dataBand.getSort(), (String)dataBandColumnString);
                    direction = direction == StiInteractionSortDirection.Ascending ? StiInteractionSortDirection.Descending : StiInteractionSortDirection.Ascending;
                    dataBand.setSort(StiSortHelper.addColumnToSorting(new ArrayList(), (String)dataBandColumnString, (direction == StiInteractionSortDirection.Ascending ? 1 : 0) != 0));
                    comp.getInteraction().setSortingDirection(direction);
                } else {
                    dataBand.setSort(StiSortHelper.addColumnToSorting(new ArrayList(), (String)dataBandColumnString, (boolean)true));
                    comp.getInteraction().setSortingDirection(StiInteractionSortDirection.Ascending);
                }
            }
            report.setIsRendered(false);
        }
    }

    public static List<Object> getPagesArray(StiReport report, StiRequestParams requestParams) throws IOException, StiException {
        StiHtmlExportService service = new StiHtmlExportService();
        service.setRenderWebViewer(true);
        service.setRenderWebInteractions(true);
        service.setStyles(new ArrayList());
        service.setClearOnFinish(false);
        service.setRenderStyles(false);
        ArrayList<Object> pages = new ArrayList<Object>();
        if (requestParams.viewer.reportType == StiReportType.Dashboard) {
            HashMap<String, Object> attributes = StiReportHelper.getDashboardPage(report, requestParams.viewer.pageNumber, requestParams);
            pages.add(attributes);
        } else if (requestParams.viewer.viewMode == StiWebViewMode.SinglePage) {
            HashMap<String, Object> attributes = StiReportHelper.getReportPage(report, service, requestParams.viewer.pageNumber, requestParams);
            pages.add(attributes);
        } else {
            for (int index = 0; index < report.getRenderedPages().size(); ++index) {
                HashMap<String, Object> attributes = StiReportHelper.getReportPage(report, service, index, requestParams);
                pages.add(attributes);
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        StiHtmlTextWriter htmlWriter = new StiHtmlTextWriter(writer);
        service.setHtmlWriter(htmlWriter);
        if (service.getTableRender() != null) {
            service.getTableRender().renderStylesTable(true, false, false, null, "#" + requestParams.id + " ");
        }
        htmlWriter.flush();
        writer.flush();
        String htmlTextStyles = new String(stream.toByteArray(), "UTF-8");
        writer.close();
        pages.add(htmlTextStyles);
        String chartScript = service.getChartScript();
        pages.add(chartScript);
        service.clear();
        return pages;
    }

    public static void applyCollapsing(StiReport report, HashMap<String, Object> parameters) {
        StiComponent interactionComp;
        String componentName = (String)parameters.get("ComponentName");
        StiComponent comp = report.GetComponentByName(componentName);
        Object object = interactionComp = comp instanceof IStiInteraction ? comp : null;
        if (interactionComp != null && interactionComp.getInteraction() != null) {
            StiCrossHeaderInteraction crossHeaderInteraction;
            report.setInteractionCollapsingStates((HashMap)parameters.get("CollapsingStates"));
            HashMap states = (HashMap)report.getInteractionCollapsingStates().get(componentName);
            HashMap clonedStates = (HashMap)states.clone();
            for (Object obj : clonedStates.keySet()) {
                if (!(obj instanceof String)) continue;
                int num = Integer.parseInt((String)obj);
                states.put(num, states.get(obj));
                states.remove(obj);
            }
            StiCrossHeaderInteraction stiCrossHeaderInteraction = crossHeaderInteraction = interactionComp.getInteraction() instanceof StiCrossHeaderInteraction ? (StiCrossHeaderInteraction)interactionComp.getInteraction() : null;
            if (crossHeaderInteraction != null && crossHeaderInteraction.getCollapsingEnabled()) {
                StiCrossHeader header;
                StiCrossTabV2Builder.setCollapsed((StiCrossHeader)header, (!StiCrossTabV2Builder.isCollapsed((StiCrossHeader)(header = (StiCrossHeader)comp)) ? 1 : 0) != 0);
            }
            report.setIsRendered(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StiReport applyDrillDown(StiReport report, StiReport renderedReport, HashMap<String, Object> parameters) throws IOException, SAXException, StiDeserializationException {
        StiChart interactionChart;
        StiPage renderedPage;
        StiComponent interactionComp;
        int pageIndex = StiConvert.toInt32((Object)parameters.get("PageIndex"));
        int componentIndex = StiConvert.toInt32((Object)parameters.get("ComponentIndex"));
        int elementIndex = StiConvert.toInt32((Object)parameters.get("ElementIndex"));
        String pageGuid = (String)parameters.get("PageGuid");
        String reportFile = (String)parameters.get("ReportFile");
        Object drillDownPage = null;
        StiReport newReport = report;
        if (renderedReport == null) {
            renderedReport = report;
        }
        if (!renderedReport.isRendered) {
            renderedReport.Render(false);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)pageGuid)) {
            for (Object page : report.getPages()) {
                if (pageGuid.equals(page.getGuid())) {
                    drillDownPage = page;
                    page.setEnabled(true);
                    page.setSkip(false);
                    continue;
                }
                page.setEnabled(false);
            }
            StiComponentsCollection comps = report.GetComponents();
            for (Object comp : comps) {
                if (comp.getInteraction() != null && comp.getInteraction().getDrillDownEnabled() && drillDownPage.getGuid().equals(comp.getInteraction().getDrillDownPageGuid())) {
                    comp.getInteraction().setDrillDownPage(null);
                }
                if (!(comp instanceof StiChart)) continue;
                StiChart chart = (StiChart)comp;
                for (IStiSeries series : chart.getSeries()) {
                    StiSeriesInteraction seriesInteraction = (StiSeriesInteraction)series.getInteraction();
                    if (series.getInteraction() == null || !seriesInteraction.getDrillDownEnabled() || !drillDownPage.getGuid().equals(seriesInteraction.getDrillDownPageGuid())) continue;
                    seriesInteraction.setDrillDownPage(null);
                }
            }
        } else if (StiValidationUtil.isNotNullOrEmpty((String)reportFile)) {
            newReport = StiSerializeManager.deserializeReport((File)new File(reportFile));
        }
        if (StiValidationUtil.equals((Object)report.getReportAlias(), (Object)newReport.getReportAlias()) && drillDownPage != null) {
            newReport.setReportAlias(drillDownPage.getAlias() == null || drillDownPage.getAlias().length() == 0 ? drillDownPage.getName() : drillDownPage.getAlias());
        }
        if (StiValidationUtil.equals((Object)report.getReportDescription(), (Object)newReport.getReportDescription())) {
            newReport.setReportDescription(newReport.getReportAlias());
        }
        if ((interactionComp = (StiComponent)(renderedPage = renderedReport.getRenderedPages().get(pageIndex)).getComponents().get(componentIndex)) != null && interactionComp.getDrillDownParameters() != null) {
            for (String key : interactionComp.getDrillDownParameters().keySet()) {
                newReport.set(key, interactionComp.getDrillDownParameters().get(key));
            }
        }
        StiChart stiChart = interactionChart = interactionComp instanceof StiChart ? (StiChart)interactionComp : null;
        if (interactionChart != null) {
            StiSeriesElementGeom seriesElementGeom;
            BufferedImage bmp = new BufferedImage(10, 10, 1);
            StiGraphics gg = new StiGraphics((Graphics)bmp.createGraphics());
            StiContextPainter painter = new StiContextPainter(gg, 1.0, Double.valueOf(1.0));
            StiContext context = new StiContext((IStiContextPainter)painter, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), 1.0);
            StiRectangle rect = interactionChart.getReport().getUnit().ConvertToHInches(interactionChart.getClientRectangle());
            StiCellGeom chartGeom = interactionChart.getCore().Render(context, new StiRectangle(0.0, 0.0, rect.width, rect.height), true);
            List seriesGeomItems = chartGeom.getSeriesElementGeoms();
            StiSeriesElementGeom stiSeriesElementGeom = seriesElementGeom = seriesGeomItems.get(elementIndex) instanceof StiSeriesElementGeom ? (StiSeriesElementGeom)seriesGeomItems.get(elementIndex) : null;
            if (seriesElementGeom != null && seriesElementGeom.getInteraction() != null) {
                String arg2;
                newReport.set("Series", (Object)seriesElementGeom.getSeries().getCore());
                newReport.set("SeriesIndex", (Object)seriesElementGeom.getSeries().getCore().getSeries().getChart().getSeries().indexOf((Object)seriesElementGeom.getSeries().getCore().getSeries()));
                newReport.set("SeriesArgument", seriesElementGeom.getInteraction().getArgument());
                newReport.set("SeriesValue", (Object)seriesElementGeom.getInteraction().getValue());
                newReport.set("SeriesPointIndex", (Object)seriesElementGeom.getInteraction().getPointIndex());
                newReport.set("SeriesTag", seriesElementGeom.getInteraction().getTag());
                newReport.set("SeriesHyperlink", (Object)seriesElementGeom.getInteraction().getHyperlink());
                newReport.set("SeriesTooltip", (Object)seriesElementGeom.getInteraction().getTooltip());
                newReport.set("SeriesTitle", (Object)seriesElementGeom.getSeries().getCoreTitle());
                String arg1 = seriesElementGeom.getInteraction().getSeries() != null ? seriesElementGeom.getInteraction().getSeries().getCoreTitle() : null;
                String string = arg2 = seriesElementGeom.getInteraction().getArgument() != null ? String.valueOf(seriesElementGeom.getInteraction().getArgument()) : null;
                if (StiValidationUtil.isNullOrEmpty((String)arg2)) {
                    arg2 = String.valueOf(seriesElementGeom.getInteraction().getValue());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)arg1) && !StiValidationUtil.isNullOrEmpty((String)arg2)) {
                    newReport.setReportAlias(String.format("%s - %s", arg1, arg2));
                } else if (!StiValidationUtil.isNullOrEmpty((String)arg2)) {
                    newReport.setReportAlias(arg1);
                } else {
                    newReport.setReportAlias(arg2);
                }
            }
        }
        try {
            newReport.isInteractionRendering = true;
            newReport.Render(false);
        }
        finally {
            newReport.setInteractionRendering(false);
        }
        return newReport;
    }

    private static HashMap<String, Object> getDashboardPage(StiReport report, int pageIndex, StiRequestParams requestParams) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        return attributes;
    }

    private static HashMap<String, Object> getReportPage(StiReport report, StiHtmlExportService service, int pageIndex, StiRequestParams requestParams) throws StiException, IOException {
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        settings.setPageRange(new StiPagesRange(pageIndex));
        settings.setZoom(requestParams.viewer.zoom);
        settings.setImageFormat(StiImageFormat.Png);
        settings.setExportMode(StiHtmlExportMode.Table);
        settings.setExportQuality(StiHtmlExportQuality.High);
        settings.setExportBookmarksMode(StiHtmlExportBookmarksMode.ReportOnly);
        settings.setRemoveEmptySpaceAtBottom(false);
        settings.setOpenLinksTarget(requestParams.viewer.openLinksWindow);
        settings.setChartType(requestParams.viewer.chartRenderType);
        settings.setUseWatermarkMargins(true);
        switch (requestParams.viewer.reportDisplayMode) {
            case FromReport: {
                settings.setExportMode(StiReportHelper.getReportDisplayModeFromReport(report));
                break;
            }
            case Table: {
                settings.setExportMode(StiHtmlExportMode.Table);
                break;
            }
            case Div: {
                settings.setExportMode(StiHtmlExportMode.Div);
                break;
            }
            case Span: {
                settings.setExportMode(StiHtmlExportMode.Span);
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        service.exportHtmlWithoutEvents(report, (OutputStream)stream, settings);
        String htmlPageContent = new String(stream.toByteArray(), "UTF-8");
        stream.close();
        HashMap<String, Object> pageAttr = new HashMap<String, Object>();
        pageAttr.put("content", report.getRenderedPages().size() > 0 ? htmlPageContent : "");
        StiPage page = report.getRenderedPages().size() > 0 ? report.getRenderedPages().get(pageIndex) : new StiPage(report);
        pageAttr.put("margins", String.format("%spx %spx %spx %spx", Math.round(report.getUnit().ConvertToHInches(page.getMargins().getTop()) * requestParams.viewer.zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getRight()) * requestParams.viewer.zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getBottom()) * requestParams.viewer.zoom), Math.round(report.getUnit().ConvertToHInches(page.getMargins().getLeft()) * requestParams.viewer.zoom)));
        pageAttr.put("sizes", String.format("%s;%s", Math.round(report.getUnit().ConvertToHInches(page.getPageWidth() * (double)page.getSegmentPerWidth()) * requestParams.viewer.zoom), Math.round(report.getUnit().ConvertToHInches(page.getPageHeight() * (double)page.getSegmentPerHeight()) * requestParams.viewer.zoom)));
        pageAttr.put("brush", StiReportHelper.brushToStr(page.getBrush()));
        pageAttr.put("existsWatermark", (page.getWatermark().getImageBytes() != null || !StiValidationUtil.isNullOrEmpty((String)page.getWatermark().getImageHyperlink()) || !StiValidationUtil.isNullOrEmpty((String)page.getWatermark().getText())) && page.getWatermark().getEnabled());
        return pageAttr;
    }

    private static String brushToStr(StiBrush brush) {
        if (brush instanceof StiEmptyBrush) {
            return "0";
        }
        if (brush instanceof StiSolidBrush) {
            StiSolidBrush solid = (StiSolidBrush)brush;
            return String.format("1;%s", StiReportHelper.getHtmlColor(solid.getColor()));
        }
        if (brush instanceof StiHatchBrush) {
            StiHatchBrush hatch = (StiHatchBrush)brush;
            return String.format("2;%s;%s;%s", StiReportHelper.getHtmlColor(hatch.getForeColor()), StiReportHelper.getHtmlColor(hatch.getBackColor()), hatch.getStyle().getValue());
        }
        if (brush instanceof StiGradientBrush) {
            StiGradientBrush gradient = (StiGradientBrush)brush;
            return String.format("3;%s;%s;%s", StiReportHelper.getHtmlColor(gradient.getStartColor()), StiReportHelper.getHtmlColor(gradient.getEndColor()), gradient.angle);
        }
        if (brush instanceof StiGlareBrush) {
            StiGlareBrush glare = (StiGlareBrush)brush;
            return String.format("4;%s;%s;%s;%s;%s", StiReportHelper.getHtmlColor(glare.getStartColor()), StiReportHelper.getHtmlColor(glare.getEndColor()), glare.angle, Float.valueOf(glare.getFocus()), Float.valueOf(glare.getScale()));
        }
        if (brush instanceof StiGlassBrush) {
            StiGlassBrush glass = (StiGlassBrush)brush;
            return String.format("5;%s;%s;%s", StiReportHelper.getHtmlColor(glass.getColor()), Float.valueOf(glass.getBlend()), glass.getDrawHatch());
        }
        return "";
    }

    private static StiHtmlExportMode getReportDisplayModeFromReport(StiReport report) {
        return report.getHtmlPreviewMode() == StiHtmlPreviewMode.Div ? StiHtmlExportMode.Div : StiHtmlExportMode.Table;
    }

    private static void addBookmarkNode(StiBookmark bkm, int parentNode, ArrayList<StiBookmarkTreeNode> bookmarksTree) {
        String st;
        StiBookmarkTreeNode tn = new StiBookmarkTreeNode();
        tn.parent = parentNode;
        tn.title = st = bkm.text.replaceAll("'", "\\'").replaceAll("\r", "").replaceAll("\n", "");
        tn.url = "#" + st;
        tn.used = true;
        tn.componentGuid = bkm.getComponentGuid();
        bookmarksTree.add(tn);
        int currentNode = bookmarksTree.size() - 1;
        if (bkm.getBookmarks().size() != 0) {
            for (int tempCount = 0; tempCount < bkm.getBookmarks().size(); ++tempCount) {
                StiReportHelper.addBookmarkNode((StiBookmark)bkm.getBookmarks().get(tempCount), currentNode, bookmarksTree);
            }
        }
    }

    private static HashMap<String, Integer> getBookmarksPageIndexes(StiReport report, int tempPageNumber) {
        HashMap<String, Integer> bookmarksPageIndex = new HashMap<String, Integer>();
        for (StiPage page : report.getRenderedPages()) {
            report.getRenderedPages().GetPage(page);
            StiComponentsCollection components = page.GetComponents();
            for (StiComponent comp : components) {
                if (!comp.getEnabled()) continue;
                String bookmarkValue = comp.getBookmarkValue() instanceof String ? comp.getBookmarkValue() : null;
                String componentGuid = comp.getGuid();
                if (componentGuid != null && !bookmarksPageIndex.containsKey(componentGuid)) {
                    bookmarksPageIndex.put(componentGuid, tempPageNumber);
                }
                if (bookmarkValue == null) {
                    bookmarkValue = "";
                }
                if (!StiValidationUtil.isNotNullOrEmpty((String)(bookmarkValue = bookmarkValue.replaceAll("'", "\\'"))) || bookmarksPageIndex.containsKey(bookmarkValue)) continue;
                bookmarksPageIndex.put(bookmarkValue, tempPageNumber);
            }
            ++tempPageNumber;
        }
        return bookmarksPageIndex;
    }

    public static String getBookmarksContent(StiReport report, String viewerId, int pageNumber) {
        HashMap<String, Integer> bookmarksPageIndex = StiReportHelper.getBookmarksPageIndexes(report, 0);
        ArrayList<StiBookmarkTreeNode> bookmarksTree = new ArrayList<StiBookmarkTreeNode>();
        StiReportHelper.addBookmarkNode(report.getBookmark(), -1, bookmarksTree);
        String html = "";
        html = html + String.format("bookmarks = new stiTree('bookmarks','%s',%s, imagesForBookmarks);", viewerId, pageNumber);
        for (int index = 0; index < bookmarksTree.size(); ++index) {
            StiBookmarkTreeNode node = bookmarksTree.get(index);
            String pageTitle = "";
            pageTitle = node.componentGuid != null && bookmarksPageIndex.containsKey(node.componentGuid) ? String.format("Page %s", bookmarksPageIndex.get(node.componentGuid) + 1) : (bookmarksPageIndex.containsKey(node.title) ? String.format("Page %s", bookmarksPageIndex.get(node.title) + 1) : "Page 0");
            html = html + String.format("bookmarks.add(%s,%s,'%s','%s','%s','%s');", index, node.parent, StiReportHelper.escape(node.title), StiReportHelper.escape2(node.url), pageTitle, node.componentGuid);
        }
        return html;
    }

    public static ArrayList<HashMap<String, Object>> getBookmarkPointers(StiReport report, StiBookmark bookmark) {
        HashMap<String, Integer> bookmarksPageIndex = StiReportHelper.getBookmarksPageIndexes(report, 1);
        ArrayList<HashMap<String, Object>> pointers = new ArrayList<HashMap<String, Object>>();
        ArrayList<StiBookmarkTreeNode> bookmarksTree = new ArrayList<StiBookmarkTreeNode>();
        StiReportHelper.addBookmarkNode(bookmark, -1, bookmarksTree);
        for (int i = 0; i < bookmarksTree.size(); ++i) {
            HashMap<String, Object> bookmarkParams = new HashMap<String, Object>();
            StiBookmarkTreeNode node = bookmarksTree.get(i);
            int pageIndex = 0;
            if (node.componentGuid != null && bookmarksPageIndex.containsKey(node.componentGuid)) {
                pageIndex = bookmarksPageIndex.get(node.componentGuid);
            } else if (bookmarksPageIndex.containsKey(node.title)) {
                pageIndex = bookmarksPageIndex.get(node.title);
            }
            bookmarkParams.put("componentGuid", node.componentGuid);
            bookmarkParams.put("anchor", node.url);
            bookmarkParams.put("pageIndex", pageIndex);
            pointers.add(bookmarkParams);
        }
        return pointers;
    }

    public static String escape(String text) {
        return text.replaceAll("'", "&quot;").replace("\\", "&#92;");
    }

    public static String escape2(String text) {
        return text.replaceAll("'", "").replace("\\", "!!#92");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StiWebActionResult interactionResult(StiRequestParams requestParams, StiReport report, StiHttpServletRequest request) throws IOException, SAXException, StiDeserializationException, StiException {
        if (requestParams.action == StiAction.InitVars) {
            if (report == null || report.isDocument) {
                return new StiWebActionResult("null", "application/json");
            }
            report = StiReportHelper.getCompiledReport(report);
            StiVariablesHelper.applyReportBindingVariables(report, requestParams.interaction.variables);
            HashMap<String, HashMap<String, Object>> variables = StiVariablesHelper.getVariables(report, requestParams.interaction.variables);
            return new StiWebActionResult(variables != null ? new JSONObject(variables).toString() : "null", "application/json");
        }
        if (report == null) {
            return StiWebActionResult.emptyReportResult();
        }
        if (report.isDocument) {
            // empty if block
        }
        report = StiReportHelper.getCompiledReport(report);
        if (requestParams.interaction.drillDown != null && requestParams.interaction.drillDown.size() > 0) {
            report = StiReportHelper.createReportCopy(report);
        }
        StiReportHelper.applyQueryParameters(requestParams, report);
        if (requestParams.action == StiAction.RefreshReport) {
            report.setIsRendered(false);
        }
        if (requestParams.action == StiAction.Variables || requestParams.action == StiAction.Sorting || requestParams.action == StiAction.Collapsing) {
            StiVariablesHelper.applyReportParameters(report, requestParams.interaction.variables);
        }
        if (requestParams.action == StiAction.Sorting) {
            StiReportHelper.applySorting(report, requestParams.interaction.sorting);
        } else if (requestParams.action == StiAction.Collapsing) {
            StiReportHelper.applyCollapsing(report, requestParams.interaction.collapsing);
        }
        if (requestParams.interaction.drillDown != null && requestParams.interaction.drillDown.size() > 0) {
            StiReport renderedReport = requestParams.cache.helper.getReportInternal(requestParams, false, request);
            if (renderedReport == null) {
                renderedReport = report;
            }
            for (HashMap hashMap : requestParams.interaction.drillDown) {
                renderedReport = StiReportHelper.applyDrillDown(report, renderedReport, hashMap);
            }
            report = renderedReport;
        }
        if (!report.getIsRendered()) {
            try {
                report.getInfo().setForceDesigningMode(false);
                report.isReportRenderingAfterSubmit = true;
                report.Render(false);
                report.setPreviewDialogs(false);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel >= 10) {
                    e.printStackTrace();
                }
                StiWebActionResult stiWebActionResult = new StiWebActionResult("ServerError:" + e.getMessage());
                return stiWebActionResult;
            }
            finally {
                report.isReportRenderingAfterSubmit = false;
            }
        }
        requestParams.cache.helper.saveReportInternal(requestParams, report, request);
        return StiReportHelper.viewerResult(requestParams, report);
    }

    public static StiWebActionResult viewerResult(StiRequestParams requestParams, StiReport report) throws IOException, StiException {
        if (report == null) {
            return StiWebActionResult.emptyReportResult();
        }
        if (!report.getIsRendered() || report.getRenderedPages().size() == 0) {
            try {
                report.Render(false);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel >= 10) {
                    e.printStackTrace();
                }
                return new StiWebActionResult("ServerError:" + e.getMessage());
            }
        }
        StiEditableFieldsHelper.applyEditableFieldsToReport(report, requestParams.interaction.editable);
        if (requestParams.action == StiAction.DrillDown) {
            requestParams.viewer.pageNumber = 0;
        }
        if (requestParams.action == StiAction.Variables || requestParams.action == StiAction.Collapsing) {
            requestParams.viewer.pageNumber = Math.min(requestParams.viewer.pageNumber, report.getRenderedPages().size() - 1);
        }
        if (requestParams.viewer.reportType == StiReportType.Auto) {
            requestParams.viewer.reportType = StiReportType.Report;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("action", (Object)requestParams.action);
        parameters.put("parameterWidth", report.getParameterWidth());
        parameters.put("parameterAlignment", report.getParameterAlignment().toString());
        if (requestParams.action == StiAction.GetReport || requestParams.action == StiAction.OpenReport) {
            parameters.put("customFonts", StiReportResourceHelper.getFontResourcesArray(report));
            if (StiReportHelper.isReportHasDashboards(report)) {
                parameters.put("dashboards", StiReportHelper.getDashboards(report));
            }
        }
        if (requestParams.viewer.reportType == StiReportType.Report || requestParams.action != StiAction.GetReport && requestParams.action != StiAction.OpenReport) {
            parameters.put("pagesArray", StiReportHelper.getPagesArray(report, requestParams));
        }
        if (requestParams.action != StiAction.GetPages) {
            parameters.put("reportType", requestParams.viewer.reportType.toString());
            parameters.put("drillDownGuid", requestParams.cache.drillDownGuid);
            parameters.put("zoom", Math.round(requestParams.viewer.zoom * 100.0));
            parameters.put("viewMode", (Object)requestParams.viewer.viewMode);
            parameters.put("isEditableReport", StiEditableFieldsHelper.checkEditableReport(report));
            parameters.put("pagesCount", report.getRenderedPages().size());
            parameters.put("reportFileName", StiReportHelper.getReportFileName(report));
            parameters.put("refreshTime", report.isDocument ? 0 : report.getRefreshTime());
            parameters.put("parameterWidth", report.getParameterWidth());
            parameters.put("collapsingStates", report.getInteractionCollapsingStates());
            parameters.put("resources", StiReportResourceHelper.getResourcesItems(report));
            parameters.put("previewSettings", StiReportHelper.getReportPreviewSettings(report));
            parameters.put("tableOfContentsPointers", StiReportHelper.getTableOfContentsPointers(report, requestParams));
            parameters.put("exportSettings", StiExportsHelper.checkExistsReportExportSettings(report));
            if (requestParams.viewer.reportDisplayMode == StiReportDisplayMode.FromReport) {
                parameters.put("reportDisplayMode", StiReportHelper.getReportDisplayModeFromReport(report));
            }
            if (requestParams.action == StiAction.DrillDown) {
                parameters.put("drillDownParameters", requestParams.interaction.drillDown);
            }
            if (report.getBookmark() != null && report.getBookmark().getBookmarks().size() > 0 && requestParams.viewer.showBookmarks) {
                parameters.put("bookmarksContent", StiReportHelper.getBookmarksContent(report, requestParams.id, requestParams.viewer.viewMode == StiWebViewMode.SinglePage ? requestParams.viewer.pageNumber : -1));
            }
        }
        return new StiWebActionResult(new JSONObject(parameters).toString());
    }

    public static StiWebActionResult openReportResult(StiRequestParams requestParams, StiHttpServletRequest request) throws IOException, StiException {
        StiReport report = new StiReport();
        String fileName = requestParams.viewer.openingFileName;
        String password = requestParams.viewer.openingFilePassword;
        try {
            if (StiValidationUtil.isNullOrEmpty((String)password)) {
                if (fileName.toLowerCase().endsWith("mrt")) {
                    report = StiSerializeManager.deserializeReport((InputStream)StiIOUtil.toInputStream((String)new String(requestParams.data, "UTF-8")));
                    report.render();
                } else if (fileName.toLowerCase().endsWith("mrz")) {
                    byte[] unpacked = StiGZipHelper.unpack((byte[])requestParams.data);
                    report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
                    report.render();
                } else if (fileName.toLowerCase().endsWith("mdz")) {
                    byte[] unpacked = StiGZipHelper.unpack((byte[])requestParams.data);
                    report = StiSerializeManager.deserializeDocument((InputStream)new ByteArrayInputStream(unpacked)).getReport();
                } else {
                    report = StiSerializeManager.deserializeDocument((InputStream)StiIOUtil.toInputStream((String)new String(requestParams.data, "UTF-8"))).getReport();
                }
            } else {
                if (fileName.toLowerCase().endsWith("mrx") && ((char)requestParams.data[0] != 'm' || (char)requestParams.data[1] != 'r' || (char)requestParams.data[2] != 'x')) {
                    throw new Exception("This file is a not '.mrx' format.");
                }
                if (fileName.toLowerCase().endsWith("mdx") && ((char)requestParams.data[0] != 'm' || (char)requestParams.data[1] != 'd' || (char)requestParams.data[2] != 'x')) {
                    throw new Exception("This file is a not '.mdx' format.");
                }
                int[] dest = new int[requestParams.data.length - 3];
                for (int i = 3; i < requestParams.data.length; ++i) {
                    dest[i - 3] = requestParams.data[i] >= 0 ? requestParams.data[i] : 256 + requestParams.data[i];
                }
                dest = StiEncryption.decrypt((int[])dest, (String)password);
                try {
                    byte[] dest2 = new byte[dest.length];
                    for (int i = 0; i < dest.length; ++i) {
                        dest2[i] = (byte)dest[i];
                    }
                    byte[] unpacked = StiGZipHelper.unpack((byte[])dest2);
                    if (fileName.toLowerCase().endsWith("mrx")) {
                        report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
                        report.render();
                    } else {
                        report = StiSerializeManager.deserializeDocument((InputStream)new ByteArrayInputStream(unpacked)).getReport();
                    }
                }
                catch (Exception ee) {
                    if (StiOptions.Engine.logLevel >= 10) {
                        ee.printStackTrace();
                    }
                    throw new Exception("File decryption error: wrong key.");
                }
            }
            requestParams.cache.helper.saveReportInternal(requestParams, report, request);
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return new StiWebActionResult("ServerError:" + e.getMessage());
        }
        return StiReportHelper.viewerResult(requestParams, report);
    }

    public static ArrayList getTableOfContentsPointers(StiReport report, StiRequestParams requestParams) {
        ArrayList<Object> pointers = new ArrayList();
        StiTableOfContents tableOfContents = null;
        if (report != null) {
            for (StiComponent comp : report.GetComponents()) {
                if (!(comp instanceof StiTableOfContents)) continue;
                tableOfContents = (StiTableOfContents)comp;
            }
        }
        if (tableOfContents != null) {
            StiBookmark pointer = report.getPointer();
            if (StiValidationUtil.isNullOrWhiteSpace((String)tableOfContents.getReportPointer())) {
                pointers = StiReportHelper.getBookmarkPointers(report, pointer);
            } else {
                pointer.setText(StiReportParser.parse((String)tableOfContents.getReportPointer(), (StiComponent)tableOfContents, (boolean)true, null, (boolean)true, (boolean)false));
                pointer.setParentComponent((Object)report);
                pointers = StiReportHelper.getBookmarkPointers(report, pointer);
            }
        }
        return pointers;
    }

    public static HashMap<String, Object> getReportPreviewSettings(StiReport report) {
        HashMap<String, Object> settingsJsObject = new HashMap<String, Object>();
        long repSettings = report.getPreviewSettings();
        settingsJsObject.put("reportPrint", (repSettings & StiPreviewSettings.Print.getValue()) > 0L);
        settingsJsObject.put("reportOpen", (repSettings & StiPreviewSettings.Open.getValue()) > 0L);
        settingsJsObject.put("reportSave", (repSettings & StiPreviewSettings.Save.getValue()) > 0L);
        settingsJsObject.put("reportSendEMail", (repSettings & StiPreviewSettings.SendEMail.getValue()) > 0L);
        settingsJsObject.put("reportPageControl", (repSettings & StiPreviewSettings.PageControl.getValue()) > 0L);
        settingsJsObject.put("reportEditor", (repSettings & StiPreviewSettings.Editor.getValue()) > 0L);
        settingsJsObject.put("reportFind", (repSettings & StiPreviewSettings.Find.getValue()) > 0L);
        settingsJsObject.put("reportPageViewMode", (repSettings & StiPreviewSettings.PageViewMode.getValue()) > 0L);
        settingsJsObject.put("reportZoom", (repSettings & StiPreviewSettings.Zoom.getValue()) > 0L);
        settingsJsObject.put("reportBookmarks", (repSettings & StiPreviewSettings.Bookmarks.getValue()) > 0L);
        settingsJsObject.put("reportParameters", (repSettings & StiPreviewSettings.Parameters.getValue()) > 0L);
        settingsJsObject.put("reportResources", (repSettings & StiPreviewSettings.Resources.getValue()) > 0L);
        settingsJsObject.put("reportStatusBar", (repSettings & StiPreviewSettings.StatusBar.getValue()) > 0L);
        settingsJsObject.put("reportToolbar", (repSettings & StiPreviewSettings.Toolbar.getValue()) > 0L);
        settingsJsObject.put("reportToolbarHorAlignment", report.getPreviewToolBarOptions().getReportToolbarHorAlignment());
        settingsJsObject.put("reportToolbarReverse", report.getPreviewToolBarOptions().isReportToolbarReverse());
        return settingsJsObject;
    }
}

