/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.base.mail.StiMailSender;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.report.enums.StiHtmlPreviewMode;
import com.stimulsoft.report.enums.StiRangeType;
import com.stimulsoft.report.export.StiPdfComplianceMode;
import com.stimulsoft.report.export.StiPdfZUGFeRDComplianceMode;
import com.stimulsoft.report.export.service.StiBmpExportService;
import com.stimulsoft.report.export.service.StiCsvExportService;
import com.stimulsoft.report.export.service.StiExcel2007ExportService;
import com.stimulsoft.report.export.service.StiExcelExportService;
import com.stimulsoft.report.export.service.StiExcelXmlExportService;
import com.stimulsoft.report.export.service.StiHtml5ExportService;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.service.StiJpegExportService;
import com.stimulsoft.report.export.service.StiOdsExportService;
import com.stimulsoft.report.export.service.StiOdtExportService;
import com.stimulsoft.report.export.service.StiPcxExportService;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.service.StiPngExportService;
import com.stimulsoft.report.export.service.StiPpt2007ExportService;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.StiSvgzExportService;
import com.stimulsoft.report.export.service.StiSylkExportService;
import com.stimulsoft.report.export.service.StiTxtExportService;
import com.stimulsoft.report.export.service.StiWord2007ExportService;
import com.stimulsoft.report.export.service.StiXmlExportService;
import com.stimulsoft.report.export.service.StiXpsExportService;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExcelXmlExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiImageExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.settings.StiWordExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.report.export.tools.StiDataType;
import com.stimulsoft.report.export.tools.StiExcelType;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiImageType;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiPdfAllowEditable;
import com.stimulsoft.report.export.tools.StiPdfAutoPrintMode;
import com.stimulsoft.report.export.tools.StiRtfExportMode;
import com.stimulsoft.report.export.tools.StiTxtBorderType;
import com.stimulsoft.report.export.tools.StiUserAccessPrivileges;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.pdf.StiPdfEncryptionKeyLength;
import com.stimulsoft.report.export.tools.pdf.StiPdfImageCompressionMethod;
import com.stimulsoft.report.saveLoad.StiEncryptedDocumentSLService;
import com.stimulsoft.report.saveLoad.StiSLActions;
import com.stimulsoft.report.saveLoad.StiSLService;
import com.stimulsoft.web.classes.StiDefaultExportSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiDocumentType;
import com.stimulsoft.web.enums.StiPrintAction;
import com.stimulsoft.web.enums.StiReportType;
import com.stimulsoft.web.helper.StiEditableFieldsHelper;
import com.stimulsoft.web.helper.StiReportHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class StiExportsHelper {
    public static HashMap<String, Object> checkExistsReportExportSettings(StiReport report) {
        HashMap<String, Boolean> reportSettings = new HashMap<String, Boolean>();
        if (report.getExportSettings() != null) {
            for (StiExportSettings settings : report.getExportSettings()) {
                reportSettings.put(StiExportsHelper.getExportFormat(settings).toString(), true);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("report", reportSettings);
        result.put("dashboard", new HashMap());
        return result;
    }

    private static StiExportFormat getExportFormat(StiExportSettings settings) {
        if (settings instanceof StiDataExportSettings) {
            return StiExportFormat.Data;
        }
        if (settings instanceof StiImageExportSettings) {
            return StiExportFormat.Image;
        }
        return settings.getExportFormat();
    }

    public static String getReportFileContentType(StiRequestParams requestParams) {
        switch (requestParams.exportFormat) {
            case Document: {
                StiDocumentType type = StiExportsHelper.getExportDocumentType(requestParams);
                switch (type) {
                    case Mdc: {
                        return "text/xml";
                    }
                    case Mdz: {
                        return "application/zip";
                    }
                    case Mdx: {
                        return "application/octet-stream";
                    }
                }
                break;
            }
            case Pdf: {
                return "application/pdf";
            }
            case Xps: {
                return "application/vnd.ms-xpsdocument";
            }
            case PowerPoint: 
            case Ppt2007: {
                return "application/vnd.ms-powerpoint";
            }
            case Text: {
                return "text/plain";
            }
            case Rtf: {
                return "application/rtf";
            }
            case Word: 
            case Word2007: {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case Odt: {
                return "application/vnd.oasis.opendocument.text";
            }
            case Ods: {
                return "application/vnd.oasis.opendocument.spreadsheet";
            }
            case Html: 
            case Html5: {
                return "text/html";
            }
            case Mht: {
                return "message/rfc822";
            }
            case ExcelXml: {
                return "application/vnd.ms-excel";
            }
            case Excel: 
            case ExcelBiff: {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case Csv: {
                return "text/csv";
            }
            case Dbf: {
                return "application/dbf";
            }
            case Xml: {
                return "application/xml";
            }
            case Dif: {
                return "video/x-dv";
            }
            case Sylk: {
                return "application/excel";
            }
            case ImageBmp: {
                return "image/bmp";
            }
            case ImageGif: {
                return "image/gif";
            }
            case ImageJpeg: {
                return "image/jpeg";
            }
            case ImagePcx: {
                return "image/x-pcx";
            }
            case ImagePng: {
                return "image/png";
            }
            case ImageTiff: {
                return "image/tiff";
            }
            case ImageEmf: {
                return "image/x-emf";
            }
            case ImageSvg: 
            case ImageSvgz: {
                return "image/svg+xml";
            }
        }
        return "text/plain";
    }

    public static String getReportFileName(StiRequestParams requestParams, StiReport report) {
        String fileName = StiReportHelper.getReportFileName(report) + ".";
        switch (requestParams.exportFormat) {
            case Document: {
                return fileName + StiExportsHelper.getExportDocumentType(requestParams).toString().toLowerCase();
            }
            case ExcelBiff: {
                return fileName + "xls";
            }
            case Excel: 
            case Excel2007: {
                return fileName + "xlsx";
            }
            case ExcelXml: {
                return fileName + "xml.xls";
            }
            case PowerPoint: 
            case Ppt2007: {
                return fileName + "ppt";
            }
            case Text: {
                return fileName + "txt";
            }
            case Word: 
            case Word2007: {
                return fileName + "docx";
            }
        }
        return fileName + requestParams.exportFormat.toString().toLowerCase().replaceAll("image", "");
    }

    private static StiDocumentType getExportDocumentType(StiRequestParams requestParams) {
        String format;
        String string = format = requestParams.exportSettings.containsKey("Format") ? String.valueOf(requestParams.exportSettings.get("Format")).toLowerCase() : null;
        if ("mdc".equals(format)) {
            return StiDocumentType.Mdc;
        }
        if ("mdz".equals(format)) {
            return StiDocumentType.Mdz;
        }
        if ("mdx".equals(format)) {
            return StiDocumentType.Mdx;
        }
        return StiDocumentType.Mdc;
    }

    public static StiExportSettings getExportSettings(StiRequestParams requestParams, StiReport report) {
        if (requestParams.action == StiAction.PrintReport) {
            if (requestParams.viewer.printAction == StiPrintAction.PrintPdf) {
                return new StiPdfExportSettings();
            }
            return new StiHtmlExportSettings();
        }
        switch (requestParams.exportFormat) {
            case Pdf: {
                return StiExportsHelper.getPdfExportSettings(requestParams.exportSettings, report);
            }
            case Xps: {
                return StiExportsHelper.getXpsExportSettings(requestParams.exportSettings, report);
            }
            case PowerPoint: 
            case Ppt2007: {
                return StiExportsHelper.getPpt2007ExportSettings(requestParams.exportSettings, report);
            }
            case Text: {
                return StiExportsHelper.getTextExportSettings(requestParams.exportSettings, report);
            }
            case Rtf: {
                return StiExportsHelper.getRtfExportSettings(requestParams.exportSettings, report);
            }
            case Word: 
            case Word2007: {
                return StiExportsHelper.getWord2007ExportSettings(requestParams.exportSettings, report);
            }
            case Odt: {
                return StiExportsHelper.getOdtExportSettings(requestParams.exportSettings, report);
            }
            case Ods: {
                return StiExportsHelper.getOdsExportSettings(requestParams.exportSettings, report);
            }
            case Html: 
            case Html5: 
            case Mht: {
                return StiExportsHelper.getHtmlExportSettings(requestParams.exportSettings, report);
            }
            case Excel: 
            case ExcelBiff: 
            case Excel2007: {
                return StiExportsHelper.getExcelExportSettings(requestParams.exportSettings, report);
            }
            case ExcelXml: {
                return StiExportsHelper.getExcelXmlExportSettings(requestParams.exportSettings, report);
            }
            case Csv: 
            case Dbf: 
            case Xml: 
            case Dif: 
            case Sylk: {
                return StiExportsHelper.getDataExportSettings(requestParams.exportSettings, report);
            }
            case ImageBmp: 
            case ImageGif: 
            case ImageJpeg: 
            case ImagePcx: 
            case ImagePng: 
            case ImageTiff: 
            case ImageEmf: 
            case ImageSvg: 
            case ImageSvgz: {
                return StiExportsHelper.getImageExportSettings(requestParams.exportSettings, report);
            }
        }
        return null;
    }

    public static HashMap<String, HashMap<String, Object>> getDefaultExportSettings(StiDefaultExportSettings exportSettings) {
        StiExportSettings[] defaultSettingsObjects = new StiExportSettings[]{exportSettings.exportToPdf, exportSettings.exportToXps, exportSettings.exportToPowerPoint, exportSettings.exportToHtml, exportSettings.exportToText, exportSettings.exportToRtf, exportSettings.exportToWord, exportSettings.exportToOdt, exportSettings.exportToOds, exportSettings.exportToExcel, exportSettings.exportToData, exportSettings.exportToImage};
        HashMap<String, HashMap<String, Object>> defaultSettings = new HashMap<String, HashMap<String, Object>>();
        for (StiExportSettings settings : defaultSettingsObjects) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Class<?> type = settings.getClass();
            for (Method property : type.getMethods()) {
                if (property.getTypeParameters().length != 0 || !property.getName().startsWith("get") && !property.getName().startsWith("is") || property.getName().equals("getCompanyString") || property.getName().equals("getLastModifiedString")) continue;
                try {
                    Object value = property.invoke((Object)settings, new Object[0]);
                    if (value instanceof StiPagesRange) {
                        Object object = ((StiPagesRange)value).getRangeType() == StiRangeType.CurrentPage ? ((StiPagesRange)value).getCurrentPage().toString() : (value = ((StiPagesRange)value).getRangeType() == StiRangeType.Pages ? ((StiPagesRange)value).getPageRanges() : ((StiPagesRange)value).getRangeType().toString());
                    }
                    if (value instanceof Charset) {
                        value = ((Charset)value).name();
                    }
                    if (value instanceof StiImageFormat) {
                        value = ((StiImageFormat)value).toString();
                    }
                    values.put(property.getName().substring(property.getName().startsWith("get") ? 3 : 2), value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String className = settings.getClass().getName().substring(settings.getClass().getName().lastIndexOf(".") + 1);
            defaultSettings.put(className, values);
            if ("StiWordExportSettings".equals(className)) {
                defaultSettings.put("StiWord2007ExportSettings", values);
                continue;
            }
            if (!"StiPowerPointExportSettings".equals(className)) continue;
            defaultSettings.put("StiPpt2007ExportSettings", values);
        }
        return defaultSettings;
    }

    private static StiPdfExportSettings getPdfExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiPdfExportSettings defSettings;
        StiPdfExportSettings stiPdfExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiPdfExportSettings)report.getExportSettings().findExportSettings(StiPdfExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiPdfExportSettings settings = new StiPdfExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("EmbeddedFonts")) {
                settings.setEmbeddedFonts(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("StandardPdfFonts")) {
                settings.setStandardPdfFonts(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("Compressed")) continue;
            if (node.equals("ExportRtfTextAsImage")) {
                settings.setExportRtfTextAsImage(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("PasswordInputUser")) {
                settings.setPasswordInputUser(value);
                continue;
            }
            if (node.equals("PasswordInputOwner")) {
                settings.setPasswordInputOwner(value);
                continue;
            }
            if (node.equals("UserAccessPrivileges")) {
                settings.setUserAccessPrivileges(StiUserAccessPrivileges.parse((String)value));
                continue;
            }
            if (node.equals("KeyLength")) {
                settings.setKeyLength(StiPdfEncryptionKeyLength.valueOf((String)value));
                continue;
            }
            if (node.equals("UseUnicode")) {
                settings.setUseUnicode(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("UseDigitalSignature") || node.equals("GetCertificateFromCryptoUI") || node.equals("SubjectNameString") || node.equals("UseLocalMachineCertificates") || node.equals("CreatorString") || node.equals("KeywordsString")) continue;
            if (node.equals("ImageCompressionMethod")) {
                settings.setImageCompressionMethod(StiPdfImageCompressionMethod.valueOf((String)value));
                continue;
            }
            if (node.equals("ImageFormat")) {
                settings.setImageFormat(StiColorImageFormat.valueOf((String)value));
                continue;
            }
            if (node.equals("DitheringType")) {
                settings.setDitheringType(StiMonochromeDitheringType.valueOf((String)value));
                continue;
            }
            if (node.equals("PdfComplianceMode")) {
                settings.setPdfComplianceMode(StiPdfComplianceMode.valueOf((String)value));
                continue;
            }
            if (node.equals("AutoPrintMode")) {
                settings.setAutoPrintMode(StiPdfAutoPrintMode.valueOf((String)value));
                continue;
            }
            if (node.equals("AllowEditable")) {
                settings.setAllowEditable(StiPdfAllowEditable.valueOf((String)value));
                continue;
            }
            if (node.equals("ZUGFeRDComplianceMode")) {
                settings.setZUGFeRDComplianceMode(StiPdfZUGFeRDComplianceMode.valueOf((String)value));
                continue;
            }
            if (node.equals("ZUGFeRDConformanceLevel")) {
                settings.setZUGFeRDConformanceLevel(value);
                continue;
            }
            if (!node.equals("PdfACompliance")) continue;
            settings.setPdfComplianceMode(Func.Convert.toBoolean((Object)value) ? (jsSettings.get("PdfComplianceMode") != null ? StiPdfComplianceMode.valueOf((String)jsSettings.get("PdfComplianceMode").toString()) : StiPdfComplianceMode.A1) : StiPdfComplianceMode.None);
        }
        return settings;
    }

    private static StiXpsExportSettings getXpsExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiXpsExportSettings defSettings;
        StiXpsExportSettings stiXpsExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiXpsExportSettings)report.getExportSettings().findExportSettings(StiXpsExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiXpsExportSettings settings = new StiXpsExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (!node.equals("ExportRtfTextAsImage")) continue;
            settings.setExportRtfTextAsImage(Boolean.valueOf(value).booleanValue());
        }
        return settings;
    }

    private static StiPowerPointExportSettings getPpt2007ExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiPowerPointExportSettings defSettings;
        StiPowerPointExportSettings stiPowerPointExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiPowerPointExportSettings)report.getExportSettings().findExportSettings(StiPowerPointExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiPowerPointExportSettings settings = new StiPowerPointExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (!node.equals("ImageQuality")) continue;
            settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
        }
        return settings;
    }

    private static StiHtmlExportSettings getHtmlExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiHtmlExportSettings defSettings;
        StiHtmlExportSettings stiHtmlExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiHtmlExportSettings)report.getExportSettings().findExportSettings(StiHtmlExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("Encoding")) {
                settings.setEncoding(Charset.forName(value));
                continue;
            }
            if (node.equals("Zoom")) {
                settings.setZoom(StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ExportMode")) {
                settings.setExportMode(StiHtmlExportMode.valueOf((String)value));
                continue;
            }
            if (node.equals("ExportQuality")) {
                settings.setExportQuality(StiHtmlExportQuality.valueOf((String)value));
                continue;
            }
            if (node.equals("AddPageBreaks")) {
                settings.setAddPageBreaks(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("BookmarksTreeWidth")) {
                settings.setBookmarksTreeWidth(Integer.valueOf(value).intValue());
                continue;
            }
            if (node.equals("ExportBookmarksMode")) {
                settings.setExportBookmarksMode(StiHtmlExportBookmarksMode.valueOf((String)value));
                continue;
            }
            if (node.equals("UseStylesTable")) {
                settings.setUseStylesTable(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("RemoveEmptySpaceAtBottom")) {
                settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("PageHorAlignment")) {
                settings.setPageHorAlignment(StiHorAlignment.valueOf((String)value));
                continue;
            }
            if (!node.equals("ImageFormat")) continue;
            if (value.equals("Bmp")) {
                settings.setImageFormat(StiImageFormat.Bmp);
                continue;
            }
            if (value.equals("Emf")) {
                settings.setImageFormat(StiImageFormat.Emf);
                continue;
            }
            if (value.equals("Gif")) {
                settings.setImageFormat(StiImageFormat.Gif);
                continue;
            }
            if (value.equals("Jpeg")) {
                settings.setImageFormat(StiImageFormat.Jpeg);
                continue;
            }
            if (value.equals("Png")) {
                settings.setImageFormat(StiImageFormat.Png);
                continue;
            }
            if (!value.equals("Tiff")) continue;
            settings.setImageFormat(StiImageFormat.Tiff);
        }
        return settings;
    }

    private static StiTxtExportSettings getTextExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiTxtExportSettings defSettings;
        StiTxtExportSettings stiTxtExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiTxtExportSettings)report.getExportSettings().findExportSettings(StiTxtExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiTxtExportSettings settings = new StiTxtExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("Encoding")) {
                settings.setEncoding(Charset.forName(value));
                continue;
            }
            if (node.equals("DrawBorder")) {
                settings.setDrawBorder(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("BorderType")) {
                settings.setBorderType(StiTxtBorderType.valueOf((String)value));
                continue;
            }
            if (node.equals("KillSpaceLines")) {
                settings.setKillSpaceLines(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("KillSpaceGraphLines")) {
                settings.setKillSpaceGraphLines(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("PutFeedPageCode")) {
                settings.setPutFeedPageCode(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("CutLongLines")) {
                settings.setCutLongLines(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ZoomX")) {
                settings.setZoomX((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ZoomY")) {
                settings.setZoomY((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("UseEscapeCodes")) {
                settings.setUseEscapeCodes(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (!node.equals("EscapeCodesCollectionName")) continue;
            settings.setEscapeCodesCollectionName(value);
        }
        return settings;
    }

    private static StiRtfExportSettings getRtfExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiRtfExportSettings defSettings;
        StiRtfExportSettings stiRtfExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiRtfExportSettings)report.getExportSettings().findExportSettings(StiRtfExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiRtfExportSettings settings = new StiRtfExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("CodePage")) {
                settings.setCodePage(Integer.valueOf(value).intValue());
                continue;
            }
            if (node.equals("ExportMode")) {
                settings.setExportMode(StiRtfExportMode.valueOf((String)value));
                continue;
            }
            if (node.equals("UsePageHeadersAndFooters")) {
                settings.setUsePageHeadersAndFooters(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("RemoveEmptySpaceAtBottom")) {
                settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (!node.equals("StoreImagesAsPng")) continue;
            settings.setStoreImagesAsPng(Boolean.valueOf(value).booleanValue());
        }
        return settings;
    }

    private static StiWordExportSettings getWord2007ExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiWordExportSettings defSettings;
        StiWordExportSettings stiWordExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiWordExportSettings)report.getExportSettings().findExportSettings(StiWordExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiWordExportSettings settings = new StiWordExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("UsePageHeadersAndFooters")) {
                settings.setUsePageHeadersAndFooters(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("RemoveEmptySpaceAtBottom")) {
                settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("CompanyString")) {
                settings.setCompanyString(value);
                continue;
            }
            if (!node.equals("LastModifiedString")) continue;
            settings.setLastModifiedString(value);
        }
        return settings;
    }

    private static StiOdtExportSettings getOdtExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiOdtExportSettings defSettings;
        StiOdtExportSettings stiOdtExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiOdtExportSettings)report.getExportSettings().findExportSettings(StiOdtExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiOdtExportSettings settings = new StiOdtExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("UsePageHeadersAndFooters")) {
                settings.setUsePageHeadersAndFooters(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (!node.equals("RemoveEmptySpaceAtBottom")) continue;
            settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(value).booleanValue());
        }
        return settings;
    }

    private static StiExcelExportSettings getExcelExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiExcelExportSettings defSettings;
        StiExcelExportSettings stiExcelExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiExcelExportSettings)report.getExportSettings().findExportSettings(StiExcelExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiExcelExportSettings settings = new StiExcelExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ExcelType")) {
                settings.setExcelType(StiExcelType.valueOf((String)value));
                continue;
            }
            if (node.equals("UseOnePageHeaderAndFooter")) {
                settings.setUseOnePageHeaderAndFooter(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportDataOnly")) {
                settings.setExportDataOnly(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportPageBreaks")) {
                settings.setExportPageBreaks(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportObjectFormatting")) {
                settings.setExportObjectFormatting(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportEachPageToSheet")) {
                settings.setExportEachPageToSheet(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("CompanyString")) {
                settings.setCompanyString(value);
                continue;
            }
            if (!node.equals("LastModifiedString")) continue;
            settings.setLastModifiedString(value);
        }
        return settings;
    }

    private static StiExcelXmlExportSettings getExcelXmlExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiExcelXmlExportSettings defSettings;
        StiExcelXmlExportSettings stiExcelXmlExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiExcelXmlExportSettings)report.getExportSettings().findExportSettings(StiExcelXmlExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiExcelXmlExportSettings settings = new StiExcelXmlExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ExcelType")) {
                settings.setExcelType(StiExcelType.valueOf((String)value));
                continue;
            }
            if (node.equals("UseOnePageHeaderAndFooter")) {
                settings.setUseOnePageHeaderAndFooter(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportDataOnly")) {
                settings.setExportDataOnly(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportPageBreaks")) {
                settings.setExportPageBreaks(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportObjectFormatting")) {
                settings.setExportObjectFormatting(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ExportEachPageToSheet")) {
                settings.setExportEachPageToSheet(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("CompanyString")) {
                settings.setCompanyString(value);
                continue;
            }
            if (!node.equals("LastModifiedString")) continue;
            settings.setLastModifiedString(value);
        }
        return settings;
    }

    private static StiOdsExportSettings getOdsExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiOdsExportSettings defSettings;
        StiOdsExportSettings stiOdsExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiOdsExportSettings)report.getExportSettings().findExportSettings(StiOdsExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiOdsExportSettings settings = new StiOdsExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ImageQuality")) {
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (!node.equals("ImageResolution")) continue;
            settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)value));
        }
        return settings;
    }

    private static StiDataExportSettings getDataExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiDataExportSettings defSettings;
        StiDataExportSettings stiDataExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiDataExportSettings)report.getExportSettings().findExportSettings(StiDataExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiDataExportSettings settings = new StiDataExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("DataType")) {
                settings.setDataType(StiDataType.valueOf((String)value));
                continue;
            }
            if (node.equals("DataExportMode")) {
                settings.setDataExportMode(StiDataExportMode.valueOf((String)value));
                continue;
            }
            if (node.equals("Encoding")) {
                settings.setEncoding(Charset.forName(value));
                continue;
            }
            if (node.equals("ExportDataOnly")) {
                settings.setExportDataOnly(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("Separator")) {
                settings.setSeparator(value);
                continue;
            }
            if (node.equals("SkipColumnHeaders")) {
                settings.setSkipColumnHeaders(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (!node.equals("UseDefaultSystemEncoding")) continue;
            settings.setUseDefaultSystemEncoding(Boolean.valueOf(value).booleanValue());
        }
        return settings;
    }

    private static StiImageExportSettings getImageExportSettings(HashMap<String, String> jsSettings, StiReport report) {
        StiImageExportSettings defSettings;
        StiImageExportSettings stiImageExportSettings = defSettings = report != null && report.getExportSettings() != null ? (StiImageExportSettings)report.getExportSettings().findExportSettings(StiImageExportSettings.class) : null;
        if (defSettings != null) {
            return defSettings;
        }
        StiImageExportSettings settings = new StiImageExportSettings();
        for (String key : jsSettings.keySet()) {
            String value = String.valueOf(jsSettings.get(key));
            String node = key;
            if (node.equals("PageRange") || node.equals("PagesRange")) {
                settings.setPageRange(new StiPagesRange(value));
                continue;
            }
            if (node.equals("ImageType")) {
                settings.setImageType(StiImageType.valueOf((String)value));
                continue;
            }
            if (node.equals("ImageZoom")) {
                settings.setImageZoom(StiObjectConverter.ConvertToDouble((Object)value));
                continue;
            }
            if (node.equals("ImageResolution")) {
                settings.setImageResolution(Integer.valueOf(value).intValue());
                continue;
            }
            if (node.equals("CutEdges")) {
                settings.setCutEdges(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("ImageFormat")) {
                settings.setImageFormat(StiColorImageFormat.valueOf((String)value));
                continue;
            }
            if (node.equals("MultipleFiles")) {
                settings.setMultipleFiles(Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (node.equals("DitheringType")) {
                settings.setDitheringType(StiMonochromeDitheringType.valueOf((String)value));
                continue;
            }
            if (!node.equals("TiffCompressionScheme")) continue;
        }
        return settings;
    }

    public static ByteArrayOutputStream exportReport(StiRequestParams requestParams, StiReport report, StiExportSettings settings) throws StiException, NoSuchAlgorithmException, IOException {
        StiEditableFieldsHelper.applyEditableFieldsToReport(report, requestParams.interaction.editable);
        StiPdfExportService service = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        switch (requestParams.exportFormat) {
            case Document: {
                StiDocumentType documentType = StiExportsHelper.getExportDocumentType(requestParams);
                StiSLService service2 = null;
                switch (documentType) {
                    case Mdc: {
                        service2 = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(0);
                        break;
                    }
                    case Mdz: {
                        service2 = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(1);
                        break;
                    }
                    case Mdx: {
                        String password = requestParams.exportSettings.containsKey("SaveReportPassword") ? String.valueOf(requestParams.exportSettings.get("SaveReportPassword")) : "";
                        service2 = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(2);
                        ((StiEncryptedDocumentSLService)service2).setKey(password);
                    }
                }
                service2.save(report, (OutputStream)stream);
                return stream;
            }
            case Pdf: {
                service = new StiPdfExportService();
                break;
            }
            case Xps: {
                service = new StiXpsExportService();
                break;
            }
            case PowerPoint: 
            case Ppt2007: {
                service = new StiPpt2007ExportService();
                break;
            }
            case Html: {
                service = new StiHtmlExportService();
                break;
            }
            case Html5: {
                service = new StiHtml5ExportService();
                break;
            }
            case Mht: {
                break;
            }
            case Text: {
                service = new StiTxtExportService();
                break;
            }
            case Rtf: {
                service = new StiRtfExportService();
                break;
            }
            case Word: 
            case Word2007: {
                service = new StiWord2007ExportService();
                break;
            }
            case Odt: {
                service = new StiOdtExportService();
                break;
            }
            case Excel: 
            case Excel2007: {
                service = new StiExcel2007ExportService();
                break;
            }
            case ExcelXml: {
                service = new StiExcelXmlExportService();
                break;
            }
            case ExcelBiff: {
                service = new StiExcelExportService();
                break;
            }
            case Ods: {
                service = new StiOdsExportService();
                break;
            }
            case Csv: {
                service = new StiCsvExportService();
                break;
            }
            case Xml: {
                service = new StiXmlExportService();
                break;
            }
            case Sylk: {
                service = new StiSylkExportService();
                break;
            }
            case ImageBmp: {
                service = new StiBmpExportService();
                break;
            }
            case ImageJpeg: {
                service = new StiJpegExportService();
                break;
            }
            case ImagePcx: {
                service = new StiPcxExportService();
                break;
            }
            case ImagePng: {
                service = new StiPngExportService();
                break;
            }
            case ImageSvg: {
                service = new StiSvgExportService();
                break;
            }
            case ImageSvgz: {
                service = new StiSvgzExportService();
            }
        }
        if (service != null) {
            service.export(report, (OutputStream)stream, settings);
        }
        return stream;
    }

    public static StiWebActionResult exportReportResult(StiRequestParams requestParams, StiReport report, StiExportSettings settings) throws NoSuchAlgorithmException, StiException, IOException {
        boolean openAfterExport;
        if (report == null) {
            return StiWebActionResult.emptyReportResult();
        }
        if (requestParams.viewer.reportType == StiReportType.Report && !report.getIsRendered()) {
            try {
                report.Render(false);
            }
            catch (Exception e) {
                return new StiWebActionResult("ServerError:" + e.getMessage());
            }
        }
        ByteArrayOutputStream stream = StiExportsHelper.exportReport(requestParams, report, settings);
        String contentType = StiExportsHelper.getReportFileContentType(requestParams);
        boolean bl = openAfterExport = requestParams.exportSettings.containsKey("OpenAfterExport") ? Boolean.parseBoolean(String.valueOf(requestParams.exportSettings.get("OpenAfterExport"))) : false;
        if (requestParams.exportFormat != StiExportFormat.Pdf && requestParams.exportFormat != StiExportFormat.Html && requestParams.exportFormat != StiExportFormat.Html5) {
            openAfterExport = false;
        }
        String fileName = StiExportsHelper.getReportFileName(requestParams, report);
        return new StiWebActionResult(stream, fileName, contentType, !openAfterExport);
    }

    public static StiWebActionResult printReportResult(StiRequestParams requestParams, StiReport report, StiExportSettings settings) throws StiException, IOException {
        if (report == null) {
            return StiWebActionResult.emptyReportResult();
        }
        if (!report.getIsRendered()) {
            try {
                report.Render(false);
            }
            catch (Exception e) {
                return new StiWebActionResult("ServerError:" + e.getMessage());
            }
        }
        StiEditableFieldsHelper.applyEditableFieldsToReport(report, requestParams.interaction.editable);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (requestParams.viewer.printAction == StiPrintAction.PrintPdf) {
            StiPdfExportSettings pdfSettings = (StiPdfExportSettings)settings;
            pdfSettings.setAutoPrintMode(StiPdfAutoPrintMode.Dialog);
            StiPdfExportService pdfService = new StiPdfExportService();
            report.setIsPrinting(true);
            pdfService.exportPdf(report, (OutputStream)stream, pdfSettings);
            report.setIsPrinting(false);
            return new StiWebActionResult(stream, "file.pdf", "application/pdf");
        }
        StiHtmlExportSettings htmlSettings = (StiHtmlExportSettings)settings;
        htmlSettings.setAddPageBreaks(true);
        htmlSettings.setChartType(requestParams.viewer.chartRenderType == StiHtmlChartType.Image ? StiHtmlChartType.Image : StiHtmlChartType.Vector);
        if (requestParams.viewer.bookmarksPrint) {
            htmlSettings.setExportBookmarksMode(StiHtmlExportBookmarksMode.All);
        } else {
            htmlSettings.setExportBookmarksMode(StiHtmlExportBookmarksMode.ReportOnly);
        }
        switch (requestParams.viewer.reportDisplayMode) {
            case FromReport: {
                htmlSettings.setExportMode(report.getHtmlPreviewMode() == StiHtmlPreviewMode.Div ? StiHtmlExportMode.Div : StiHtmlExportMode.Table);
                break;
            }
            case Table: {
                htmlSettings.setExportMode(StiHtmlExportMode.Table);
                break;
            }
            case Div: {
                htmlSettings.setExportMode(StiHtmlExportMode.Div);
                break;
            }
            case Span: {
                htmlSettings.setExportMode(StiHtmlExportMode.Span);
            }
        }
        StiHtmlExportService htmlService = new StiHtmlExportService();
        report.setIsPrinting(true);
        htmlService.exportHtmlWithoutEvents(report, (OutputStream)stream, htmlSettings);
        report.setIsPrinting(false);
        StringBuffer htmlText = new StringBuffer(new String(stream.toByteArray(), "UTF-8"));
        stream.close();
        htmlText = htmlText.insert(htmlText.indexOf("></meta>") + 8, "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"></meta>");
        return new StiWebActionResult(htmlText.toString(), "text/html", "file.html");
    }

    public static StiWebActionResult emailReportResult(StiRequestParams requestParams, StiReport report, StiExportSettings settings, StiMailProperties options, StiHttpServletRequest request) throws NoSuchAlgorithmException, IOException, StiException {
        if (options == null) {
            return new StiWebActionResult("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SendEmail><ErrorCode>An error occurred while sending Email.</ErrorCode><ErrorDescription>StiEmailOptions object is empty.</ErrorDescription></SendEmail>");
        }
        if (report == null) {
            return StiWebActionResult.emptyReportResult();
        }
        if (!report.getIsRendered()) {
            try {
                report.Render(false);
            }
            catch (Exception e) {
                return new StiWebActionResult("ServerError:" + e.getMessage());
            }
        }
        ByteArrayOutputStream stream = StiExportsHelper.emailReport(requestParams, report, settings, options, request);
        return new StiWebActionResult(stream, "", "text/plain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream emailReport(StiRequestParams requestParams, StiReport report, StiExportSettings settings, StiMailProperties options, StiHttpServletRequest request) throws IOException, NoSuchAlgorithmException, StiException {
        if (StiValidationUtil.isNullOrEmpty((String)(options = options.clone()).getRecipients()) || StiValidationUtil.isNullOrEmpty((String)options.getSubject()) || StiValidationUtil.isNullOrEmpty((String)options.getBody())) {
            if (StiValidationUtil.isNullOrEmpty((String)options.getRecipients())) {
                options.setRecipients(requestParams.exportSettings.get("Email"));
            }
            if (StiValidationUtil.isNullOrEmpty((String)options.getSubject())) {
                options.setSubject(requestParams.exportSettings.get("Subject"));
            }
            if (StiValidationUtil.isNullOrEmpty((String)options.getBody())) {
                options.setBody(requestParams.exportSettings.get("Message"));
            }
        }
        String attachmentName = StiExportsHelper.getReportFileName(requestParams, report);
        ByteArrayOutputStream stream = StiExportsHelper.exportReport(requestParams, report, settings);
        if (StiValidationUtil.isNullOrEmpty((String)options.getBody())) {
            options.setBody(String.format("This Email contains the '$s' report file.", attachmentName));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(stream.toByteArray());
        StiMailProperties stiMailProperties = options;
        stiMailProperties.getClass();
        StiMailProperties.StiStreamAttachment sa = new StiMailProperties.StiStreamAttachment(stiMailProperties, (InputStream)bis, attachmentName);
        options.getStreamAttachments().add(sa);
        String result = "0";
        try {
            StiMailSender.sendMail((StiMailProperties)options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
        }
        finally {
            stream = new ByteArrayOutputStream();
            StiIOUtil.write((String)result, (OutputStream)stream);
        }
        return stream;
    }
}

