/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.viewer.StiPreviewSettings;
import java.util.HashMap;
import java.util.logging.Logger;

public class StiEditableFieldsHelper {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.webviewer.helper.StiEditableFieldsHelper");

    public static boolean checkEditableReport(StiReport report) {
        if ((report.getPreviewSettings() & StiPreviewSettings.Editor.getValue()) == 0L) {
            return false;
        }
        StiComponentsCollection components = report.GetRenderedComponents();
        for (StiComponent component : components) {
            if (component instanceof StiText && ((StiText)component).getEditable()) {
                return true;
            }
            if (component instanceof StiCheckBox && ((StiCheckBox)component).getEditable()) {
                return true;
            }
            if (!(component instanceof StiRichText) || !((StiRichText)component).getEditable()) continue;
            return true;
        }
        return false;
    }

    public static void applyEditableFieldsToReport(StiReport report, Object parameters) {
        if (parameters == null) {
            return;
        }
        try {
            HashMap allPagesParams = (HashMap)parameters;
            for (Object key : allPagesParams.keySet()) {
                int pageIndex = 0;
                try {
                    pageIndex = Integer.parseInt(key.toString());
                }
                catch (Exception e) {
                    if (report != null) {
                        report.WriteToReportRenderingMessages(StiValidationUtil.isNotNullOrEmpty((String)e.getMessage()) ? e.getMessage() : e.getStackTrace()[0].toString());
                    }
                    LOG.info(e.getMessage());
                    continue;
                }
                HashMap allComponetsParams = (HashMap)allPagesParams.get(key);
                for (Object key2 : allComponetsParams.keySet()) {
                    StiPage page;
                    int compIndex = Integer.parseInt(key2.toString());
                    HashMap compParams = (HashMap)allComponetsParams.get(key2);
                    if (pageIndex >= report.getRenderedPages().size() || compIndex >= (page = report.getRenderedPages().get(pageIndex)).getComponents().size()) continue;
                    StiComponent component = (StiComponent)page.getComponents().get(compIndex);
                    if ("CheckBox".equals(compParams.get("type")) && component instanceof StiCheckBox) {
                        ((StiCheckBox)component).setCheckedValue((Object)((Boolean)compParams.get("checked") != false ? "true" : "false"));
                        continue;
                    }
                    if (!"Text".equals(compParams.get("type")) || !(component instanceof StiText)) continue;
                    ((StiText)component).getText().setValue((String)compParams.get("text"));
                }
                report.setIsRendered(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

