﻿
StiJsViewer.prototype.CreateParameter = function(params) {
	var parameter = this.CreateHTMLTable();
	this.options.parameters[params.name] = parameter;
	parameter.params = params;
	parameter.controls = {};
	parameter.params.isNull = false;
	parameter.menu = null;
	parameter.className = "stiJsViewerTextBoxDefault";
	parameter.style.borderWidth = "1px";
	parameter.style.marginTop = parameter.style.marginBottom = "6px";

	var jsObject = parameter.jsObject = this;

	parameter.isDateTimeVar = function() {
		return (this.params.type == "DateTime" || this.params.type == "DateTimeOffset" || this.params.type == "DateOnly" || this.params.type == "TimeOnly");
	}

	parameter.addCell = function(control) {
		var cell = document.createElement("td");
		cell.style.height = jsObject.options.parameterRowHeight + "px";
		this.tr[0].appendChild(cell);
		if (control) cell.appendChild(control);

		return cell;
	}

	parameter.oldAddCellInNextRow = parameter.addCellInNextRow;
	parameter.addCellInNextRow = function(control) {
		var cell = this.oldAddCellInNextRow(control);
		cell.style.height = jsObject.options.parameterRowHeight + "px";

		return cell;
	}

	parameter.oldAddCellInLastRow = parameter.addCellInLastRow;
	parameter.addCellInLastRow = function(control) {
		var cell = this.oldAddCellInLastRow(control);
		cell.style.height = jsObject.options.parameterRowHeight + "px";

		return cell;
	}

	//boolCheckBox
	if (parameter.params.type == "Bool" && (parameter.params.basicType == "Value" || parameter.params.basicType == "NullableValue")) {
		parameter.addCell(this.CreateBoolCheckBox(parameter));
		parameter.style.borderWidth = "0px";
	}

	//firstTextBox
	if (parameter.params.type != "Bool" || parameter.params.basicType == "List") {
		var firstTextBox = this.CreateFirstTextBox(parameter);
		var firstTextCell = parameter.addCellInLastRow(firstTextBox);

		if (parameter.controls.nullableCheckBox) {
			firstTextCell.style.position = "relative";
			firstTextCell.appendChild(parameter.controls.nullableCheckBox);
		}
		if (parameter.controls.nullableCheckBoxFrom) {
			firstTextCell.style.position = "relative";
			firstTextCell.appendChild(parameter.controls.nullableCheckBoxFrom);
		}
	}
	//firstDateTimeButton
	if (parameter.isDateTimeVar() && parameter.params.allowUserValues && parameter.params.basicType != "List" && parameter.params.basicType != "Range")
		parameter.addCell(this.CreateFirstDateTimeButton(parameter));

	//firstGuidButton
	if (parameter.params.type == "Guid" && parameter.params.allowUserValues && parameter.params.basicType != "List") parameter.addCell(this.CreateFirstGuidButton(parameter));

	//labelTo
	if (parameter.params.basicType == "Range") {
		var middleBlock = document.createElement("div");
		middleBlock.innerHTML = "-";
		middleBlock.style.width = "8px";
		middleBlock.style.textAlign = "center";
		parameter.addCell(middleBlock);
	}

	//secondTextBox
	if (parameter.params.basicType == "Range") {
		var secondTextBox = this.CreateSecondTextBox(parameter);
		var secondTextCell = parameter.addCellInLastRow(secondTextBox);

		if (parameter.controls.nullableCheckBoxTo) {
			secondTextCell.style.position = "relative";
			secondTextCell.appendChild(parameter.controls.nullableCheckBoxTo);
		}

		parameter.style.borderWidth = "0px";
	}

	//secondDateTimeButton
	if (parameter.params.basicType == "Range" && parameter.isDateTimeVar() && parameter.params.allowUserValues) parameter.addCellInLastRow(this.CreateSecondDateTimeButton(parameter));

	//secondGuidButton
	if (parameter.params.basicType == "Range" && parameter.params.type == "Guid" && parameter.params.allowUserValues) parameter.addCellInLastRow(this.CreateSecondGuidButton(parameter));

	//dropDownButton
	if (parameter.params.items != null || (parameter.params.basicType == "List" && parameter.params.allowUserValues)) {
		parameter.addCellInLastRow(this.CreateDropDownButton(parameter));

		if (parameter.controls.boolCheckBox) {
			parameter.controls.boolCheckBox.style.margin = "0 4px 0 4px";
			parameter.style.borderWidth = "1px";
		}
	}

	parameter.setEnabled = function(state) {
		this.params.isNull = !state;
		for (var controlName in this.controls) {
			if (controlName != "nullableCheckBox")
				this.controls[controlName].setEnabled(state);
		}
	}

	parameter.changeVisibleStateMenu = function(state) {
		if (state) {
			var menu = null;
			switch (this.params.basicType) {
				case "Value":
				case "NullableValue":
					menu = jsObject.parameterMenuForValue(this);
					break;

				case "Range":
					menu = jsObject.parameterMenuForRange(this);
					break;

				case "List":
					menu = (this.params.allowUserValues) ? jsObject.parameterMenuForEditList(this) : jsObject.parameterMenuForNotEditList(this);
					break;
			}

			if (menu != null) menu.changeVisibleState(true);
		}
		else {
			if (parameter.menu != null) {
				if (parameter.params.allowUserValues && parameter.params.basicType == "List") parameter.menu.updateItems();
				parameter.menu.changeVisibleState(false);
			}
		}
	}

	parameter.getStringDateTime = function(object, dateTimeType, isFinishOfDay) {
		if (!object) return "";

		if (dateTimeType == "Date") {
			object.hours = isFinishOfDay ? 23 : 0;
			object.minutes = isFinishOfDay ? 59 : 0;
			object.seconds = isFinishOfDay ? 59 : 0;
		}

		var hours = object.hours > 12 ? object.hours - 12 : object.hours;
		if (hours == 0) hours = 12;

		return object.month + "/" + object.day + "/" + object.year + " " +
			hours + ":" + object.minutes + ":" + object.seconds + " " +
			(object.hours < 12 ? "AM" : "PM");
	}

	parameter.getValue = function() {
		var value = null;
		if (parameter.params.isNull) return null;

		var isDateTimeVar = parameter.isDateTimeVar();
		var isBoolVar = parameter.params.type == "Bool";

		if (parameter.params.basicType == "Value" || parameter.params.basicType == "NullableValue") {
			if (isBoolVar) return parameter.controls.boolCheckBox.isNull ? null : parameter.controls.boolCheckBox.isChecked;
			if (isDateTimeVar) return this.getStringDateTime(parameter.params.key, parameter.params.dateTimeType);

			value = parameter.params.allowUserValues
				? parameter.controls.firstTextBox.value
				: parameter.params.key;
		}

		if (parameter.params.basicType == "Range") {
			value = {};
			value.from = isDateTimeVar ? (!parameter.controls.firstTextBox.isEnabled ? null : this.getStringDateTime(parameter.params.key, parameter.params.dateTimeType)) : parameter.controls.firstTextBox.value;
			value.to = isDateTimeVar ? (!parameter.controls.secondTextBox.isEnabled ? null : this.getStringDateTime(parameter.params.keyTo, parameter.params.dateTimeType, true)) : parameter.controls.secondTextBox.value;
		}

		if (parameter.params.basicType == "List") {
			value = []
			if (parameter.params.allowUserValues) {
				for (var index in parameter.params.items)
					value[index] = isDateTimeVar
						? this.getStringDateTime(parameter.params.items[index].key, parameter.params.dateTimeType)
						: parameter.params.items[index].key;
			}
			else {
				var num = 0;
				for (var index in parameter.params.items)
					if (parameter.params.items[index].isChecked) {
						value[num] = isDateTimeVar
							? this.getStringDateTime(parameter.params.items[index].key, parameter.params.dateTimeType)
							: parameter.params.items[index].key;
						num++;
					}
			}
		}

		return value;
	};

	parameter.setValue = function(value) {
		var isDateTimeVar = parameter.isDateTimeVar();
		var isBoolVar = parameter.params.type == "Bool";

		if (parameter.params.basicType == "Value") {
			if (isBoolVar) {
				parameter.params.key = value;
				parameter.controls.boolCheckBox.setChecked(value);
			}
			else if (isDateTimeVar) {
				parameter.params.key = jsObject.getDateTimeObject(new Date(value));
				parameter.controls.firstTextBox.value = jsObject.getStringKey(parameter.params.key, parameter);
			}
			else {
				parameter.params.key = value;
				parameter.controls.firstTextBox.value = value;
			}
		}
		else if (parameter.params.basicType == "Range") {
			if (isDateTimeVar) {
				parameter.params.key = jsObject.getDateTimeObject(new Date(value.from));
				parameter.params.keyTo = jsObject.getDateTimeObject(new Date(value.to));
				parameter.controls.firstTextBox.value = jsObject.getStringKey(parameter.params.key, parameter);
				parameter.controls.secondTextBox.value = jsObject.getStringKey(parameter.params.keyTo, parameter);
			}
			else {
				parameter.params.key = value.from;
				parameter.params.keyTo = value.to;
				parameter.controls.firstTextBox.value = value.from;
				parameter.controls.secondTextBox.value = value.to;
			}
		}
	};

	//Methods For Stimulsoft Server

	parameter.getDateTimeForReportServer = function(value) {
		var date = new Date(value.year, value.month - 1, value.day, value.hours, value.minutes, value.seconds);
		return (jsObject.options.cloudReportsClient.options.const_dateTime1970InTicks + date * 10000).toString();
	}

	parameter.getTimeSpanForReportServer = function(value) {
		var timeArray = value.split(":");
		var daysHoursArray = timeArray[0].split(".");
		var days = (daysHoursArray.length > 1) ? jsObject.strToInt(daysHoursArray[0]) : 0;
		var hours = jsObject.strToInt((daysHoursArray.length > 1) ? daysHoursArray[1] : daysHoursArray[0]);
		var minutes = (timeArray.length > 1) ? jsObject.strToInt(timeArray[1]) : 0;
		var seconds = (timeArray.length > 2) ? jsObject.strToInt(timeArray[2]) : 0;

		return ((days * 86400000 + hours * 3600000 + minutes * 60000 + seconds * 1000) * 10000).toString();
	}

	parameter.getSingleValueForReportServer = function() {
		var value = null;
		if (parameter.params.isNull) return null;

		if (parameter.params.basicType == "Value" || parameter.params.basicType == "NullableValue") {
			if (parameter.params.type == "Bool") return parameter.controls.boolCheckBox.isChecked ? "True" : "False";
			if (parameter.isDateTimeVar()) return parameter.getDateTimeForReportServer(parameter.params.key);
			value = parameter.params.allowUserValues ? parameter.controls.firstTextBox.value : parameter.params.key;
			if (parameter.params.type == "TimeSpan") value = parameter.getTimeSpanForReportServer(value);
		}

		return value;
	};

	parameter.getRangeValuesForReportServer = function() {
		var values = {};
		values.from = (parameter.isDateTimeVar())
			? parameter.getDateTimeForReportServer(parameter.params.key)
			: (parameter.params.type == "TimeSpan") ? parameter.getTimeSpanForReportServer(parameter.controls.firstTextBox.value) : parameter.controls.firstTextBox.value;

		values.to = (parameter.isDateTimeVar())
			? parameter.getDateTimeForReportServer(parameter.params.keyTo)
			: (parameter.params.type == "TimeSpan") ? parameter.getTimeSpanForReportServer(parameter.controls.secondTextBox.value) : parameter.controls.secondTextBox.value;

		return values;
	};

	parameter.getListValuesForReportServer = function() {
		var values = [];
		var num = 0;

		for (var index in parameter.params.items) {
			var valuesItem = {};
			valuesItem.Ident = "Single";

			if (parameter.params.allowUserValues || (!parameter.params.allowUserValues && parameter.params.items[index].isChecked)) {
				valuesItem.Value = (parameter.isDateTimeVar())
					? parameter.getDateTimeForReportServer(parameter.params.items[index].key)
					: (parameter.params.type == "TimeSpan")
						? parameter.getTimeSpanForReportServer(parameter.params.items[index].key)
						: parameter.params.items[index].key;
				valuesItem.Type = (valuesItem.Value == null) ? null : parameter.getSingleType();
				values.push(valuesItem);
			}
		}

		return values;
	};

	parameter.getParameterObjectForReportServer = function() {
		var parameterObject = {};
		parameterObject.Ident = parameter.params.basicType.indexOf("Value") != -1 ? "Single" : parameter.params.basicType;
		parameterObject.Name = parameter.params.name;

		switch (parameterObject.Ident) {
			case "Single":
				parameterObject.Value = parameter.getSingleValueForReportServer();
				parameterObject.Type = (parameterObject.Value == null) ? null : parameter.getSingleType();
				break;

			case "Range":
				var values = parameter.getRangeValuesForReportServer();
				parameterObject.FromValue = values.from;
				parameterObject.ToValue = values.to;
				parameterObject.RangeType = parameter.params.type + "Range";
				parameterObject.FromType = (parameterObject.FromValue == null) ? null : parameter.getSingleType();
				parameterObject.ToType = (parameterObject.ToValue == null) ? null : parameter.getSingleType();
				break;

			case "List":
				parameterObject.ListType = parameter.params.type + "List";
				parameterObject.Values = parameter.getListValuesForReportServer();
				break;
		}

		return parameterObject;
	};

	parameter.getSingleType = function() {
		var type = parameter.params.type;
		if (type != "DateTime" && type != "DateTimeOffset" && type != "TimeSpan" && type != "DateOnly" && type != "TimeOnly" && type != "Guid" && type != "Decimal") return type.toLowerCase();

		return type;
	}

	if (parameter.controls.nullableCheckBox && (parameter.params.value == null || parameter.params.value == "null")) {
		parameter.controls.nullableCheckBox.setChecked(false);
	}

	return parameter;
}

// ---------------------  Controls   ----------------------------

//boolCheckBox
StiJsViewer.prototype.CreateBoolCheckBox = function(parameter) {
	var hasNullState = parameter.params.basicType == "NullableValue" && parameter.params.allowUserValues;
	var checkBox = this.ParameterCheckBox(parameter, "", hasNullState);
	checkBox.name = parameter.params.name;
	parameter.controls.boolCheckBox = checkBox;

	if (parameter.params.value == null && checkBox.hasNullState) {
		checkBox.setChecked(false);
		checkBox.setNullState(true);
	}
	else {
		checkBox.setChecked((typeof (parameter.params.value) == "boolean" && parameter.params.value) || parameter.params.value == "true" || parameter.params.value == "True");
		checkBox.setEnabled(parameter.params.allowUserValues);
	}

	return checkBox;
}

//firstTextBox
StiJsViewer.prototype.CreateFirstTextBox = function(parameter) {
	var jsObject = this;
	var textBox = this.ParameterTextBox(parameter);
	textBox.name = parameter.params.name;
	parameter.controls.firstTextBox = textBox;
	textBox.setReadOnly(parameter.params.basicType == "List" || !parameter.params.allowUserValues);

	if (parameter.params.basicType != "Range") {
		textBox.style.borderWidth = "0";
	}

	if (parameter.params.formatMask) {
		this.maskTextBox(textBox, StiBase64.decode(parameter.params.formatMask));
	}

	var isDateTimeVar = parameter.isDateTimeVar();

	//Value
	if (parameter.params.basicType == "Value" || parameter.params.basicType == "NullableValue") {
		var isDateNull = isDateTimeVar && parameter.params.key != null && parameter.params.key.isNull;

		if (isDateTimeVar && (parameter.params.value == null || isDateNull)) {
			parameter.params.key = this.getDateTimeObject(new Date());
			if (isDateNull) parameter.params.key.isNull = true;
		}

		var value = isDateTimeVar ? this.getStringKey(parameter.params.key, parameter) : parameter.params.value;
		if (typeof value == "undefined") value = "";

		textBox.value = value;
	}

	//Range
	if (parameter.params.basicType == "Range") {
		var isDateNull = isDateTimeVar && parameter.params.key != null && parameter.params.key.isNull;

		if (isDateTimeVar && (parameter.params.value == null || isDateNull)) {
			parameter.params.key = this.getDateTimeObject(new Date());
			if (isDateNull) parameter.params.key.isNull = true;
		}

		textBox.value = this.getStringKey(parameter.params.key, parameter);

		if (isDateNull) {
			var checkBox = this.CreateRangeNullableCheckBox(parameter, "nullableCheckBoxFrom");
			textBox.style.width = (parseInt(textBox.style.width) - (this.options.isTouchDevice ? 14 : 10)) + "px";
			textBox.style.padding = this.options.isTouchDevice ? "0 0 0 26px" : "0 0 0 22px";

			textBox.setEnabled = function(state) {
				this.isEnabled = state;
				this.disabled = !state;
				this.className = this.styleName + " " + this.styleName + (state ? "Default" : "Disabled");
				this.style.color = state ? (this.foreColor || (jsObject.options.toolbar.fontColor && jsObject.options.toolbar.fontColor != "Empty" ? jsObject.options.toolbar.fontColor : (jsObject.isBlackTheme() ? "#ffffff" : "#444444"))) : "transparent";
			}

			textBox.setEnabled(false);

			checkBox.action = function() {
				textBox.setEnabled(this.isChecked);
			}
		}
	}

	//List
	if (parameter.params.basicType == "List") {
		if (parameter.params.items) {
			var showAll = true;

			for (var index = 0; index < parameter.params.items.length; index++) {
				var isChecked = true;

				if (parameter.params.value instanceof Array && parameter.params.value.indexOf(parameter.params.items[index].value) < 0 && parameter.params.value.indexOf(parameter.params.items[index].key) < 0)
					isChecked = false;

				if (parameter.params.isFirstInitialization && parameter.params.checkedStates && index < parameter.params.checkedStates.length) {
					isChecked = parameter.params.checkedStates[index];
				}

				parameter.params.items[index].isChecked = isChecked;

				if (isChecked && index < 50) {
					if (textBox.value != "") textBox.value += (parameter.jsObject.options.listSeparator ? parameter.jsObject.options.listSeparator + " " : "; ");

					if (parameter.params.allowUserValues)
						textBox.value += this.getStringKey(parameter.params.items[index].key, parameter);
					else
						textBox.value += parameter.params.items[index].value != "" ? parameter.params.items[index].value : this.getStringKey(parameter.params.items[index].key, parameter);
				}

				if (!isChecked) showAll = false;
			}

			if (!parameter.params.allowUserValues && showAll) {
				textBox.value = "(" + jsObject.collections.loc["All"] + ")";
			}
		}
	}

	if (textBox.readOnly) {
		textBox.onclick = function() {
			if (parameter.controls.dropDownButton) parameter.controls.dropDownButton.action();
		}
	}

	return textBox;
}

//firstDateTimeButton
StiJsViewer.prototype.CreateFirstDateTimeButton = function(parameter) {
	var jsObject = this;
	var dateTimeButton = this.ParameterButton("DateTimeButton", parameter, parameter.params.basicType == "Range");
	parameter.controls.firstDateTimeButton = dateTimeButton;

	if (parameter.controls.firstTextBox) {
		parameter.controls.firstTextBox.cropToOneButton();
	}

	dateTimeButton.action = function() {
		var datePicker = dateTimeButton.jsObject.controls.datePicker;
		datePicker.value = this.parameter.params.key;
		datePicker.showTime = this.parameter.params.dateTimeType != "Date";
		datePicker.showDate = this.parameter.params.dateTimeType != "Time";
		datePicker.parentDateControl = this.parameter.controls.firstTextBox;
		datePicker.parentButton = this;
		datePicker.changeVisibleState(!datePicker.visible);
	}

	return dateTimeButton;
}

//firstGuidButton
StiJsViewer.prototype.CreateFirstGuidButton = function(parameter) {
	var guidButton = this.ParameterButton("GuidButton", parameter, parameter.params.basicType == "Range");
	parameter.controls.firstGuidButton = guidButton;

	if (parameter.controls.firstTextBox) {
		parameter.controls.firstTextBox.cropToOneButton();
	}

	guidButton.action = function() {
		this.parameter.controls.firstTextBox.value = this.parameter.jsObject.newGuid();
	}

	return guidButton;
}

//secondTextBox
StiJsViewer.prototype.CreateSecondTextBox = function(parameter) {
	var jsObject = this;
	var isDateNull = parameter.isDateTimeVar() && parameter.params.keyTo != null && parameter.params.keyTo.isNull;
	var textBox = this.ParameterTextBox(parameter);
	textBox.name = parameter.params.name + "_To";
	parameter.controls.secondTextBox = textBox;
	textBox.setReadOnly(!parameter.params.allowUserValues);

	if (parameter.isDateTimeVar() && (parameter.params.value == null || isDateNull)) {
		parameter.params.keyTo = this.getDateTimeObject(new Date);
		parameter.params.keyTo.isNull = true;
	}

	textBox.value = this.getStringKey(parameter.params.keyTo, parameter);

	if (isDateNull) {
		var checkBox = this.CreateRangeNullableCheckBox(parameter, "nullableCheckBoxTo");
		textBox.style.width = (parseInt(textBox.style.width) - (this.options.isTouchDevice ? 14 : 10)) + "px";
		textBox.style.padding = this.options.isTouchDevice ? "0 0 0 26px" : "0 0 0 22px";

		textBox.setEnabled = function(state) {
			this.isEnabled = state;
			this.disabled = !state;
			this.className = this.styleName + " " + this.styleName + (state ? "Default" : "Disabled");
			this.style.color = state ? (this.foreColor || (jsObject.options.toolbar.fontColor && jsObject.options.toolbar.fontColor != "Empty" ? jsObject.options.toolbar.fontColor : (jsObject.isBlackTheme() ? "#ffffff" : "#444444"))) : "transparent";
		}

		textBox.setEnabled(false);

		checkBox.action = function() {
			textBox.setEnabled(this.isChecked);
		}
	}

	if (textBox.readOnly) {
		textBox.onclick = function() {
			if (parameter.controls.dropDownButton) parameter.controls.dropDownButton.action();
		}
	}

	return textBox;
}

//secondDateTimeButton
StiJsViewer.prototype.CreateSecondDateTimeButton = function(parameter) {
	var jsObject = this;
	var dateTimeButton = this.ParameterButton("DateTimeButton", parameter, parameter.params.basicType == "Range");
	parameter.controls.secondDateTimeButton = dateTimeButton;

	dateTimeButton.action = function() {
		var datePickerParams = {
			showTime: this.parameter.params.dateTimeType != "Date",
			showDate: this.parameter.params.dateTimeType != "Time",
			firstParentDateControl: this.parameter.controls.firstTextBox,
			firstParentButton: this.parameter.controls.firstDateTimeButton,
			firstValue: this.parameter.params.key,
			secondParentDateControl: this.parameter.controls.secondTextBox,
			secondParentButton: this,
			secondValue: this.parameter.params.keyTo
		}

		var parametersPanelPosition = jsObject.options.currentParametersPanelPosition || jsObject.options.appearance.parametersPanelPosition;
		var datePicker = jsObject.InitializeDoubleDatePicker(datePickerParams);
		datePicker.changeVisibleState(!datePicker.visible, null, parametersPanelPosition == "Left" ? false : true, parametersPanelPosition == "Left" ? 245 : 0);
	}

	return dateTimeButton;
}

//secondGuidButton
StiJsViewer.prototype.CreateSecondGuidButton = function(parameter) {
	var guidButton = this.ParameterButton("GuidButton", parameter, parameter.params.basicType == "Range");
	parameter.controls.secondGuidButton = guidButton;

	if (parameter.controls.secondTextBox) {
		parameter.controls.secondTextBox.cropToOneButton();
	}

	guidButton.action = function() {
		this.parameter.controls.secondTextBox.value = this.parameter.jsObject.newGuid();
	}

	return guidButton;
}

//dropDownButton
StiJsViewer.prototype.CreateDropDownButton = function(parameter) {
	var dropDownButton = this.ParameterButton("DropDownButton", parameter, parameter.params.basicType == "Range");
	parameter.controls.dropDownButton = dropDownButton;

	if (parameter.controls.firstTextBox) {
		parameter.controls.firstTextBox.cropToOneButton(parameter.controls.secondTextBox != null);
	}

	if (parameter.controls.secondTextBox) {
		parameter.controls.secondTextBox.cropToOneButton(true);
	}

	dropDownButton.action = function() {
		this.parameter.changeVisibleStateMenu(this.parameter.menu == null);
	}

	return dropDownButton;
}

//nullableCheckBox
StiJsViewer.prototype.CreateNullableCheckBox = function(parameter) {
	var jsObject = this;
	var checkBox = parameter.controls.nullableCheckBox = this.ParameterCheckBox(parameter);
	checkBox.setChecked(true);
	checkBox.name = parameter.params.name + "_Nullable";
	checkBox.style.position = "absolute";
	checkBox.style.left = checkBox.style.top = "4px";

	checkBox.onChecked = function() {
		this.parameter.setEnabled(this.isChecked);

		var textColor = this.isChecked
			? (jsObject.options.toolbar.fontColor && jsObject.options.toolbar.fontColor != "Empty" ? jsObject.options.toolbar.fontColor : (jsObject.isBlackTheme() ? "#ffffff" : "#444444"))
			: "transparent";

		var firstTextBox = this.parameter.controls.firstTextBox;
		var secondTextBox = this.parameter.controls.secondTextBox;

		if (firstTextBox) firstTextBox.style.color = this.isChecked && firstTextBox.foreColor ? firstTextBox.foreColor : textColor;
		if (secondTextBox) secondTextBox.style.color = this.isChecked && secondTextBox.foreColor ? secondTextBox.foreColor : textColor;
	}

	return checkBox;
}

StiJsViewer.prototype.CreateRangeNullableCheckBox = function(parameter, controlName) {
	var checkBox = parameter.controls[controlName] = this.ParameterCheckBox(parameter);
	checkBox.style.position = "absolute";
	checkBox.style.left = checkBox.style.top = "4px";

	return checkBox;
}