﻿StiJsViewer.prototype.postAction = function (action, bookmarkPage, bookmarkAnchor, componentGuid) {
    switch (action) {
        case "Refresh":
            break;

        case "Print":
            switch (this.options.toolbar.printDestination) {
                case "Pdf": this.postPrint("PrintPdf"); break;
                case "Direct": this.postPrint("PrintWithoutPreview"); break;
                case "WithPreview": this.postPrint("PrintWithPreview"); break;
                default: this.controls.menus.printMenu.changeVisibleState(!this.controls.menus.printMenu.visible); break;
            }
            return;

        case "Open":
            var openReportDialog = this.InitializeOpenDialog("openReportDialog", function (fileName, filePath, content) {
                openReportDialog.jsObject.postOpen(fileName, content);
            }, ".mdc,.mdz,.mdx");
            openReportDialog.action();
            return;

        case "Save":
            this.controls.menus.saveMenu.changeVisibleState(!this.controls.menus.saveMenu.visible);
            return;

        case "SendEmail":
            this.controls.menus.sendEmailMenu.changeVisibleState(!this.controls.menus.sendEmailMenu.visible);
            return;

        case "Zoom":
            this.controls.menus.zoomMenu.changeVisibleState(!this.controls.menus.zoomMenu.visible);
            return;

        case "ViewMode":
            this.controls.menus.viewModeMenu.changeVisibleState(!this.controls.menus.viewModeMenu.visible);
            return;

        case "FirstPage":
        case "PrevPage":
        case "NextPage":
        case "LastPage":
            if (action == "FirstPage") this.reportParams.pageNumber = 0;
            if (action == "PrevPage" && this.reportParams.pageNumber > 0) this.reportParams.pageNumber--;
            if (action == "NextPage" && this.reportParams.pageNumber < this.reportParams.pagesCount - 1) this.reportParams.pageNumber++;
            if (action == "LastPage") this.reportParams.pageNumber = this.reportParams.pagesCount - 1;
            if (this.controls.reportPanel.pagesNavigationIsActive()) {
                this.scrollToPage(this.reportParams.pageNumber);
                if (this.controls.toolbar) this.controls.toolbar.changeToolBarState();
                return;
            }
            break;

        case "FullScreen":
            this.changeFullScreenMode(!this.options.appearance.fullScreenMode);
            return;

        case "Zoom25": this.reportParams.zoom = 25; break;
        case "Zoom50": this.reportParams.zoom = 50; break;
        case "Zoom75": this.reportParams.zoom = 75; break;
        case "Zoom100": this.reportParams.zoom = 100; break;
        case "Zoom150": this.reportParams.zoom = 150; break;
        case "Zoom200": this.reportParams.zoom = 200; break;

        case "ZoomOnePage":
        case "ZoomPageWidth":
            {
                if (this.options.toolbar.displayMode == "Separated") {
                    this.controls.toolbar.controls.ZoomOnePage.setSelected(action == "ZoomOnePage");
                    this.controls.toolbar.controls.ZoomPageWidth.setSelected(action == "ZoomPageWidth");
                }
                this.reportParams.zoom = action == "ZoomPageWidth"
                    ? parseInt(this.controls.reportPanel.getZoomByPageWidth())
                    : parseInt(this.controls.reportPanel.getZoomByPageHeight());
                break;
            }

        case "ViewModeSinglePage":
            this.reportParams.viewMode = "SinglePage";
            break;

        case "ViewModeContinuous":
            this.reportParams.viewMode = "Continuous";
            break;

        case "ViewModeMultiplePages":
            this.reportParams.viewMode = "MultiplePages";
            break;

        case "ViewModeMultiPage":
            this.reportParams.viewMode = "MultiPage";
            this.reportParams.multiPageContainerWidth = this.controls.reportPanel.offsetWidth;
            this.reportParams.multiPageContainerHeight = this.controls.reportPanel.offsetHeight;
            this.reportParams.multiPageMargins = 10;
            break;

        case "GoToPage":
            this.reportParams.pageNumber = this.controls.toolbar.controls["PageControl"].textBox.getCorrectValue() - 1;
            if (this.controls.reportPanel.pagesNavigationIsActive()) {
                this.scrollToPage(this.reportParams.pageNumber);
                if (this.controls.toolbar) this.controls.toolbar.changeToolBarState();
                return;
            }
            break;

        case "BookmarkAction":
            if (this.reportParams.pageNumber == bookmarkPage || this.reportParams.viewMode != "SinglePage") {
                this.scrollToAnchor(bookmarkAnchor, componentGuid);
                return;
            }
            else {
                this.reportParams.pageNumber = bookmarkPage;
                this.options.bookmarkAnchor = bookmarkAnchor;
                this.options.componentGuid = componentGuid;
            }
            break;

        case "Bookmarks":
            this.controls.bookmarksPanel.changeVisibleState(!this.controls.buttons["Bookmarks"].isSelected);
            return;

        case "Parameters":
            this.controls.parametersPanel.changeVisibleState(!this.controls.buttons["Parameters"].isSelected);
            return;

        case "Resources":
            this.controls.resourcesPanel.changeVisibleState(!this.controls.buttons["Resources"].isSelected);
            return;

        case "Find":
            this.controls.findPanel.changeVisibleState(!this.controls.toolbar.controls.Find.isSelected);
            return;

        case "About":
            this.controls.aboutPanel.changeVisibleState(!this.controls.toolbar.controls.About.isSelected);
            return;

        case "Design":
            this.postDesign();
            return;

        case "Pin":
            if (this.controls.toolbar) this.controls.toolbar.changePinState(!this.options.toolbar.autoHide);
            return;

        case "Submit":
            this.reportParams.editableParameters = null;
            this.reportParams.pageNumber = 0;
            if (this.options.isMobileDevice) this.controls.parametersPanel.changeVisibleState(false);
            this.postInteraction({ action: "Variables", variables: this.controls.parametersPanel.getParametersValues() });
            return;

        case "Reset":
            this.options.parameters = {};
            if (this.options.paramsVariablesStartValues) {
                this.options.paramsVariables = this.options.paramsVariablesStartValues;
            }
            this.controls.parametersPanel.clearParameters();
            this.controls.parametersPanel.addParameters();
            return;

        case "Editor":
            this.SetEditableMode(!this.options.editableMode);
            return;
    }

    // Check for OnePage or PageWidth zoom when the viewer is launched for the first time
    if (this.reportParams.zoom == -1 || this.reportParams.zoom == -2)
        this.reportParams.autoZoom = this.reportParams.zoom;

    // Correct viewer action
    var viewerAction = action == "Refresh" ? "RefreshReport" : "GetPages";
    if (!action || action == "GetReport") {
        this.clearViewerState(true);
        viewerAction = "GetReport";
    }
    var requestUrl = this.options.requestUrl.replace("{action}",
        (viewerAction == "GetReport" || this.options.server.cacheMode == "None")
            ? this.options.actions.getReport
            : this.options.actions.viewerEvent);
    
    this.controls.processImage.show();
    this.postAjax(requestUrl, { action: viewerAction }, this.showReportPage);
}

StiJsViewer.prototype.postOpen = function (fileName, content) {
    if (typeof content != "string" || content == "") return;
    if (content.indexOf("<?xml") == 0 || content.indexOf("{") == 0) content = Base64.encode(content);

    var data = {
        "action": "OpenReport",
        "openingFileName": fileName || "Report.mdc",
        "base64Data": content.indexOf("base64,") > 0 ? content.substr(content.indexOf("base64,") + 7) : content
    };
    
    this.clearViewerState();
    this.reportParams.reportFileName = fileName;

    var jsObject = this;
    if (fileName && fileName.toLowerCase().indexOf(".mdx") >= 0) {
        var passwordForm = this.InitializePasswordForm();
        passwordForm.show(function (password) {
            data.openingFilePassword = password;
            jsObject.controls.processImage.show();
            jsObject.postAjax(jsObject.options.requestUrl.replace("{action}", jsObject.options.actions.openReport), data, jsObject.showReportPage);
        }, this.collections.loc["PasswordEnter"] + ":");
    }
    else {
        this.controls.processImage.show();
        this.postAjax(this.options.requestUrl.replace("{action}", this.options.actions.openReport), data, this.showReportPage);
    }
}

StiJsViewer.prototype.postPrint = function (printAction) {
    var data = {
        "action": "PrintReport",
        "printAction": printAction,
        "bookmarksPrint": this.options.appearance.bookmarksPrint
    };

    var url = this.options.requestUrl.replace("{action}", this.options.actions.printReport);
    switch (printAction) {
        case "PrintPdf":
            if (this.options.appearance.printToPdfMode == "Popup") this.printAsPdfPopup(data);
            else this.printAsPdf(url, data);
            break;

        case "PrintWithPreview":
            this.printAsPopup(data);
            break;

        case "PrintWithoutPreview":
            this.postAjax(url, data, this.printAsHtml);
            break;
    }
}

StiJsViewer.prototype.printAsPdfPopup = function (data) {
    var url = this.options.requestAbsoluteUrl.replace("{action}", this.options.actions.printReport);
    var win = this.openNewWindow("about:blank", "_blank");
    if (win != null) this.postForm(url, data, win.document);
}


StiJsViewer.prototype.printAsPdf = function (url, data) {
    data.responseType = "blob";

    var printFrameId = this.options.viewerId + "_PdfPrintFrame";
    var printFrame = document.getElementById(printFrameId);
    if (printFrame) this.controls.viewer.removeChild(printFrame);

    printFrame = document.createElement("iframe");
    printFrame.id = printFrameId;
    printFrame.name = printFrameId;
    printFrame.width = "0";
    printFrame.height = "0";
    printFrame.style.position = "absolute";
    printFrame.style.border = "none";
   
    // Firefox does not load the invisible content of the iframe
    if (this.getNavigatorName() == "Mozilla") {
        printFrame.width = "100px";
        printFrame.height = "100px";
        printFrame.style.opacity = "0.01";
        printFrame.style.zIndex = "-100";
        printFrame.style.pointerEvents = "none";
    }

    this.controls.viewer.insertBefore(printFrame, this.controls.viewer.firstChild);

    // Manual printing in browsers that do not support automatic PDF printing
    printFrame.onload = function () {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
    }

    var form = document.createElement("FORM");
    form.setAttribute("id", "printForm");
    form.setAttribute("method", "POST");
    form.setAttribute("action", url);
    form.setAttribute("target", this.options.viewerId + "_PdfPrintFrame");

    var params = this.createPostParameters(data, true);
    for (var key in params) {
        var paramsField = document.createElement("INPUT");
        paramsField.setAttribute("type", "hidden");
        paramsField.setAttribute("name", key);
        paramsField.setAttribute("value", params[key]);
        form.appendChild(paramsField);
    }

    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}

StiJsViewer.prototype.printAsPopup = function (data) {
    var url = this.options.requestAbsoluteUrl.replace("{action}", this.options.actions.printReport);
    var win = this.openNewWindow("about:blank", "PrintReport", "height=900, width=790, toolbar=no, menubar=yes, scrollbars=yes, resizable=yes, location=no, directories=no, status=no");
    if (win != null) this.postForm(url, data, win.document);
}

StiJsViewer.prototype.printAsHtml = function (text, jsObject) {
    if (jsObject.showError(text)) return;

    // Delete pdfPrintFrame, this is fix IE strange error
    var printFrame = document.getElementById("pdfPrintFrame");
    if (printFrame) document.body.removeChild(printFrame);
    
    printFrame = document.getElementById("htmlPrintFrame");
    if (printFrame) document.body.removeChild(printFrame);
    
    printFrame = document.createElement("iframe");
    printFrame.id = "htmlPrintFrame";
    printFrame.name = "htmlPrintFrame";
    printFrame.width = "0px";
    printFrame.height = "0px";
    printFrame.style.position = "absolute";
    printFrame.style.border = "none";
    document.body.appendChild(printFrame, document.body.firstChild);

    printFrame.contentWindow.document.open();
    printFrame.contentWindow.document.write(text);
    printFrame.contentWindow.document.close();
    setTimeout(function () {
        printFrame.contentWindow.focus();
        printFrame.contentWindow.print();
    });
}

StiJsViewer.prototype.postExport = function (format, settings, elementName) {
    var data = {
        action: "ExportReport",
        exportFormat: format,
        exportSettings: settings,
        elementName: elementName
    };

    var doc = settings.OpenAfterExport && this.options.appearance.openExportedReportWindow == "_blank" ? this.openNewWindow("about:blank", "_blank").document : null;
    var url = doc ? this.options.requestAbsoluteUrl : this.options.requestUrl;
    this.postForm(url.replace("{action}", this.options.actions.exportReport), data, doc);
    
    this.showTrLog();
}

StiJsViewer.prototype.postEmail = function (format, settings) {
    var data = {
        action: "EmailReport",
        exportFormat: format,
        exportSettings: settings
    };

    this.controls.processImage.show();
    this.postAjax(this.options.requestUrl.replace("{action}", this.options.actions.emailReport), data, this.emailResult);
}

StiJsViewer.prototype.postDesign = function () {
    var doc = this.options.appearance.designWindow == "_blank" ? this.openNewWindow("about:blank", "_blank").document : null;
    var url = doc ? this.options.requestAbsoluteUrl : this.options.requestUrl;
    this.postForm(url.replace("{action}", this.options.actions.designReport), { action: "DesignReport" }, doc);
}

StiJsViewer.prototype.postInteraction = function (params) {
    if (!this.options.actions.interaction) {
        if (this.controls.buttons["Parameters"]) this.controls.buttons["Parameters"].setEnabled(false);
        return;
    }

    // Add new drill-down parameters to drill-down queue and calc guid
    if (params.action != "InitVars" && params.action == "DrillDown") {
        params.drillDownParameters = this.reportParams.drillDownParameters.concat(params.drillDownParameters);
        params.drillDownGuid = hex_md5(JSON.stringify(params.drillDownParameters));
    }

    this.controls.processImage.show();
    this.postAjax(
        this.options.requestUrl.replace("{action}", this.options.actions.interaction),
        params,
        params.action == "InitVars" ? this.showParametersPanel : this.showReportPage
    );
}

StiJsViewer.prototype.postReportResource = function (resourceName, viewType) {
    var data = {
        action: "ReportResource",
        reportResourceParams: {
            resourceName: resourceName,
            viewType: viewType
        }
    };

    var doc = viewType == "View" ? this.openNewWindow("about:blank", "_blank").document : null;
    var url = doc ? this.options.requestAbsoluteUrl : this.options.requestUrl;
    this.postForm(url.replace("{action}", this.options.actions.viewerEvent), data, doc);
}

StiJsViewer.prototype.initAutoUpdateCache = function (data, jsObject) {
    if (jsObject.options.server.allowAutoUpdateCache) {
        if (jsObject.controls.timerAutoUpdateCache) clearTimeout(jsObject.controls.timerAutoUpdateCache);
        jsObject.controls.timerAutoUpdateCache = setTimeout(function () {
            jsObject.postAjax(jsObject.options.requestUrl.replace("{action}", jsObject.options.actions.viewerEvent), { action: "UpdateCache" }, jsObject.initAutoUpdateCache);
        }, jsObject.options.server.timeoutAutoUpdateCache);
    }
}

StiJsViewer.prototype.emailResult = function (data, jsObject) {
    jsObject.controls.processImage.hide();
    if (data == "0")
        alert(jsObject.collections.loc["EmailSuccessfullySent"]);
    else {
        if (data.indexOf("<?xml") == 0) {
            alert(jsObject.GetXmlValue(data, "ErrorCode"));
            alert(jsObject.GetXmlValue(data, "ErrorDescription"));
        }
        else
            alert(data);
    }
}

StiJsViewer.prototype.parseReportParameters = function (parameters) {
    this.reportParams.pagesArray = parameters.pagesArray;

    // Apply new report parameters, if not update current page
    if (parameters.action != "GetPages") {
        this.reportParams.type = parameters.reportType;
        this.reportParams.drillDownGuid = parameters.drillDownGuid;
        this.reportParams.pagesCount = parameters.pagesCount;
        if (parameters.pageNumber != null) this.reportParams.pageNumber = parameters.pageNumber;
        this.reportParams.zoom = parameters.zoom;
        this.reportParams.viewMode = parameters.viewMode;
        this.reportParams.reportFileName = parameters.reportFileName;
        this.reportParams.collapsingStates = parameters.collapsingStates;
        if (parameters.bookmarksContent) this.reportParams.bookmarksContent = parameters.bookmarksContent;
        if (parameters.resources) this.reportParams.resources = parameters.resources;
        if (parameters.tableOfContentsPointers) this.reportParams.tableOfContentsPointers = parameters.tableOfContentsPointers;
		if (parameters.exportSettings) this.reportParams.exportSettings = parameters.exportSettings;
    }
}

StiJsViewer.prototype.parseCloudParameters = function (parameters) {
    if (parameters.maxReportPages) this.showError({
        success: false,
        type: "Warning",
        text: this.collections.loc["QuotaMaximumReportPagesCountExceeded"] + "\n" + this.collections.loc["Maximum"] + " " + this.numberWithSpaces(parameters.maxReportPages) + "."
    });

    if (parameters.maxDataRows) this.showError({
        success: false,
        type: "Warning",
        text: this.collections.loc["QuotaMaximumDataRowsCountExceeded"] + "\n" + this.collections.loc["Maximum"] + " " + this.numberWithSpaces(parameters.maxDataRows) + "."
    });
}

StiJsViewer.prototype.showParametersPanel = function (data, jsObject) {
    if (jsObject.showError(data)) data = null;

    jsObject.options.isParametersReceived = true;
    jsObject.options.paramsVariables = typeof data == "string" ? JSON.parse(data) : data;
    jsObject.InitializeParametersPanel();
    jsObject.controls.processImage.hide();
}

StiJsViewer.prototype.showDrillDownPage = function (reportFileName, drillDownGuid, drillDownParameters) {
    this.controls.drillDownPanel.changeVisibleState(true);

    var buttonExist = false;
    for (var name in this.controls.drillDownPanel.buttons) {
        var button = this.controls.drillDownPanel.buttons[name];
        if (button.reportParams.drillDownGuid == drillDownGuid) {
            buttonExist = true;
            button.style.display = "inline-block";
            button.select();
            break;
        }
    }
    if (!buttonExist) {
        this.controls.drillDownPanel.addButton(reportFileName);
        this.reportParams.drillDownParameters = drillDownParameters;
        this.reportParams.pageNumber = 0;
        this.reportParams.pagesWidth = 0;
        this.reportParams.pagesHeight = 0;
    }

    this.controls.reportPanel.scrollTop = 0;
}

StiJsViewer.prototype.startRefreshReportTimer = function (timeout) {
    if (this.service.refreshReportTimer != null)
        clearInterval(this.service.refreshReportTimer);

    var jsObject = this;
    this.service.refreshReportTimer = setInterval(function () {
        if (!jsObject.service.isRequestInProcess)
            jsObject.postAction("Refresh");
    }, timeout * 1000);
}

StiJsViewer.prototype.stopRefreshReportTimer = function () {
    if (this.service.refreshReportTimer != null) {
        clearInterval(this.service.refreshReportTimer);
        this.service.refreshReportTimer = null;
    }
}

StiJsViewer.prototype.showReportPage = function (data, jsObject) {
    // If report not found, try to get the report again
    if (data == "ServerError:The report is not specified." && jsObject.options.isReportRecieved) {
        jsObject.options.isReportRecieved = false;
        jsObject.reportParams.prevPageNumber = jsObject.reportParams.pageNumber;
        jsObject.postAction("GetReport");
        return;
    }

    jsObject.controls.processImage.hide();
    jsObject.options.isReportRecieved = true;
    
    if (jsObject.showError(data)) return; // Check for error

    if (jsObject.options.server.useCompression) {
        data = StiGZipHelper.unpack(data);
        if (jsObject.showError(data)) return; // Check for error unpacked data
    }
    
    // Get JSON parameters and check for error in JSON format
    var parameters = (typeof (data) == "string" && data.substr(0, 1) == "{") ? JSON.parse(data) : data;
    if (jsObject.showError(parameters)) return;
    
    if (parameters.reportDisplayMode) {
        jsObject.options.displayModeFromReport = parameters.reportDisplayMode;
    }

    // Add first report do drill-down panel, show drill-down page
    if (jsObject.controls.drillDownPanel.buttonsRow.children.length == 0) jsObject.controls.drillDownPanel.addButton(parameters.reportFileName, jsObject.reportParams);
    if (parameters.action == "DrillDown") jsObject.showDrillDownPage(parameters.reportFileName, parameters.drillDownGuid, parameters.drillDownParameters);

    // Parse report and cloud parameters
    jsObject.parseReportParameters(parameters);
    jsObject.parseCloudParameters(parameters);

    // Add custom report fonts for new report
    if (parameters.action == "GetReport" || parameters.action == "OpenReport") {
		jsObject.addCustomFontStyles(parameters.customFonts);
		jsObject.options.currentParameterWidth = parameters.parameterWidth;
        jsObject.options.currentParameterAlignment = parameters.parameterAlignment;
    }

    // Init viewer panels
    if (parameters.bookmarksContent) jsObject.InitializeBookmarksPanel();
    if (jsObject.controls.resourcesPanel) jsObject.controls.resourcesPanel.update();
    
    // Fill report panel
    if (parameters.pagesArray) jsObject.controls.reportPanel.addPages();
    
    if ((parameters.action == "GetReport" || parameters.action == "OpenReport" || parameters.action == "RefreshReport") && jsObject.reportParams.type == "Report" && parameters.previewSettings) {
        jsObject.applyPreviewSettingsToViewer(parameters.previewSettings);
    }

    if (jsObject.controls.toolbar) {
        jsObject.controls.toolbar.changeToolBarState();
        jsObject.controls.toolbar.setEnabled(true);
        if (jsObject.controls.navigatePanel) jsObject.controls.navigatePanel.setEnabled(true);
        if (jsObject.controls.buttons.Editor) jsObject.controls.buttons.Editor.style.display = parameters.isEditableReport ? "" : "none";
    }

    // Check for auto zoom by page width or page height
    if (jsObject.reportParams.autoZoom != null) {
        if (jsObject.reportParams.type == "Report") jsObject.postAction(jsObject.reportParams.autoZoom == -1 ? "ZoomPageWidth" : "ZoomOnePage");
        delete jsObject.reportParams.autoZoom;
    }

    // Go to the bookmark, if it present
    if (jsObject.options.bookmarkAnchor != null) {
        jsObject.scrollToAnchor(jsObject.options.bookmarkAnchor, jsObject.options.componentGuid);
        jsObject.options.bookmarkAnchor = null;
        jsObject.options.componentGuid = null;
    }

    // Find text in the report
    if (jsObject.options.findMode && jsObject.controls.findPanel) jsObject.showFindLabels(jsObject.controls.findPanel.controls.findTextBox.value);
    
    // Init auto-update report cache
    jsObject.initAutoUpdateCache(null, jsObject);

    // Init auto refresh report timer
    jsObject.stopRefreshReportTimer();
    if (parameters.refreshTime && parseInt(parameters.refreshTime) > 0) jsObject.startRefreshReportTimer(parameters.refreshTime);

    // Update all panels
    jsObject.updateVisibleState();
    jsObject.updateLayout();

    // Get the request from user variables if they are not already received
    if (!jsObject.options.isParametersReceived && jsObject.reportParams.type == "Report" && jsObject.options.toolbar.showParametersButton) jsObject.postInteraction({ action: "InitVars" });

    // If report contains dashboards, add dashboards buttons and get dashboard page
    if (parameters.dashboards) {
        jsObject.controls.dashboardsPanel.update(parameters.dashboards);
        if (!jsObject.controls.menus.saveDashboardMenu) jsObject.InitializeSaveDashboardMenu();
        if (jsObject.reportParams.type == "Dashboard") jsObject.postAction("GetPages");
    }
}
