import { OnInit, AfterViewInit, ElementRef, OnChanges, EventEmitter, OnDestroy } from '@angular/core';
import { ControllerService } from './services/controller.service';
import { MenuService } from './menu/menu.service';
import { ModelService } from './services/model.service';
import { ExportService } from './services/export.service';
import { FormService } from './forms/form.service';
import { ApiService } from './services/api.service';
import { PrintService } from './services/print.service';
import { DashboardService } from './services/dashboard.service';
import * as i0 from "@angular/core";
export declare class StimulsoftViewerComponent implements OnInit, AfterViewInit, OnChanges, OnDestroy {
    private controller;
    menuService: MenuService;
    model: ModelService;
    exportService: ExportService;
    formService: FormService;
    api: ApiService;
    private printService;
    private dashboardService;
    private dashboardsElement;
    /**
     * Root viewer span
     */
    viewerElement: ElementRef;
    /**
     * Occurs when report/dashboard loaded
     */
    loaded: EventEmitter<any>;
    /**
     * Occurs on error, $event is ErrorMessage object contains error: string & type: any  (if present)
     */
    error: EventEmitter<any>;
    /**
     * Occurs on export, $event object contains exportFormat: string & exportSettings: {}
     */
    export: EventEmitter<any>;
    /**
     * Occurs on export & email, $event object contains exportFormat: string & exportSettings: {}
     */
    email: EventEmitter<any>;
    /**
     * Occurs on export & email, $event object contains format: string : 'PrintPdf' or 'PrintWithoutPreview' or 'PrintWithPreview'
     */
    print: EventEmitter<any>;
    /**
     * Occurs on pressing 'Design' button
     */
    design: EventEmitter<any>;
    /**
     * Url to server instance, must contains placeholder {action} that will replace with action
     * Example: http://server.url:51528/Viewer/{action}
     */
    requestUrl: string;
    /**
     * Controller action that handle viewer initial request
     */
    action: string;
    /**
     * Properties that will transfer to controller action as JSON object
     */
    properties: any;
    /**
     * Viewer width
     */
    width: string;
    /**
     * Viewer height
     */
    height: string;
    /**
     * Viewer background color
     */
    backgroundColor: string;
    /**
     * Style of viewer applied to main span as [style]="style"
     */
    style: string;
    postParametersFunction: any;
    initialized: boolean;
    private viewInit;
    private dashboardDiv;
    constructor(controller: ControllerService, menuService: MenuService, model: ModelService, exportService: ExportService, formService: FormService, api: ApiService, printService: PrintService, dashboardService: DashboardService);
    ngOnDestroy(): void;
    ngOnChanges(changes: import('@angular/core').SimpleChanges): void;
    ngOnInit(): void;
    ngAfterViewInit(): void;
    initEvents(): void;
    loadViewer(): void;
    resize(): void;
    showTr(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StimulsoftViewerComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StimulsoftViewerComponent, "stimulsoft-viewer-angular", never, { "requestUrl": { "alias": "requestUrl"; "required": false; }; "action": { "alias": "action"; "required": false; }; "properties": { "alias": "properties"; "required": false; }; "width": { "alias": "width"; "required": false; }; "height": { "alias": "height"; "required": false; }; "backgroundColor": { "alias": "backgroundColor"; "required": false; }; "style": { "alias": "style"; "required": false; }; "postParametersFunction": { "alias": "postParametersFunction"; "required": false; }; }, { "loaded": "loaded"; "error": "error"; "export": "export"; "email": "email"; "print": "print"; "design": "design"; }, never, never, false, never>;
}
