import { ExportFormSettings, ExportComponent } from './objects';
import { FormService } from '../forms/form.service';
import { HelperService } from './helper.service';
import { ModelService } from './model.service';
import { CollectionsService } from './collections.service';
import { ControllerService } from './controller.service';
import { Observable } from 'rxjs';
import * as i0 from "@angular/core";
export declare class ExportService {
    formService: FormService;
    helper: HelperService;
    model: ModelService;
    collections: CollectionsService;
    controller: ControllerService;
    exportFormSettings: ExportFormSettings;
    exportSettings: any;
    format: string;
    sendMail: boolean;
    private subject;
    constructor(formService: FormService, helper: HelperService, model: ModelService, collections: CollectionsService, controller: ControllerService);
    getMessage(): Observable<any>;
    export(format: string, update?: boolean, sendMail?: boolean): void;
    postExport(): void;
    getExportSetings(update: boolean): ExportFormSettings;
    getComponents(names: string[]): ExportComponent[];
    getGroups(format: string): any;
    getStoredSettings(format?: string): any;
    getDefaultSettings(update: boolean): any;
    updateTypes(defaultExportSettings: any): void;
    getCommonExportFormat(format?: string): string;
    getDefaultExportSettings(format: string, isDashboardExport?: boolean): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<ExportService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ExportService>;
}
