import { ModelService } from './model.service';
import { ApiAngularService } from './api.angular.service';
import { ApiDashboardService } from './api.dashboard.service';
import * as i0 from "@angular/core";
export declare class ApiService implements ApiInterface {
    private angularService;
    private dashboardService;
    private model;
    EXPORT_FORMATS: string[];
    constructor(angularService: ApiAngularService, dashboardService: ApiDashboardService, model: ModelService);
    private get api();
    /**
     * The current page number
     */
    get currentPage(): number;
    set currentPage(value: number);
    /**
     * The total pages count
     */
    get pagesCount(): number;
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode(): string;
    set viewMode(value: string);
    /**
     * The page zoom in percent
     * From 1 to 200
     */
    get zoom(): number;
    set zoom(value: number);
    /**
     * Zoom page in height
     */
    zoomPageHeight(): void;
    /**
     * Zoom page in width
     */
    zoomPageWidth(): void;
    /**
     * Print to PDF
     */
    printPdf(): void;
    /**
     * Print with preview
     */
    printWithPreview(): void;
    /**
     * Print without preview
     */
    printWithoutPreview(): void;
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format: string): void;
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format: string): void;
    /**
     * Export report/dashboard to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format: string, settings?: any): void;
    /**
     * Refresh dashboard
     */
    dashboardRefresh(): void;
    /**
     * Reset all filters
     */
    dashboardResetAllFilters(): void;
    /**
     * Export report/dashboard to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format: string, settings?: any, email?: string, subject?: string, message?: string): void;
    /**
     * Report or Dashboard
     */
    get reportType(): string;
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text: string, matchCase: boolean, matchWholeWord: boolean): void;
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction: string): void;
    /**
     * Hide search
     */
    hideSearchLabels(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ApiService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ApiService>;
}
export interface ApiInterface {
    currentPage: number;
    pagesCount: number;
    viewMode: string;
    zoom: number;
    zoomPageHeight(): any;
    zoomPageWidth(): any;
    printPdf(): any;
    printWithPreview(): any;
    printWithoutPreview(): any;
    showExportForm(format: string): any;
    showExportEmailForm(format: string): any;
    export(format: string, settings?: any): any;
    exportEmail(format: string, settings?: any, email?: string, subject?: string, message?: string): any;
    search(text: string, matchCase: boolean, matchWholeWord: boolean): any;
    selectSearchLabel(direction: any): any;
    hideSearchLabels(): any;
    /**
     * Refresh dashboard
     */
    dashboardRefresh(): any;
    dashboardResetAllFilters(): any;
    /**
     * Report or Dashboard
     */
    get reportType(): string;
}
