import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import { ControllerService } from './services/controller.service';
import { MenuService } from './menu/menu.service';
import { ModelService } from './services/model.service';
import { ExportService } from './services/export.service';
import { FormService } from './forms/form.service';
import { ApiService } from './services/api.service';
import { PrintService } from './services/print.service';
import { DashboardService } from './services/dashboard.service';
import { StiHttpClientService } from './services/http-client.service';
import { StylesService } from './services/styles.service';
import { HelperService } from './services/helper.service';
import { MouseService } from './services/mouse.service';
import { PageService } from './services/page.service';
import { TooltipService } from './services/tooltip.service';
import { FindService } from './services/find.service';
import { AnimationService } from './services/animation.service';
import { InteractionsService } from './services/interactions.service';
import { RadioButtonService } from './services/radio-button.service';
import { CollectionsService } from './services/collections.service';
import { MailService } from './services/mail.service';
import { EditableFieldsService } from './services/editable-fields.service';
import { DrillDownService } from './services/drill-down.service';
import { Md5Service } from './services/md5.service';
import { FullScreenService } from './services/full-screen.service';
import { ToolbarService } from './services/toolbar.service';
import { DashboardProxyService } from './services/dashboard-proxy.service';
import { ApiDashboardService } from './services/api.dashboard.service';
import { ApiAngularService } from './services/api.angular.service';
import { FileSaverService } from './services/file.saver.service';
import * as i0 from "@angular/core";
import * as i1 from "./services/controller.service";
import * as i2 from "./menu/menu.service";
import * as i3 from "./services/model.service";
import * as i4 from "./services/export.service";
import * as i5 from "./forms/form.service";
import * as i6 from "./services/api.service";
import * as i7 from "./services/print.service";
import * as i8 from "./services/dashboard.service";
import * as i9 from "@angular/common";
import * as i10 from "./components/toolbar.component";
import * as i11 from "./components/report-panel.component";
import * as i12 from "./menu/menu.component";
import * as i13 from "./controls/tooltip.component";
import * as i14 from "./components/find-panel.component";
import * as i15 from "./components/bookmarks-panel.component";
import * as i16 from "./components/interactions-panel.component";
import * as i17 from "./forms/export-form.component";
import * as i18 from "./forms/send-email-form.component";
import * as i19 from "./components/drill-down-panel.component";
import * as i20 from "./components/open-dialog.component";
import * as i21 from "./forms/password-form.component";
import * as i22 from "./forms/error-message-form.component";
import * as i23 from "./components/resources-panel.component";
import * as i24 from "./components/progress.component";
import * as i25 from "./components/navigate-panel.component";
import * as i26 from "./components/about-panel.component";
import * as i27 from "./components/center-text.component";
import * as i28 from "./forms/notification-form.component";
import * as i29 from "./components/dashboards-panel.component";
//1bfb351c1add27b1537ffce9c723e3cb1f5b27bb 02.03.2021 17:29:20
export class StimulsoftViewerComponent {
    constructor(controller, menuService, model, exportService, formService, api, printService, dashboardService) {
        this.controller = controller;
        this.menuService = menuService;
        this.model = model;
        this.exportService = exportService;
        this.formService = formService;
        this.api = api;
        this.printService = printService;
        this.dashboardService = dashboardService;
        /**
         * Occurs when report/dashboard loaded
         */
        this.loaded = new EventEmitter();
        /**
         * Occurs on error, $event is ErrorMessage object contains error: string & type: any  (if present)
         */
        this.error = new EventEmitter();
        /**
         * Occurs on export, $event object contains exportFormat: string & exportSettings: {}
         */
        this.export = new EventEmitter();
        /**
         * Occurs on export & email, $event object contains exportFormat: string & exportSettings: {}
         */
        this.email = new EventEmitter();
        /**
         * Occurs on export & email, $event object contains format: string : 'PrintPdf' or 'PrintWithoutPreview' or 'PrintWithPreview'
         */
        this.print = new EventEmitter();
        /**
         * Occurs on pressing 'Design' button
         */
        this.design = new EventEmitter();
        /**
         * Controller action that handle viewer initial request
         */
        this.action = 'InitViewer';
        /**
         * Viewer background color
         */
        this.backgroundColor = 'White';
        this.initialized = false;
        this.viewInit = false;
        window.onresize = () => this.resize();
        this.initEvents();
    }
    ngOnDestroy() {
        try {
            clearInterval(this.model.timerAutoUpdateCache);
            clearInterval(this.model.refreshReportTimer);
        }
        catch { }
    }
    ngOnChanges(changes) {
        this.loadViewer();
    }
    ngOnInit() {
        this.model.postParametersFunction = this.postParametersFunction;
        this.controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'viewer_loaded':
                    this.initialized = true;
                    break;
                case 'ShowDashboard':
                    this.dashboardsElement.nativeElement.innerHTML = this.model.dashboards;
                    this.dashboardDiv = this.dashboardsElement.nativeElement.firstChild.firstChild;
                    this.viewerElement.nativeElement.appendChild(this.dashboardDiv);
                    this.dashboardsElement.nativeElement.style.display = 'none';
                    break;
            }
        });
    }
    ngAfterViewInit() {
        this.viewInit = true;
        this.loadViewer();
    }
    initEvents() {
        this.controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'OpenReport':
                case 'ShowDashboard':
                    setTimeout(() => {
                        this.loaded.next(null);
                    });
                    this.showTr();
                    break;
            }
        });
        this.controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Error':
                    setTimeout(() => {
                        this.error.next(this.model.errorMessage);
                    });
                    break;
                case 'ExportReport':
                    setTimeout(() => {
                        this.export.next(message.data);
                    });
                    break;
                case 'Email':
                    setTimeout(() => {
                        this.email.next(message.data);
                    });
                    break;
                case 'Print':
                    setTimeout(() => {
                        this.print.next(message.data);
                    });
                    break;
                case 'Design':
                    setTimeout(() => {
                        this.design.next(null);
                    });
                    break;
            }
            this.showTr();
        });
    }
    loadViewer() {
        if (this.viewInit) {
            if (this.dashboardDiv?.parentElement) {
                this.dashboardDiv?.parentElement.removeChild(this.dashboardDiv);
                this.dashboardDiv = null;
            }
            this.model.requestUrl = this.requestUrl;
            this.model.action = this.action || 'InitViewer';
            this.model.properties = this.properties;
            this.controller.loadViewer();
            this.resize();
            this.model.controls.viewer.el = this.viewerElement;
        }
    }
    resize() {
        if (this.viewerElement?.nativeElement) {
            this.model.viewerSize = { width: this.viewerElement.nativeElement.offsetWidth, height: this.viewerElement.nativeElement.offsetHeight };
            this.controller.viewerResized();
        }
    }
    showTr() {
        if (!this.model.options.alternateValid) {
            console.warn("You are using a trial version of the Stimulsoft product!");
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftViewerComponent, deps: [{ token: i1.ControllerService }, { token: i2.MenuService }, { token: i3.ModelService }, { token: i4.ExportService }, { token: i5.FormService }, { token: i6.ApiService }, { token: i7.PrintService }, { token: i8.DashboardService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StimulsoftViewerComponent, selector: "stimulsoft-viewer-angular", inputs: { requestUrl: "requestUrl", action: "action", properties: "properties", width: "width", height: "height", backgroundColor: "backgroundColor", style: "style", postParametersFunction: "postParametersFunction" }, outputs: { loaded: "loaded", error: "error", export: "export", email: "email", print: "print", design: "design" }, providers: [ModelService, StiHttpClientService, ControllerService, StylesService, HelperService, MenuService,
            MouseService, PageService, TooltipService, FindService, AnimationService, Md5Service, InteractionsService, FormService, RadioButtonService, ExportService,
            CollectionsService, MailService, EditableFieldsService, DrillDownService, PrintService, FullScreenService, ToolbarService, ApiService, DashboardService, DashboardProxyService,
            ApiDashboardService, ApiAngularService, FileSaverService], viewQueries: [{ propertyName: "dashboardsElement", first: true, predicate: ["dashboards"], descendants: true }, { propertyName: "viewerElement", first: true, predicate: ["viewer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <span #viewer [style]="style"
      [style.top.px]="0"
      [style.right.px]="0"
      [style.bottom.px]="0"
      [style.left.px]="0"
      [style.display]="'inline-block'"
      [style.backgroundColor]="backgroundColor"
      [style.width]="this.width != null ? this.width : '100%'"
      [style.height]="this.height != null ? this.height : (model.options?.appearance.scrollbarsMode ? '650px' : '100%')"
      [id]="model.options?.viewerId">
      <div class="stiJsViewerMainPanel" [style.display]="model.showDashboard ? 'none' : ''">
        <sti-center-text *ngIf="initialized"></sti-center-text>
        <sti-toolbar *ngIf="initialized"></sti-toolbar>
        <div *ngFor="let i of [1,2,3,4,5]" [style.zIndex]="i * 10" [style.display]="formService.form?.level == i ? '' : 'none'" class="stiJsViewerDisabledPanel"></div>
        <sti-about-panel *ngIf="initialized"></sti-about-panel>

        <sti-dashboards-panel *ngIf="initialized"></sti-dashboards-panel>
        <sti-report-panel *ngIf="initialized"></sti-report-panel>
        <sti-progress *ngIf="initialized"></sti-progress>
        <sti-find-panel *ngIf="initialized"></sti-find-panel>
        <sti-drill-down-panel *ngIf="initialized"></sti-drill-down-panel>
        <sti-resources-panel *ngIf="initialized"></sti-resources-panel>
        <sti-navigate-panel *ngIf="initialized"></sti-navigate-panel>

        <sti-export-form *ngIf="initialized" [exportFormSettings]="exportService.exportFormSettings"></sti-export-form>
        <sti-send-email-form *ngIf="initialized"></sti-send-email-form>
        <sti-password-form *ngIf="initialized"></sti-password-form>
        <sti-error-message-form *ngIf="initialized"></sti-error-message-form>
        <sti-notification-form *ngIf="initialized"></sti-notification-form>

        <sti-tooltip *ngIf="initialized"></sti-tooltip>
        <sti-menu *ngFor="let menu of menuService.menus" [menu]="menu"></sti-menu>
        <sti-bookmarks-panel *ngIf="initialized"></sti-bookmarks-panel>
        <sti-interactions-panel *ngIf="initialized"></sti-interactions-panel>

        <sti-open-dialog *ngIf="initialized" [fileMask]="model.openDialogFileMask"></sti-open-dialog>
      </div>
      <div #dashboards>
      </div>
    </span>
  `, isInline: true, dependencies: [{ kind: "directive", type: i9.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i9.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i10.ToolbarComponent, selector: "sti-toolbar" }, { kind: "component", type: i11.ReportPanelComponent, selector: "sti-report-panel" }, { kind: "component", type: i12.MenuComponent, selector: "sti-menu", inputs: ["menu"] }, { kind: "component", type: i13.TooltipComponent, selector: "sti-tooltip" }, { kind: "component", type: i14.FindPanelComponent, selector: "sti-find-panel" }, { kind: "component", type: i15.BookmarksPanelComponent, selector: "sti-bookmarks-panel" }, { kind: "component", type: i16.InteractionsPanelComponent, selector: "sti-interactions-panel" }, { kind: "component", type: i17.ExportFormComponent, selector: "sti-export-form", inputs: ["exportFormSettings"] }, { kind: "component", type: i18.SendEmailFormComponent, selector: "sti-send-email-form" }, { kind: "component", type: i19.DrillDownPanelComponent, selector: "sti-drill-down-panel" }, { kind: "component", type: i20.OpenDialogComponent, selector: "sti-open-dialog", inputs: ["fileMask"] }, { kind: "component", type: i21.PasswordFormComponent, selector: "sti-password-form" }, { kind: "component", type: i22.ErrorMessageFormComponent, selector: "sti-error-message-form" }, { kind: "component", type: i23.ResourcesPanelComponent, selector: "sti-resources-panel" }, { kind: "component", type: i24.ProgressComponent, selector: "sti-progress" }, { kind: "component", type: i25.NavigatePanelComponent, selector: "sti-navigate-panel" }, { kind: "component", type: i26.AboutPanelComponent, selector: "sti-about-panel" }, { kind: "component", type: i27.CenterTextComponent, selector: "sti-center-text" }, { kind: "component", type: i28.NotificationFormComponent, selector: "sti-notification-form" }, { kind: "component", type: i29.DashboardsPanelComponent, selector: "sti-dashboards-panel" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftViewerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'stimulsoft-viewer-angular',
                    template: `
    <span #viewer [style]="style"
      [style.top.px]="0"
      [style.right.px]="0"
      [style.bottom.px]="0"
      [style.left.px]="0"
      [style.display]="'inline-block'"
      [style.backgroundColor]="backgroundColor"
      [style.width]="this.width != null ? this.width : '100%'"
      [style.height]="this.height != null ? this.height : (model.options?.appearance.scrollbarsMode ? '650px' : '100%')"
      [id]="model.options?.viewerId">
      <div class="stiJsViewerMainPanel" [style.display]="model.showDashboard ? 'none' : ''">
        <sti-center-text *ngIf="initialized"></sti-center-text>
        <sti-toolbar *ngIf="initialized"></sti-toolbar>
        <div *ngFor="let i of [1,2,3,4,5]" [style.zIndex]="i * 10" [style.display]="formService.form?.level == i ? '' : 'none'" class="stiJsViewerDisabledPanel"></div>
        <sti-about-panel *ngIf="initialized"></sti-about-panel>

        <sti-dashboards-panel *ngIf="initialized"></sti-dashboards-panel>
        <sti-report-panel *ngIf="initialized"></sti-report-panel>
        <sti-progress *ngIf="initialized"></sti-progress>
        <sti-find-panel *ngIf="initialized"></sti-find-panel>
        <sti-drill-down-panel *ngIf="initialized"></sti-drill-down-panel>
        <sti-resources-panel *ngIf="initialized"></sti-resources-panel>
        <sti-navigate-panel *ngIf="initialized"></sti-navigate-panel>

        <sti-export-form *ngIf="initialized" [exportFormSettings]="exportService.exportFormSettings"></sti-export-form>
        <sti-send-email-form *ngIf="initialized"></sti-send-email-form>
        <sti-password-form *ngIf="initialized"></sti-password-form>
        <sti-error-message-form *ngIf="initialized"></sti-error-message-form>
        <sti-notification-form *ngIf="initialized"></sti-notification-form>

        <sti-tooltip *ngIf="initialized"></sti-tooltip>
        <sti-menu *ngFor="let menu of menuService.menus" [menu]="menu"></sti-menu>
        <sti-bookmarks-panel *ngIf="initialized"></sti-bookmarks-panel>
        <sti-interactions-panel *ngIf="initialized"></sti-interactions-panel>

        <sti-open-dialog *ngIf="initialized" [fileMask]="model.openDialogFileMask"></sti-open-dialog>
      </div>
      <div #dashboards>
      </div>
    </span>
  `,
                    providers: [ModelService, StiHttpClientService, ControllerService, StylesService, HelperService, MenuService,
                        MouseService, PageService, TooltipService, FindService, AnimationService, Md5Service, InteractionsService, FormService, RadioButtonService, ExportService,
                        CollectionsService, MailService, EditableFieldsService, DrillDownService, PrintService, FullScreenService, ToolbarService, ApiService, DashboardService, DashboardProxyService,
                        ApiDashboardService, ApiAngularService, FileSaverService]
                }]
        }], ctorParameters: () => [{ type: i1.ControllerService }, { type: i2.MenuService }, { type: i3.ModelService }, { type: i4.ExportService }, { type: i5.FormService }, { type: i6.ApiService }, { type: i7.PrintService }, { type: i8.DashboardService }], propDecorators: { dashboardsElement: [{
                type: ViewChild,
                args: ['dashboards']
            }], viewerElement: [{
                type: ViewChild,
                args: ['viewer']
            }], loaded: [{
                type: Output
            }], error: [{
                type: Output
            }], export: [{
                type: Output
            }], email: [{
                type: Output
            }], print: [{
                type: Output
            }], design: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], action: [{
                type: Input
            }], properties: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], backgroundColor: [{
                type: Input
            }], style: [{
                type: Input
            }], postParametersFunction: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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