import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "../menu/menu.service";
export class TooltipService {
    constructor(model, menuService) {
        this.model = model;
        this.menuService = menuService;
        this.state = 'initial';
        this.caption = '';
        this.helpLink = '';
        this.top = 0;
        this.left = 0;
        this.innerState = 'initial';
    }
    show(left, top, caption, below = true, helpLink) {
        if (this.menuService.isMenuVisible() || !this.model.options.appearance.showTooltips) {
            this.hideImmediately();
            return;
        }
        if (this.caption === caption && this.helpLink === helpLink && this.state !== 'initial') {
            this.showInternal();
            return;
        }
        this.caption = caption;
        this.helpLink = helpLink;
        this.state = this.innerState = this.state !== 'expanded' ? 'preInitial' : 'preInitial2';
        setTimeout(() => {
            const tooltip = this.model.controls.tooltip.el.nativeElement;
            const browserWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
            if (!below) {
                top -= tooltip.offsetHeight;
            }
            if (left + tooltip.offsetWidth > browserWidth) {
                left = browserWidth - tooltip.offsetWidth;
            }
            this.left = left;
            this.top = top;
            if (this.innerState !== 'initial') {
                this.showInternal();
            }
        });
    }
    showInternal() {
        this.state = 'expanded';
        this.innerState = 'expanded';
    }
    showFromTooltip() {
        if (this.state !== 'preInitial') {
            this.state = 'expanded';
            this.innerState = 'expanded';
        }
    }
    hideImmediately() {
        this.innerState = 'initial';
        this.state = 'initial';
    }
    hide() {
        this.innerState = 'initial';
        if (this.timeout) {
            clearTimeout(this.timeout);
        }
        this.timeout = setTimeout(() => {
            if (this.innerState === 'initial') {
                this.state = 'initial';
            }
            this.timeout = null;
        }, 1000);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TooltipService, deps: [{ token: i1.ModelService }, { token: i2.MenuService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TooltipService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TooltipService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.MenuService }] });
//# sourceMappingURL=data:application/json;base64,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