import { Injectable } from '@angular/core';
import { Rectangle } from './objects';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./helper.service";
export class PageService {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        Object.keys(model.controls).forEach(k => model.controls[k].pageService = this);
    }
    calculateLayout() {
        setTimeout(() => {
            this.calculateLayoutInner();
        });
    }
    calculateLayoutInner() {
        const reportLayout = new Rectangle();
        const paramsLayout = new Rectangle();
        if (!this.model.controls.reportPanel.el) {
            return reportLayout;
        }
        if (this.model.controls.dashboardsPanel.el) {
            reportLayout.top += this.model.controls.dashboardsPanel.offsetHeight;
        }
        if (this.model.reportParams.type === 'Report') {
            if (this.model.controls.toolbar && this.model.controls.toolbar.visible && !(this.model.options.isMobileDevice && this.model.options.toolbar.autoHide)) {
                reportLayout.top += this.model.controls.toolbar.offsetHeight;
            }
            if (this.model.controls.drillDownPanel && this.model.controls.drillDownPanel.visible) {
                reportLayout.top += this.model.controls.drillDownPanel.offsetHeight;
            }
            if (this.model.controls.findPanel && this.model.controls.findPanel.visible) {
                reportLayout.top += this.model.controls.findPanel.offsetHeight;
            }
            if (this.model.controls.resourcesPanel && this.model.controls.resourcesPanel.visible) {
                reportLayout.top += this.model.controls.resourcesPanel.offsetHeight;
            }
            if (this.model.controls.bookmarksPanel && this.model.controls.bookmarksPanel.visible) {
                reportLayout.left += this.model.options.appearance.bookmarksTreeWidth;
                if (this.model.options.toolbar.displayMode === 'Simple') {
                    reportLayout.left += 2;
                }
            }
            if (this.model.controls.navigatePanel && this.model.controls.navigatePanel.visible && !(this.model.options.isMobileDevice && this.model.options.toolbar.autoHide)) {
                reportLayout.bottom = this.model.controls.navigatePanel.offsetHeight;
            }
        }
        if (this.model.controls.parametersPanel && this.model.controls.parametersPanel.visible) {
            this.model.controls.parametersPanel.layout = paramsLayout;
            paramsLayout.top = reportLayout.top;
            if (this.model.options.appearance.currentParametersPanelPosition === 'Left') {
                paramsLayout.left = reportLayout.left;
                paramsLayout.width = this.model.controls.parametersPanel.el.nativeElement.firstChild.offsetWidth;
                reportLayout.left += paramsLayout.width;
                if (this.model.options.toolbar.displayMode === 'Simple') {
                    reportLayout.left += 2;
                }
            }
            if (this.model.options.appearance.currentParametersPanelPosition === 'Top') {
                paramsLayout.height = this.model.controls.parametersPanel.offsetHeight;
                reportLayout.top += paramsLayout.height;
            }
        }
        if (this.model.controls.bookmarksPanel) {
            // this.model.controls.bookmarksPanel.layout = new Rectangle();
            let styleTop = this.model.options.toolbar.visible ? this.model.controls.toolbar.offsetHeight : 0;
            if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
                styleTop = 0;
            }
            styleTop += this.model.controls.parametersPanel.exists && this.model.options.appearance.currentParametersPanelPosition === 'Top' ? this.model.controls.parametersPanel.offsetHeight : 0;
            styleTop += this.model.controls.findPanel.exists ? this.model.controls.findPanel.offsetHeight : 0;
            styleTop += this.model.controls.drillDownPanel.exists ? this.model.controls.drillDownPanel.offsetHeight : 0;
            styleTop += this.model.controls.resourcesPanel.exists ? this.model.controls.resourcesPanel.offsetHeight : 0;
            this.model.controls.bookmarksPanel.layout.top = styleTop; // reportLayout.top;
        }
        if (this.model.options.toolbar.displayMode === 'Simple' && reportLayout.top > 0) {
            reportLayout.top += 2;
        }
        if (this.model.controls.reportPanel.el?.nativeElement.style.position === 'relative') {
            reportLayout.top = paramsLayout.height;
        }
        const reportMargins = {
            top: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginTop ? this.model.controls.reportPanel.el.nativeElement.style.marginTop : 0),
            right: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginRight ? this.model.controls.reportPanel.el.nativeElement.style.marginRight : 0),
            bottom: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginBottom ? this.model.controls.reportPanel.el.nativeElement.style.marginBottom : 0),
            left: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginLeft ? this.model.controls.reportPanel.el.nativeElement.style.marginLeft : 0)
        };
        reportLayout.width = this.model.controls.reportPanel.offsetWidth - reportLayout.left - reportLayout.right + reportMargins.left + reportMargins.right;
        reportLayout.height = this.model.controls.reportPanel.el.nativeElement.style.position === 'absolute'
            ? this.model.controls.reportPanel.offsetHeight - reportLayout.top - reportLayout.bottom + reportMargins.top + reportMargins.bottom
            : Math.round(reportLayout.width * 0.56); // use 16:9 aspect ratio for automatic height
        this.model.controls.reportPanel.layout = reportLayout;
    }
    getZoomByPageWidth() {
        const pageNumber = this.model.reportParams.viewMode === 'SinglePage' ? 0 : (this.model.reportParams.pageNumber || 0);
        return (this.model.controls.reportPanel.layout.width - 40) * this.getZoom() / (this.model.pages[pageNumber]?.page?.offsetWidth || 1);
    }
    getZoomByPageHeight() {
        const pageNumber = this.model.reportParams.viewMode === 'SinglePage' ? 0 : (this.model.reportParams.pageNumber || 0);
        return (this.model.controls.reportPanel.layout.height - 40) * this.getZoom() / (this.model.pages[pageNumber]?.page?.offsetHeight || 1);
    }
    getZoom() {
        return this.model.reportParams.zoom < 0 ? 100 : this.model.reportParams.zoom;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageService, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.HelperService }] });
//# sourceMappingURL=data:application/json;base64,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