import { Injectable } from '@angular/core';
import { ControlClass } from './objects';
import * as i0 from "@angular/core";
export class ModelService {
    constructor() {
        this._reportParams = {};
        this.showDashboard = false;
        this.controls = new ControlClass();
        this.pages = [];
        this.months = [];
        this.dayOfWeek = [];
        this.dateRanges = [];
        this.encodingData = [];
        this.pdfSecurityCertificates = [];
        this.paperSizes = [];
        this.drillDownButtons = [];
        this.showProgress = false;
    }
    get reportParams() {
        return this._reportParams;
    }
    set reportParams(parameters) {
        this._reportParams.pagesArray = parameters.pagesArray;
        // Apply new report parameters, if not update current page
        if (parameters.action && parameters.action !== 'GetPages') {
            this.reportParams.type = parameters.reportType;
            this.reportParams.drillDownGuid = parameters.drillDownGuid;
            this.reportParams.dashboardDrillDownGuid = parameters.dashboardDrillDownGuid;
            this.reportParams.pagesCount = parameters.pagesCount;
            if (parameters.pageNumber != null) {
                this.reportParams.pageNumber = parameters.pageNumber;
            }
            this.reportParams.zoom = parameters.zoom;
            this.reportParams.viewMode = parameters.viewMode;
            this.reportParams.reportFileName = parameters.reportFileName;
            this.reportParams.collapsingStates = parameters.collapsingStates;
            if (parameters.bookmarksContent) {
                this.reportParams.bookmarksContent = parameters.bookmarksContent;
            }
            if (parameters.resources) {
                this.reportParams.resources = parameters.resources;
            }
            this.reportParams.isCompilationMode = parameters.isCompilationMode;
            if (parameters.variablesValues) {
                this.reportParams.variablesValues = parameters.variablesValues;
            }
            if (parameters.parametersDateFormat) {
                this.options.appearance.parametersPanelDateFormat = parameters.parametersDateFormat;
            }
            if (parameters.tableOfContentsPointers)
                this.reportParams.tableOfContentsPointers = parameters.tableOfContentsPointers;
            this.reportParams.isEditableReport = parameters.isEditableReport;
            if (parameters.userValues) {
                this.options.userValues = parameters.userValues;
            }
            this.reportParams.dashboards = parameters.dashboards;
            this.reportParams.previewSettings = parameters.previewSettings;
        }
    }
    setReportParams(parameters) {
        this._reportParams = parameters;
    }
    getReportParams() {
        return this.copyObject(this._reportParams);
    }
    copyObject(o) {
        if (!o || 'object' !== typeof o) {
            return o;
        }
        const c = 'function' === typeof o.pop ? [] : {};
        let p;
        let v;
        for (p in o) {
            if (o.hasOwnProperty(p) && p !== 'pagesArray') {
                v = o[p];
                if (v && 'object' === typeof v) {
                    c[p] = this.copyObject(v);
                }
                else {
                    c[p] = v;
                }
            }
        }
        return c;
    }
    set options(data) {
        this._options = this.toLower(data.options);
        if (data.jsOptions) {
            for (const key in data.jsOptions) {
                if (data.jsOptions.hasOwnProperty(key)) {
                    this._options[key] = data.jsOptions[key];
                }
            }
        }
        if (data.defaultSettings?.StiExcelExportSettings?.ExcelType != null) {
            let excelType = data.defaultSettings.StiExcelExportSettings.ExcelType;
            if (excelType == 'Excel2007') {
                excelType = 'Excel';
            }
            else if (excelType == 'ExcelBinary') {
                excelType = 'ExcelBiff';
            }
            data.defaultSettings.StiExcelExportSettings.ExcelType = excelType;
        }
        this._options.exports.defaultSettings = data.defaultSettings;
        this.localization = data.loc;
        this.months = data.months;
        this.dayOfWeek = data.dayOfWeek;
        this.images = data.images;
        this.dateRanges = data.dateRanges;
        this.paperSizes = data.paperSizes;
        this.encodingData = data.encodingData;
        this.pdfSecurityCertificates = data.pdfSecurityCertificates;
        this.clearViewerState();
        this.setupOptions();
    }
    get options() {
        return this._options;
    }
    loc(attr) {
        return this.localization[attr] ?? attr;
    }
    img(name) {
        if (name != null && name.length > 0 && !this.images[name]) {
            //console.warn(`Image: ${name} not found`);
        }
        return this.images[name] ?? '';
    }
    toLower(obj) {
        const result = {};
        Object.keys(obj).forEach(key => {
            result[key.substr(0, 1).toLowerCase() + key.substr(1)] = (typeof (obj[key]) === 'object' && obj[key] !== null) ? this.toLower(obj[key]) : obj[key];
        });
        return result;
    }
    clear() {
        this._options = undefined;
        this._reportParams = {};
        this._imagesForBookmark = undefined;
        this.pages = [];
        this.form = null;
    }
    clearViewerState() {
        this.reportParams = {};
        this.reportParams.type = 'Auto';
        this.reportParams.pageNumber = 0;
        this.reportParams.originalPageNumber = 0;
        this.reportParams.drillDownGuid = null;
        this.reportParams.dashboardDrillDownGuid = null;
        this.reportParams.collapsingStates = null;
        this.reportParams.bookmarksContent = null;
        this.reportParams.editableParameters = null;
        this.reportParams.resources = null;
        this.reportParams.drillDownParameters = [];
        this.reportParams.elementName = null;
        this.reportParams.variablesValues = null;
        this.reportParams.tableOfContentsPointers = [];
        this.reportParams.isEditableReport = false;
        //this.options.viewerId = this.newToken();
        this.options.clientGuid = this.newToken();
        this.options.paramsVariables = null;
        this.options.multiFilterStates = null;
        this.options.isParametersReceived = false;
        this.options.drillDownInProgress = false;
        this.options.displayModeFromReport = null;
        this.options.currentParameterWidth = null;
        this.options.currentParameterAlignment = "Left";
        // this.controls.mainPanel.style.background = '';
        // this.tableElementGridStates = {};
        // Restore current page number, if reload current report
        if (this.reportParams.prevPageNumber) {
            this.reportParams.pageNumber = this.reportParams.prevPageNumber;
            delete this.reportParams.prevPageNumber;
        }
        this.fullScreenOptions = null;
        this.drillDownButtons = [];
        this.controls.parametersPanel.visible = false;
        this.controls.bookmarksPanel.visible = false;
        this.interactions = null;
        /*
        this.controls.drillDownPanel.visible = false;
        this.controls.findPanel.visible = false;
        this.controls.parametersPanel.visible = false;
        this.controls.resourcesPanel.visible = false;*/
    }
    style(value) {
        return value !== '' && value != null ? value : '';
    }
    createPostParameters(data, asObject = true, useOptions = true) {
        let params;
        // Object params
        const postParams = {
            stiweb_component: 'Viewer',
            stiweb_imagesScalingFactor: this.getImagesScalingFactor()
        };
        if (this.properties) {
            postParams['properties'] = this.encode(JSON.stringify(this.properties));
        }
        if (this.options && useOptions) {
            params = {
                viewerId: this.options.viewerId,
                routes: this.options.routes,
                formValues: this.options.formValues,
                clientGuid: this.options.clientGuid,
                drillDownGuid: this.reportParams.drillDownGuid,
                dashboardDrillDownGuid: this.reportParams.dashboardDrillDownGuid,
                cacheMode: this.options.server.cacheMode,
                cacheTimeout: this.options.server.cacheTimeout,
                cacheItemPriority: this.options.server.cacheItemPriority,
                pageNumber: this.reportParams.pageNumber,
                originalPageNumber: this.reportParams.originalPageNumber,
                reportType: this.reportParams.type,
                zoom: (this.reportParams.zoom && this.reportParams.zoom > 0) ? this.reportParams.zoom : (this.options?.toolbar?.zoom > 0 ? this.options?.toolbar?.zoom : 100),
                viewMode: this.reportParams.viewMode || this.options.toolbar.viewMode,
                multiPageWidthCount: this.reportParams.multiPageWidthCount,
                multiPageHeightCount: this.reportParams.multiPageHeightCount,
                multiPageContainerWidth: this.reportParams.multiPageContainerWidth,
                multiPageContainerHeight: this.reportParams.multiPageContainerHeight,
                multiPageMargins: this.reportParams.multiPageMargins,
                showBookmarks: this.options.toolbar.showBookmarksButton,
                openLinksWindow: this.options.appearance.openLinksWindow,
                chartRenderType: this.options.appearance.chartRenderType,
                reportDisplayMode: (this.options.displayModeFromReport || this.options.appearance.reportDisplayMode),
                drillDownParameters: this.reportParams.drillDownParameters,
                editableParameters: this.reportParams.editableParameters,
                useRelativeUrls: this.options.server.useRelativeUrls,
                passQueryParametersForResources: this.options.server.passQueryParametersForResources,
                passQueryParametersToReport: this.options.server.passQueryParametersToReport,
                version: this.options.shortProductVersion,
                reportDesignerMode: this.options.reportDesignerMode,
                imagesQuality: this.options.appearance.imagesQuality,
                parametersPanelSortDataItems: this.options.appearance.parametersPanelSortDataItems,
                combineReportPages: this.options.appearance.combineReportPages,
                isAngular: true,
                CSPNonce: this.options.cSPNonce,
                allowAutoUpdateCookies: this.options.server.allowAutoUpdateCookies
            };
            if (this.options.server.useLocalizedCache && this.options.localization) {
                params['useLocalizedCache'] = true;
                params['localization'] = this.options.localization;
            }
            if (this.options.userValues) {
                params['userValues'] = this.options.userValues;
            }
        }
        else {
            params = {};
        }
        if (data) {
            Object.keys(data).forEach(key => params[key] = data[key]);
        }
        // Object params
        if (params.action) {
            postParams['stiweb_action'] = params.action;
            delete params.action;
        }
        if (data?.viewerRequestUrl) {
            postParams['stiweb_viewerRequestUrl'] = data.viewerRequestUrl;
        }
        if (params.base64Data) {
            postParams['stiweb_data'] = params.base64Data;
            delete params.base64Data;
        }
        if (this.options && useOptions) {
            // Params
            const jsonParams = JSON.stringify(params);
            if (this.options.server.useCompression) {
                // postParams['stiweb_packed_parameters'] = StiGZipHelper.pack(jsonParams);
                postParams['stiweb_parameters'] = this.encode(jsonParams);
            }
            else {
                postParams['stiweb_parameters'] = this.encode(jsonParams);
            }
        }
        if (this.postParametersFunction) {
            let postParamsF = this.postParametersFunction(data);
            if (postParamsF) {
                Object.keys(postParamsF).forEach(key => postParams[key] = postParamsF[key]);
            }
        }
        if (asObject) {
            return postParams;
        }
    }
    newToken() {
        const a = '1234567890abcdefghijklmnopqrstuvwxyz'.split('');
        const b = [];
        const length = 32;
        b[0] = "s";
        for (let i = 1; i < length; i++) {
            const j = (Math.random() * (a.length - 1)).toFixed(0);
            b[i] = a[j];
        }
        return b.join('');
    }
    setupOptions() {
        if (!this.options.exports.showExportToPowerPoint && !this.options.exports.showExportToPdf && !this.options.exports.showExportToXps &&
            !this.options.exports.showExportToOpenDocumentWriter && !this.options.exports.showExportToOpenDocumentCalc && !this.options.exports.showExportToText &&
            !this.options.exports.showExportToRtf && !this.options.exports.showExportToWord && !this.options.exports.showExportToCsv && !this.options.exports.showExportToJson &&
            !this.options.exports.showExportToDbf && !this.options.exports.showExportToXml && !this.options.exports.showExportToDif && !this.options.exports.showExportToSylk &&
            !this.options.exports.showExportToExcelBiff && !this.options.exports.showExportToExcel && !this.options.exports.showExportToExcelXml && !this.options.exports.showExportToHtml &&
            !this.options.exports.showExportToHtml5 && !this.options.exports.showExportToMht && !this.options.exports.showExportToImageBmp && !this.options.exports.showExportToImageGif &&
            !this.options.exports.showExportToImageJpeg && !this.options.exports.showExportToImageMetafile && !this.options.exports.showExportToImagePcx &&
            !this.options.exports.showExportToImagePng && !this.options.exports.showExportToImageTiff && !this.options.exports.showExportToImageSvg && !this.options.exports.showExportToImageSvgz) {
            if (!this.options.exports.showExportToDocument) {
                this.options.toolbar.showSaveButton = false;
            }
            this.options.toolbar.showSendEmailButton = false;
        }
        // Options
        this.options.isTouchDevice = this.options.appearance.interfaceType === 'Auto'
            ? this.isTouchDevice() && this.isMobileDevice()
            : this.options.appearance.interfaceType === 'Touch';
        this.options.isMobileDevice = this.options.appearance.interfaceType === 'Auto' && !this.options.reportDesignerMode
            ? this.isTouchDevice() && this.isMobileDevice()
            : this.options.appearance.interfaceType === 'Mobile';
        if (this.options.isMobileDevice) {
            this.initializeMobile();
        }
        else {
            this.options.toolbar.showPinToolbarButton = false;
        }
        this.options.menuAnimDuration = 150;
        this.options.formAnimDuration = 200;
        this.options.scrollDuration = 350;
        this.options.menuHideDelay = 250;
        this.options.server.timeoutAutoUpdateCache = 180000;
        this.options.toolbar.backgroundColor = this.getHTMLColor(this.options.toolbar.backgroundColor);
        this.options.toolbar.borderColor = this.getHTMLColor(this.options.toolbar.borderColor);
        this.options.toolbar.fontColor = this.getHTMLColor(this.options.toolbar.fontColor);
        this.options.appearance.pageBorderColor = this.getHTMLColor(this.options.appearance.pageBorderColor);
        this.options.parametersValues = {};
        this.options.parameterRowHeight = this.options.isTouchDevice ? 35 : 30;
        // First Day Of Week
        if (this.options.appearance.datePickerFirstDayOfWeek === 'Sunday') {
            this.dayOfWeek.splice(6, 1);
            this.dayOfWeek.splice(0, 0, 'Sunday');
        }
        if (this.options?.toolbar?.zoom === -1 || this.options?.toolbar?.zoom === -2) {
            this.reportParams.autoZoom = this.options?.toolbar?.zoom;
        }
        // Actions
        if (!this.options.actions.getReport) {
            this.options.actions.getReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.printReport) {
            this.options.actions.printReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.openReport) {
            this.options.actions.openReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.exportReport) {
            this.options.actions.exportReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.interaction) {
            this.options.actions.interaction = this.options.actions.viewerEvent;
        }
        if (!(window.File && window.FileReader && window.FileList && window.Blob)) {
            this.options.toolbar.showOpenButton = false;
        }
        // Render JsViewer styles into HEAD
        if (this.options.requestResourcesUrl || this.options.appearance.customStylesUrl) {
            const viewerStyles = document.createElement('link');
            viewerStyles.setAttribute('type', 'text/css');
            viewerStyles.setAttribute('rel', 'stylesheet');
            viewerStyles.setAttribute('href', this.options.appearance.customStylesUrl || this.getResourceUrl('styles'));
            this.controls.head.appendChild(viewerStyles);
        }
        this.options.viewerId = this.options.viewerId || this.newToken();
    }
    pagesNavigationIsActive() {
        return (this.options.appearance.fullScreenMode || this.options.appearance.scrollbarsMode) && this.reportParams.viewMode === 'Continuous';
    }
    get imagesForBookmark() {
        if (!this._imagesForBookmark) {
            const names = ['root', 'folder', 'folderOpen', 'node', 'empty', 'line', 'join', 'joinBottom', 'plus', 'plusBottom', 'minus', 'minusBottom'];
            const imagesForBookmarks = {};
            names.forEach(name => imagesForBookmarks[name] = this.images['Bookmarks' + name + '.png']);
            this._imagesForBookmark = imagesForBookmarks;
        }
        return this._imagesForBookmark;
    }
    isTouchDevice() {
        return ('ontouchstart' in document.documentElement);
    }
    isMobileDevice() {
        return /iPhone|iPad|iPod|Macintosh|Android|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }
    initializeMobile() {
        let isViewPortExist = false;
        const metas = this.controls.head.getElementsByTagName('meta');
        for (const meta of metas) {
            if (meta.name && meta.name.toLowerCase() === 'viewport') {
                isViewPortExist = true;
                break;
            }
        }
        if (!isViewPortExist) {
            const viewPortTag = document.createElement('meta');
            viewPortTag.id = 'viewport';
            viewPortTag.name = 'viewport';
            viewPortTag.content = 'initial-scale=1.0,width=device-width,user-scalable=0';
            this.controls.head.appendChild(viewPortTag);
        }
        this.options.appearance.fullScreenMode = true;
        this.options.appearance.scrollbarsMode = true;
        this.options.appearance.currentParametersPanelPosition = 'Left';
        this.options.appearance.parametersPanelPosition = 'Left';
        this.options.appearance.parametersPanelColumnsCount = 1;
        this.options.toolbar.displayMode = 'Separated';
        this.options.toolbar.viewMode = 'SinglePage';
        this.options.toolbar.showZoomButton = false;
        const defaultZoom = this.options.toolbar.zoom === -2 ? -2 : -1; // PageWidth or PageHeight
        this.options.toolbar.zoom = this.reportParams.zoom = defaultZoom;
        this.options.toolbar.showButtonCaptions = false;
        this.options.toolbar.showOpenButton = false;
        this.options.toolbar.showFindButton = false;
        this.options.toolbar.showEditorButton = false;
        this.options.toolbar.showFullScreenButton = false;
        this.options.toolbar.showAboutButton = false;
        this.options.toolbar.showViewModeButton = false;
    }
    getImagesScalingFactor() {
        const wnd = window;
        const devicePixelRatio = window.devicePixelRatio || (wnd.deviceXDPI && wnd.logicalXDPI ? wnd.deviceXDPI / wnd.logicalXDPI : 1);
        if (!devicePixelRatio || devicePixelRatio <= 1) {
            return '1';
        }
        else {
            return devicePixelRatio.toString();
        }
    }
    getHTMLColor(color) {
        if (color.indexOf(',') > 0 && color.indexOf('rgb') < 0) {
            return `rgb(${color})`;
        }
        return color;
    }
    getResourceUrl(resourceParameter) {
        let url = this.getActionRequestUrl(this.options.requestResourcesUrl, this.options.actions.viewerEvent);
        url += url.indexOf('?') > 0 ? '&' : '?';
        url += 'stiweb_component=Viewer&stiweb_action=Resource&stiweb_data=' + resourceParameter + '&stiweb_theme=' + this.options.theme;
        url += '&stiweb_cachemode=' + (this.options.server.useCacheForResources
            ? this.options.server.cacheMode === 'ObjectSession' || this.options.server.cacheMode === 'StringSession'
                ? 'session'
                : 'cache'
            : 'none');
        url += '&stiweb_version=' + this.options.shortProductVersion;
        return url;
    }
    getActionRequestUrl(requestUrl, action) {
        if (!action) {
            return requestUrl;
        }
        if (action.indexOf('?') < 0) {
            return requestUrl.replace('{action}', action);
        }
        const query = action.substring(action.indexOf('?') + 1);
        action = action.substring(0, action.indexOf('?'));
        return requestUrl.replace('{action}', action) + (requestUrl.indexOf('?') > 0 ? '&' : '?') + query;
    }
    encode(input) {
        // Decode from UTF-8 text
        if (typeof unescape != 'undefined') {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != 'undefined')
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output = output +
                this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
                this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }
        return output;
    }
    decode(input) {
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != 'undefined') {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != 'undefined')
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ModelService, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ModelService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ModelService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [] });
//# sourceMappingURL=data:application/json;base64,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