import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./page.service";
export class FullScreenService {
    constructor(model, pageService) {
        this.model = model;
        this.pageService = pageService;
    }
    changeFullScreenMode(fullScreenMode) {
        this.model.options.appearance.fullScreenMode = fullScreenMode;
        const viewer = this.model.controls.viewer.el.nativeElement;
        if (fullScreenMode) {
            this.model.fullScreenOptions = {
                scrollbarsMode: this.model.options.appearance.scrollbarsMode,
                zIndex: viewer.style.zIndex,
                position: viewer.style.position,
                width: viewer.style.width,
                height: viewer.style.height,
                overflow: document.body.style.overflow
            };
            this.model.options.appearance.scrollbarsMode = true;
            viewer.style.zIndex = '1000000';
            viewer.style.position = this.model.options.reportDesignerMode ? 'absolute' : 'fixed';
            viewer.style.width = null;
            viewer.style.height = null;
            document.body.style.overflow = 'hidden';
        }
        else if (this.model.fullScreenOptions) {
            this.model.options.appearance.scrollbarsMode = this.model.fullScreenOptions.scrollbarsMode;
            viewer.style.zIndex = this.model.fullScreenOptions.zIndex;
            viewer.style.position = this.model.fullScreenOptions.position;
            viewer.style.width = this.model.fullScreenOptions.width;
            viewer.style.height = this.model.fullScreenOptions.height;
            document.body.style.overflow = this.model.fullScreenOptions.overflow;
            this.model.fullScreenOptions = null;
        }
        this.pageService.calculateLayout();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FullScreenService, deps: [{ token: i1.ModelService }, { token: i2.PageService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FullScreenService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FullScreenService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.PageService }] });
//# sourceMappingURL=data:application/json;base64,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