import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class FileSaverService {
    constructor() {
        this._global = typeof window === 'object' && window.window === window
            ? window : typeof self === 'object' && self.self === self
            ? self : /*typeof global === 'object' && global.global === global
          ? global
          : */
            this;
        // Detect WebView inside a native macOS app by ruling out all browsers
        // We just need to check for 'Safari' because all other browsers (besides Firefox) include that too
        // https://www.whatismybrowser.com/guides/the-latest-user-agent/macos
        this.isMacOSWebView = this._global.navigator && /Macintosh/.test(navigator.userAgent) && /AppleWebKit/.test(navigator.userAgent) && !/Safari/.test(navigator.userAgent);
        this.saveAs = this._global.saveAs || (
        // probably in some web worker
        (typeof window !== 'object' || window !== this._global)
            ? function saveAs() { }
            // Use download attribute first if possible (#193 Lumia mobile) unless this is a macOS WebView
            : ('download' in HTMLAnchorElement.prototype && !this.isMacOSWebView)
                ? function saveAs(blob, name, opts) {
                    let URL = this._global.URL || this._global.webkitURL;
                    let a = document.createElement('a');
                    name = name || blob.name || 'download';
                    a.download = name;
                    a.rel = 'noopener'; // tabnabbing
                    // TODO: detect chrome extensions & packaged apps
                    // a.target = '_blank'
                    if (typeof blob === 'string') {
                        // Support regular links
                        a.href = blob;
                        if (a.origin !== location.origin) {
                            this.corsEnabled(a.href)
                                ? this.download(blob, name, opts)
                                : this.click(a, a.target = '_blank');
                        }
                        else {
                            this.click(a);
                        }
                    }
                    else {
                        // Support blobs
                        a.href = URL.createObjectURL(blob);
                        let this_ = this;
                        setTimeout(function () { URL.revokeObjectURL(a.href); }, 4E4); // 40s
                        setTimeout(function () { this_.click(a); }, 0);
                    }
                }
                // Use msSaveOrOpenBlob as a second approach
                : 'msSaveOrOpenBlob' in navigator
                    ? function saveAs(blob, name, opts) {
                        name = name || blob.name || 'download';
                        if (typeof blob === 'string') {
                            if (this.corsEnabled(blob)) {
                                this.download(blob, name, opts);
                            }
                            else {
                                let a = document.createElement('a');
                                a.href = blob;
                                a.target = '_blank';
                                let this_ = this;
                                setTimeout(function () { this_.click(a); });
                            }
                        }
                        else {
                            navigator.msSaveOrOpenBlob(this.bom(blob, opts), name);
                        }
                    }
                    // Fallback to using FileReader and a popup
                    : function saveAs(blob, name, opts, popup) {
                        // Open a popup immediately do go around popup blocker
                        // Mostly only available on user interaction and the fileReader is async so...
                        popup = popup || open('', '_blank');
                        if (popup) {
                            popup.document.title =
                                popup.document.body.innerText = 'downloading...';
                        }
                        if (typeof blob === 'string')
                            return this.download(blob, name, opts);
                        let force = blob.type === 'application/octet-stream';
                        let isSafari = /constructor/i.test(this._global.HTMLElement) || this._global.safari;
                        let isChromeIOS = /CriOS\/[\d]+/.test(navigator.userAgent);
                        if ((isChromeIOS || (force && isSafari) || this.isMacOSWebView) && typeof FileReader !== 'undefined') {
                            // Safari doesn't allow downloading of blob URLs
                            let reader = new FileReader();
                            reader.onloadend = function () {
                                let url = reader.result;
                                url = isChromeIOS ? url : url.replace(/^data:[^;]*;/, 'data:attachment/file;');
                                if (popup)
                                    popup.location.href = url;
                                else
                                    location = url;
                                popup = null; // reverse-tabnabbing #460
                            };
                            reader.readAsDataURL(blob);
                        }
                        else {
                            let URL = this._global.URL || this._global.webkitURL;
                            let url = URL.createObjectURL(blob);
                            if (popup)
                                popup.location = url;
                            else
                                location.href = url;
                            popup = null; // reverse-tabnabbing #460
                            setTimeout(function () { URL.revokeObjectURL(url); }, 4E4); // 40s
                        }
                    });
        this._global.saveAs = this.saveAs.saveAs = this.saveAs;
        /*if (typeof module !== 'undefined') {
          module.exports = this.saveAs;
        }*/
    }
    bom(blob, opts) {
        if (typeof opts === 'undefined')
            opts = { autoBom: false };
        else if (typeof opts !== 'object') {
            console.warn('Deprecated: Expected third argument to be a object');
            opts = { autoBom: !opts };
        }
        // prepend BOM for UTF-8 XML and text/* types (including HTML)
        // note: your browser will automatically convert UTF-16 U+FEFF to EF BB BF
        if (opts.autoBom && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(blob.type)) {
            return new Blob([String.fromCharCode(0xFEFF), blob], { type: blob.type });
        }
        return blob;
    }
    download(url, name, opts) {
        let xhr = new XMLHttpRequest();
        xhr.open('GET', url);
        xhr.responseType = 'blob';
        let this_ = this;
        xhr.onload = function () {
            this_.saveAs(xhr.response, name, opts);
        };
        xhr.onerror = function () {
            console.error('could not download file');
        };
        xhr.send();
    }
    corsEnabled(url) {
        let xhr = new XMLHttpRequest();
        // use sync to avoid popup blocker
        xhr.open('HEAD', url, false);
        try {
            xhr.send();
        }
        catch (e) { }
        return xhr.status >= 200 && xhr.status <= 299;
    }
    // `a.click()` doesn't work for all browsers (#465)
    click(node) {
        try {
            node.dispatchEvent(new MouseEvent('click'));
        }
        catch (e) {
            let evt = document.createEvent('MouseEvents');
            evt.initMouseEvent('click', true, true, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null);
            node.dispatchEvent(evt);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FileSaverService, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FileSaverService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FileSaverService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [] });
//# sourceMappingURL=data:application/json;base64,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