import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./controller.service";
import * as i2 from "./model.service";
import * as i3 from "./helper.service";
export class DrillDownService {
    constructor(controller, model, helper) {
        this.controller = controller;
        this.model = model;
        this.helper = helper;
        controller.getMessage().subscribe((message) => {
            if (message.action !== 'InitVars' && message.action !== 'viewer_loaded') {
                this.model.options.drillDownInProgress = false;
                const parameters = message.data;
                if (this.model.drillDownButtons.length === 0) {
                    this.addButton(parameters.reportFileName, {});
                }
                if (message.action === 'DrillDown') {
                    const useDbsDrillDownPanel = false; // jsObject.controls.dashboardsPanel && jsObject.controls.dashboardsPanel.visible && jsObject.controls.dashboardsPanel.selectedButton;
                    if (useDbsDrillDownPanel) {
                        // jsObject.controls.dashboardsPanel.addDrillDownButton(null, parameters.drillDownGuid, parameters.drillDownParameters, parameters.previewSettings, parameters.reportFileName);
                    }
                    this.showDrillDownPage(parameters.reportFileName, parameters.drillDownGuid, parameters.drillDownParameters, useDbsDrillDownPanel);
                }
            }
        });
    }
    showDrillDownPage(reportFileName, drillDownGuid, drillDownParameters, useDbsDrillDownPanel) {
        if (useDbsDrillDownPanel) {
            return;
        }
        let buttonExist = false;
        this.model.drillDownButtons.forEach((b) => {
            if (b.reportParams.drillDownGuid === drillDownGuid) {
                this.model.drillDownButtons.forEach(bt => bt.selected = false);
                buttonExist = b.selected = b.visible = true;
                this.model.reportParams.drillDownParameters = b.reportParams.drillDownParameters;
            }
        });
        if (!buttonExist) {
            this.addButton(reportFileName);
            this.model.reportParams.drillDownParameters = drillDownParameters;
            this.model.reportParams.pageNumber = 0;
            this.model.reportParams.pagesWidth = 0;
            this.model.reportParams.pagesHeight = 0;
        }
    }
    addButton(caption, reportParams = {}) {
        this.model.drillDownButtons.forEach(b => b.selected = false);
        this.model.drillDownButtons.push({ caption, selected: true, reportParams, visible: true });
        this.updateVisibility();
    }
    updateVisibility() {
        this.model.controls.drillDownPanel.visible = this.model.drillDownButtons.length > 1;
    }
    saveState() {
        const sButton = this.model.drillDownButtons.find(b => b.selected);
        if (sButton) {
            sButton.reportParams = this.model.getReportParams();
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DrillDownService, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DrillDownService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DrillDownService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.HelperService }] });
//# sourceMappingURL=data:application/json;base64,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