import { Injectable } from '@angular/core';
import { catchError, EMPTY } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./model.service";
import * as i3 from "./controller.service";
import * as i4 from "./file.saver.service";
export class DashboardProxyService {
    constructor(httpClient, model, controller, fileSaver) {
        this.httpClient = httpClient;
        this.model = model;
        this.controller = controller;
        this.fileSaver = fileSaver;
        this.openReport = false;
    }
    createConnection() {
        let request = new Object();
        request.method = "POST";
        request.url = "";
        request.headers = {};
        request.responseType = "text";
        request.readyState = 1;
        request.status = 0;
        request.responseText = null;
        request.statusText = null;
        request.id = null;
        request.open = (method, url) => {
            request.method = method;
            request.url = url;
        };
        request.setRequestHeader = (key, value) => {
            request.headers[key] = value;
        };
        request.abort = () => {
        };
        request.onreadystatechange = () => { };
        request.send = (data) => {
            let formData;
            if (typeof data == 'object') {
                if (this.model.properties) {
                    data['properties'] = this.model.encode(JSON.stringify(this.model.properties));
                }
                if (this.model.postParametersFunction) {
                    let postParamsF = this.model.postParametersFunction(data);
                    if (postParamsF) {
                        Object.keys(postParamsF).forEach(key => data[key] = postParamsF[key]);
                    }
                }
                formData = new FormData();
                Object.keys(data).forEach(key => formData.append(key, data[key]));
            }
            let observable = this.httpClient.post(request.url, formData ?? data, { responseType: request.responseType }).pipe(catchError((error) => {
                alert(JSON.stringify(error));
                request.status = error.status;
                request.statusText = error.statusText;
                request.responseText = error.error;
                request.readyState = 4;
                request.onreadystatechange();
                return EMPTY;
            }));
            observable.subscribe(data => {
                request.readyState = 4;
                if (request.responseType == "text")
                    request.responseText = data;
                else
                    request.response = data;
                request.status = 200;
                request.onreadystatechange();
                if (typeof data == 'string' && data.indexOf('{"images"') == 0 && this.model.proxyData != null) {
                    this.jsObject.options.reportDesignerMode = false;
                    setTimeout(() => {
                        this.jsObject.clearViewerState(!this.openReport);
                        this.jsObject.showReportPage(this.model.proxyData, this.jsObject);
                        this.model.proxyData = null;
                    }, 0);
                }
            });
        };
        return request;
    }
    ;
    error(message) {
        this.model.errorMessage = message;
        this.controller.actionSubject.next({ action: 'Error' });
    }
    export(data) {
        this.controller.actionSubject.next({ action: 'ExportReport', data });
    }
    email(data) {
        this.controller.actionSubject.next({ action: 'Email', data });
    }
    print(data) {
        this.controller.actionSubject.next({ action: 'Print', data });
    }
    design() {
        this.controller.actionSubject.next({ action: 'Design' });
    }
    async getText(url) {
        return new Promise((resolve, reject) => {
            let observable = this.httpClient.get(url, { responseType: 'text' }).pipe(catchError((error) => {
                console.log(error);
                return EMPTY;
            }));
            observable.subscribe(data => {
                resolve(data);
            });
        });
    }
    async getData(url, params) {
        return new Promise((resolve, reject) => {
            let observable = this.httpClient.post(url, params, { responseType: 'blob' }).pipe(catchError((error) => {
                console.error(error);
                return EMPTY;
            }));
            observable.subscribe(data => {
                resolve(data);
            });
        });
    }
    getFormData(data) {
        const formData = new FormData();
        Object.keys(data).forEach(key => formData.append(key, data[key]));
        return formData;
    }
    getData2(url, data) {
        return this.httpClient.post(url, this.getFormData(data), { responseType: 'blob' }).pipe(catchError((error) => {
            console.error(error);
            return EMPTY;
        }));
    }
    saveData(url, params, newWindow, retrieveFileName) {
        if (retrieveFileName) {
            params.stiweb_onlyFileName = true;
            debugger;
            let observable = this.httpClient.post(url, this.getFormData(params), { responseType: 'json' }).pipe(catchError((error) => {
                console.error(error);
                return EMPTY;
            }));
            observable.subscribe(resp => {
                let fileName = resp.fileName;
                delete params.stiweb_onlyFileName;
                this.getData2(url, params).subscribe((data) => {
                    this.showData(data, fileName, newWindow);
                });
            });
        }
        else {
            this.getData2(url, params).subscribe((data) => {
                this.showData(data, null, newWindow);
            });
        }
    }
    showData(data, fileName, newWindow) {
        if (newWindow) {
            if (window.navigator && window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveOrOpenBlob(data);
            }
            else {
                var fileURL = URL.createObjectURL(data);
                window.open(fileURL, '_blank');
            }
        }
        else {
            this.fileSaver.saveAs(data, fileName);
        }
    }
    postParametersFunction(data) {
        return this.model.postParametersFunction ? this.model.postParametersFunction(data) : {};
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardProxyService, deps: [{ token: i1.HttpClient }, { token: i2.ModelService }, { token: i3.ControllerService }, { token: i4.FileSaverService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardProxyService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: DashboardProxyService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.HttpClient }, { type: i2.ModelService }, { type: i3.ControllerService }, { type: i4.FileSaverService }] });
//# sourceMappingURL=data:application/json;base64,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