import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "./http-client.service";
import * as i2 from "./model.service";
import * as i3 from "./styles.service";
import * as i4 from "./page.service";
import * as i5 from "./helper.service";
import * as i6 from "../forms/form.service";
import * as i7 from "./full-screen.service";
import * as i8 from "../menu/menu.service";
import * as i9 from "./animation.service";
export class ControllerService {
    constructor(httpClient, model, stylesService, pageService, helper, formService, fullScreenService, menuService, styleService, animationService) {
        this.httpClient = httpClient;
        this.model = model;
        this.stylesService = stylesService;
        this.pageService = pageService;
        this.helper = helper;
        this.formService = formService;
        this.fullScreenService = fullScreenService;
        this.menuService = menuService;
        this.styleService = styleService;
        this.animationService = animationService;
        this.subject = new Subject();
        this.actionSubject = new Subject();
        setInterval(() => {
            if (this.model.httpError) {
                if (this.model.httpError.error?.text) {
                    this.showError(this.model.httpError.error?.text);
                }
                else if (this.model.httpError.message) {
                    this.showError(null, this.model.httpError.message);
                }
                else if (this.model.httpError.error instanceof ErrorEvent) {
                    this.showError(this.model.httpError.error.message);
                }
                this.model.httpError = null;
            }
            if (this.model.navigateNode) {
                this.postBookmarkNodeAction(this.model.navigateNode);
                this.model.navigateNode = null;
            }
        }, 250);
        this.setupHandlers();
    }
    setupHandlers() {
        this.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'OpenReport':
                    setTimeout(() => {
                        this.styleService.addCustomFontStyles(message.data?.customFonts);
                        if (this.model.options.appearance.fullScreenMode) {
                            this.fullScreenService.changeFullScreenMode(true);
                        }
                        if (message.data?.stimulsoftFontContent && !this.model.options.stimulsoftFontContentLoaded) {
                            this.model.options.stimulsoftFontContentLoaded = message.data.stimulsoftFontContent;
                            this.styleService.addCustomFontStyles([{
                                    contentForCss: message.data.stimulsoftFontContent,
                                    originalFontFamily: 'Stimulsoft'
                                }]);
                        }
                    });
                    this.model.options.currentParameterWidth = message.data.parameterWidth;
                    this.model.options.currentParameterAlignment = message.data.parameterAlignment;
                    let appearance = this.model.options.appearance;
                    appearance.currentParametersPanelPosition = appearance.parametersPanelPosition == "FromReport" ? (this.model.reportParams.parametersOrientation == "Horizontal" ? "Top" : "Left") : appearance.parametersPanelPosition;
                    break;
            }
        });
        this.model.controls.bookmarksPanel.getVisibility().subscribe((value) => {
            if (value && this.model.options.isMobileDevice) {
                this.model.controls.parametersPanel.visible = false;
            }
            if (value) {
                this.hideToolbar();
            }
            else {
                this.showToolbar();
            }
        });
        this.model.controls.parametersPanel.getVisibility().subscribe((value) => {
            if (value && this.model.options.isMobileDevice) {
                this.model.controls.bookmarksPanel.visible = false;
            }
            if (value) {
                this.hideToolbar();
            }
            else {
                this.showToolbar();
            }
        });
        this.menuService.getVisibility().subscribe((menu) => {
            this.hideToolbar();
        });
    }
    hideToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            this.model.controls.toolbar.visible = false;
            this.model.controls.navigatePanel.visible = false;
        }
    }
    showToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            this.model.controls.toolbar.visible = true;
            this.model.controls.navigatePanel.visible = true;
            setTimeout(() => {
                this.keepToolbar();
            }, 300);
        }
    }
    keepToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            clearTimeout(this.model.toolbarHideTimer);
            this.model.toolbarHideTimer = setTimeout(() => {
                this.hideToolbar();
            }, 4000);
        }
    }
    getMessage() {
        return this.subject.asObservable();
    }
    getActionMessage() {
        return this.actionSubject.asObservable();
    }
    post(action, cAction, postData, responseType = 'json', subAction) {
        this.model.controls.navigatePanel.enabled = false;
        this.model.controls.toolbar.enabled = false;
        let url;
        if (!cAction) {
            url = this.model.requestUrl.replace('{action}', action === 'GetReport' || this.model.options.server.cacheMode === 'None' ? this.model.options.actions.getReport : this.model.options.actions.viewerEvent);
        }
        else {
            url = this.model.requestUrl.replace('{action}', cAction);
        }
        if (postData) {
            postData.action = action;
        }
        else {
            postData = { action };
        }
        this.httpClient.post(url, this.model.createPostParameters(postData), responseType).subscribe(data => {
            this.model.showProgress = false;
            this.model.controls.navigatePanel.enabled = true;
            this.model.controls.toolbar.enabled = true;
            if (data === 'ServerError:The report is not specified.' && this.model.options?.isReportRecieved) {
                this.model.options.isReportRecieved = false;
                this.model.reportParams.prevPageNumber = this.model.reportParams.pageNumber;
                this.post('GetReport');
                return;
            }
            if ((data?.action == 'GetReport' || data?.action == 'OpenReport') && data.dashboards) {
                action = 'ShowDashboard';
                this.subject.next({ action, data, subAction });
            }
            else {
                if (data?.action == 'GetReport' || data?.action == 'OpenReport') {
                    this.model.controls.toolbar.visible = this.model.options.toolbar.visible;
                }
                if (data) {
                    this.model.reportParams = data;
                    this.startRefreshReportTimer(data.refreshTime);
                    if (data.reportDisplayMode) {
                        this.model.options.displayModeFromReport = data.reportDisplayMode;
                    }
                }
                this.subject.next({ action, data, subAction });
            }
        });
    }
    loadViewer() {
        const url = this.model.requestUrl.replace('{action}', this.model.action);
        this.httpClient.post(url, this.model.createPostParameters({ action: 'AngularViewerData', viewerRequestUrl: this.model.requestUrl }, true, false), 'json').subscribe(data => {
            this.model.clear();
            this.model.proxyData = null;
            this.model.options = data;
            this.stylesService.setupStyle(atob(data['styles']), 'viewer');
            this.model.dashboards = data?.dashboards?.Value;
            this.checkTrExp();
            this.initAutoUpdateCache();
            this.subject.next({ action: 'viewer_loaded' });
            this.getReport();
        });
    }
    getReport() {
        this.model.options.paramsVariablesStartValues = null;
        this.post('GetReport');
    }
    getPages() {
        this.post('GetPages');
    }
    postExport(format, settings, elementName, isDashboardExport = false) {
        if (settings?.ExcelType) {
            settings.ExcelType = settings.ExcelType == 'Excel' ? 'Excel2007' : (settings.ExcelType == 'ExcelBiff' ? 'ExcelBinary' : settings.ExcelType);
        }
        const data = {
            action: isDashboardExport ? 'ExportDashboard' : 'ExportReport',
            exportFormat: format,
            exportSettings: settings,
            elementName
        };
        const doc = settings && settings.OpenAfterExport && this.model.options.appearance.openExportedReportWindow === '_blank' ?
            (!this.model.options.replaceHtmlFormWithRequest ? this.helper.openNewWindow('about:blank', '_blank').document : document) :
            null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.exportReport), data, doc);
        this.actionSubject.next({ action: 'ExportReport', data });
    }
    loadFile(fileName, content) {
        if (typeof content !== 'string' || content === '') {
            return;
        }
        if (content.indexOf('<?xml') === 0 || content.indexOf('{') === 0) {
            content = btoa(content);
        }
        const data = {
            action: 'OpenReport',
            openingFileName: fileName || 'Report.mdc',
            base64Data: content.indexOf('base64,') > 0 ? content.substr(content.indexOf('base64,') + 7) : content
        };
        if (fileName && (fileName.toLowerCase().indexOf('.mdx') >= 0 || fileName.toLowerCase().indexOf('.mrx') >= 0)) {
            this.formService.showForm('passwordForm', data);
        }
        else {
            this.postOpen(data);
        }
    }
    postOpen(data) {
        this.model.clearViewerState();
        this.model.reportParams.reportFileName = data.openingFileName;
        this.post('OpenReport', this.model.options.actions.openReport, data);
    }
    action(event) {
        switch (event.name) {
            case 'Find':
                this.model.controls.findPanel.visible = !this.model.controls.findPanel.visible;
                return;
            case 'Bookmarks':
                this.model.controls.bookmarksPanel.visible = !this.model.controls.bookmarksPanel.visible;
                return;
            case 'Parameters':
                this.model.controls.parametersPanel.visible = !this.model.controls.parametersPanel.visible;
                return;
            case 'BookmarkAction':
                if (this.model.reportParams.pageNumber === event.bookmarkPage || this.model.reportParams.viewMode !== 'SinglePage') {
                    this.helper.scrollToAnchor(event.bookmarkAnchor, event.componentGuid);
                    return;
                }
                else {
                    this.model.reportParams.pageNumber = event.bookmarkPage;
                    this.model.options.bookmarkAnchor = event.bookmarkAnchor;
                    this.model.options.componentGuid = event.componentGuid;
                }
                break;
            case 'GoToPage':
                this.model.reportParams.pageNumber = event.value;
                this.scrollToPage();
                break;
            case 'FirstPage':
                this.model.reportParams.pageNumber = 0;
                this.scrollToPage();
                break;
            case 'PrevPage':
                this.model.reportParams.pageNumber = Math.max(0, this.model.reportParams.pageNumber - 1);
                this.scrollToPage();
                break;
            case 'NextPage':
                this.model.reportParams.pageNumber = Math.min(this.model.reportParams.pagesCount - 1, this.model.reportParams.pageNumber + 1);
                this.scrollToPage();
                break;
            case 'LastPage':
                this.model.reportParams.pageNumber = this.model.reportParams.pagesCount - 1;
                this.scrollToPage();
                break;
            case 'ViewModeSinglePage':
                this.model.reportParams.viewMode = 'SinglePage';
                break;
            case 'ViewModeContinuous':
                this.model.reportParams.viewMode = 'Continuous';
                break;
            case 'ViewModeMultiplePages':
                this.model.reportParams.viewMode = 'MultiplePages';
                break;
            case 'Zoom25':
                this.model.reportParams.zoom = 25;
                break;
            case 'Zoom50':
                this.model.reportParams.zoom = 50;
                break;
            case 'Zoom75':
                this.model.reportParams.zoom = 75;
                break;
            case 'Zoom100':
                this.model.reportParams.zoom = 100;
                break;
            case 'Zoom150':
                this.model.reportParams.zoom = 150;
                break;
            case 'Zoom200':
                this.model.reportParams.zoom = 200;
                break;
            case 'ZoomOnePage':
            case 'ZoomPageWidth':
                this.model.reportParams.zoom = event.name === 'ZoomPageWidth' ? this.pageService.getZoomByPageWidth() : this.pageService.getZoomByPageHeight();
                break;
            case 'Submit':
                this.model.reportParams.editableParameters = null;
                if (this.model.reportParams.type === 'Report') {
                    this.model.reportParams.pageNumber = 0;
                }
                if (this.model.options.isMobileDevice) {
                    this.model.controls.parametersPanel.visible = false;
                }
                this.actionSubject.next({ action: 'Variables' });
                return;
            case 'Reset':
                if (this.model.options.paramsVariablesStartValues) {
                    this.model.options.paramsVariables = this.model.options.paramsVariablesStartValues;
                }
                this.actionSubject.next({ action: 'Reset' });
                return;
            case 'Editor':
                this.actionSubject.next({ action: 'Editor', data: {} });
                return;
            case 'Resources':
                this.model.controls.resourcesPanel.visible = !this.model.controls.resourcesPanel.visible;
                return;
            case 'PrintPdf':
            case 'PrintWithPreview':
            case 'PrintWithoutPreview':
                this.actionSubject.next({ action: 'Print', data: { format: event.name } });
                return;
            case 'Print':
                let format = 'PrintPdf';
                switch (this.model.options.toolbar.printDestination) {
                    case 'Pdf':
                        format = 'PrintPdf';
                        break;
                    case 'Direct':
                        format = 'PrintWithoutPreview';
                        break;
                    case 'WithPreview':
                        format = 'PrintWithPreview';
                        break;
                }
                this.actionSubject.next({ action: 'Print', data: { format } });
                return;
            case 'Open':
                this.model.openDialogFileMask = null;
                setTimeout(() => {
                    this.model.openDialogFileMask = '.mdc,.mdz,.mdx,.mrt,.mrz,.mrx';
                });
                return;
            case 'ResourceView':
                this.postReportResource(event.value.name, 'View');
                return;
            case 'ResourceSaveFile':
                this.postReportResource(event.value.name, 'SaveFile');
                return;
            case 'FullScreen':
                this.fullScreenService.changeFullScreenMode(!this.model.options.appearance.fullScreenMode);
                return;
            case 'About':
                this.actionSubject.next({ action: 'About' });
                return;
            case 'Pin':
                this.model.options.toolbar.autoHide = !this.model.options.toolbar.autoHide;
                this.pageService.calculateLayout();
                if (this.model.options.toolbar.autoHide) {
                    setTimeout(() => {
                        this.hideToolbar();
                    }, 200);
                }
                return;
            case 'Design':
                this.actionSubject.next({ action: 'Design' });
                break;
            default:
                if (event.name.indexOf('saveMenu') === 0) {
                    this.actionSubject.next({ action: 'Export', data: { format: event.name.substr(8) } });
                    return;
                }
                else if (event.name.indexOf('sendEmailMenu') === 0) {
                    this.actionSubject.next({ action: 'SendEmail', data: { format: event.name.substr(13) } });
                    return;
                }
        }
        this.getPages();
    }
    scrollToPage() {
        if (this.model.reportParams.viewMode === 'Continuous') {
            let panel = this.model.controls.reportPanel.el.nativeElement;
            const endTime = (new Date()).getTime() + this.model.options.scrollDuration;
            let targetTop = this.model.pages[this.model.reportParams.pageNumber].page.offsetTop;
            this.animationService.showAnimationForScroll(panel, targetTop, endTime, () => { });
        }
    }
    showError(message, messageText) {
        let type = 'Error';
        // Check for error in 'ServerError:' string format
        if (message != null && typeof (message) === 'string' && message.substr(0, 12) === 'ServerError:') {
            if (message.length <= 13) {
                messageText = 'An unknown error occurred (the server returned an empty value).';
            }
            else {
                messageText = message.substr(12);
            }
        }
        // Check for error in JSON format
        if (message != null && message.success === false && message.type && message.text) {
            type = message.type;
            messageText = message.text;
        }
        this.model.errorMessage = { error: 'Unknown error', type };
        if (messageText != null) {
            if (messageText === 'The report is not specified.' && !this.model.options.appearance.showReportIsNotSpecifiedMessage) {
                return true;
            }
            this.model.errorMessage = { error: messageText.replace('\n', '<br>'), type };
            if (this.model.images) {
                this.formService.showForm('errorMessageForm');
            }
            else {
                alert(messageText);
            }
            this.actionSubject.next({ action: 'Error' });
            return true;
        }
        return false;
    }
    postReportResource(resourceName, viewType) {
        const data = {
            action: 'ReportResource',
            reportResourceParams: {
                resourceName,
                viewType
            }
        };
        const doc = viewType === 'View' ? (!this.model.options.replaceHtmlFormWithRequest ? this.helper.openNewWindow('about:blank', '_blank').document : document) : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.viewerEvent), data, doc);
    }
    postBookmarkNodeAction(node) {
        node.selected = true;
        this.action({ name: 'BookmarkAction', bookmarkPage: node.page, bookmarkAnchor: node.url.replace(/\\\'/g, '\'').substr(1), componentGuid: node.compunentGuid });
    }
    viewerResized() {
        this.menuService.closeAllMenus();
    }
    initAutoUpdateCache() {
        if (this.model.options.server.allowAutoUpdateCache) {
            if (this.model.timerAutoUpdateCache) {
                clearInterval(this.model.timerAutoUpdateCache);
            }
            this.model.timerAutoUpdateCache = setInterval(() => this.post('UpdateCache'), this.model.options.server.timeoutAutoUpdateCache);
        }
    }
    startRefreshReportTimer(timeout) {
        if (this.model.refreshReportTimer != null) {
            clearInterval(this.model.refreshReportTimer);
            this.model.refreshReportTimer = null;
        }
        if (timeout && timeout > 0) {
            this.model.refreshReportTimer = setInterval(() => {
                if (!this.model.showProgress) {
                    this.post('Refresh');
                }
            }, timeout * 1000);
        }
    }
    checkTrExp() {
        if (!this.model.options.cloudMode && !this.model.options.serverMode && !this.model.options.standaloneJsMode && !this.model.options.reportDesignerMode && !this.model.options.alternateValid) {
            let buildDate = new Date();
            try {
                buildDate = new Date(this.model.options.buildDate);
            }
            catch { }
            const trDays = Math.floor(((new Date()).getTime() - buildDate.getTime()) / 1000 / 60 / 60 / 24);
            if (trDays > 45) {
                setTimeout(() => {
                    const message = trDays > 60 ? this.model.loc('NoticesYourTrialHasExpired') : this.model.loc('NoticesYouUsingTrialVersion');
                    const image = 'Notifications.Warning.png';
                    const buttonCaption = this.model.loc('ButtonOk');
                    let cancelAction;
                    let action;
                    if (trDays > 60) {
                        action = cancelAction = () => { window.location.href = 'https://www.stimulsoft.com/en/online-store'; };
                    }
                    this.model.notificationFormOptions = { message, image, buttonCaption, cancelAction, action };
                    this.formService.showForm('notificationForm');
                }, 3000);
            }
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ControllerService, deps: [{ token: i1.StiHttpClientService }, { token: i2.ModelService }, { token: i3.StylesService }, { token: i4.PageService }, { token: i5.HelperService }, { token: i6.FormService }, { token: i7.FullScreenService }, { token: i8.MenuService }, { token: i3.StylesService }, { token: i9.AnimationService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ControllerService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ControllerService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.StiHttpClientService }, { type: i2.ModelService }, { type: i3.StylesService }, { type: i4.PageService }, { type: i5.HelperService }, { type: i6.FormService }, { type: i7.FullScreenService }, { type: i8.MenuService }, { type: i3.StylesService }, { type: i9.AnimationService }] });
//# sourceMappingURL=data:application/json;base64,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