import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./api.angular.service";
import * as i2 from "./api.dashboard.service";
import * as i3 from "./model.service";
export class ApiService {
    constructor(angularService, dashboardService, model) {
        this.angularService = angularService;
        this.dashboardService = dashboardService;
        this.model = model;
        this.EXPORT_FORMATS = ['Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
            'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
            'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'];
    }
    get api() {
        return this.model.showDashboard ? this.dashboardService : this.angularService;
    }
    /**
     * The current page number
     */
    get currentPage() {
        return this.api.currentPage;
    }
    set currentPage(value) {
        this.api.currentPage = value;
    }
    /**
     * The total pages count
     */
    get pagesCount() {
        return this.api.pagesCount;
    }
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode() {
        return this.api.viewMode;
    }
    set viewMode(value) {
        this.api.viewMode = value;
    }
    /**
     * The page zoom in percent
     * From 1 to 200
     */
    get zoom() {
        return this.api.zoom;
    }
    set zoom(value) {
        this.api.zoom = value;
    }
    /**
     * Zoom page in height
     */
    zoomPageHeight() {
        this.api.zoomPageHeight();
    }
    /**
     * Zoom page in width
     */
    zoomPageWidth() {
        this.api.zoomPageWidth();
    }
    /**
     * Print to PDF
     */
    printPdf() {
        this.api.printPdf();
    }
    /**
     * Print with preview
     */
    printWithPreview() {
        this.api.printWithPreview();
    }
    /**
     * Print without preview
     */
    printWithoutPreview() {
        this.api.printWithoutPreview();
    }
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format) {
        this.api.showExportForm(format);
    }
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format) {
        this.api.showExportEmailForm(format);
    }
    /**
     * Export report/dashboard to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format, settings) {
        this.api.export(format, settings);
    }
    /**
     * Refresh dashboard
     */
    dashboardRefresh() {
        this.api.dashboardRefresh();
    }
    /**
     * Reset all filters
     */
    dashboardResetAllFilters() {
        this.api.dashboardResetAllFilters();
    }
    /**
     * Export report/dashboard to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'PowerPoint', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word', 'Odt', 'ExcelBiff',
     * 'Excel', 'ExcelXml', 'Excel', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format, settings, email, subject, message) {
        this.api.exportEmail(format, settings, email, subject, message);
    }
    /**
     * Report or Dashboard
     */
    get reportType() {
        return this.api.reportType;
    }
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text, matchCase, matchWholeWord) {
        this.api.search(text, matchCase, matchWholeWord);
    }
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction) {
        this.api.selectSearchLabel(direction);
    }
    /**
     * Hide search
     */
    hideSearchLabels() {
        this.api.hideSearchLabels();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ApiService, deps: [{ token: i1.ApiAngularService }, { token: i2.ApiDashboardService }, { token: i3.ModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ApiService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ApiService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ApiAngularService }, { type: i2.ApiDashboardService }, { type: i3.ModelService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLnNlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LXZpZXdlci1hbmd1bGFyL3NyYy9saWIvc2VydmljZXMvYXBpLnNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQzs7Ozs7QUFNM0MsTUFBTSxPQUFPLFVBQVU7SUFNckIsWUFBb0IsY0FBaUMsRUFBVSxnQkFBcUMsRUFBVSxLQUFtQjtRQUE3RyxtQkFBYyxHQUFkLGNBQWMsQ0FBbUI7UUFBVSxxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQXFCO1FBQVUsVUFBSyxHQUFMLEtBQUssQ0FBYztRQUoxSCxtQkFBYyxHQUFhLENBQUMsVUFBVSxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsWUFBWSxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSxXQUFXO1lBQzFJLE9BQU8sRUFBRSxVQUFVLEVBQUUsT0FBTyxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSxVQUFVO1lBQzNGLFVBQVUsRUFBRSxXQUFXLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxXQUFXLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxXQUFXLENBQUMsQ0FBQztJQUVnQyxDQUFDO0lBRXRJLElBQVksR0FBRztRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUNoRixDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQztJQUM5QixDQUFDO0lBRUQsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsR0FBRyxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUVEOztPQUVHO0lBQ0gsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUM7SUFDN0IsQ0FBQztJQUVEOztPQUVHO0lBQ0gsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUM7SUFDM0IsQ0FBQztJQUVELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFFRDs7O09BR0c7SUFDSCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBRUQ7O09BRUc7SUFDSSxjQUFjO1FBQ25CLElBQUksQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLENBQUM7SUFDNUIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksYUFBYTtRQUNsQixJQUFJLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzNCLENBQUM7SUFFRDs7T0FFRztJQUNJLFFBQVE7UUFDYixJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7T0FFRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLENBQUM7SUFDOUIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxHQUFHLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYyxDQUFDLE1BQWM7UUFDbEMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQixDQUFDLE1BQWM7UUFDdkMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksTUFBTSxDQUFDLE1BQWMsRUFBRSxRQUFjO1FBQzFDLElBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxRQUFRLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7O09BRUc7SUFDSSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFBO0lBQzdCLENBQUM7SUFDRDs7T0FFRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsR0FBRyxDQUFDLHdCQUF3QixFQUFFLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7O09BZ0JHO0lBQ0ksV0FBVyxDQUFDLE1BQWMsRUFBRSxRQUFjLEVBQUUsS0FBYyxFQUFFLE9BQWdCLEVBQUUsT0FBZ0I7UUFDbkcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUMsTUFBTSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ2xFLENBQUM7SUFFRDs7T0FFRztJQUNILElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDO0lBQzdCLENBQUM7SUFFRDs7Ozs7Ozs7T0FRRztJQUNJLE1BQU0sQ0FBQyxJQUFZLEVBQUUsU0FBa0IsRUFBRSxjQUF1QjtRQUNyRSxJQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRDs7Ozs7T0FLRztJQUNJLGlCQUFpQixDQUFDLFNBQWlCO1FBQ3hDLElBQUksQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOztPQUVHO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxHQUFHLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztJQUM5QixDQUFDOytHQWhNVSxVQUFVO21IQUFWLFVBQVU7OzRGQUFWLFVBQVU7a0JBRHRCLFVBQVUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IE1vZGVsU2VydmljZSB9IGZyb20gJy4vbW9kZWwuc2VydmljZSc7XHJcbmltcG9ydCB7IEFwaUFuZ3VsYXJTZXJ2aWNlIH0gZnJvbSAnLi9hcGkuYW5ndWxhci5zZXJ2aWNlJztcclxuaW1wb3J0IHsgQXBpRGFzaGJvYXJkU2VydmljZSB9IGZyb20gJy4vYXBpLmRhc2hib2FyZC5zZXJ2aWNlJztcclxuXHJcbkBJbmplY3RhYmxlKClcclxuZXhwb3J0IGNsYXNzIEFwaVNlcnZpY2UgaW1wbGVtZW50cyBBcGlJbnRlcmZhY2Uge1xyXG5cclxuICBwdWJsaWMgRVhQT1JUX0ZPUk1BVFM6IHN0cmluZ1tdID0gWydEb2N1bWVudCcsICdQZGYnLCAnWHBzJywgJ1Bvd2VyUG9pbnQnLCAnSHRtbCcsICdIdG1sNScsICdNaHQnLCAnVGV4dCcsICdSdGYnLCAnV29yZCcsICdPZHQnLCAnRXhjZWxCaWZmJyxcclxuICAgICdFeGNlbCcsICdFeGNlbFhtbCcsICdFeGNlbCcsICdPZHMnLCAnQ3N2JywgJ0RiZicsICdEaWYnLCAnU3lsaycsICdKc29uJywgJ1htbCcsICdJbWFnZUJtcCcsXHJcbiAgICAnSW1hZ2VHaWYnLCAnSW1hZ2VKcGVnJywgJ0ltYWdlUGN4JywgJ0ltYWdlUG5nJywgJ0ltYWdlVGlmZicsICdJbWFnZUVtZicsICdJbWFnZVN2ZycsICdJbWFnZVN2Z3onXTtcclxuXHJcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBhbmd1bGFyU2VydmljZTogQXBpQW5ndWxhclNlcnZpY2UsIHByaXZhdGUgZGFzaGJvYXJkU2VydmljZTogQXBpRGFzaGJvYXJkU2VydmljZSwgcHJpdmF0ZSBtb2RlbDogTW9kZWxTZXJ2aWNlKSB7IH1cclxuXHJcbiAgcHJpdmF0ZSBnZXQgYXBpKCk6IEFwaUludGVyZmFjZSB7XHJcbiAgICByZXR1cm4gdGhpcy5tb2RlbC5zaG93RGFzaGJvYXJkID8gdGhpcy5kYXNoYm9hcmRTZXJ2aWNlIDogdGhpcy5hbmd1bGFyU2VydmljZTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFRoZSBjdXJyZW50IHBhZ2UgbnVtYmVyXHJcbiAgICovXHJcbiAgcHVibGljIGdldCBjdXJyZW50UGFnZSgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuYXBpLmN1cnJlbnRQYWdlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBjdXJyZW50UGFnZSh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICB0aGlzLmFwaS5jdXJyZW50UGFnZSA9IHZhbHVlO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogVGhlIHRvdGFsIHBhZ2VzIGNvdW50XHJcbiAgICovXHJcbiAgcHVibGljIGdldCBwYWdlc0NvdW50KCkge1xyXG4gICAgcmV0dXJuIHRoaXMuYXBpLnBhZ2VzQ291bnQ7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBUaGUgdmlldyBtb2RlLCBjYW4gYmUgJ1NpbmdsZVBhZ2UnLCAnQ29udGludW91cycgJiAnTXVsdGlwbGVQYWdlcydcclxuICAgKi9cclxuICBwdWJsaWMgZ2V0IHZpZXdNb2RlKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5hcGkudmlld01vZGU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHZpZXdNb2RlKHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIHRoaXMuYXBpLnZpZXdNb2RlID0gdmFsdWU7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBUaGUgcGFnZSB6b29tIGluIHBlcmNlbnRcclxuICAgKiBGcm9tIDEgdG8gMjAwXHJcbiAgICovXHJcbiAgcHVibGljIGdldCB6b29tKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5hcGkuem9vbTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgem9vbSh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICB0aGlzLmFwaS56b29tID0gdmFsdWU7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBab29tIHBhZ2UgaW4gaGVpZ2h0XHJcbiAgICovXHJcbiAgcHVibGljIHpvb21QYWdlSGVpZ2h0KCkge1xyXG4gICAgdGhpcy5hcGkuem9vbVBhZ2VIZWlnaHQoKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFpvb20gcGFnZSBpbiB3aWR0aFxyXG4gICAqL1xyXG4gIHB1YmxpYyB6b29tUGFnZVdpZHRoKCkge1xyXG4gICAgdGhpcy5hcGkuem9vbVBhZ2VXaWR0aCgpO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogUHJpbnQgdG8gUERGXHJcbiAgICovXHJcbiAgcHVibGljIHByaW50UGRmKCkge1xyXG4gICAgdGhpcy5hcGkucHJpbnRQZGYoKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFByaW50IHdpdGggcHJldmlld1xyXG4gICAqL1xyXG4gIHB1YmxpYyBwcmludFdpdGhQcmV2aWV3KCkge1xyXG4gICAgdGhpcy5hcGkucHJpbnRXaXRoUHJldmlldygpO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogUHJpbnQgd2l0aG91dCBwcmV2aWV3XHJcbiAgICovXHJcbiAgcHVibGljIHByaW50V2l0aG91dFByZXZpZXcoKSB7XHJcbiAgICB0aGlzLmFwaS5wcmludFdpdGhvdXRQcmV2aWV3KCk7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBTaG93IGV4cG9ydCBmb3JtXHJcbiAgICpcclxuICAgKiBAcGFyYW0gZm9ybWF0IFRoZSBmb3JtYXQgdG8gZXhwb3J0LCBjYW4gYmUgJ0RvY3VtZW50JywgJ1BkZicsICdYcHMnLCAnUG93ZXJQb2ludCcsICdIdG1sJywgJ0h0bWw1JywgJ01odCcsICdUZXh0JywgJ1J0ZicsICdXb3JkJywgJ09kdCcsICdFeGNlbEJpZmYnLFxyXG4gICAqICdFeGNlbCcsICdFeGNlbFhtbCcsICdFeGNlbCcsICdPZHMnLCAnQ3N2JywgJ0RiZicsICdEaWYnLCAnU3lsaycsICdKc29uJywgJ1htbCcsICdJbWFnZUJtcCcsXHJcbiAgICogJ0ltYWdlR2lmJywgJ0ltYWdlSnBlZycsICdJbWFnZVBjeCcsICdJbWFnZVBuZycsICdJbWFnZVRpZmYnLCAnSW1hZ2VFbWYnLCAnSW1hZ2VTdmcnLCAnSW1hZ2VTdmd6J1xyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93RXhwb3J0Rm9ybShmb3JtYXQ6IHN0cmluZykge1xyXG4gICAgdGhpcy5hcGkuc2hvd0V4cG9ydEZvcm0oZm9ybWF0KTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFNob3cgZXhwb3J0IGZvcm0gJiBlbWFpbFxyXG4gICAqXHJcbiAgICogQHBhcmFtIGZvcm1hdCBUaGUgZm9ybWF0IHRvIGV4cG9ydCwgY2FuIGJlICdEb2N1bWVudCcsICdQZGYnLCAnWHBzJywgJ1Bvd2VyUG9pbnQnLCAnSHRtbCcsICdIdG1sNScsICdNaHQnLCAnVGV4dCcsICdSdGYnLCAnV29yZCcsICdPZHQnLCAnRXhjZWxCaWZmJyxcclxuICAgKiAnRXhjZWwnLCAnRXhjZWxYbWwnLCAnRXhjZWwnLCAnT2RzJywgJ0NzdicsICdEYmYnLCAnRGlmJywgJ1N5bGsnLCAnSnNvbicsICdYbWwnLCAnSW1hZ2VCbXAnLFxyXG4gICAqICdJbWFnZUdpZicsICdJbWFnZUpwZWcnLCAnSW1hZ2VQY3gnLCAnSW1hZ2VQbmcnLCAnSW1hZ2VUaWZmJywgJ0ltYWdlRW1mJywgJ0ltYWdlU3ZnJywgJ0ltYWdlU3ZneidcclxuICAgKi9cclxuICBwdWJsaWMgc2hvd0V4cG9ydEVtYWlsRm9ybShmb3JtYXQ6IHN0cmluZykge1xyXG4gICAgdGhpcy5hcGkuc2hvd0V4cG9ydEVtYWlsRm9ybShmb3JtYXQpO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogRXhwb3J0IHJlcG9ydC9kYXNoYm9hcmQgdG8gc2VsZWN0ZWQgZm9ybWF0XHJcbiAgICogVXNlIGRlZmF1bHQgc2V0dGluZ3MgaWYgbm90IHNwZWNpZmllZFxyXG4gICAqXHJcbiAgICogQHBhcmFtIGZvcm1hdCBUaGUgZm9ybWF0IHRvIGV4cG9ydCwgY2FuIGJlICdEb2N1bWVudCcsICdQZGYnLCAnWHBzJywgJ1Bvd2VyUG9pbnQnLCAnSHRtbCcsICdIdG1sNScsICdNaHQnLCAnVGV4dCcsICdSdGYnLCAnV29yZCcsICdPZHQnLCAnRXhjZWxCaWZmJyxcclxuICAgKiAnRXhjZWwnLCAnRXhjZWxYbWwnLCAnRXhjZWwnLCAnT2RzJywgJ0NzdicsICdEYmYnLCAnRGlmJywgJ1N5bGsnLCAnSnNvbicsICdYbWwnLCAnSW1hZ2VCbXAnLFxyXG4gICAqICdJbWFnZUdpZicsICdJbWFnZUpwZWcnLCAnSW1hZ2VQY3gnLCAnSW1hZ2VQbmcnLCAnSW1hZ2VUaWZmJywgJ0ltYWdlRW1mJywgJ0ltYWdlU3ZnJywgJ0ltYWdlU3ZneidcclxuICAgKlxyXG4gICAqIEBwYXJhbSBzZXR0aW5ncyBUaGUgZXhwb3J0IHNldHRpbmdzXHJcbiAgICovXHJcbiAgcHVibGljIGV4cG9ydChmb3JtYXQ6IHN0cmluZywgc2V0dGluZ3M/OiBhbnkpIHtcclxuICAgIHRoaXMuYXBpLmV4cG9ydChmb3JtYXQsIHNldHRpbmdzKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFJlZnJlc2ggZGFzaGJvYXJkXHJcbiAgICovXHJcbiAgcHVibGljIGRhc2hib2FyZFJlZnJlc2goKSB7XHJcbiAgICB0aGlzLmFwaS5kYXNoYm9hcmRSZWZyZXNoKClcclxuICB9XHJcbiAgLyoqXHJcbiAgICogUmVzZXQgYWxsIGZpbHRlcnNcclxuICAgKi9cclxuICBwdWJsaWMgZGFzaGJvYXJkUmVzZXRBbGxGaWx0ZXJzKCkge1xyXG4gICAgdGhpcy5hcGkuZGFzaGJvYXJkUmVzZXRBbGxGaWx0ZXJzKCk7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBFeHBvcnQgcmVwb3J0L2Rhc2hib2FyZCB0byBzZWxldGVkIGZvcm1hdCAmIGVtYWlsXHJcbiAgICogVXNlIGRlZmF1bHQgc2V0dGluZ3MgaWYgbm90IHNwZWNpZmllZFxyXG4gICAqIFVzZSBkZWZhdWx0IGVtYWlsIHNldHRpbmdzIGlmIG5vdCBzcGVjaWZpZWRcclxuICAgKlxyXG4gICAqIEBwYXJhbSBmb3JtYXQgVGhlIGZvcm1hdCB0byBleHBvcnQsIGNhbiBiZSAnRG9jdW1lbnQnLCAnUGRmJywgJ1hwcycsICdQb3dlclBvaW50JywgJ0h0bWwnLCAnSHRtbDUnLCAnTWh0JywgJ1RleHQnLCAnUnRmJywgJ1dvcmQnLCAnT2R0JywgJ0V4Y2VsQmlmZicsXHJcbiAgICogJ0V4Y2VsJywgJ0V4Y2VsWG1sJywgJ0V4Y2VsJywgJ09kcycsICdDc3YnLCAnRGJmJywgJ0RpZicsICdTeWxrJywgJ0pzb24nLCAnWG1sJywgJ0ltYWdlQm1wJyxcclxuICAgKiAnSW1hZ2VHaWYnLCAnSW1hZ2VKcGVnJywgJ0ltYWdlUGN4JywgJ0ltYWdlUG5nJywgJ0ltYWdlVGlmZicsICdJbWFnZUVtZicsICdJbWFnZVN2ZycsICdJbWFnZVN2Z3onXHJcbiAgICpcclxuICAgKiBAcGFyYW0gc2V0dGluZ3MgVGhlIGV4cG9ydCBzZXR0aW5nc1xyXG4gICAqXHJcbiAgICogQHBhcmFtIGVtYWlsIFRoZSBlbWFpbFxyXG4gICAqXHJcbiAgICogQHBhcmFtIG1lc3NhZ2UgVGhlIGVtYWlsIG1lc3NhZ2VcclxuICAgKlxyXG4gICAqIEBwYXJhbSBzdWJqZWN0IFRoZSBlbWFpbCBzdWJqZWN0XHJcbiAgICovXHJcbiAgcHVibGljIGV4cG9ydEVtYWlsKGZvcm1hdDogc3RyaW5nLCBzZXR0aW5ncz86IGFueSwgZW1haWw/OiBzdHJpbmcsIHN1YmplY3Q/OiBzdHJpbmcsIG1lc3NhZ2U/OiBzdHJpbmcpIHtcclxuICAgIHRoaXMuYXBpLmV4cG9ydEVtYWlsKGZvcm1hdCwgc2V0dGluZ3MsIGVtYWlsLCBzdWJqZWN0LCBtZXNzYWdlKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFJlcG9ydCBvciBEYXNoYm9hcmRcclxuICAgKi9cclxuICBwdWJsaWMgZ2V0IHJlcG9ydFR5cGUoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLmFwaS5yZXBvcnRUeXBlO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogU2VhcmNoIHRleHQgaW4gcmVwb3J0XHJcbiAgICpcclxuICAgKiBAcGFyYW0gdGV4dCB0ZXh0IHRvIHNlYXJjaFxyXG4gICAqXHJcbiAgICogQHBhcmFtIG1hdGNoQ2FzZVxyXG4gICAqXHJcbiAgICogQHBhcmFtIG1hdGNoV2hvbGVXb3JkXHJcbiAgICovXHJcbiAgcHVibGljIHNlYXJjaCh0ZXh0OiBzdHJpbmcsIG1hdGNoQ2FzZTogYm9vbGVhbiwgbWF0Y2hXaG9sZVdvcmQ6IGJvb2xlYW4pIHtcclxuICAgIHRoaXMuYXBpLnNlYXJjaCh0ZXh0LCBtYXRjaENhc2UsIG1hdGNoV2hvbGVXb3JkKTtcclxuICB9XHJcbiAgLyoqXHJcbiAgICogU2VsZWN0IG5leHQgb3IgcHJldmlvdXMgc2VhcmNoXHJcbiAgICpcclxuICAgKiBAcGFyYW0gZGlyZWN0aW9uICdOZXh0JyBvciAnUHJldmlvdXMnXHJcbiAgICpcclxuICAgKi9cclxuICBwdWJsaWMgc2VsZWN0U2VhcmNoTGFiZWwoZGlyZWN0aW9uOiBzdHJpbmcpIHtcclxuICAgIHRoaXMuYXBpLnNlbGVjdFNlYXJjaExhYmVsKGRpcmVjdGlvbik7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBIaWRlIHNlYXJjaFxyXG4gICAqL1xyXG4gIHB1YmxpYyBoaWRlU2VhcmNoTGFiZWxzKCkge1xyXG4gICAgdGhpcy5hcGkuaGlkZVNlYXJjaExhYmVscygpO1xyXG4gIH1cclxufVxyXG5cclxuZXhwb3J0IGludGVyZmFjZSBBcGlJbnRlcmZhY2Uge1xyXG4gIGN1cnJlbnRQYWdlOiBudW1iZXI7XHJcbiAgcGFnZXNDb3VudDogbnVtYmVyO1xyXG4gIHZpZXdNb2RlOiBzdHJpbmc7XHJcbiAgem9vbTogbnVtYmVyO1xyXG5cclxuICB6b29tUGFnZUhlaWdodCgpO1xyXG4gIHpvb21QYWdlV2lkdGgoKTtcclxuICBwcmludFBkZigpO1xyXG4gIHByaW50V2l0aFByZXZpZXcoKTtcclxuICBwcmludFdpdGhvdXRQcmV2aWV3KCk7XHJcbiAgc2hvd0V4cG9ydEZvcm0oZm9ybWF0OiBzdHJpbmcpO1xyXG4gIHNob3dFeHBvcnRFbWFpbEZvcm0oZm9ybWF0OiBzdHJpbmcpO1xyXG4gIGV4cG9ydChmb3JtYXQ6IHN0cmluZywgc2V0dGluZ3M/OiBhbnkpO1xyXG4gIGV4cG9ydEVtYWlsKGZvcm1hdDogc3RyaW5nLCBzZXR0aW5ncz86IGFueSwgZW1haWw/OiBzdHJpbmcsIHN1YmplY3Q/OiBzdHJpbmcsIG1lc3NhZ2U/OiBzdHJpbmcpO1xyXG4gIHNlYXJjaCh0ZXh0OiBzdHJpbmcsIG1hdGNoQ2FzZTogYm9vbGVhbiwgbWF0Y2hXaG9sZVdvcmQ6IGJvb2xlYW4pO1xyXG4gIHNlbGVjdFNlYXJjaExhYmVsKGRpcmVjdGlvbik7XHJcbiAgaGlkZVNlYXJjaExhYmVscygpO1xyXG5cclxuICAvKipcclxuICAgKiBSZWZyZXNoIGRhc2hib2FyZFxyXG4gICAqL1xyXG4gIGRhc2hib2FyZFJlZnJlc2goKTtcclxuXHJcbiAgZGFzaGJvYXJkUmVzZXRBbGxGaWx0ZXJzKCk7XHJcblxyXG4gIC8qKlxyXG4gICAqIFJlcG9ydCBvciBEYXNoYm9hcmRcclxuICAgKi9cclxuICBnZXQgcmVwb3J0VHlwZSgpOiBzdHJpbmc7XHJcbn1cclxuIl19