import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class AnimationService {
    constructor(model) {
        this.model = model;
    }
    showAnimationForScroll(reportPanel, finishScrollTop, endTime, completeFunction) {
        if (!reportPanel) {
            return;
        }
        let currentScrollTop = 0;
        if (this.model.options.appearance.scrollbarsMode) {
            currentScrollTop = reportPanel.scrollTop;
        }
        else {
            currentScrollTop = document.documentElement.scrollTop;
            if (currentScrollTop === 0) {
                currentScrollTop = document.getElementsByTagName('BODY')[0].scrollTop;
            }
        }
        clearTimeout(reportPanel.animationTimer);
        const d = new Date();
        const t = d.getTime();
        let step = Math.round((finishScrollTop - currentScrollTop) / ((Math.abs(endTime - t) + 1) / 30));
        // Last step
        if (Math.abs(step) > Math.abs(finishScrollTop - currentScrollTop)) {
            step = finishScrollTop - currentScrollTop;
        }
        currentScrollTop += step;
        let resultScrollTop;
        if (t < endTime) {
            resultScrollTop = currentScrollTop;
            reportPanel.animationTimer = setTimeout(() => {
                this.showAnimationForScroll(reportPanel, finishScrollTop, endTime, completeFunction);
            }, 30);
        }
        else {
            resultScrollTop = finishScrollTop;
            if (completeFunction) {
                completeFunction();
            }
        }
        if (this.model.options.appearance.scrollbarsMode) {
            reportPanel.scrollTop = resultScrollTop;
        }
        else {
            window.scrollTo(0, resultScrollTop);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AnimationService, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AnimationService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: AnimationService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.ModelService }] });
//# sourceMappingURL=data:application/json;base64,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