import { Component, Input, Output, EventEmitter } from '@angular/core';
import { trigger, state, transition, animate, style } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../controls/form-button.component";
export class GroupPanelComponent {
    constructor(model) {
        this.model = model;
        this.opened = false;
        this.action = new EventEmitter();
        this.display = 'none';
    }
    ngOnInit() { }
    startAnimation(event) {
        if (event.toState === 'opened') {
            this.display = '';
        }
    }
    doneAnimation(event) {
        if (event.toState === 'closed') {
            this.display = 'none';
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: GroupPanelComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: GroupPanelComponent, selector: "sti-group-panel", inputs: { width: "width", caption: "caption", innerPadding: "innerPadding", opened: "opened", margin: "margin" }, outputs: { action: "action" }, ngImport: i0, template: `
  <div #groupPanel [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbarFontColor"
       [style.minWidth.px]="width"
       [style.margin]="margin"
       [style.overflow]="'hidden'">
      <sti-form-button [caption]="caption"
          [imageName]="opened ? 'Arrows.BigArrowDown.png' : 'Arrows.BigArrowRight.png'"
          [imageCellWidth]="'1px'"
          [captionPadding]="'0 15px 0 5px'"
          [margin]="'0px'"
          [captionAlign]="'left'"
          (action)="opened = !opened; action.emit(opened)">
      </sti-form-button>

      <div class="stiJsViewerGroupPanelContainer"
           [style.padding]="innerPadding"
           [style.display]="display"
           [@state]="opened ? 'opened' : 'closed'"
           (@state.start)="startAnimation($event)"
           (@state.done)="doneAnimation($event)">
          <ng-content>

          </ng-content>
      </div>


  </div>
  `, isInline: true, dependencies: [{ kind: "component", type: i2.FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }], animations: [
            trigger('state', [
                state('opened', style({ height: '*' })),
                state('closed', style({ height: '0px' })),
                transition('* => *', [
                    animate('150ms ease-in-out')
                ])
            ])
        ] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: GroupPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-group-panel',
                    template: `
  <div #groupPanel [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbarFontColor"
       [style.minWidth.px]="width"
       [style.margin]="margin"
       [style.overflow]="'hidden'">
      <sti-form-button [caption]="caption"
          [imageName]="opened ? 'Arrows.BigArrowDown.png' : 'Arrows.BigArrowRight.png'"
          [imageCellWidth]="'1px'"
          [captionPadding]="'0 15px 0 5px'"
          [margin]="'0px'"
          [captionAlign]="'left'"
          (action)="opened = !opened; action.emit(opened)">
      </sti-form-button>

      <div class="stiJsViewerGroupPanelContainer"
           [style.padding]="innerPadding"
           [style.display]="display"
           [@state]="opened ? 'opened' : 'closed'"
           (@state.start)="startAnimation($event)"
           (@state.done)="doneAnimation($event)">
          <ng-content>

          </ng-content>
      </div>


  </div>
  `,
                    animations: [
                        trigger('state', [
                            state('opened', style({ height: '*' })),
                            state('closed', style({ height: '0px' })),
                            transition('* => *', [
                                animate('150ms ease-in-out')
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }], propDecorators: { width: [{
                type: Input
            }], caption: [{
                type: Input
            }], innerPadding: [{
                type: Input
            }], opened: [{
                type: Input
            }], margin: [{
                type: Input
            }], action: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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