import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/mouse.service";
import * as i2 from "../menu/menu.service";
import * as i3 from "../services/helper.service";
import * as i4 from "../services/model.service";
export class FormService {
    constructor(mouseService, menuService, helper, model) {
        this.mouseService = mouseService;
        this.menuService = menuService;
        this.helper = helper;
        this.model = model;
        this.mouseX = 0;
        this.mouseY = 0;
        this.formX = 0;
        this.formY = 0;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.move(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.stopMove();
        });
    }
    get form() {
        return this.model.form;
    }
    set form(form) {
        this.model.form = form;
    }
    showForm(name, formData) {
        this.form = { name, left: 0, top: 0, isMooving: false, formData };
    }
    closeForm(name) {
        if (this.form?.name === 'notificationForm' && this.model.notificationFormOptions?.action) {
            this.model.notificationFormOptions.action();
        }
        this.form = null;
    }
    centerForm(baseForm, defaultTop) {
        if (this.form != null) {
            setTimeout(() => {
                const position = this.helper.setObjectToCenter(baseForm.element.nativeElement, defaultTop);
                this.form.left = position.left;
                this.form.top = position.top;
                this.form.level = baseForm.level;
            });
        }
    }
    startMove(name, event, touchEvent) {
        if (event || touchEvent && touchEvent.changedTouches.length > 0) {
            this.formX = this.form.left;
            this.formY = this.form.top;
            this.mouseX = event?.screenX || touchEvent.changedTouches[0].screenX;
            this.mouseY = event?.screenY || touchEvent.changedTouches[0].screenY;
            this.form.isMooving = true;
        }
    }
    move(event) {
        if (this.form?.isMooving) {
            const screenX = event.screenX || (event.changedTouches.length > 0 ? event.changedTouches[0].screenX : -1);
            const screenY = event.screenY || (event.changedTouches.length > 0 ? event.changedTouches[0].screenY : -1);
            this.form.left = this.formX + (screenX - this.mouseX);
            this.form.top = this.formY + (screenY - this.mouseY);
            this.menuService.closeAllMenus();
        }
    }
    stopMove() {
        if (this.form?.isMooving) {
            this.form.isMooving = false;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FormService, deps: [{ token: i1.MouseService }, { token: i2.MenuService }, { token: i3.HelperService }, { token: i4.ModelService }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FormService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FormService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [{ type: i1.MouseService }, { type: i2.MenuService }, { type: i3.HelperService }, { type: i4.ModelService }] });
//# sourceMappingURL=data:application/json;base64,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