import { Component } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "./form.service";
import * as i3 from "./base-form.component";
export class ErrorMessageFormComponent {
    constructor(model, formService) {
        this.model = model;
        this.formService = formService;
    }
    ngOnInit() { }
    getImage() {
        const messageType = this.model.errorMessage?.type;
        if (messageType === 'Warning') {
            return this.model.img('MsgFormWarning.png');
        }
        else if (messageType === true || messageType === 'Info') {
            return this.model.img('MsgFormInfo.png');
        }
        else {
            return this.model.img('MsgFormError.png');
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ErrorMessageFormComponent, deps: [{ token: i1.ModelService }, { token: i2.FormService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ErrorMessageFormComponent, selector: "sti-error-message-form", ngImport: i0, template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'errorMessageForm'"
      [caption]="model.loc(model.errorMessage?.type == 'Error' ? 'Error' : 'FormViewerTitle')"
      [level]="4"
      [defaultTop]="150"
      [showCancel]="false"
      (action)="formService.closeForm('errorMessageForm')">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <img [attr.src]="getImage()" [style.padding.px]="15" [style.height.px]="32" [style.width.px]="32">
            </td>
            <td class="stiJsViewerMessagesFormDescription" [style.maxWidth.px]="600"
              [style.color]="model.options.toolbar.fontColor" [innerHTML]="model.errorMessage?.error">
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "component", type: i3.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ErrorMessageFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-error-message-form',
                    template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'errorMessageForm'"
      [caption]="model.loc(model.errorMessage?.type == 'Error' ? 'Error' : 'FormViewerTitle')"
      [level]="4"
      [defaultTop]="150"
      [showCancel]="false"
      (action)="formService.closeForm('errorMessageForm')">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <img [attr.src]="getImage()" [style.padding.px]="15" [style.height.px]="32" [style.width.px]="32">
            </td>
            <td class="stiJsViewerMessagesFormDescription" [style.maxWidth.px]="600"
              [style.color]="model.options.toolbar.fontColor" [innerHTML]="model.errorMessage?.error">
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.FormService }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3ItbWVzc2FnZS1mb3JtLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtdmlld2VyLWFuZ3VsYXIvc3JjL2xpYi9mb3Jtcy9lcnJvci1tZXNzYWdlLWZvcm0uY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQVUsTUFBTSxlQUFlLENBQUM7Ozs7O0FBK0JsRCxNQUFNLE9BQU8seUJBQXlCO0lBRXBDLFlBQW1CLEtBQW1CLEVBQVMsV0FBd0I7UUFBcEQsVUFBSyxHQUFMLEtBQUssQ0FBYztRQUFTLGdCQUFXLEdBQVgsV0FBVyxDQUFhO0lBQUksQ0FBQztJQUU1RSxRQUFRLEtBQUssQ0FBQztJQUVkLFFBQVE7UUFDTixNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUM7UUFFbEQsSUFBSSxXQUFXLEtBQUssU0FBUyxFQUFFLENBQUM7WUFDOUIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQzlDLENBQUM7YUFBTSxJQUFJLFdBQVcsS0FBSyxJQUFJLElBQUksV0FBVyxLQUFLLE1BQU0sRUFBRSxDQUFDO1lBQzFELE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUMzQyxDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM1QyxDQUFDO0lBQ0gsQ0FBQzsrR0FoQlUseUJBQXlCO21HQUF6Qix5QkFBeUIsOERBekIxQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXNCVDs7NEZBR1UseUJBQXlCO2tCQTNCckMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsd0JBQXdCO29CQUNsQyxRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FzQlQ7aUJBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBNb2RlbFNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlJztcclxuaW1wb3J0IHsgRm9ybVNlcnZpY2UgfSBmcm9tICcuL2Zvcm0uc2VydmljZSc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3N0aS1lcnJvci1tZXNzYWdlLWZvcm0nLFxyXG4gIHRlbXBsYXRlOiBgXHJcbiAgICA8c3RpLWJhc2UtZm9ybSBbZm9udEZhbWlseV09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udEZhbWlseVwiXHJcbiAgICAgIFtjb2xvcl09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udENvbG9yXCJcclxuICAgICAgW25hbWVdPVwiJ2Vycm9yTWVzc2FnZUZvcm0nXCJcclxuICAgICAgW2NhcHRpb25dPVwibW9kZWwubG9jKG1vZGVsLmVycm9yTWVzc2FnZT8udHlwZSA9PSAnRXJyb3InID8gJ0Vycm9yJyA6ICdGb3JtVmlld2VyVGl0bGUnKVwiXHJcbiAgICAgIFtsZXZlbF09XCI0XCJcclxuICAgICAgW2RlZmF1bHRUb3BdPVwiMTUwXCJcclxuICAgICAgW3Nob3dDYW5jZWxdPVwiZmFsc2VcIlxyXG4gICAgICAoYWN0aW9uKT1cImZvcm1TZXJ2aWNlLmNsb3NlRm9ybSgnZXJyb3JNZXNzYWdlRm9ybScpXCI+XHJcbiAgICAgIDx0YWJsZSBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjZWxscGFkZGluZz1cIjBcIiBjZWxsc3BhY2luZz1cIjBcIj5cclxuICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICA8aW1nIFthdHRyLnNyY109XCJnZXRJbWFnZSgpXCIgW3N0eWxlLnBhZGRpbmcucHhdPVwiMTVcIiBbc3R5bGUuaGVpZ2h0LnB4XT1cIjMyXCIgW3N0eWxlLndpZHRoLnB4XT1cIjMyXCI+XHJcbiAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyTWVzc2FnZXNGb3JtRGVzY3JpcHRpb25cIiBbc3R5bGUubWF4V2lkdGgucHhdPVwiNjAwXCJcclxuICAgICAgICAgICAgICBbc3R5bGUuY29sb3JdPVwibW9kZWwub3B0aW9ucy50b29sYmFyLmZvbnRDb2xvclwiIFtpbm5lckhUTUxdPVwibW9kZWwuZXJyb3JNZXNzYWdlPy5lcnJvclwiPlxyXG4gICAgICAgICAgICA8L3RkPlxyXG4gICAgICAgICAgPC90cj5cclxuICAgICAgICA8L3Rib2R5PlxyXG4gICAgICA8L3RhYmxlPlxyXG4gICAgPC9zdGktYmFzZS1mb3JtPlxyXG4gIGBcclxufSlcclxuXHJcbmV4cG9ydCBjbGFzcyBFcnJvck1lc3NhZ2VGb3JtQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcclxuXHJcbiAgY29uc3RydWN0b3IocHVibGljIG1vZGVsOiBNb2RlbFNlcnZpY2UsIHB1YmxpYyBmb3JtU2VydmljZTogRm9ybVNlcnZpY2UpIHsgfVxyXG5cclxuICBuZ09uSW5pdCgpIHsgfVxyXG5cclxuICBnZXRJbWFnZSgpIHtcclxuICAgIGNvbnN0IG1lc3NhZ2VUeXBlID0gdGhpcy5tb2RlbC5lcnJvck1lc3NhZ2U/LnR5cGU7XHJcblxyXG4gICAgaWYgKG1lc3NhZ2VUeXBlID09PSAnV2FybmluZycpIHtcclxuICAgICAgcmV0dXJuIHRoaXMubW9kZWwuaW1nKCdNc2dGb3JtV2FybmluZy5wbmcnKTtcclxuICAgIH0gZWxzZSBpZiAobWVzc2FnZVR5cGUgPT09IHRydWUgfHwgbWVzc2FnZVR5cGUgPT09ICdJbmZvJykge1xyXG4gICAgICByZXR1cm4gdGhpcy5tb2RlbC5pbWcoJ01zZ0Zvcm1JbmZvLnBuZycpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIHRoaXMubW9kZWwuaW1nKCdNc2dGb3JtRXJyb3IucG5nJyk7XHJcbiAgICB9XHJcbiAgfVxyXG59XHJcbiJdfQ==