import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
export class TextAreaComponent {
    constructor() {
        this.enabled = true;
        this.action = new EventEmitter();
        this.onchange = new EventEmitter();
        this.onblur = new EventEmitter();
        this.selected = false;
        this.focused = false;
        this.over = false;
        this._readOnly = false;
        this.styleName = 'stiJsViewerTextBox';
    }
    ngOnInit() { }
    keypress(event) {
        if (!this.enabled) {
            return false;
        }
        if (event.keyCode === 13) {
            this.action.emit(event.target);
        }
    }
    onchanged(event) {
        this.onchange.emit(event.target);
    }
    get className() {
        if (this._readOnly) {
            return this.styleName + ' ' + this.styleName + 'Default';
        }
        return this.styleName + ' ' + this.styleName + (this.selected ? 'Over' : (this.enabled ? (this.over ? 'Over' : 'Default') : 'Disabled'));
    }
    get readOnly() {
        return this._readOnly;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TextAreaComponent, deps: [], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: TextAreaComponent, selector: "sti-text-area", inputs: { width: "width", height: "height", enabled: "enabled", value: "value", padding: "padding", margin: "margin" }, outputs: { action: "action", onchange: "onchange", onblur: "onblur" }, ngImport: i0, template: `
    <textarea
      [style.width.px]="width"
      [style.minWidth.px]="width"
      [style.height.px]="height"
      [style.minHeight.px]="height"
      [class]="className"
      [value]="value || ''"
      [style.margin]="margin"
      [style.cursor]="readOnly ? 'default' : ''"
      [style.padding]="padding"
      [style.paddingTop.px]="3"
      [style.fontFamily]="'Arial'"
      (mouseover)="over=true"
      (mouseleave)="over=false"
      (focused)="focused=true; selected=true"
      (blur)="focused=false; selected=false; onblur.emit($event.target)"
      (keypress)="keypress($event)"
      (keyup)="onchanged($event)">
    </textarea>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: TextAreaComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-area',
                    template: `
    <textarea
      [style.width.px]="width"
      [style.minWidth.px]="width"
      [style.height.px]="height"
      [style.minHeight.px]="height"
      [class]="className"
      [value]="value || ''"
      [style.margin]="margin"
      [style.cursor]="readOnly ? 'default' : ''"
      [style.padding]="padding"
      [style.paddingTop.px]="3"
      [style.fontFamily]="'Arial'"
      (mouseover)="over=true"
      (mouseleave)="over=false"
      (focused)="focused=true; selected=true"
      (blur)="focused=false; selected=false; onblur.emit($event.target)"
      (keypress)="keypress($event)"
      (keyup)="onchanged($event)">
    </textarea>
  `
                }]
        }], ctorParameters: () => [], propDecorators: { width: [{
                type: Input
            }], height: [{
                type: Input
            }], enabled: [{
                type: Input
            }], value: [{
                type: Input
            }], padding: [{
                type: Input
            }], margin: [{
                type: Input
            }], action: [{
                type: Output
            }], onchange: [{
                type: Output
            }], onblur: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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