import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/radio-button.service";
import * as i3 from "@angular/common";
export class RadioButtonComponent {
    constructor(model, radioService) {
        this.model = model;
        this.radioService = radioService;
        this.action = new EventEmitter();
        this.enabled = true;
        this.checked = false;
        this.over = false;
    }
    ngAfterViewInit() {
        this.radioService.addButton(this);
    }
    ngOnDestroy() {
        this.radioService.removeButton(this);
    }
    ngOnInit() { }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    click() {
        if (this.enabled) {
            this.checked = true;
            this.radioService.check(this);
            this.action.emit(true);
        }
    }
    uncheck() {
        this.checked = false;
        this.action.emit(false);
    }
    get outClass() {
        return !this.enabled ? 'stiJsViewerRadioButtonOutCircleDisabled' : (this.over ? 'stiJsViewerRadioButtonOutCircleOver' : 'stiJsViewerRadioButtonOutCircle');
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: RadioButtonComponent, deps: [{ token: i1.ModelService }, { token: i2.RadioButtonService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: RadioButtonComponent, selector: "sti-radio-button", inputs: { groupName: "groupName", name: "name", enabled: "enabled", checked: "checked", tooltip: "tooltip", caption: "caption", margin: "margin", paddingLeftLastCell: "paddingLeftLastCell" }, outputs: { action: "action" }, ngImport: i0, template: `
    <table [class]="enabled ? 'stiJsViewerRadioButton' : 'stiJsViewerRadioButtonDisabled'" cellpadding="0" cellspacing="0"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.margin]="margin"
      [attr.title]="tooltip"
      (mouseover)="mouseover()" (mouseout)="mouseout()" (click)="click()">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td class="stiJsViewerClearAllStyles">
            <div class="stiJsViewerRadioButtonOutCircle" [class]="outClass">
              <div class="stiJsViewerRadioButtonInnerCircle"
                  [style.margin]="model.options.isTouchDevice ? '4px' : '3px'"
                  [style.width]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.height]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.visibility]="checked ? 'visible' : 'hidden'"
                  [style.opacity]="enabled ? 1 : 0.5">
              </div>
            </div>
          </td>
          <td *ngIf="caption != null" class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="4" [style.whiteSpace]="'nowrap'">
            {{caption}}
          </td>
          <td class="stiJsViewerClearAllStyles" [style.paddingLeft]="paddingLeftLastCell">
            <ng-content></ng-content>
          </td>
        </tr>
      </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: RadioButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-radio-button',
                    template: `
    <table [class]="enabled ? 'stiJsViewerRadioButton' : 'stiJsViewerRadioButtonDisabled'" cellpadding="0" cellspacing="0"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.margin]="margin"
      [attr.title]="tooltip"
      (mouseover)="mouseover()" (mouseout)="mouseout()" (click)="click()">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td class="stiJsViewerClearAllStyles">
            <div class="stiJsViewerRadioButtonOutCircle" [class]="outClass">
              <div class="stiJsViewerRadioButtonInnerCircle"
                  [style.margin]="model.options.isTouchDevice ? '4px' : '3px'"
                  [style.width]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.height]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.visibility]="checked ? 'visible' : 'hidden'"
                  [style.opacity]="enabled ? 1 : 0.5">
              </div>
            </div>
          </td>
          <td *ngIf="caption != null" class="stiJsViewerClearAllStyles" [style.paddingLeft.px]="4" [style.whiteSpace]="'nowrap'">
            {{caption}}
          </td>
          <td class="stiJsViewerClearAllStyles" [style.paddingLeft]="paddingLeftLastCell">
            <ng-content></ng-content>
          </td>
        </tr>
      </tbody>
    </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.RadioButtonService }], propDecorators: { action: [{
                type: Output
            }], groupName: [{
                type: Input
            }], name: [{
                type: Input
            }], enabled: [{
                type: Input
            }], checked: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], caption: [{
                type: Input
            }], margin: [{
                type: Input
            }], paddingLeftLastCell: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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