import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "@angular/common";
import * as i5 from "./text-box.componet";
export class PageControlComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.enabled = true;
        this.count = '?';
    }
    ngOnInit() { }
    textBoxAction(target) {
        if (this.model.reportParams.pagesCount > 0 && this.model.reportParams.pageNumber !== this.getCorrectValue(target.value) - 1) {
            this.controller.action({ name: 'GoToPage', value: this.getCorrectValue(target.value) - 1 });
        }
    }
    getCorrectValue(value) {
        value = parseInt(value, 10);
        if (value < 1 || !value) {
            value = 1;
        }
        if (value > this.model.reportParams.pagesCount) {
            value = this.model.reportParams.pagesCount;
        }
        return value;
    }
    get textBoxColor() {
        const toolbarFontColor = this.model.options.toolbar.fontColor;
        return this.enabled ? (toolbarFontColor && toolbarFontColor !== 'Empty' ? toolbarFontColor : '#444444')
            : (this.model.reportParams && this.model.reportParams.viewMode !== 'SinglePage' ? 'transparent' : toolbarFontColor);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageControlComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: PageControlComponent, selector: "sti-page-control", inputs: { enabled: "enabled", count: "count", textBoxBorder: "textBoxBorder", margin: "margin" }, ngImport: i0, template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin]="helper.val(margin, '1px')">
      <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              {{model.loc('Page')}}
            </td>
            <td *ngIf="model.options.isMobileDevice" class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              <span>{{model.reportParams.pageNumber + 1}}</span>
            </td>
            <td *ngIf="!model.options.isMobileDevice" class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              <sti-text-box [width]="45" [enabled]="enabled" [style.color]="textBoxColor" [style.opacity]="enabled ? 1 : 0.5"
              (action)="textBoxAction($event)" [value]="model.reportParams.pageNumber + 1" [border]="textBoxBorder"></sti-text-box>
            </td>
            <td class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              {{model.loc('PageOf')}}
            </td>
            <td class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              {{count}}
            </td>
          </tr>
      </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "textAlign", "autocomplete", "readOnly"], outputs: ["action", "onchange", "onblur"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: PageControlComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-page-control',
                    template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin]="helper.val(margin, '1px')">
      <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              {{model.loc('Page')}}
            </td>
            <td *ngIf="model.options.isMobileDevice" class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              <span>{{model.reportParams.pageNumber + 1}}</span>
            </td>
            <td *ngIf="!model.options.isMobileDevice" class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              <sti-text-box [width]="45" [enabled]="enabled" [style.color]="textBoxColor" [style.opacity]="enabled ? 1 : 0.5"
              (action)="textBoxAction($event)" [value]="model.reportParams.pageNumber + 1" [border]="textBoxBorder"></sti-text-box>
            </td>
            <td class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              {{model.loc('PageOf')}}
            </td>
            <td class="stiJsViewerClearAllStyles" [style.padding]="'0 2px 0 2px'">
              {{count}}
            </td>
          </tr>
      </tbody>
    </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }], propDecorators: { enabled: [{
                type: Input
            }], count: [{
                type: Input
            }], textBoxBorder: [{
                type: Input
            }], margin: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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