import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "@angular/common";
export class CheckboxComponent {
    constructor(model) {
        this.model = model;
        this.isEnabled = true;
        this.isChecked = false;
        this.indeterminate = false;
        this.nullable = false;
        this.action = new EventEmitter();
        this.over = false;
        this.isNull = false;
    }
    ngOnInit() { }
    mouseover() {
        this.over = true;
    }
    mouseleave() {
        this.over = false;
    }
    click() {
        if (this.isEnabled) {
            this.isChecked = !this.isChecked || this.isNull;
            this.isNull = this.nullable && this.isChecked && !this.isNull;
            this.action.emit(this.isNull ? null : this.isChecked);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CheckboxComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: CheckboxComponent, selector: "sti-check-box", inputs: { isEnabled: "isEnabled", isChecked: "isChecked", indeterminate: "indeterminate", captionText: "captionText", tooltip: "tooltip", margin: "margin", width: "width", styleColors: "styleColors", imageBlockParentWidth: "imageBlockParentWidth", nullable: "nullable" }, outputs: { action: "action" }, ngImport: i0, template: `
    <table cellpadding="0" cellspacing="0"
      [class]="isEnabled ? 'stiJsViewerCheckBox' : 'stiJsViewerCheckBoxDisabled'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [attr.title]="tooltip"
      [style.margin]="margin"
      [style.width]="width"
      [style.boxSizing]="'content-box'"
      (mouseover)="mouseover()"
      (mouseleave)="mouseleave()"
      (click)="click()">
       <tbody>
          <tr class="stiJsViewerClearAllStyles">
             <td [style.lineHeight] = "0"
                 [style.padding]="model.options.isTouchDevice ? '1px 3px 1px 1px' : ''"
                 [style.width]="imageBlockParentWidth"
                 class="stiJsViewerClearAllStyles">
                <div [style.width.px]="model.options.isTouchDevice ? 16 : 13"
                     [style.height.px]="model.options.isTouchDevice ? 16 : 13"
                     [class]="isEnabled ? (over ? 'stiJsViewerCheckBoxImageBlockOver' : 'stiJsViewerCheckBoxImageBlock') : 'stiJsViewerCheckBoxImageBlockDisabled'"
                     [style.boxSizing]="'content-box'">
                     <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'" [style.height]="'100%'">
                        <tbody>
                          <tr class="stiJsViewerClearAllStyles">
                            <td [style.textAlign]="model.options.isTouchDevice ? 'center' : 'right'"
                                [style.verticalAlign]="model.options.isTouchDevice ? 'middle' : 'top'"
                                [style.position]="'relative'">
                                <img *ngIf="!isNull" [src]="model.img((indeterminate ? 'CheckBoxIndeterminate' : 'CheckBox') + (styleColors && styleColors.isDarkStyle ? 'White.png' : '.png'))"
                                    [style.visibility]="isChecked ? 'visible' : 'hidden'"
                                    [style.width.px]="indeterminate ? 13 : 12"
                                    [style.height.px]="indeterminate ? 13 : 12"
                                    [style.opacity]="isEnabled ? 1 : 0.5"
                                    [style.verticalAlign]="'baseline'"/>
                                <div *ngIf="isNull" class="stiJsViewerCheckBoxNullBlock" [style.left.px]="2" [style.top.px]="6"  [style.width.px]="9" [style.opacity]="isEnabled ? 1 : 0.5"></div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                </div>
             </td>
             <td *ngIf="captionText != null"
                 [style.padding]="!model.options.isTouchDevice ? '1px 0 0 4px' : ''"
                 [style.whiteSpace]="'nowrap'">
                 {{captionText}}
             </td>
          </tr>
       </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CheckboxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-check-box',
                    template: `
    <table cellpadding="0" cellspacing="0"
      [class]="isEnabled ? 'stiJsViewerCheckBox' : 'stiJsViewerCheckBoxDisabled'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [attr.title]="tooltip"
      [style.margin]="margin"
      [style.width]="width"
      [style.boxSizing]="'content-box'"
      (mouseover)="mouseover()"
      (mouseleave)="mouseleave()"
      (click)="click()">
       <tbody>
          <tr class="stiJsViewerClearAllStyles">
             <td [style.lineHeight] = "0"
                 [style.padding]="model.options.isTouchDevice ? '1px 3px 1px 1px' : ''"
                 [style.width]="imageBlockParentWidth"
                 class="stiJsViewerClearAllStyles">
                <div [style.width.px]="model.options.isTouchDevice ? 16 : 13"
                     [style.height.px]="model.options.isTouchDevice ? 16 : 13"
                     [class]="isEnabled ? (over ? 'stiJsViewerCheckBoxImageBlockOver' : 'stiJsViewerCheckBoxImageBlock') : 'stiJsViewerCheckBoxImageBlockDisabled'"
                     [style.boxSizing]="'content-box'">
                     <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.width]="'100%'" [style.height]="'100%'">
                        <tbody>
                          <tr class="stiJsViewerClearAllStyles">
                            <td [style.textAlign]="model.options.isTouchDevice ? 'center' : 'right'"
                                [style.verticalAlign]="model.options.isTouchDevice ? 'middle' : 'top'"
                                [style.position]="'relative'">
                                <img *ngIf="!isNull" [src]="model.img((indeterminate ? 'CheckBoxIndeterminate' : 'CheckBox') + (styleColors && styleColors.isDarkStyle ? 'White.png' : '.png'))"
                                    [style.visibility]="isChecked ? 'visible' : 'hidden'"
                                    [style.width.px]="indeterminate ? 13 : 12"
                                    [style.height.px]="indeterminate ? 13 : 12"
                                    [style.opacity]="isEnabled ? 1 : 0.5"
                                    [style.verticalAlign]="'baseline'"/>
                                <div *ngIf="isNull" class="stiJsViewerCheckBoxNullBlock" [style.left.px]="2" [style.top.px]="6"  [style.width.px]="9" [style.opacity]="isEnabled ? 1 : 0.5"></div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                </div>
             </td>
             <td *ngIf="captionText != null"
                 [style.padding]="!model.options.isTouchDevice ? '1px 0 0 4px' : ''"
                 [style.whiteSpace]="'nowrap'">
                 {{captionText}}
             </td>
          </tr>
       </tbody>
    </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }], propDecorators: { isEnabled: [{
                type: Input
            }], isChecked: [{
                type: Input
            }], indeterminate: [{
                type: Input
            }], captionText: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], margin: [{
                type: Input
            }], width: [{
                type: Input
            }], styleColors: [{
                type: Input
            }], imageBlockParentWidth: [{
                type: Input
            }], nullable: [{
                type: Input
            }], action: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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