import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/toolbar.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/toolbar-separator.component";
import * as i7 from "../controls/page-control.component";
export class ToolbarDopComponent {
    constructor(model, controller, toolbarService) {
        this.model = model;
        this.controller = controller;
        this.toolbarService = toolbarService;
        this.marginLeft = '1px';
        this.viewInit = false;
    }
    ngAfterViewInit() {
        this.viewInit = true;
        setTimeout(() => {
            const width = this.mainTable?.nativeElement?.offsetWidth;
            this.marginLeft = this.viewInit && this.model.options.toolbar.alignment === 'Center' && width ? `calc(50% - ${Math.trunc(width / 2)}px)` : '1px';
        });
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarDopComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.ToolbarService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ToolbarDopComponent, selector: "sti-toolbar-dop", inputs: { comps: "comps", align: "align" }, viewQueries: [{ propertyName: "mainTable", first: true, predicate: ["mainTable"], descendants: true }], ngImport: i0, template: `
    <table #mainTable
      class="stiJsViewerClearAllStyles"
      cellpadding="0"
      cellspacing="0"
      [style.margin.px]="1"
      [attr.align]="align"
      [style.marginLeft]="marginLeft">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="model.options.toolbar.showButtonCaptions ? comp.caption : null"
              [imageName]="comp.img"
              [arrow]="!model.options.isMobileDevice ? comp.arrow : null"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [enabled]="toolbarService.enabled(comp)"
              [display]="toolbarService.display(comp)"
              [innerTableWidth]="toolbarService.getInnerTableWidth(comp)"
              [width]="toolbarService.getButonWidth(comp)"
              [height]="model.options.toolbar.displayMode == 'Separated' ? (model.options.isMobileDevice ? '0.5in' : '28px') : null"
              (action)="controller.action({ name: comp.action });"
              [selected]="toolbarService.selected(comp)"></sti-button>
            <sti-toolbar-separator *ngIf="comp.type=='separator'"></sti-toolbar-separator>
            <sti-page-control *ngIf="comp.type=='pageControl'" [enabled]="!(model.reportParams.pagesCount <= 1 || toolbarService.disableNaviButtons())" [count]="model.reportParams.pagesCount" ></sti-page-control>
        </td>
      </tr>
    </tbody>
  </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.ToolbarSeparatorComponent, selector: "sti-toolbar-separator" }, { kind: "component", type: i7.PageControlComponent, selector: "sti-page-control", inputs: ["enabled", "count", "textBoxBorder", "margin"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ToolbarDopComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar-dop',
                    template: `
    <table #mainTable
      class="stiJsViewerClearAllStyles"
      cellpadding="0"
      cellspacing="0"
      [style.margin.px]="1"
      [attr.align]="align"
      [style.marginLeft]="marginLeft">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="model.options.toolbar.showButtonCaptions ? comp.caption : null"
              [imageName]="comp.img"
              [arrow]="!model.options.isMobileDevice ? comp.arrow : null"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [enabled]="toolbarService.enabled(comp)"
              [display]="toolbarService.display(comp)"
              [innerTableWidth]="toolbarService.getInnerTableWidth(comp)"
              [width]="toolbarService.getButonWidth(comp)"
              [height]="model.options.toolbar.displayMode == 'Separated' ? (model.options.isMobileDevice ? '0.5in' : '28px') : null"
              (action)="controller.action({ name: comp.action });"
              [selected]="toolbarService.selected(comp)"></sti-button>
            <sti-toolbar-separator *ngIf="comp.type=='separator'"></sti-toolbar-separator>
            <sti-page-control *ngIf="comp.type=='pageControl'" [enabled]="!(model.reportParams.pagesCount <= 1 || toolbarService.disableNaviButtons())" [count]="model.reportParams.pagesCount" ></sti-page-control>
        </td>
      </tr>
    </tbody>
  </table>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.ToolbarService }], propDecorators: { mainTable: [{
                type: ViewChild,
                args: ['mainTable']
            }], comps: [{
                type: Input
            }], align: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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