import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
export class ResourcesPanelComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                this.model.controls.resourcesPanel.visible = this.model.reportParams.resources?.length > 0;
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.resourcesPanel.el = this.element;
    }
    action(resource) {
        const resTypesAllowedViewInBrowser = ['Image', 'Pdf', 'Txt'];
        const viewType = resTypesAllowedViewInBrowser.indexOf(resource.type) >= 0 ? 'View' : 'SaveFile';
        this.controller.postReportResource(resource.name, this.model.options.jsMode ? 'SaveFile' : viewType);
    }
    getResourceImage(resourceType) {
        if (this.model.img('BigResource' + resourceType + '.png') !== '') {
            return 'BigResource' + resourceType + '.png';
        }
        else {
            return 'BigResource.png';
        }
    }
    getMenuItems(resource) {
        const items = [];
        items.push({ name: 'Resource' + 'View', caption: this.model.loc('ButtonView'), value: resource });
        items.push({ name: 'Resource' + 'SaveFile', caption: this.model.loc('SaveFile'), value: resource });
        return items;
    }
    getActionName(resource) {
        if (!resource.id) {
            resource.id = Math.random().toString();
        }
        return 'resource' + resource.name + resource.id;
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ResourcesPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ResourcesPanelComponent, selector: "sti-resources-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [style.zIndex]="3"
      [style.display]="this.model.controls.resourcesPanel.visible ? '' : 'none'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="model.options.toolbar.fontColor"
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.boxSizing]="'border-box'" [style.display]="'table'"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td *ngFor="let resource of model.reportParams.resources" class="stiJsViewerClearAllStyles">
                  <sti-button [caption]="resource.name"
                    [caption2]="helper.getHumanFileSize(resource.size, 1)"
                    [imageName]="getResourceImage(resource.type)"
                    [styleName]="'stiJsViewerFormButton'"
                    [height]="'auto'"
                    [margin]="'3px 0 3px 3px'"
                    [innerTableWidth]="'100%'"
                    [minWidth]="'80px'"
                    [captionAlign]="'left'"
                    [captionPaddingLeft]="'3px'"
                    [captionMaxWidth]="'150px'"
                    [captionLineHeight]="'14px'"
                    [captionWhiteSpace]="'nowrap'"
                    [captionOverflow]="'hidden'"
                    [captionTextOverflow]="'ellipsis'"
                    [imageCellWidth]="'1px'"
                    [imageCellPadding]="'4px 8px 4px 4px'"
                    [menuItems]="getMenuItems(resource)"
                    [resourceButton]="true"
                    [imageSizesWidth]="32"
                    [imageSizesHeight]="32"
                    [actionName]="getActionName(resource)"
                    (action)="action(resource)">
                  </sti-button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ResourcesPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-resources-panel',
                    template: `
    <div #element [style.zIndex]="3"
      [style.display]="this.model.controls.resourcesPanel.visible ? '' : 'none'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="model.options.toolbar.fontColor"
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.boxSizing]="'border-box'" [style.display]="'table'"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td *ngFor="let resource of model.reportParams.resources" class="stiJsViewerClearAllStyles">
                  <sti-button [caption]="resource.name"
                    [caption2]="helper.getHumanFileSize(resource.size, 1)"
                    [imageName]="getResourceImage(resource.type)"
                    [styleName]="'stiJsViewerFormButton'"
                    [height]="'auto'"
                    [margin]="'3px 0 3px 3px'"
                    [innerTableWidth]="'100%'"
                    [minWidth]="'80px'"
                    [captionAlign]="'left'"
                    [captionPaddingLeft]="'3px'"
                    [captionMaxWidth]="'150px'"
                    [captionLineHeight]="'14px'"
                    [captionWhiteSpace]="'nowrap'"
                    [captionOverflow]="'hidden'"
                    [captionTextOverflow]="'ellipsis'"
                    [imageCellWidth]="'1px'"
                    [imageCellPadding]="'4px 8px 4px 4px'"
                    [menuItems]="getMenuItems(resource)"
                    [resourceButton]="true"
                    [imageSizesWidth]="32"
                    [imageSizesHeight]="32"
                    [actionName]="getActionName(resource)"
                    (action)="action(resource)">
                  </sti-button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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