import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/controller.service";
import * as i2 from "../services/model.service";
import * as i3 from "../services/styles.service";
import * as i4 from "../services/interactions.service";
import * as i5 from "@angular/common";
import * as i6 from "./page.component";
export class ReportPanelComponent {
    constructor(controller, model, stylesService, interactionService) {
        this.controller = controller;
        this.model = model;
        this.stylesService = stylesService;
        this.interactionService = interactionService;
        this.touchZoomFirstDistance = 0;
        this.touchZoomSecondDistance = 0;
        this.touchZoomValue = 0;
        this.maxHeights = {};
        controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded' && this.model.reportParams.pagesArray) {
                if (this.model.reportParams.repaintOnlyDashboardContent) {
                    // jsObject.controls.reportPanel.repaintDashboardContent(parameters);
                }
                else {
                    this.loadPages();
                }
            }
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (!this.model.options.isParametersReceived && ((this.model.reportParams.type === 'Report' && this.model.options.toolbar.showParametersButton) || this.model.reportParams.type === 'Dashboard')) {
                        interactionService.postInteraction({ action: 'InitVars' });
                    }
                    if (this.model.reportParams.autoZoom) {
                        this.controller.action({ name: this.model.reportParams.autoZoom === -1 ? 'ZoomPageWidth' : 'ZoomOnePage' });
                        this.model.reportParams.autoZoom = null;
                    }
                });
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.reportPanel.el = this.element;
    }
    loadPages() {
        this.maxHeights = {};
        const pagesArray = this.model.reportParams.pagesArray;
        this.stylesService.setupStyle(pagesArray[pagesArray.length - 2], 'page');
        const chartScript = pagesArray[pagesArray.length - 1];
        this.model.pages = pagesArray.slice(0, pagesArray.length - 2);
        setTimeout(() => {
            this.model.pages.forEach(page => this.interactionService.initializeInteractions(page.page));
            this.interactionService.updateAllHyperLinks();
            this.stylesService.addChartScript(chartScript);
        });
    }
    get position() {
        return this.model.options.heightType !== 'Percentage' || this.model.options.appearance.scrollbarsMode ? 'absolute' : 'relative';
    }
    scroll() {
        if (this.model.pagesNavigationIsActive()) {
            clearTimeout(this.scrollTimeout);
            // update current page number
            this.scrollTimeout = setTimeout(() => {
                let commonPagesHeight = 0;
                let index = 0;
                for (index = 0; index < this.model.pages.length; index++) {
                    commonPagesHeight += this.model.pages[index].page.offsetHeight + 10;
                    if (commonPagesHeight > this.element.nativeElement.scrollTop) {
                        break;
                    }
                }
                if (index < this.model.reportParams.pagesCount && index >= 0 && index !== this.model.reportParams.pageNumber) {
                    this.model.reportParams.pageNumber = index;
                }
            }, 300);
        }
    }
    eventTouchStart(e) {
        this.touchesLength++;
        this.touchStartX = parseInt(e.changedTouches[0].clientX, 10);
        if (this.model.options.appearance.allowTouchZoom && this.touchesLength === 1) {
            this.touchZoomFirstDistance = 0;
            this.touchZoomSecondDistance = 0;
            this.touchZoomValue = 0;
        }
    }
    eventTouchMove(e) {
        if (this.model.options.appearance.allowTouchZoom && e.touches.length > 1) {
            if ('preventDefault' in e) {
                e.preventDefault();
            }
            this.touchZoomSecondDistance = Math.sqrt(Math.pow(e.touches[0].pageX - e.touches[1].pageX, 2) + Math.pow(e.touches[0].pageY - e.touches[1].pageY, 2));
            if (this.touchZoomFirstDistance === 0) {
                this.touchZoomFirstDistance = Math.sqrt(Math.pow(e.touches[0].pageX - e.touches[1].pageX, 2) + Math.pow(e.touches[0].pageY - e.touches[1].pageY, 2));
            }
            const touchZoomOffset = Math.trunc((this.touchZoomSecondDistance - this.touchZoomFirstDistance) / 2.5);
            if (Math.abs(touchZoomOffset) >= 5) {
                this.touchZoomValue = Math.trunc((this.model.reportParams.zoom + touchZoomOffset) / 5) * 5;
                this.touchZoomValue = Math.min(Math.max(this.touchZoomValue, 20), 200);
                this.controller.actionSubject.next({ action: 'centerText', data: this.touchZoomValue.toString() });
            }
        }
    }
    eventTouchEnd(e) {
        if (this.touchesLength > 0) {
            this.touchesLength--;
        }
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            if (Math.trunc(this.touchStartX - e.changedTouches[0].clientX) !== 0) {
                this.controller.keepToolbar();
            }
            else {
                if (!this.model.controls.toolbar.visible) {
                    this.controller.showToolbar();
                }
                else {
                    this.controller.hideToolbar();
                }
            }
        }
        if (this.model.options.appearance.allowTouchZoom && this.touchZoomValue !== 0 && this.touchesLength === 0) {
            this.controller.actionSubject.next({ action: 'hideCenterText' });
            this.model.reportParams.zoom = this.touchZoomValue;
            this.controller.post('GetPages');
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ReportPanelComponent, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.StylesService }, { token: i4.InteractionsService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ReportPanelComponent, selector: "sti-report-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
         [style.textAlign]="model.options.appearance.pageAlignment == 'default' ? 'center' : model.options.appearance.pageAlignment"
         [style.top]="0"
         [style.bottom]="0"
         [style.position]="position"
         [style.height]="model.options.heightType != 'Percentage' || model.options.appearance.scrollbarsMode ? 'auto' : 'calc(100% - 35px)'"
         [style.overflow] = "model.reportParams.type == 'Report' && model.options.appearance.scrollbarsMode ? 'auto' : 'hidden'"
         [style.marginTop.px]="model.controls.reportPanel.layout.top"
         [style.marginLeft.px]="model.controls.reportPanel.layout.left"
         [style.marginBottom.px]="position == 'absolute' ? model.controls.reportPanel.layout.bottom : 0"
         [style.paddingBottom.px]="position == 'relative' ? model.controls.reportPanel.layout.bottom : 0"
         [style.transition]="model.options.isMobileDevice ? 'margin 200ms ease' : null"
         (scroll)="scroll()"
         class="stiJsViewerReportPanel"
         (touchstart)="eventTouchStart($event)"
         (touchmove)="eventTouchMove($event)"
         (touchend)="eventTouchEnd($event)">
      <sti-page *ngFor="let page of model.pages" [pageAttributes]="page"></sti-page>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i6.PageComponent, selector: "sti-page", inputs: ["pageAttributes"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ReportPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-report-panel',
                    template: `
    <div #element
         [style.textAlign]="model.options.appearance.pageAlignment == 'default' ? 'center' : model.options.appearance.pageAlignment"
         [style.top]="0"
         [style.bottom]="0"
         [style.position]="position"
         [style.height]="model.options.heightType != 'Percentage' || model.options.appearance.scrollbarsMode ? 'auto' : 'calc(100% - 35px)'"
         [style.overflow] = "model.reportParams.type == 'Report' && model.options.appearance.scrollbarsMode ? 'auto' : 'hidden'"
         [style.marginTop.px]="model.controls.reportPanel.layout.top"
         [style.marginLeft.px]="model.controls.reportPanel.layout.left"
         [style.marginBottom.px]="position == 'absolute' ? model.controls.reportPanel.layout.bottom : 0"
         [style.paddingBottom.px]="position == 'relative' ? model.controls.reportPanel.layout.bottom : 0"
         [style.transition]="model.options.isMobileDevice ? 'margin 200ms ease' : null"
         (scroll)="scroll()"
         class="stiJsViewerReportPanel"
         (touchstart)="eventTouchStart($event)"
         (touchmove)="eventTouchMove($event)"
         (touchend)="eventTouchEnd($event)">
      <sti-page *ngFor="let page of model.pages" [pageAttributes]="page"></sti-page>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.StylesService }, { type: i4.InteractionsService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0LXBhbmVsLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtdmlld2VyLWFuZ3VsYXIvc3JjL2xpYi9jb21wb25lbnRzL3JlcG9ydC1wYW5lbC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBVSxTQUFTLEVBQTZCLE1BQU0sZUFBZSxDQUFDOzs7Ozs7OztBQWdDeEYsTUFBTSxPQUFPLG9CQUFvQjtJQWEvQixZQUFvQixVQUE2QixFQUFTLEtBQW1CLEVBQVUsYUFBNEIsRUFBVSxrQkFBdUM7UUFBaEosZUFBVSxHQUFWLFVBQVUsQ0FBbUI7UUFBUyxVQUFLLEdBQUwsS0FBSyxDQUFjO1FBQVUsa0JBQWEsR0FBYixhQUFhLENBQWU7UUFBVSx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQXFCO1FBUDVKLDJCQUFzQixHQUFHLENBQUMsQ0FBQztRQUMzQiw0QkFBdUIsR0FBRyxDQUFDLENBQUM7UUFDNUIsbUJBQWMsR0FBRyxDQUFDLENBQUM7UUFHcEIsZUFBVSxHQUFHLEVBQUUsQ0FBQztRQUlyQixVQUFVLENBQUMsVUFBVSxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUMsT0FBZ0IsRUFBRSxFQUFFO1lBRXJELElBQUksT0FBTyxDQUFDLE1BQU0sS0FBSyxlQUFlLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsVUFBVSxFQUFFLENBQUM7Z0JBQzdFLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsMkJBQTJCLEVBQUUsQ0FBQztvQkFDeEQscUVBQXFFO2dCQUN2RSxDQUFDO3FCQUFNLENBQUM7b0JBQ04sSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO2dCQUNuQixDQUFDO1lBQ0gsQ0FBQztZQUVELElBQUksT0FBTyxDQUFDLE1BQU0sS0FBSyxXQUFXLElBQUksT0FBTyxDQUFDLE1BQU0sS0FBSyxZQUFZLEVBQUUsQ0FBQztnQkFDdEUsVUFBVSxDQUFDLEdBQUcsRUFBRTtvQkFDZCxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsb0JBQW9CLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLElBQUksS0FBSyxRQUFRLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxLQUFLLFdBQVcsQ0FBQyxFQUFFLENBQUM7d0JBQ2pNLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsQ0FBQyxDQUFDO29CQUM3RCxDQUFDO29CQUVELElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsUUFBUSxFQUFFLENBQUM7d0JBQ3JDLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFFBQVEsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxDQUFDO3dCQUM1RyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO29CQUMxQyxDQUFDO2dCQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztRQUVILENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELFFBQVEsS0FBSyxDQUFDO0lBRWQsZUFBZTtRQUNiLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUNwRCxDQUFDO0lBRUQsU0FBUztRQUNQLElBQUksQ0FBQyxVQUFVLEdBQUcsRUFBRSxDQUFDO1FBQ3JCLE1BQU0sVUFBVSxHQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxJQUFJLENBQUMsYUFBYSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUN6RSxNQUFNLFdBQVcsR0FBRyxVQUFVLENBQUMsVUFBVSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQztRQUN0RCxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxVQUFVLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBRTlELFVBQVUsQ0FBQyxHQUFHLEVBQUU7WUFDZCxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7WUFDNUYsSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixFQUFFLENBQUM7WUFDOUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDakQsQ0FBQyxDQUFDLENBQUM7SUFFTCxDQUFDO0lBRUQsSUFBSSxRQUFRO1FBQ1YsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLEtBQUssWUFBWSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xJLENBQUM7SUFFRCxNQUFNO1FBQ0osSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLHVCQUF1QixFQUFFLEVBQUUsQ0FBQztZQUN6QyxZQUFZLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBRWpDLDZCQUE2QjtZQUM3QixJQUFJLENBQUMsYUFBYSxHQUFHLFVBQVUsQ0FBQyxHQUFHLEVBQUU7Z0JBQ25DLElBQUksaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMxQixJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7Z0JBRWQsS0FBSyxLQUFLLEdBQUcsQ0FBQyxFQUFFLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsS0FBSyxFQUFFLEVBQUUsQ0FBQztvQkFDekQsaUJBQWlCLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUM7b0JBQ3BFLElBQUksaUJBQWlCLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsU0FBUyxFQUFFLENBQUM7d0JBQzdELE1BQU07b0JBQ1IsQ0FBQztnQkFDSCxDQUFDO2dCQUVELElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFVBQVUsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLEtBQUssS0FBSyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxVQUFVLEVBQUUsQ0FBQztvQkFDN0csSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztnQkFDN0MsQ0FBQztZQUNILENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUNWLENBQUM7SUFDSCxDQUFDO0lBRU0sZUFBZSxDQUFDLENBQU07UUFDM0IsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxXQUFXLEdBQUcsUUFBUSxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRTdELElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQzdFLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxDQUFDLENBQUM7WUFDaEMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLENBQUMsQ0FBQztZQUNqQyxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztRQUMxQixDQUFDO0lBQ0gsQ0FBQztJQUVNLGNBQWMsQ0FBQyxDQUFNO1FBQzFCLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLGNBQWMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUN6RSxJQUFJLGdCQUFnQixJQUFJLENBQUMsRUFBRSxDQUFDO2dCQUFDLENBQUMsQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUFDLENBQUM7WUFFbEQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDdEosSUFBSSxJQUFJLENBQUMsc0JBQXNCLEtBQUssQ0FBQyxFQUFFLENBQUM7Z0JBQ3RDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3ZKLENBQUM7WUFFRCxNQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFDO1lBQ3ZHLElBQUksSUFBSSxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQztnQkFDbkMsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxHQUFHLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQztnQkFDM0YsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxFQUFFLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDdkUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxFQUFFLFlBQVksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDckcsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0lBRU0sYUFBYSxDQUFDLENBQU07UUFDekIsSUFBSSxJQUFJLENBQUMsYUFBYSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQUMsQ0FBQztRQUVyRCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDN0UsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxXQUFXLEdBQUcsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztnQkFDckUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUNoQyxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQztvQkFDekMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztnQkFDaEMsQ0FBQztxQkFBTSxDQUFDO29CQUNOLElBQUksQ0FBQyxVQUFVLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ2hDLENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsY0FBYyxLQUFLLENBQUMsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQzFHLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxFQUFFLE1BQU0sRUFBRSxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7WUFDakUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDbkQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDbkMsQ0FBQztJQUNILENBQUM7K0dBMUlVLG9CQUFvQjttR0FBcEIsb0JBQW9CLDRKQXZCckI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBb0JUOzs0RkFHVSxvQkFBb0I7a0JBekJoQyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxrQkFBa0I7b0JBQzVCLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FvQlQ7aUJBQ0Y7K0tBSXVCLE9BQU87c0JBQTVCLFNBQVM7dUJBQUMsU0FBUyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgT25Jbml0LCBWaWV3Q2hpbGQsIEVsZW1lbnRSZWYsIEFmdGVyVmlld0luaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgQ29udHJvbGxlclNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9jb250cm9sbGVyLnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBNb2RlbFNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlJztcclxuaW1wb3J0IHsgU3R5bGVzU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL3N0eWxlcy5zZXJ2aWNlJztcclxuaW1wb3J0IHsgSW50ZXJhY3Rpb25zU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2ludGVyYWN0aW9ucy5zZXJ2aWNlJztcclxuaW1wb3J0IHsgTWVzc2FnZSB9IGZyb20gJy4uL3NlcnZpY2VzL29iamVjdHMnO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6ICdzdGktcmVwb3J0LXBhbmVsJyxcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgPGRpdiAjZWxlbWVudFxyXG4gICAgICAgICBbc3R5bGUudGV4dEFsaWduXT1cIm1vZGVsLm9wdGlvbnMuYXBwZWFyYW5jZS5wYWdlQWxpZ25tZW50ID09ICdkZWZhdWx0JyA/ICdjZW50ZXInIDogbW9kZWwub3B0aW9ucy5hcHBlYXJhbmNlLnBhZ2VBbGlnbm1lbnRcIlxyXG4gICAgICAgICBbc3R5bGUudG9wXT1cIjBcIlxyXG4gICAgICAgICBbc3R5bGUuYm90dG9tXT1cIjBcIlxyXG4gICAgICAgICBbc3R5bGUucG9zaXRpb25dPVwicG9zaXRpb25cIlxyXG4gICAgICAgICBbc3R5bGUuaGVpZ2h0XT1cIm1vZGVsLm9wdGlvbnMuaGVpZ2h0VHlwZSAhPSAnUGVyY2VudGFnZScgfHwgbW9kZWwub3B0aW9ucy5hcHBlYXJhbmNlLnNjcm9sbGJhcnNNb2RlID8gJ2F1dG8nIDogJ2NhbGMoMTAwJSAtIDM1cHgpJ1wiXHJcbiAgICAgICAgIFtzdHlsZS5vdmVyZmxvd10gPSBcIm1vZGVsLnJlcG9ydFBhcmFtcy50eXBlID09ICdSZXBvcnQnICYmIG1vZGVsLm9wdGlvbnMuYXBwZWFyYW5jZS5zY3JvbGxiYXJzTW9kZSA/ICdhdXRvJyA6ICdoaWRkZW4nXCJcclxuICAgICAgICAgW3N0eWxlLm1hcmdpblRvcC5weF09XCJtb2RlbC5jb250cm9scy5yZXBvcnRQYW5lbC5sYXlvdXQudG9wXCJcclxuICAgICAgICAgW3N0eWxlLm1hcmdpbkxlZnQucHhdPVwibW9kZWwuY29udHJvbHMucmVwb3J0UGFuZWwubGF5b3V0LmxlZnRcIlxyXG4gICAgICAgICBbc3R5bGUubWFyZ2luQm90dG9tLnB4XT1cInBvc2l0aW9uID09ICdhYnNvbHV0ZScgPyBtb2RlbC5jb250cm9scy5yZXBvcnRQYW5lbC5sYXlvdXQuYm90dG9tIDogMFwiXHJcbiAgICAgICAgIFtzdHlsZS5wYWRkaW5nQm90dG9tLnB4XT1cInBvc2l0aW9uID09ICdyZWxhdGl2ZScgPyBtb2RlbC5jb250cm9scy5yZXBvcnRQYW5lbC5sYXlvdXQuYm90dG9tIDogMFwiXHJcbiAgICAgICAgIFtzdHlsZS50cmFuc2l0aW9uXT1cIm1vZGVsLm9wdGlvbnMuaXNNb2JpbGVEZXZpY2UgPyAnbWFyZ2luIDIwMG1zIGVhc2UnIDogbnVsbFwiXHJcbiAgICAgICAgIChzY3JvbGwpPVwic2Nyb2xsKClcIlxyXG4gICAgICAgICBjbGFzcz1cInN0aUpzVmlld2VyUmVwb3J0UGFuZWxcIlxyXG4gICAgICAgICAodG91Y2hzdGFydCk9XCJldmVudFRvdWNoU3RhcnQoJGV2ZW50KVwiXHJcbiAgICAgICAgICh0b3VjaG1vdmUpPVwiZXZlbnRUb3VjaE1vdmUoJGV2ZW50KVwiXHJcbiAgICAgICAgICh0b3VjaGVuZCk9XCJldmVudFRvdWNoRW5kKCRldmVudClcIj5cclxuICAgICAgPHN0aS1wYWdlICpuZ0Zvcj1cImxldCBwYWdlIG9mIG1vZGVsLnBhZ2VzXCIgW3BhZ2VBdHRyaWJ1dGVzXT1cInBhZ2VcIj48L3N0aS1wYWdlPlxyXG4gICAgPC9kaXY+XHJcbiAgYFxyXG59KVxyXG5cclxuZXhwb3J0IGNsYXNzIFJlcG9ydFBhbmVsQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0LCBBZnRlclZpZXdJbml0IHtcclxuXHJcbiAgQFZpZXdDaGlsZCgnZWxlbWVudCcpIGVsZW1lbnQ6IEVsZW1lbnRSZWY7XHJcblxyXG4gIHByaXZhdGUgc2Nyb2xsVGltZW91dDogYW55O1xyXG4gIHByaXZhdGUgdG91Y2hlc0xlbmd0aDogbnVtYmVyO1xyXG4gIHByaXZhdGUgdG91Y2hab29tRmlyc3REaXN0YW5jZSA9IDA7XHJcbiAgcHJpdmF0ZSB0b3VjaFpvb21TZWNvbmREaXN0YW5jZSA9IDA7XHJcbiAgcHJpdmF0ZSB0b3VjaFpvb21WYWx1ZSA9IDA7XHJcbiAgcHJpdmF0ZSB0b3VjaFN0YXJ0WDogbnVtYmVyO1xyXG5cclxuICBwdWJsaWMgbWF4SGVpZ2h0cyA9IHt9O1xyXG5cclxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIGNvbnRyb2xsZXI6IENvbnRyb2xsZXJTZXJ2aWNlLCBwdWJsaWMgbW9kZWw6IE1vZGVsU2VydmljZSwgcHJpdmF0ZSBzdHlsZXNTZXJ2aWNlOiBTdHlsZXNTZXJ2aWNlLCBwcml2YXRlIGludGVyYWN0aW9uU2VydmljZTogSW50ZXJhY3Rpb25zU2VydmljZSkge1xyXG5cclxuICAgIGNvbnRyb2xsZXIuZ2V0TWVzc2FnZSgpLnN1YnNjcmliZSgobWVzc2FnZTogTWVzc2FnZSkgPT4ge1xyXG5cclxuICAgICAgaWYgKG1lc3NhZ2UuYWN0aW9uICE9PSAndmlld2VyX2xvYWRlZCcgJiYgdGhpcy5tb2RlbC5yZXBvcnRQYXJhbXMucGFnZXNBcnJheSkge1xyXG4gICAgICAgIGlmICh0aGlzLm1vZGVsLnJlcG9ydFBhcmFtcy5yZXBhaW50T25seURhc2hib2FyZENvbnRlbnQpIHtcclxuICAgICAgICAgIC8vIGpzT2JqZWN0LmNvbnRyb2xzLnJlcG9ydFBhbmVsLnJlcGFpbnREYXNoYm9hcmRDb250ZW50KHBhcmFtZXRlcnMpO1xyXG4gICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICB0aGlzLmxvYWRQYWdlcygpO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG5cclxuICAgICAgaWYgKG1lc3NhZ2UuYWN0aW9uID09PSAnR2V0UmVwb3J0JyB8fCBtZXNzYWdlLmFjdGlvbiA9PT0gJ09wZW5SZXBvcnQnKSB7XHJcbiAgICAgICAgc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgICAgICBpZiAoIXRoaXMubW9kZWwub3B0aW9ucy5pc1BhcmFtZXRlcnNSZWNlaXZlZCAmJiAoKHRoaXMubW9kZWwucmVwb3J0UGFyYW1zLnR5cGUgPT09ICdSZXBvcnQnICYmIHRoaXMubW9kZWwub3B0aW9ucy50b29sYmFyLnNob3dQYXJhbWV0ZXJzQnV0dG9uKSB8fCB0aGlzLm1vZGVsLnJlcG9ydFBhcmFtcy50eXBlID09PSAnRGFzaGJvYXJkJykpIHtcclxuICAgICAgICAgICAgaW50ZXJhY3Rpb25TZXJ2aWNlLnBvc3RJbnRlcmFjdGlvbih7IGFjdGlvbjogJ0luaXRWYXJzJyB9KTtcclxuICAgICAgICAgIH1cclxuXHJcbiAgICAgICAgICBpZiAodGhpcy5tb2RlbC5yZXBvcnRQYXJhbXMuYXV0b1pvb20pIHtcclxuICAgICAgICAgICAgdGhpcy5jb250cm9sbGVyLmFjdGlvbih7IG5hbWU6IHRoaXMubW9kZWwucmVwb3J0UGFyYW1zLmF1dG9ab29tID09PSAtMSA/ICdab29tUGFnZVdpZHRoJyA6ICdab29tT25lUGFnZScgfSk7XHJcbiAgICAgICAgICAgIHRoaXMubW9kZWwucmVwb3J0UGFyYW1zLmF1dG9ab29tID0gbnVsbDtcclxuICAgICAgICAgIH1cclxuICAgICAgICB9KTtcclxuICAgICAgfVxyXG5cclxuICAgIH0pO1xyXG4gIH1cclxuXHJcbiAgbmdPbkluaXQoKSB7IH1cclxuXHJcbiAgbmdBZnRlclZpZXdJbml0KCk6IHZvaWQge1xyXG4gICAgdGhpcy5tb2RlbC5jb250cm9scy5yZXBvcnRQYW5lbC5lbCA9IHRoaXMuZWxlbWVudDtcclxuICB9XHJcblxyXG4gIGxvYWRQYWdlcygpIHtcclxuICAgIHRoaXMubWF4SGVpZ2h0cyA9IHt9O1xyXG4gICAgY29uc3QgcGFnZXNBcnJheTogW10gPSB0aGlzLm1vZGVsLnJlcG9ydFBhcmFtcy5wYWdlc0FycmF5O1xyXG4gICAgdGhpcy5zdHlsZXNTZXJ2aWNlLnNldHVwU3R5bGUocGFnZXNBcnJheVtwYWdlc0FycmF5Lmxlbmd0aCAtIDJdLCAncGFnZScpO1xyXG4gICAgY29uc3QgY2hhcnRTY3JpcHQgPSBwYWdlc0FycmF5W3BhZ2VzQXJyYXkubGVuZ3RoIC0gMV07XHJcbiAgICB0aGlzLm1vZGVsLnBhZ2VzID0gcGFnZXNBcnJheS5zbGljZSgwLCBwYWdlc0FycmF5Lmxlbmd0aCAtIDIpO1xyXG5cclxuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICB0aGlzLm1vZGVsLnBhZ2VzLmZvckVhY2gocGFnZSA9PiB0aGlzLmludGVyYWN0aW9uU2VydmljZS5pbml0aWFsaXplSW50ZXJhY3Rpb25zKHBhZ2UucGFnZSkpO1xyXG4gICAgICB0aGlzLmludGVyYWN0aW9uU2VydmljZS51cGRhdGVBbGxIeXBlckxpbmtzKCk7XHJcbiAgICAgIHRoaXMuc3R5bGVzU2VydmljZS5hZGRDaGFydFNjcmlwdChjaGFydFNjcmlwdCk7XHJcbiAgICB9KTtcclxuXHJcbiAgfVxyXG5cclxuICBnZXQgcG9zaXRpb24oKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLm1vZGVsLm9wdGlvbnMuaGVpZ2h0VHlwZSAhPT0gJ1BlcmNlbnRhZ2UnIHx8IHRoaXMubW9kZWwub3B0aW9ucy5hcHBlYXJhbmNlLnNjcm9sbGJhcnNNb2RlID8gJ2Fic29sdXRlJyA6ICdyZWxhdGl2ZSc7XHJcbiAgfVxyXG5cclxuICBzY3JvbGwoKSB7XHJcbiAgICBpZiAodGhpcy5tb2RlbC5wYWdlc05hdmlnYXRpb25Jc0FjdGl2ZSgpKSB7XHJcbiAgICAgIGNsZWFyVGltZW91dCh0aGlzLnNjcm9sbFRpbWVvdXQpO1xyXG5cclxuICAgICAgLy8gdXBkYXRlIGN1cnJlbnQgcGFnZSBudW1iZXJcclxuICAgICAgdGhpcy5zY3JvbGxUaW1lb3V0ID0gc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgICAgbGV0IGNvbW1vblBhZ2VzSGVpZ2h0ID0gMDtcclxuICAgICAgICBsZXQgaW5kZXggPSAwO1xyXG5cclxuICAgICAgICBmb3IgKGluZGV4ID0gMDsgaW5kZXggPCB0aGlzLm1vZGVsLnBhZ2VzLmxlbmd0aDsgaW5kZXgrKykge1xyXG4gICAgICAgICAgY29tbW9uUGFnZXNIZWlnaHQgKz0gdGhpcy5tb2RlbC5wYWdlc1tpbmRleF0ucGFnZS5vZmZzZXRIZWlnaHQgKyAxMDtcclxuICAgICAgICAgIGlmIChjb21tb25QYWdlc0hlaWdodCA+IHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50LnNjcm9sbFRvcCkge1xyXG4gICAgICAgICAgICBicmVhaztcclxuICAgICAgICAgIH1cclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIGlmIChpbmRleCA8IHRoaXMubW9kZWwucmVwb3J0UGFyYW1zLnBhZ2VzQ291bnQgJiYgaW5kZXggPj0gMCAmJiBpbmRleCAhPT0gdGhpcy5tb2RlbC5yZXBvcnRQYXJhbXMucGFnZU51bWJlcikge1xyXG4gICAgICAgICAgdGhpcy5tb2RlbC5yZXBvcnRQYXJhbXMucGFnZU51bWJlciA9IGluZGV4O1xyXG4gICAgICAgIH1cclxuICAgICAgfSwgMzAwKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBldmVudFRvdWNoU3RhcnQoZTogYW55KSB7XHJcbiAgICB0aGlzLnRvdWNoZXNMZW5ndGgrKztcclxuICAgIHRoaXMudG91Y2hTdGFydFggPSBwYXJzZUludChlLmNoYW5nZWRUb3VjaGVzWzBdLmNsaWVudFgsIDEwKTtcclxuXHJcbiAgICBpZiAodGhpcy5tb2RlbC5vcHRpb25zLmFwcGVhcmFuY2UuYWxsb3dUb3VjaFpvb20gJiYgdGhpcy50b3VjaGVzTGVuZ3RoID09PSAxKSB7XHJcbiAgICAgIHRoaXMudG91Y2hab29tRmlyc3REaXN0YW5jZSA9IDA7XHJcbiAgICAgIHRoaXMudG91Y2hab29tU2Vjb25kRGlzdGFuY2UgPSAwO1xyXG4gICAgICB0aGlzLnRvdWNoWm9vbVZhbHVlID0gMDtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBldmVudFRvdWNoTW92ZShlOiBhbnkpIHtcclxuICAgIGlmICh0aGlzLm1vZGVsLm9wdGlvbnMuYXBwZWFyYW5jZS5hbGxvd1RvdWNoWm9vbSAmJiBlLnRvdWNoZXMubGVuZ3RoID4gMSkge1xyXG4gICAgICBpZiAoJ3ByZXZlbnREZWZhdWx0JyBpbiBlKSB7IGUucHJldmVudERlZmF1bHQoKTsgfVxyXG5cclxuICAgICAgdGhpcy50b3VjaFpvb21TZWNvbmREaXN0YW5jZSA9IE1hdGguc3FydChNYXRoLnBvdyhlLnRvdWNoZXNbMF0ucGFnZVggLSBlLnRvdWNoZXNbMV0ucGFnZVgsIDIpICsgTWF0aC5wb3coZS50b3VjaGVzWzBdLnBhZ2VZIC0gZS50b3VjaGVzWzFdLnBhZ2VZLCAyKSk7XHJcbiAgICAgIGlmICh0aGlzLnRvdWNoWm9vbUZpcnN0RGlzdGFuY2UgPT09IDApIHtcclxuICAgICAgICB0aGlzLnRvdWNoWm9vbUZpcnN0RGlzdGFuY2UgPSBNYXRoLnNxcnQoTWF0aC5wb3coZS50b3VjaGVzWzBdLnBhZ2VYIC0gZS50b3VjaGVzWzFdLnBhZ2VYLCAyKSArIE1hdGgucG93KGUudG91Y2hlc1swXS5wYWdlWSAtIGUudG91Y2hlc1sxXS5wYWdlWSwgMikpO1xyXG4gICAgICB9XHJcblxyXG4gICAgICBjb25zdCB0b3VjaFpvb21PZmZzZXQgPSBNYXRoLnRydW5jKCh0aGlzLnRvdWNoWm9vbVNlY29uZERpc3RhbmNlIC0gdGhpcy50b3VjaFpvb21GaXJzdERpc3RhbmNlKSAvIDIuNSk7XHJcbiAgICAgIGlmIChNYXRoLmFicyh0b3VjaFpvb21PZmZzZXQpID49IDUpIHtcclxuICAgICAgICB0aGlzLnRvdWNoWm9vbVZhbHVlID0gTWF0aC50cnVuYygodGhpcy5tb2RlbC5yZXBvcnRQYXJhbXMuem9vbSArIHRvdWNoWm9vbU9mZnNldCkgLyA1KSAqIDU7XHJcbiAgICAgICAgdGhpcy50b3VjaFpvb21WYWx1ZSA9IE1hdGgubWluKE1hdGgubWF4KHRoaXMudG91Y2hab29tVmFsdWUsIDIwKSwgMjAwKTtcclxuICAgICAgICB0aGlzLmNvbnRyb2xsZXIuYWN0aW9uU3ViamVjdC5uZXh0KHsgYWN0aW9uOiAnY2VudGVyVGV4dCcsIGRhdGE6IHRoaXMudG91Y2hab29tVmFsdWUudG9TdHJpbmcoKSB9KTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGV2ZW50VG91Y2hFbmQoZTogYW55KSB7XHJcbiAgICBpZiAodGhpcy50b3VjaGVzTGVuZ3RoID4gMCkgeyB0aGlzLnRvdWNoZXNMZW5ndGgtLTsgfVxyXG5cclxuICAgIGlmICh0aGlzLm1vZGVsLm9wdGlvbnMuaXNNb2JpbGVEZXZpY2UgJiYgdGhpcy5tb2RlbC5vcHRpb25zLnRvb2xiYXIuYXV0b0hpZGUpIHtcclxuICAgICAgaWYgKE1hdGgudHJ1bmModGhpcy50b3VjaFN0YXJ0WCAtIGUuY2hhbmdlZFRvdWNoZXNbMF0uY2xpZW50WCkgIT09IDApIHtcclxuICAgICAgICB0aGlzLmNvbnRyb2xsZXIua2VlcFRvb2xiYXIoKTtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICBpZiAoIXRoaXMubW9kZWwuY29udHJvbHMudG9vbGJhci52aXNpYmxlKSB7XHJcbiAgICAgICAgICB0aGlzLmNvbnRyb2xsZXIuc2hvd1Rvb2xiYXIoKTtcclxuICAgICAgICB9IGVsc2Uge1xyXG4gICAgICAgICAgdGhpcy5jb250cm9sbGVyLmhpZGVUb29sYmFyKCk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKHRoaXMubW9kZWwub3B0aW9ucy5hcHBlYXJhbmNlLmFsbG93VG91Y2hab29tICYmIHRoaXMudG91Y2hab29tVmFsdWUgIT09IDAgJiYgdGhpcy50b3VjaGVzTGVuZ3RoID09PSAwKSB7XHJcbiAgICAgIHRoaXMuY29udHJvbGxlci5hY3Rpb25TdWJqZWN0Lm5leHQoeyBhY3Rpb246ICdoaWRlQ2VudGVyVGV4dCcgfSk7XHJcbiAgICAgIHRoaXMubW9kZWwucmVwb3J0UGFyYW1zLnpvb20gPSB0aGlzLnRvdWNoWm9vbVZhbHVlO1xyXG4gICAgICB0aGlzLmNvbnRyb2xsZXIucG9zdCgnR2V0UGFnZXMnKTtcclxuICAgIH1cclxuICB9XHJcbn1cclxuIl19