import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
export class CenterTextComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.text = '';
        this.opacity = 0;
        this.display = 'none';
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'centerText':
                    this.show(message.data);
                    break;
                case 'hideCenterText':
                    this.hide();
                    break;
            }
        });
    }
    ngOnInit() { }
    show(text) {
        this.display = '';
        this.opacity = 0;
        this.text = text;
        setTimeout(() => {
            this.helper.setObjectToCenter(this.element.nativeElement);
            this.opacity = 1;
        });
        if (this.hideTimer) {
            clearTimeout(this.hideTimer);
        }
        this.hideTimer = setTimeout(() => {
            this.hide();
        }, 2000);
    }
    hide() {
        this.opacity = 0;
        if (this.hideTimer) {
            clearTimeout(this.hideTimer);
        }
        this.hideTimer = setTimeout(() => {
            this.display = 'none';
        }, 300);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CenterTextComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: CenterTextComponent, selector: "sti-center-text", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      [style.position]="'absolute'"
      [style.zIndex]="1000"
      [style.transitionProperty]="opacity"
      [style.transitionDuration]="'300ms'"
      [style.textShadow]="'rgb(0, 0, 0) -1px -1px 0px, rgb(0, 0, 0) 1px -1px 0px, rgb(0, 0, 0) -1px 1px 0px, rgb(0, 0, 0) 1px 1px 0px'"
      [style.fontSize.px]="100"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [style.opacity]="opacity"
      [style.display]="display">
      <div>
        {{text}}
      </div>
    </div>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: CenterTextComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-center-text',
                    template: `
    <div #element
      [style.position]="'absolute'"
      [style.zIndex]="1000"
      [style.transitionProperty]="opacity"
      [style.transitionDuration]="'300ms'"
      [style.textShadow]="'rgb(0, 0, 0) -1px -1px 0px, rgb(0, 0, 0) 1px -1px 0px, rgb(0, 0, 0) -1px 1px 0px, rgb(0, 0, 0) 1px 1px 0px'"
      [style.fontSize.px]="100"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [style.opacity]="opacity"
      [style.display]="display">
      <div>
        {{text}}
      </div>
    </div>
  `
                }]
        }], ctorParameters: () => [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }], propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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